#include "EditVar.hxx"
/* Generated by GIWS (version 1.3.0) */
/*

Copyright 2007-2008 INRIA
Copyright 2008-2011 DIGITEO

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_ui_data {

// Returns the current env

JNIEnv * EditVar::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

EditVar::~EditVar() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors
EditVar::EditVar(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voidopenVariableEditorDoublejobjectArray__doublejstringjava_lang_StringID=NULL;
voidopenVariableEditorBooleanSparsejobjectArray__intjstringjava_lang_StringID=NULL;
voidopenVariableEditorSparsejobjectArray__doublejstringjava_lang_StringID=NULL;
voidopenVariableEditorComplexSparsejobjectArray__doublejobjectArray__doublejstringjava_lang_StringID=NULL;
voidopenVariableEditorComplexjobjectArray__doublejobjectArray__doublejstringjava_lang_StringID=NULL;
voidopenVariableEditorStringjobjectArray__java_lang_Stringjstringjava_lang_StringID=NULL;
voidopenVariableEditorBooleanjobjectArray__intjstringjava_lang_StringID=NULL;
voidopenVariableEditorInteger8jobjectArray__bytejstringjava_lang_StringID=NULL;
voidopenVariableEditorUInteger8jobjectArray__shortjstringjava_lang_StringID=NULL;
voidopenVariableEditorInteger16jobjectArray__shortjstringjava_lang_StringID=NULL;
voidopenVariableEditorUInteger16jobjectArray__intjstringjava_lang_StringID=NULL;
voidopenVariableEditorInteger32jobjectArray__intjstringjava_lang_StringID=NULL;
voidopenVariableEditorUInteger32jobjectArray__longjstringjava_lang_StringID=NULL;
voidrefreshVariableEditorDoublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorBooleanSparsejobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorSparsejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorComplexSparsejobjectArray__doublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorComplexjobjectArray__doublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorStringjobjectArray__java_lang_StringjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorBooleanjobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorInteger8jobjectArray__bytejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorUInteger8jobjectArray__shortjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorInteger16jobjectArray__shortjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorUInteger16jobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorInteger32jobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorUInteger32jobjectArray__longjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidcloseVariableEditorID=NULL;


}

EditVar::EditVar(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voidopenVariableEditorDoublejobjectArray__doublejstringjava_lang_StringID=NULL;
voidopenVariableEditorBooleanSparsejobjectArray__intjstringjava_lang_StringID=NULL;
voidopenVariableEditorSparsejobjectArray__doublejstringjava_lang_StringID=NULL;
voidopenVariableEditorComplexSparsejobjectArray__doublejobjectArray__doublejstringjava_lang_StringID=NULL;
voidopenVariableEditorComplexjobjectArray__doublejobjectArray__doublejstringjava_lang_StringID=NULL;
voidopenVariableEditorStringjobjectArray__java_lang_Stringjstringjava_lang_StringID=NULL;
voidopenVariableEditorBooleanjobjectArray__intjstringjava_lang_StringID=NULL;
voidopenVariableEditorInteger8jobjectArray__bytejstringjava_lang_StringID=NULL;
voidopenVariableEditorUInteger8jobjectArray__shortjstringjava_lang_StringID=NULL;
voidopenVariableEditorInteger16jobjectArray__shortjstringjava_lang_StringID=NULL;
voidopenVariableEditorUInteger16jobjectArray__intjstringjava_lang_StringID=NULL;
voidopenVariableEditorInteger32jobjectArray__intjstringjava_lang_StringID=NULL;
voidopenVariableEditorUInteger32jobjectArray__longjstringjava_lang_StringID=NULL;
voidrefreshVariableEditorDoublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorBooleanSparsejobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorSparsejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorComplexSparsejobjectArray__doublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorComplexjobjectArray__doublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorStringjobjectArray__java_lang_StringjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorBooleanjobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorInteger8jobjectArray__bytejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorUInteger8jobjectArray__shortjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorInteger16jobjectArray__shortjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorUInteger16jobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorInteger32jobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidrefreshVariableEditorUInteger32jobjectArray__longjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID=NULL;
voidcloseVariableEditorID=NULL;


}

// Generic methods

void EditVar::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "EditVar");
}
}

void EditVar::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "EditVar");
}
}
// Method(s)

void EditVar::openVariableEditorDouble (JavaVM * jvm_, double** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorDoublejobjectArray__doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "openVariableEditorDouble", "([[DLjava/lang/String;)V" ) ;
if (voidopenVariableEditorDoublejobjectArray__doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorDouble");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[D"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jdoubleArray dataLocal = curEnv->NewDoubleArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( dataLocal, 0, dataSizeCol, (jdouble*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorDoublejobjectArray__doublejstringjava_lang_StringID ,data_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorBooleanSparse (JavaVM * jvm_, int** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorBooleanSparsejobjectArray__intjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "openVariableEditorBooleanSparse", "([[ILjava/lang/String;)V" ) ;
if (voidopenVariableEditorBooleanSparsejobjectArray__intjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorBooleanSparse");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[I"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jintArray dataLocal = curEnv->NewIntArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( dataLocal, 0, dataSizeCol, (jint*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorBooleanSparsejobjectArray__intjstringjava_lang_StringID ,data_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorSparse (JavaVM * jvm_, double** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorSparsejobjectArray__doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "openVariableEditorSparse", "([[DLjava/lang/String;)V" ) ;
if (voidopenVariableEditorSparsejobjectArray__doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorSparse");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[D"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jdoubleArray dataLocal = curEnv->NewDoubleArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( dataLocal, 0, dataSizeCol, (jdouble*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorSparsejobjectArray__doublejstringjava_lang_StringID ,data_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorComplexSparse (JavaVM * jvm_, double** realData, int realDataSize, int realDataSizeCol, double** complexData, int complexDataSize, int complexDataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorComplexSparsejobjectArray__doublejobjectArray__doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "openVariableEditorComplexSparse", "([[D[[DLjava/lang/String;)V" ) ;
if (voidopenVariableEditorComplexSparsejobjectArray__doublejobjectArray__doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorComplexSparse");
}

 jobjectArray realData_ = curEnv->NewObjectArray(realDataSize, curEnv->FindClass("[D"),NULL);

if (realData_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<realDataSize; i++){

jdoubleArray realDataLocal = curEnv->NewDoubleArray( realDataSizeCol ) ;

if (realDataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(realData_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( realDataLocal, 0, realDataSizeCol, (jdouble*)(realData[i]) ) ;
curEnv->SetObjectArrayElement(realData_, i, realDataLocal);
curEnv->DeleteLocalRef(realDataLocal);
}

 jobjectArray complexData_ = curEnv->NewObjectArray(complexDataSize, curEnv->FindClass("[D"),NULL);

if (complexData_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<complexDataSize; i++){

jdoubleArray complexDataLocal = curEnv->NewDoubleArray( complexDataSizeCol ) ;

if (complexDataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(complexData_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( complexDataLocal, 0, complexDataSizeCol, (jdouble*)(complexData[i]) ) ;
curEnv->SetObjectArrayElement(complexData_, i, complexDataLocal);
curEnv->DeleteLocalRef(complexDataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorComplexSparsejobjectArray__doublejobjectArray__doublejstringjava_lang_StringID ,realData_, complexData_, variableName_);
                        curEnv->DeleteLocalRef(realData_);
curEnv->DeleteLocalRef(complexData_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorComplex (JavaVM * jvm_, double** realData, int realDataSize, int realDataSizeCol, double** imgData, int imgDataSize, int imgDataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorComplexjobjectArray__doublejobjectArray__doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "openVariableEditorComplex", "([[D[[DLjava/lang/String;)V" ) ;
if (voidopenVariableEditorComplexjobjectArray__doublejobjectArray__doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorComplex");
}

 jobjectArray realData_ = curEnv->NewObjectArray(realDataSize, curEnv->FindClass("[D"),NULL);

if (realData_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<realDataSize; i++){

jdoubleArray realDataLocal = curEnv->NewDoubleArray( realDataSizeCol ) ;

if (realDataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(realData_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( realDataLocal, 0, realDataSizeCol, (jdouble*)(realData[i]) ) ;
curEnv->SetObjectArrayElement(realData_, i, realDataLocal);
curEnv->DeleteLocalRef(realDataLocal);
}

 jobjectArray imgData_ = curEnv->NewObjectArray(imgDataSize, curEnv->FindClass("[D"),NULL);

if (imgData_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<imgDataSize; i++){

jdoubleArray imgDataLocal = curEnv->NewDoubleArray( imgDataSizeCol ) ;

if (imgDataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(imgData_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( imgDataLocal, 0, imgDataSizeCol, (jdouble*)(imgData[i]) ) ;
curEnv->SetObjectArrayElement(imgData_, i, imgDataLocal);
curEnv->DeleteLocalRef(imgDataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorComplexjobjectArray__doublejobjectArray__doublejstringjava_lang_StringID ,realData_, imgData_, variableName_);
                        curEnv->DeleteLocalRef(realData_);
curEnv->DeleteLocalRef(imgData_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorString (JavaVM * jvm_, char *** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorStringjobjectArray__java_lang_Stringjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "openVariableEditorString", "([[Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voidopenVariableEditorStringjobjectArray__java_lang_Stringjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorString");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");
// create java array of array of strings.
jobjectArray data_ = curEnv->NewObjectArray( dataSize, curEnv->FindClass("[Ljava/lang/String;"), NULL);
if (data_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

for ( int i = 0; i < dataSize; i++)
{
jobjectArray dataLocal = curEnv->NewObjectArray( dataSizeCol, stringArrayClass, NULL);
// convert each char * to java strings and fill the java array.
for ( int j = 0; j < dataSizeCol; j++) {
jstring TempString = curEnv->NewStringUTF( data[i][j] );

if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( dataLocal, j, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);

}
jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorStringjobjectArray__java_lang_Stringjstringjava_lang_StringID ,data_, variableName_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorBoolean (JavaVM * jvm_, int** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorBooleanjobjectArray__intjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "openVariableEditorBoolean", "([[ILjava/lang/String;)V" ) ;
if (voidopenVariableEditorBooleanjobjectArray__intjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorBoolean");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[I"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jintArray dataLocal = curEnv->NewIntArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( dataLocal, 0, dataSizeCol, (jint*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorBooleanjobjectArray__intjstringjava_lang_StringID ,data_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorInteger8 (JavaVM * jvm_, byte** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorInteger8jobjectArray__bytejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "openVariableEditorInteger8", "([[BLjava/lang/String;)V" ) ;
if (voidopenVariableEditorInteger8jobjectArray__bytejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorInteger8");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[B"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jbyteArray dataLocal = curEnv->NewByteArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetByteArrayRegion( dataLocal, 0, dataSizeCol, (jbyte*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorInteger8jobjectArray__bytejstringjava_lang_StringID ,data_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorUInteger8 (JavaVM * jvm_, short** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorUInteger8jobjectArray__shortjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "openVariableEditorUInteger8", "([[SLjava/lang/String;)V" ) ;
if (voidopenVariableEditorUInteger8jobjectArray__shortjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorUInteger8");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[S"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jshortArray dataLocal = curEnv->NewShortArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( dataLocal, 0, dataSizeCol, (jshort*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorUInteger8jobjectArray__shortjstringjava_lang_StringID ,data_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorInteger16 (JavaVM * jvm_, short** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorInteger16jobjectArray__shortjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "openVariableEditorInteger16", "([[SLjava/lang/String;)V" ) ;
if (voidopenVariableEditorInteger16jobjectArray__shortjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorInteger16");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[S"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jshortArray dataLocal = curEnv->NewShortArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( dataLocal, 0, dataSizeCol, (jshort*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorInteger16jobjectArray__shortjstringjava_lang_StringID ,data_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorUInteger16 (JavaVM * jvm_, int** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorUInteger16jobjectArray__intjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "openVariableEditorUInteger16", "([[ILjava/lang/String;)V" ) ;
if (voidopenVariableEditorUInteger16jobjectArray__intjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorUInteger16");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[I"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jintArray dataLocal = curEnv->NewIntArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( dataLocal, 0, dataSizeCol, (jint*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorUInteger16jobjectArray__intjstringjava_lang_StringID ,data_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorInteger32 (JavaVM * jvm_, int** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorInteger32jobjectArray__intjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "openVariableEditorInteger32", "([[ILjava/lang/String;)V" ) ;
if (voidopenVariableEditorInteger32jobjectArray__intjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorInteger32");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[I"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jintArray dataLocal = curEnv->NewIntArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( dataLocal, 0, dataSizeCol, (jint*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorInteger32jobjectArray__intjstringjava_lang_StringID ,data_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorUInteger32 (JavaVM * jvm_, long long** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorUInteger32jobjectArray__longjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "openVariableEditorUInteger32", "([[JLjava/lang/String;)V" ) ;
if (voidopenVariableEditorUInteger32jobjectArray__longjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorUInteger32");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[J"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jlongArray dataLocal = curEnv->NewLongArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetLongArrayRegion( dataLocal, 0, dataSizeCol, (jlong*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorUInteger32jobjectArray__longjstringjava_lang_StringID ,data_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::refreshVariableEditorDouble (JavaVM * jvm_, double** data, int dataSize, int dataSizeCol, double* rowsIndex, int rowsIndexSize, double* colsIndex, int colsIndexSize, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrefreshVariableEditorDoublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "refreshVariableEditorDouble", "([[D[D[DLjava/lang/String;)V" ) ;
if (voidrefreshVariableEditorDoublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "refreshVariableEditorDouble");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[D"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jdoubleArray dataLocal = curEnv->NewDoubleArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( dataLocal, 0, dataSizeCol, (jdouble*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jdoubleArray rowsIndex_ = curEnv->NewDoubleArray( rowsIndexSize ) ;

if (rowsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( rowsIndex_, 0, rowsIndexSize, (jdouble*)(rowsIndex) ) ;


jdoubleArray colsIndex_ = curEnv->NewDoubleArray( colsIndexSize ) ;

if (colsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( colsIndex_, 0, colsIndexSize, (jdouble*)(colsIndex) ) ;


jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidrefreshVariableEditorDoublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID ,data_, rowsIndex_, colsIndex_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(rowsIndex_);
curEnv->DeleteLocalRef(colsIndex_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::refreshVariableEditorBooleanSparse (JavaVM * jvm_, int** data, int dataSize, int dataSizeCol, double* rowsIndex, int rowsIndexSize, double* colsIndex, int colsIndexSize, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrefreshVariableEditorBooleanSparsejobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "refreshVariableEditorBooleanSparse", "([[I[D[DLjava/lang/String;)V" ) ;
if (voidrefreshVariableEditorBooleanSparsejobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "refreshVariableEditorBooleanSparse");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[I"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jintArray dataLocal = curEnv->NewIntArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( dataLocal, 0, dataSizeCol, (jint*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jdoubleArray rowsIndex_ = curEnv->NewDoubleArray( rowsIndexSize ) ;

if (rowsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( rowsIndex_, 0, rowsIndexSize, (jdouble*)(rowsIndex) ) ;


jdoubleArray colsIndex_ = curEnv->NewDoubleArray( colsIndexSize ) ;

if (colsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( colsIndex_, 0, colsIndexSize, (jdouble*)(colsIndex) ) ;


jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidrefreshVariableEditorBooleanSparsejobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID ,data_, rowsIndex_, colsIndex_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(rowsIndex_);
curEnv->DeleteLocalRef(colsIndex_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::refreshVariableEditorSparse (JavaVM * jvm_, double** data, int dataSize, int dataSizeCol, double* rowsIndex, int rowsIndexSize, double* colsIndex, int colsIndexSize, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrefreshVariableEditorSparsejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "refreshVariableEditorSparse", "([[D[D[DLjava/lang/String;)V" ) ;
if (voidrefreshVariableEditorSparsejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "refreshVariableEditorSparse");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[D"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jdoubleArray dataLocal = curEnv->NewDoubleArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( dataLocal, 0, dataSizeCol, (jdouble*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jdoubleArray rowsIndex_ = curEnv->NewDoubleArray( rowsIndexSize ) ;

if (rowsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( rowsIndex_, 0, rowsIndexSize, (jdouble*)(rowsIndex) ) ;


jdoubleArray colsIndex_ = curEnv->NewDoubleArray( colsIndexSize ) ;

if (colsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( colsIndex_, 0, colsIndexSize, (jdouble*)(colsIndex) ) ;


jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidrefreshVariableEditorSparsejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID ,data_, rowsIndex_, colsIndex_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(rowsIndex_);
curEnv->DeleteLocalRef(colsIndex_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::refreshVariableEditorComplexSparse (JavaVM * jvm_, double** realData, int realDataSize, int realDataSizeCol, double** complexData, int complexDataSize, int complexDataSizeCol, double* rowsIndex, int rowsIndexSize, double* colsIndex, int colsIndexSize, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrefreshVariableEditorComplexSparsejobjectArray__doublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "refreshVariableEditorComplexSparse", "([[D[[D[D[DLjava/lang/String;)V" ) ;
if (voidrefreshVariableEditorComplexSparsejobjectArray__doublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "refreshVariableEditorComplexSparse");
}

 jobjectArray realData_ = curEnv->NewObjectArray(realDataSize, curEnv->FindClass("[D"),NULL);

if (realData_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<realDataSize; i++){

jdoubleArray realDataLocal = curEnv->NewDoubleArray( realDataSizeCol ) ;

if (realDataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(realData_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( realDataLocal, 0, realDataSizeCol, (jdouble*)(realData[i]) ) ;
curEnv->SetObjectArrayElement(realData_, i, realDataLocal);
curEnv->DeleteLocalRef(realDataLocal);
}

 jobjectArray complexData_ = curEnv->NewObjectArray(complexDataSize, curEnv->FindClass("[D"),NULL);

if (complexData_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<complexDataSize; i++){

jdoubleArray complexDataLocal = curEnv->NewDoubleArray( complexDataSizeCol ) ;

if (complexDataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(complexData_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( complexDataLocal, 0, complexDataSizeCol, (jdouble*)(complexData[i]) ) ;
curEnv->SetObjectArrayElement(complexData_, i, complexDataLocal);
curEnv->DeleteLocalRef(complexDataLocal);
}

jdoubleArray rowsIndex_ = curEnv->NewDoubleArray( rowsIndexSize ) ;

if (rowsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( rowsIndex_, 0, rowsIndexSize, (jdouble*)(rowsIndex) ) ;


jdoubleArray colsIndex_ = curEnv->NewDoubleArray( colsIndexSize ) ;

if (colsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( colsIndex_, 0, colsIndexSize, (jdouble*)(colsIndex) ) ;


jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidrefreshVariableEditorComplexSparsejobjectArray__doublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID ,realData_, complexData_, rowsIndex_, colsIndex_, variableName_);
                        curEnv->DeleteLocalRef(realData_);
curEnv->DeleteLocalRef(complexData_);
curEnv->DeleteLocalRef(rowsIndex_);
curEnv->DeleteLocalRef(colsIndex_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::refreshVariableEditorComplex (JavaVM * jvm_, double** realData, int realDataSize, int realDataSizeCol, double** imgData, int imgDataSize, int imgDataSizeCol, double* rowsIndex, int rowsIndexSize, double* colsIndex, int colsIndexSize, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrefreshVariableEditorComplexjobjectArray__doublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "refreshVariableEditorComplex", "([[D[[D[D[DLjava/lang/String;)V" ) ;
if (voidrefreshVariableEditorComplexjobjectArray__doublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "refreshVariableEditorComplex");
}

 jobjectArray realData_ = curEnv->NewObjectArray(realDataSize, curEnv->FindClass("[D"),NULL);

if (realData_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<realDataSize; i++){

jdoubleArray realDataLocal = curEnv->NewDoubleArray( realDataSizeCol ) ;

if (realDataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(realData_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( realDataLocal, 0, realDataSizeCol, (jdouble*)(realData[i]) ) ;
curEnv->SetObjectArrayElement(realData_, i, realDataLocal);
curEnv->DeleteLocalRef(realDataLocal);
}

 jobjectArray imgData_ = curEnv->NewObjectArray(imgDataSize, curEnv->FindClass("[D"),NULL);

if (imgData_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<imgDataSize; i++){

jdoubleArray imgDataLocal = curEnv->NewDoubleArray( imgDataSizeCol ) ;

if (imgDataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(imgData_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( imgDataLocal, 0, imgDataSizeCol, (jdouble*)(imgData[i]) ) ;
curEnv->SetObjectArrayElement(imgData_, i, imgDataLocal);
curEnv->DeleteLocalRef(imgDataLocal);
}

jdoubleArray rowsIndex_ = curEnv->NewDoubleArray( rowsIndexSize ) ;

if (rowsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( rowsIndex_, 0, rowsIndexSize, (jdouble*)(rowsIndex) ) ;


jdoubleArray colsIndex_ = curEnv->NewDoubleArray( colsIndexSize ) ;

if (colsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( colsIndex_, 0, colsIndexSize, (jdouble*)(colsIndex) ) ;


jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidrefreshVariableEditorComplexjobjectArray__doublejobjectArray__doublejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID ,realData_, imgData_, rowsIndex_, colsIndex_, variableName_);
                        curEnv->DeleteLocalRef(realData_);
curEnv->DeleteLocalRef(imgData_);
curEnv->DeleteLocalRef(rowsIndex_);
curEnv->DeleteLocalRef(colsIndex_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::refreshVariableEditorString (JavaVM * jvm_, char *** data, int dataSize, int dataSizeCol, double* rowsIndex, int rowsIndexSize, double* colsIndex, int colsIndexSize, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrefreshVariableEditorStringjobjectArray__java_lang_StringjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "refreshVariableEditorString", "([[Ljava/lang/String;[D[DLjava/lang/String;)V" ) ;
if (voidrefreshVariableEditorStringjobjectArray__java_lang_StringjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "refreshVariableEditorString");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");
// create java array of array of strings.
jobjectArray data_ = curEnv->NewObjectArray( dataSize, curEnv->FindClass("[Ljava/lang/String;"), NULL);
if (data_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

for ( int i = 0; i < dataSize; i++)
{
jobjectArray dataLocal = curEnv->NewObjectArray( dataSizeCol, stringArrayClass, NULL);
// convert each char * to java strings and fill the java array.
for ( int j = 0; j < dataSizeCol; j++) {
jstring TempString = curEnv->NewStringUTF( data[i][j] );

if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( dataLocal, j, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);

}
jdoubleArray rowsIndex_ = curEnv->NewDoubleArray( rowsIndexSize ) ;

if (rowsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( rowsIndex_, 0, rowsIndexSize, (jdouble*)(rowsIndex) ) ;


jdoubleArray colsIndex_ = curEnv->NewDoubleArray( colsIndexSize ) ;

if (colsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( colsIndex_, 0, colsIndexSize, (jdouble*)(colsIndex) ) ;


jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidrefreshVariableEditorStringjobjectArray__java_lang_StringjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID ,data_, rowsIndex_, colsIndex_, variableName_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(rowsIndex_);
curEnv->DeleteLocalRef(colsIndex_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::refreshVariableEditorBoolean (JavaVM * jvm_, int** data, int dataSize, int dataSizeCol, double* rowsIndex, int rowsIndexSize, double* colsIndex, int colsIndexSize, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrefreshVariableEditorBooleanjobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "refreshVariableEditorBoolean", "([[I[D[DLjava/lang/String;)V" ) ;
if (voidrefreshVariableEditorBooleanjobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "refreshVariableEditorBoolean");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[I"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jintArray dataLocal = curEnv->NewIntArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( dataLocal, 0, dataSizeCol, (jint*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jdoubleArray rowsIndex_ = curEnv->NewDoubleArray( rowsIndexSize ) ;

if (rowsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( rowsIndex_, 0, rowsIndexSize, (jdouble*)(rowsIndex) ) ;


jdoubleArray colsIndex_ = curEnv->NewDoubleArray( colsIndexSize ) ;

if (colsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( colsIndex_, 0, colsIndexSize, (jdouble*)(colsIndex) ) ;


jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidrefreshVariableEditorBooleanjobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID ,data_, rowsIndex_, colsIndex_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(rowsIndex_);
curEnv->DeleteLocalRef(colsIndex_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::refreshVariableEditorInteger8 (JavaVM * jvm_, byte** data, int dataSize, int dataSizeCol, double* rowsIndex, int rowsIndexSize, double* colsIndex, int colsIndexSize, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrefreshVariableEditorInteger8jobjectArray__bytejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "refreshVariableEditorInteger8", "([[B[D[DLjava/lang/String;)V" ) ;
if (voidrefreshVariableEditorInteger8jobjectArray__bytejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "refreshVariableEditorInteger8");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[B"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jbyteArray dataLocal = curEnv->NewByteArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetByteArrayRegion( dataLocal, 0, dataSizeCol, (jbyte*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jdoubleArray rowsIndex_ = curEnv->NewDoubleArray( rowsIndexSize ) ;

if (rowsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( rowsIndex_, 0, rowsIndexSize, (jdouble*)(rowsIndex) ) ;


jdoubleArray colsIndex_ = curEnv->NewDoubleArray( colsIndexSize ) ;

if (colsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( colsIndex_, 0, colsIndexSize, (jdouble*)(colsIndex) ) ;


jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidrefreshVariableEditorInteger8jobjectArray__bytejdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID ,data_, rowsIndex_, colsIndex_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(rowsIndex_);
curEnv->DeleteLocalRef(colsIndex_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::refreshVariableEditorUInteger8 (JavaVM * jvm_, short** data, int dataSize, int dataSizeCol, double* rowsIndex, int rowsIndexSize, double* colsIndex, int colsIndexSize, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrefreshVariableEditorUInteger8jobjectArray__shortjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "refreshVariableEditorUInteger8", "([[S[D[DLjava/lang/String;)V" ) ;
if (voidrefreshVariableEditorUInteger8jobjectArray__shortjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "refreshVariableEditorUInteger8");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[S"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jshortArray dataLocal = curEnv->NewShortArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( dataLocal, 0, dataSizeCol, (jshort*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jdoubleArray rowsIndex_ = curEnv->NewDoubleArray( rowsIndexSize ) ;

if (rowsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( rowsIndex_, 0, rowsIndexSize, (jdouble*)(rowsIndex) ) ;


jdoubleArray colsIndex_ = curEnv->NewDoubleArray( colsIndexSize ) ;

if (colsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( colsIndex_, 0, colsIndexSize, (jdouble*)(colsIndex) ) ;


jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidrefreshVariableEditorUInteger8jobjectArray__shortjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID ,data_, rowsIndex_, colsIndex_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(rowsIndex_);
curEnv->DeleteLocalRef(colsIndex_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::refreshVariableEditorInteger16 (JavaVM * jvm_, short** data, int dataSize, int dataSizeCol, double* rowsIndex, int rowsIndexSize, double* colsIndex, int colsIndexSize, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrefreshVariableEditorInteger16jobjectArray__shortjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "refreshVariableEditorInteger16", "([[S[D[DLjava/lang/String;)V" ) ;
if (voidrefreshVariableEditorInteger16jobjectArray__shortjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "refreshVariableEditorInteger16");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[S"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jshortArray dataLocal = curEnv->NewShortArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( dataLocal, 0, dataSizeCol, (jshort*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jdoubleArray rowsIndex_ = curEnv->NewDoubleArray( rowsIndexSize ) ;

if (rowsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( rowsIndex_, 0, rowsIndexSize, (jdouble*)(rowsIndex) ) ;


jdoubleArray colsIndex_ = curEnv->NewDoubleArray( colsIndexSize ) ;

if (colsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( colsIndex_, 0, colsIndexSize, (jdouble*)(colsIndex) ) ;


jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidrefreshVariableEditorInteger16jobjectArray__shortjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID ,data_, rowsIndex_, colsIndex_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(rowsIndex_);
curEnv->DeleteLocalRef(colsIndex_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::refreshVariableEditorUInteger16 (JavaVM * jvm_, int** data, int dataSize, int dataSizeCol, double* rowsIndex, int rowsIndexSize, double* colsIndex, int colsIndexSize, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrefreshVariableEditorUInteger16jobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "refreshVariableEditorUInteger16", "([[I[D[DLjava/lang/String;)V" ) ;
if (voidrefreshVariableEditorUInteger16jobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "refreshVariableEditorUInteger16");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[I"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jintArray dataLocal = curEnv->NewIntArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( dataLocal, 0, dataSizeCol, (jint*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jdoubleArray rowsIndex_ = curEnv->NewDoubleArray( rowsIndexSize ) ;

if (rowsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( rowsIndex_, 0, rowsIndexSize, (jdouble*)(rowsIndex) ) ;


jdoubleArray colsIndex_ = curEnv->NewDoubleArray( colsIndexSize ) ;

if (colsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( colsIndex_, 0, colsIndexSize, (jdouble*)(colsIndex) ) ;


jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidrefreshVariableEditorUInteger16jobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID ,data_, rowsIndex_, colsIndex_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(rowsIndex_);
curEnv->DeleteLocalRef(colsIndex_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::refreshVariableEditorInteger32 (JavaVM * jvm_, int** data, int dataSize, int dataSizeCol, double* rowsIndex, int rowsIndexSize, double* colsIndex, int colsIndexSize, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrefreshVariableEditorInteger32jobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "refreshVariableEditorInteger32", "([[I[D[DLjava/lang/String;)V" ) ;
if (voidrefreshVariableEditorInteger32jobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "refreshVariableEditorInteger32");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[I"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jintArray dataLocal = curEnv->NewIntArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( dataLocal, 0, dataSizeCol, (jint*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jdoubleArray rowsIndex_ = curEnv->NewDoubleArray( rowsIndexSize ) ;

if (rowsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( rowsIndex_, 0, rowsIndexSize, (jdouble*)(rowsIndex) ) ;


jdoubleArray colsIndex_ = curEnv->NewDoubleArray( colsIndexSize ) ;

if (colsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( colsIndex_, 0, colsIndexSize, (jdouble*)(colsIndex) ) ;


jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidrefreshVariableEditorInteger32jobjectArray__intjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID ,data_, rowsIndex_, colsIndex_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(rowsIndex_);
curEnv->DeleteLocalRef(colsIndex_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::refreshVariableEditorUInteger32 (JavaVM * jvm_, long long** data, int dataSize, int dataSizeCol, double* rowsIndex, int rowsIndexSize, double* colsIndex, int colsIndexSize, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrefreshVariableEditorUInteger32jobjectArray__longjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "refreshVariableEditorUInteger32", "([[J[D[DLjava/lang/String;)V" ) ;
if (voidrefreshVariableEditorUInteger32jobjectArray__longjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "refreshVariableEditorUInteger32");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[J"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jlongArray dataLocal = curEnv->NewLongArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetLongArrayRegion( dataLocal, 0, dataSizeCol, (jlong*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jdoubleArray rowsIndex_ = curEnv->NewDoubleArray( rowsIndexSize ) ;

if (rowsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( rowsIndex_, 0, rowsIndexSize, (jdouble*)(rowsIndex) ) ;


jdoubleArray colsIndex_ = curEnv->NewDoubleArray( colsIndexSize ) ;

if (colsIndex_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( colsIndex_, 0, colsIndexSize, (jdouble*)(colsIndex) ) ;


jstring variableName_ = curEnv->NewStringUTF( variableName );
if (variableName != NULL && variableName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidrefreshVariableEditorUInteger32jobjectArray__longjdoubleArray_doublejdoubleArray_doublejstringjava_lang_StringID ,data_, rowsIndex_, colsIndex_, variableName_);
                        curEnv->DeleteLocalRef(data_);
curEnv->DeleteLocalRef(rowsIndex_);
curEnv->DeleteLocalRef(colsIndex_);
curEnv->DeleteLocalRef(variableName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::closeVariableEditor (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidcloseVariableEditorID = curEnv->GetStaticMethodID(cls, "closeVariableEditor", "()V" ) ;
if (voidcloseVariableEditorID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "closeVariableEditor");
}

                         curEnv->CallStaticVoidMethod(cls, voidcloseVariableEditorID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
