#include "IsometricCameraGL.hxx"
/* Generated by GIWS (version 1.3.0) */
/*

Copyright 2007-2008 INRIA
Copyright 2008-2011 DIGITEO

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_renderer_subwinDrawing {

// Returns the current env

JNIEnv * IsometricCameraGL::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

IsometricCameraGL::~IsometricCameraGL() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
}
// Constructors
IsometricCameraGL::IsometricCameraGL(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voiddisplayID=NULL;
voidinitializeDrawingjintintID=NULL;
voidendDrawingID=NULL;
voidshowjintintID=NULL;
voiddestroyjintintID=NULL;
voidsetViewingAreajdoubledoublejdoubledoublejdoubledoublejdoubledoubleID=NULL;
voidsetNormalizationParametersjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID=NULL;
voidsetAxesRotationParametersjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID=NULL;
voidsetFittingScalejdoubledoublejdoubledoublejdoubledoubleID=NULL;
voidplaceCameraID=NULL;
voidredrawCameraID=NULL;
voidreplaceCameraID=NULL;
voidsetAxesReversejbooleanbooleanjbooleanbooleanjbooleanbooleanID=NULL;
jintArray_getPixelCoordinatesjdoubledoublejdoubledoublejdoubledoubleID=NULL;
jintArray_get2dViewPixelCoordinatesjdoubledoublejdoubledoublejdoubledoubleID=NULL;
jdoubleArray_getProjectionMatrixID=NULL;
jdoubleArray_getUnprojectMatrixID=NULL;
jdoubleArray_get2dViewProjectionMatrixID=NULL;
jdoubleArray_get2dViewUnprojectMatrixID=NULL;
jdoubleArray_getViewPortID=NULL;
voidsetAxesBoundsjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID=NULL;


}

IsometricCameraGL::IsometricCameraGL(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voiddisplayID=NULL;
voidinitializeDrawingjintintID=NULL;
voidendDrawingID=NULL;
voidshowjintintID=NULL;
voiddestroyjintintID=NULL;
voidsetViewingAreajdoubledoublejdoubledoublejdoubledoublejdoubledoubleID=NULL;
voidsetNormalizationParametersjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID=NULL;
voidsetAxesRotationParametersjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID=NULL;
voidsetFittingScalejdoubledoublejdoubledoublejdoubledoubleID=NULL;
voidplaceCameraID=NULL;
voidredrawCameraID=NULL;
voidreplaceCameraID=NULL;
voidsetAxesReversejbooleanbooleanjbooleanbooleanjbooleanbooleanID=NULL;
jintArray_getPixelCoordinatesjdoubledoublejdoubledoublejdoubledoubleID=NULL;
jintArray_get2dViewPixelCoordinatesjdoubledoublejdoubledoublejdoubledoubleID=NULL;
jdoubleArray_getProjectionMatrixID=NULL;
jdoubleArray_getUnprojectMatrixID=NULL;
jdoubleArray_get2dViewProjectionMatrixID=NULL;
jdoubleArray_get2dViewUnprojectMatrixID=NULL;
jdoubleArray_getViewPortID=NULL;
voidsetAxesBoundsjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID=NULL;


}

// Generic methods

void IsometricCameraGL::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "IsometricCameraGL");
}
}

void IsometricCameraGL::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "IsometricCameraGL");
}
}
// Method(s)

void IsometricCameraGL::display (){

JNIEnv * curEnv = getCurrentEnv();

if (voiddisplayID==NULL) { /* Use the cache */
 voiddisplayID = curEnv->GetMethodID(this->instanceClass, "display", "()V" ) ;
if (voiddisplayID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "display");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddisplayID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::initializeDrawing (int figureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voidinitializeDrawingjintintID==NULL) { /* Use the cache */
 voidinitializeDrawingjintintID = curEnv->GetMethodID(this->instanceClass, "initializeDrawing", "(I)V" ) ;
if (voidinitializeDrawingjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "initializeDrawing");
}
}
                         curEnv->CallVoidMethod( this->instance, voidinitializeDrawingjintintID ,figureIndex);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::endDrawing (){

JNIEnv * curEnv = getCurrentEnv();

if (voidendDrawingID==NULL) { /* Use the cache */
 voidendDrawingID = curEnv->GetMethodID(this->instanceClass, "endDrawing", "()V" ) ;
if (voidendDrawingID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "endDrawing");
}
}
                         curEnv->CallVoidMethod( this->instance, voidendDrawingID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::show (int figureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voidshowjintintID==NULL) { /* Use the cache */
 voidshowjintintID = curEnv->GetMethodID(this->instanceClass, "show", "(I)V" ) ;
if (voidshowjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "show");
}
}
                         curEnv->CallVoidMethod( this->instance, voidshowjintintID ,figureIndex);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::destroy (int parentFigureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voiddestroyjintintID==NULL) { /* Use the cache */
 voiddestroyjintintID = curEnv->GetMethodID(this->instanceClass, "destroy", "(I)V" ) ;
if (voiddestroyjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "destroy");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddestroyjintintID ,parentFigureIndex);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::setViewingArea (double transX, double transY, double scaleX, double scaleY){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetViewingAreajdoubledoublejdoubledoublejdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 voidsetViewingAreajdoubledoublejdoubledoublejdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "setViewingArea", "(DDDD)V" ) ;
if (voidsetViewingAreajdoubledoublejdoubledoublejdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setViewingArea");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetViewingAreajdoubledoublejdoubledoublejdoubledoublejdoubledoubleID ,transX, transY, scaleX, scaleY);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::setNormalizationParameters (double normalizeScaleX, double normalizeScaleY, double normalizeScaleZ, double transX, double transY, double transZ){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetNormalizationParametersjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 voidsetNormalizationParametersjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "setNormalizationParameters", "(DDDDDD)V" ) ;
if (voidsetNormalizationParametersjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setNormalizationParameters");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetNormalizationParametersjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID ,normalizeScaleX, normalizeScaleY, normalizeScaleZ, transX, transY, transZ);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::setAxesRotationParameters (double centerX, double centerY, double centerZ, double alpha, double theta){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetAxesRotationParametersjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 voidsetAxesRotationParametersjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "setAxesRotationParameters", "(DDDDD)V" ) ;
if (voidsetAxesRotationParametersjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setAxesRotationParameters");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetAxesRotationParametersjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID ,centerX, centerY, centerZ, alpha, theta);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::setFittingScale (double scaleX, double scaleY, double scaleZ){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetFittingScalejdoubledoublejdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 voidsetFittingScalejdoubledoublejdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "setFittingScale", "(DDD)V" ) ;
if (voidsetFittingScalejdoubledoublejdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFittingScale");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetFittingScalejdoubledoublejdoubledoublejdoubledoubleID ,scaleX, scaleY, scaleZ);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::placeCamera (){

JNIEnv * curEnv = getCurrentEnv();

if (voidplaceCameraID==NULL) { /* Use the cache */
 voidplaceCameraID = curEnv->GetMethodID(this->instanceClass, "placeCamera", "()V" ) ;
if (voidplaceCameraID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "placeCamera");
}
}
                         curEnv->CallVoidMethod( this->instance, voidplaceCameraID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::redrawCamera (){

JNIEnv * curEnv = getCurrentEnv();

if (voidredrawCameraID==NULL) { /* Use the cache */
 voidredrawCameraID = curEnv->GetMethodID(this->instanceClass, "redrawCamera", "()V" ) ;
if (voidredrawCameraID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "redrawCamera");
}
}
                         curEnv->CallVoidMethod( this->instance, voidredrawCameraID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::replaceCamera (){

JNIEnv * curEnv = getCurrentEnv();

if (voidreplaceCameraID==NULL) { /* Use the cache */
 voidreplaceCameraID = curEnv->GetMethodID(this->instanceClass, "replaceCamera", "()V" ) ;
if (voidreplaceCameraID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "replaceCamera");
}
}
                         curEnv->CallVoidMethod( this->instance, voidreplaceCameraID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void IsometricCameraGL::setAxesReverse (bool xAxisRevert, bool yAxisRevert, bool zAxisRevert){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetAxesReversejbooleanbooleanjbooleanbooleanjbooleanbooleanID==NULL) { /* Use the cache */
 voidsetAxesReversejbooleanbooleanjbooleanbooleanjbooleanbooleanID = curEnv->GetMethodID(this->instanceClass, "setAxesReverse", "(ZZZ)V" ) ;
if (voidsetAxesReversejbooleanbooleanjbooleanbooleanjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setAxesReverse");
}
}
jboolean xAxisRevert_ = (static_cast<bool>(xAxisRevert) ? JNI_TRUE : JNI_FALSE);

jboolean yAxisRevert_ = (static_cast<bool>(yAxisRevert) ? JNI_TRUE : JNI_FALSE);

jboolean zAxisRevert_ = (static_cast<bool>(zAxisRevert) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallVoidMethod( this->instance, voidsetAxesReversejbooleanbooleanjbooleanbooleanjbooleanbooleanID ,xAxisRevert_, yAxisRevert_, zAxisRevert_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int* IsometricCameraGL::getPixelCoordinates (double userCoordX, double userCoordY, double userCoordZ){

JNIEnv * curEnv = getCurrentEnv();

if (jintArray_getPixelCoordinatesjdoubledoublejdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 jintArray_getPixelCoordinatesjdoubledoublejdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "getPixelCoordinates", "(DDD)[I" ) ;
if (jintArray_getPixelCoordinatesjdoubledoublejdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getPixelCoordinates");
}
}
                        jintArray res =  static_cast<jintArray>( curEnv->CallObjectMethod( this->instance, jintArray_getPixelCoordinatesjdoubledoublejdoubledoublejdoubledoubleID ,userCoordX, userCoordY, userCoordZ));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

int* IsometricCameraGL::get2dViewPixelCoordinates (double userCoordX, double userCoordY, double userCoordZ){

JNIEnv * curEnv = getCurrentEnv();

if (jintArray_get2dViewPixelCoordinatesjdoubledoublejdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 jintArray_get2dViewPixelCoordinatesjdoubledoublejdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "get2dViewPixelCoordinates", "(DDD)[I" ) ;
if (jintArray_get2dViewPixelCoordinatesjdoubledoublejdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get2dViewPixelCoordinates");
}
}
                        jintArray res =  static_cast<jintArray>( curEnv->CallObjectMethod( this->instance, jintArray_get2dViewPixelCoordinatesjdoubledoublejdoubledoublejdoubledoubleID ,userCoordX, userCoordY, userCoordZ));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

double* IsometricCameraGL::getProjectionMatrix (){

JNIEnv * curEnv = getCurrentEnv();

if (jdoubleArray_getProjectionMatrixID==NULL) { /* Use the cache */
 jdoubleArray_getProjectionMatrixID = curEnv->GetMethodID(this->instanceClass, "getProjectionMatrix", "()[D" ) ;
if (jdoubleArray_getProjectionMatrixID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getProjectionMatrix");
}
}
                        jdoubleArray res =  static_cast<jdoubleArray>( curEnv->CallObjectMethod( this->instance, jdoubleArray_getProjectionMatrixID ));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jdouble *resultsArray = static_cast<jdouble *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
double* myArray= new double[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

double* IsometricCameraGL::getUnprojectMatrix (){

JNIEnv * curEnv = getCurrentEnv();

if (jdoubleArray_getUnprojectMatrixID==NULL) { /* Use the cache */
 jdoubleArray_getUnprojectMatrixID = curEnv->GetMethodID(this->instanceClass, "getUnprojectMatrix", "()[D" ) ;
if (jdoubleArray_getUnprojectMatrixID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getUnprojectMatrix");
}
}
                        jdoubleArray res =  static_cast<jdoubleArray>( curEnv->CallObjectMethod( this->instance, jdoubleArray_getUnprojectMatrixID ));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jdouble *resultsArray = static_cast<jdouble *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
double* myArray= new double[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

double* IsometricCameraGL::get2dViewProjectionMatrix (){

JNIEnv * curEnv = getCurrentEnv();

if (jdoubleArray_get2dViewProjectionMatrixID==NULL) { /* Use the cache */
 jdoubleArray_get2dViewProjectionMatrixID = curEnv->GetMethodID(this->instanceClass, "get2dViewProjectionMatrix", "()[D" ) ;
if (jdoubleArray_get2dViewProjectionMatrixID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get2dViewProjectionMatrix");
}
}
                        jdoubleArray res =  static_cast<jdoubleArray>( curEnv->CallObjectMethod( this->instance, jdoubleArray_get2dViewProjectionMatrixID ));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jdouble *resultsArray = static_cast<jdouble *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
double* myArray= new double[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

double* IsometricCameraGL::get2dViewUnprojectMatrix (){

JNIEnv * curEnv = getCurrentEnv();

if (jdoubleArray_get2dViewUnprojectMatrixID==NULL) { /* Use the cache */
 jdoubleArray_get2dViewUnprojectMatrixID = curEnv->GetMethodID(this->instanceClass, "get2dViewUnprojectMatrix", "()[D" ) ;
if (jdoubleArray_get2dViewUnprojectMatrixID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get2dViewUnprojectMatrix");
}
}
                        jdoubleArray res =  static_cast<jdoubleArray>( curEnv->CallObjectMethod( this->instance, jdoubleArray_get2dViewUnprojectMatrixID ));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jdouble *resultsArray = static_cast<jdouble *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
double* myArray= new double[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

double* IsometricCameraGL::getViewPort (){

JNIEnv * curEnv = getCurrentEnv();

if (jdoubleArray_getViewPortID==NULL) { /* Use the cache */
 jdoubleArray_getViewPortID = curEnv->GetMethodID(this->instanceClass, "getViewPort", "()[D" ) ;
if (jdoubleArray_getViewPortID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getViewPort");
}
}
                        jdoubleArray res =  static_cast<jdoubleArray>( curEnv->CallObjectMethod( this->instance, jdoubleArray_getViewPortID ));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jdouble *resultsArray = static_cast<jdouble *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
double* myArray= new double[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

void IsometricCameraGL::setAxesBounds (double xMin, double xMax, double yMin, double yMax, double zMin, double zMax){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetAxesBoundsjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 voidsetAxesBoundsjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "setAxesBounds", "(DDDDDD)V" ) ;
if (voidsetAxesBoundsjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setAxesBounds");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetAxesBoundsjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID ,xMin, xMax, yMin, yMax, zMin, zMax);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
