/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2004-2006 - INRIA - Fabrice Leray
 * Copyright (C) 2006 - INRIA - Allan Cornet
 * Copyright (C) 2006 - INRIA - Jean-Baptiste Silvy
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

/*------------------------------------------------------------------------*/
/* file: set_mark_size_unit_property.c                                    */
/* desc : function to modify in Scilab the mark_size_unit field of        */
/*        a handle                                                        */
/*------------------------------------------------------------------------*/

#include "setHandleProperty.h"
#include "SetProperty.h"
#include "getPropertyAssignedValue.h"
#include "Scierror.h"
#include "localization.h"
#include "SetPropertyStatus.h"

/*------------------------------------------------------------------------*/
int set_mark_size_unit_property( sciPointObj * pobj, size_t stackPointer, int valueType, int nbRow, int nbCol )
{
  if ( !isParameterStringMatrix( valueType ) )
  {
    Scierror(999, _("Wrong type for '%s' property: String expected.\n"), "mark_size_unit");
    return SET_PROPERTY_ERROR ;
  }

  if ( isStringParamEqual( stackPointer, "point") )
  {
    return sciSetMarkSizeUnit( pobj, 1 ) ; /* 1 : points, 2 : tabulated */
  }
  else if ( isStringParamEqual( stackPointer, "tabulated" ) )
  {
    return sciSetMarkSizeUnit( pobj, 2) ;
  }
  else
  {
    Scierror(999, _("Wrong value for '%s' property: %s or %s expected.\n"), "mark_size_unit", "'point'", "'tabulated'");

  }
  return SET_PROPERTY_ERROR ;
}
/*------------------------------------------------------------------------*/
