// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) DIGITEO - 2009-2011 - Allan CORNET
//
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
//=============================================================================
function ilib_gen_cleaner(makename,loadername,files)

  [lhs,rhs] = argn(0);

  if (rhs < 1) then
    makename = 'makelib';
  end

  if (rhs < 2) then
    loadername = 'loader.sce';
  end

  if (rhs < 3) then
    files = [];
  end

  cleanername = 'cleaner.sce';

  fd = mopen(cleanername,"wt");
  mfprintf(fd,"// This file is released under the 3-clause BSD license. See COPYING-BSD.\n");
  mfprintf(fd,"// Generated by builder.sce : Please, do not edit this file\n");
  mfprintf(fd,"// cleaner.sce\n");
  mfprintf(fd,"// ------------------------------------------------------\n");
  mfprintf(fd,"curdir = pwd();\n");
  mfprintf(fd,"cleaner_path = get_file_path(''cleaner.sce'');\n");
  mfprintf(fd,"chdir(cleaner_path);\n");
  mfprintf(fd,"// ------------------------------------------------------\n");
  mfprintf(fd,"if fileinfo(''%s'') <> [] then\n",loadername);
  mfprintf(fd,"  mdelete(''%s'');\n",loadername);
  mfprintf(fd,"end\n");
  mfprintf(fd,"// ------------------------------------------------------\n");

  if getos() == 'Windows' then
    // Load dynamic_link Internal lib if it"s not already loaded
    if ~ exists("dynamic_linkwindowslib") then
      load("SCI/modules/dynamic_link/macros/windows/lib");
    end

    dlwGenerateCleaner(fd, makename);
  end

  if files <> [] then
    for i = 1:size(files,'*')
      if ( files(i) <> '' ) then
        mfprintf(fd,"if fileinfo(''%s'') <> [] then\n", files(i));
        mfprintf(fd,"  mdelete(''%s'');\n", files(i));
        mfprintf(fd,"end\n");
        mfprintf(fd,"// ------------------------------------------------------\n");
      end
    end
  end

  mfprintf(fd,"chdir(curdir);\n");
  mfprintf(fd,"// ------------------------------------------------------\n");
  mclose(fd);

  if ilib_verbose() > 1 then
    disp(mgetl('cleaner.sce'));
  end
endfunction
//=============================================================================
