.\" Copyright © 2005-2010  Roger Leigh <rleigh@debian.org>
.\"
.\" schroot is free software: you can redistribute it and/or modify it
.\" under the terms of the GNU General Public License as published by
.\" the Free Software Foundation, either version 3 of the License, or
.\" (at your option) any later version.
.\"
.\" schroot is distributed in the hope that it will be useful, but
.\" WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
.\" General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see
.\" <http://www.gnu.org/licenses/>.
.\"
.so config.man
.ds PROGRAM dchroot\-dsa
.TH DCHROOT-DSA 1 "\*[RELEASE_DATE]" "Version \*[VERSION]" "Debian sbuild"
.SH NAME
dchroot\-dsa \- enter a chroot environment
.SH SYNOPSIS
.B dchroot\-dsa
.RB [ \-h \[or] \-\-help " \[or] " \-V \[or] \-\-version
.RB " \[or] " \-l \[or] \-\-list " \[or] " \-i \[or] \-\-info
.RB " \[or] " \-\-config " \[or] " -p | \-\-listpaths ]
.RB [ "\-d \fIdirectory\fP" \[or] "\-\-directory=\fIdirectory\fP" ]
.RB [ \-q \[or] \-\-quiet " \[or] " \-v \[or] \-\-verbose ]
.RB [ "\-c \fIchroot\fP" \[or] "\-\-chroot=\fIchroot\fP"
.RB " \[or] " \-\-all " \[or] " CHROOT]
.RB [ COMMAND ]
.SH DESCRIPTION
\fBdchroot\-dsa\fP allows the user to run a command or a login shell in a
chroot environment.  If no command is specified, a login shell will be started
in the user's home directory inside the chroot.
.PP
The user's environment will be preserved inside the chroot.
.PP
The command is a single argument which must be an absolute path to the program.
Additional options are not permitted.
.PP
The directory the command or login shell is run in depends upon the context.
See \fI\-\-directory\fP option below for a complete description.
.PP
This version of dchroot\-dsa is a compatibility wrapper around the
.BR schroot (1)
program.  It is provided for backward compatibility with the dchroot\-dsa
command-line options, but schroot is recommended for future use.  See the
section \[lq]\fIMigration\fP\[rq] below for help migrating your existing
dchroot\-dsa configuration to schroot.  See the section
\[lq]\fIIncompatibilities\fP\[rq] below for known incompatibilities with older
versions of dchroot\-dsa.
.PP
.SH OPTIONS
\fBdchroot\-dsa\fP accepts the following options:
.SS Basic options
.TP
.BR \-h ", " \-\-help
Show help summary.
.TP
.BR \-a ", " \-\-all
Select all chroots.  Note that earlier versions of dchroot\-dsa did not include
this option.
.TP
.BR \-c ", " \-\-chroot=\fIchroot\fP
Specify a chroot to use.  This option may be used multiple times to specify
more than one chroot, in which case its effect is similar to \fI\-\-all\fP.  If
this option is not used, the first non-option argument specified the chroot to
use.  Note that earlier versions of dchroot\-dsa did not include this option.
.TP
.BR \-l ", " \-\-list
List all available chroots.
.TP
.BR \-i ", " \-\-info
Print detailed information about the available chroots.  Note that earlier
versions of dchroot\-dsa did not include this option.
.TP
.BR \-p ", " \-\-listpaths
Print absolute locations (paths) of the available chroots.
.TP
.BR \-\-config
Print configuration of the available chroots.  This is useful for testing that
the configuration in use is the same as the configuration file.  Any comments
in the original file will be missing.  Note that earlier versions of
dchroot\-dsa did not include this option.
.TP
.BR \-d ", " \-\-directory=\fIdirectory\fP
Change to \fIdirectory\fP inside the chroot before running the command or login
shell.  If \fIdirectory\fP is not available, dchroot\-dsa will exit with an
error status.
.IP
The default behaviour (all directory paths are inside the chroot) is to run the
login shell or command in the user's home directory, or \fI/\fP if the home
directory is not available.  If none of the directories are available,
dchroot\-dsa will exit with an error status.
.TP
.BR \-q ", " \-\-quiet
Print only essential messages.  Note that earlier versions of dchroot\-dsa did
not include this option.
.TP
.BR \-v ", " \-\-verbose
Print all messages.  Note that earlier versions of dchroot\-dsa did not include
this option.
.TP
.BR \-V ", " \-\-version
Print version information.
.SH CONFIGURATION
The original \fBdchroot\-dsa\fP configuration file, \fI\*[DCHROOT_CONF]\fP, used
by earlier versions of dchroot\-dsa, has the following format:
.IP \[bu]
\[oq]#\[cq] starts a comment line.
.IP \[bu]
Blank lines are ignored.
.IP \[bu]
Chroot definitions are a single line containing an \f[CBI]identifier\fP,
\f[CBI]path\fP, and \f[CBI]users\fP, an optional user list separated by
whitespace (space and tab), or a colon (\[oq]:\[cq]), semicolon (\[oq];\[cq]),
or comma (\[oq],\[cq]).
.PP
An example file:
.PP
.RS
\f[CR]# Example comment\fP
.br
\f[CR]\fP
.br
\f[CR]sarge /srv/chroot/sarge\fP
.br
\f[CR]sid /srv/chroot/sid rleigh,fred\fP
.br
.RE
.PP
This file defines a chroot called \[oq]sarge\[cq], located at
\fI/srv/chroot/sarge\fP, and a second chroot called \[oq]sid\[cq], located at
\fI/srv/chroot/sid\fP.  The second chroot specifies that it may only be used by
the users \[lq]rleigh\[rq] and \[lq]fred\[rq].
.SH INCOMPATIBILITIES
.SS DSA dchroot
.IP \[bu]
Log messages are worded and formatted differently.
.IP \[bu]
dchroot\-dsa provides a restricted subset of the functionality implemented by
\fBschroot\fP, but is still schroot underneath.  Thus dchroot\-dsa is still
subject to schroot security checking, including PAM authentication and
authorisation, and session management, for example, and hence may behave
slightly differently to earlier versions of dchroot\-dsa in some circumstances.
.SS Debian dchroot
A \fBdchroot\fP package provides an alternative dchroot implementation.
.IP \[bu]
All the above incompatibilities apply.
.IP \[bu]
This version of dchroot has incompatible command-line options, and while some
of those options are supported or have equivalent options by a different name,
the \fI\-c\fP option is required to specify a chroot.  It also allows a shell
script to be used as the option instead of a single absolute path, and allows
multiple command options instead of a single option.
.IP \[bu]
This version of dchroot has an incompatible format for \fIdchroot.conf\fP.
While the first two fields are the same, the third field is a optional
\f[CBI]personality\fP, instead of the \f[CI]users\fP user list permitted to
access the chroot allowed by this version.  If personality support is needed,
please use \fIschroot.conf\fP and add the allowed users there, as shown in
\[lq]\fIMigration\fP\[rq] below.
.SH MIGRATION
To migrate an existing \fBdchroot\-dsa\fP configuration to \fBschroot\fP,
perform the following steps:
.IP 1
Dump the dchroot\-dsa configuration in schroot keyfile format to
\fI\*[SCHROOT_CONF]\fP.
.PP
.RS
\f[CR]# \f[CB]dchroot\-dsa --config >> \*[SCHROOT_CONF]
.br
.RE
.PP
.IP 2
Edit \fI\*[SCHROOT_CONF]\fP to add access to the users and/or groups which are to
be allowed to access the chroots, and make any other desired changes to the
configuration.  See
.BR schroot.conf (5).
.IP 3
Remove \fI\*[DCHROOT_CONF]\fP, so that dchroot\-dsa will subsequently use
\fI\*[SCHROOT_CONF]\fP for its configuration.
.SH EXAMPLES
\f[CR]$ \f[CB]dchroot\-dsa -l\fP\fP
.br
\f[CR]Available chroots: sarge, sid\fP
.br
\f[CR]\fP
.br
\f[CR]$ \f[CB]dchroot\-dsa \-\-listpaths\fP\fP
.br
\f[CR]/srv/chroot/sarge\fP
.br
\f[CR]/srv/chroot/sid\fP
.br
\f[CR]\fP
.br
\f[CR]$ \f[CB]dchroot\-dsa \-q sid \-\- /bin/uname\fP\fP
.br
\f[CR]Linux\fP
.br
\f[CR]\fP
.br
\f[CR]$ \f[CB]dchroot\-dsa sid\fP\fP
.br
\f[CR]I: [sid chroot] Running login shell: \[lq]/bin/bash\[rq]\fP
.br
\f[CR]$ \fP
.br
.LP
Note that the top line was echoed to standard error, and the remaining lines to
standard output.  This is intentional, so that program output from commands run
in the chroot may be piped and redirected as required; the data will be the
same as if the command was run directly on the host system.
.SH TROUBLESHOOTING
If something is not working, and it's not clear from the error messages what is
wrong, try using the \fB\-\-debug=\fP\fIlevel\fP option to turn on debugging
messages.  This gives a great deal more information.  Valid debug levels are
\[oq]none\[cq], and \[oq]notice\[cq], \[oq]info\[cq], \[oq]warning\[cq] and
\[oq]critical\[cq] in order of increasing severity.  The lower the severity
level, the more output.
.PP
If you are still having trouble, the developers may be contacted on the mailing
list:
.br
\f[CR]Debian\ buildd-tools\ Developers
.br
<buildd-tools-devel@lists.alioth.debian.org>\fP
.SH BUGS
None known at this time.
.SH FILES
.TP
\f[BI]\*[DCHROOT_CONF]\fP
The system-wide \fBdchroot\-dsa\fP chroot definition file.  This file must be
owned by the root user, and not be writable by other.  If present, this file
will be used in preference to \fI\*[SCHROOT_CONF]\fP.
.TP
\f[BI]\*[SCHROOT_CONF]\fP
The system-wide \fBschroot\fP definition file.  This file must be owned by the
root user, and not be writable by other.  It is recommended that this file be
used in preference to \fI\*[DCHROOT_CONF]\fP, because the chroots can be used
interchangeably with schroot, and the user and group security policies provided
by schroot are also enforced.
.so authors.man
.PP
This implementation of dchroot\-dsa uses the same command-line options as
the \fBdchroot\fP found on machines run by the Debian System Administrators for
the Debian Project.  These machines have a \fBdchroot-dsa\fP source package
which provides a \fBdchroot\-dsa\fP package, written by Ben Collins
\f[CR]<bcollins@debian.org>\fP and Martin Schulze \f[CR]<joey@debian.org>\fP.
.so copyright.man
.SH SEE ALSO
.BR schroot (1),
.BR sbuild (1),
.BR chroot (2),
.BR schroot-setup (5),
.BR schroot.conf (5).
.\"#
.\"# The following sets edit modes for GNU EMACS
.\"# Local Variables:
.\"# mode:nroff
.\"# fill-column:79
.\"# End:
