# Samizdat member model
#
#   Copyright (c) 2002-2009  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 3 or later.
#
# vim: et sw=2 sts=2 ts=8 tw=0

require 'samizdat/engine'

class Member
  def Member.cached(id)
    if id = Resource.validate_id(id)
      cache.fetch_or_add(%{member/#{id}}) do
        Member.new(id)
      end
    else
      Member.new(nil)
    end
  end

  def initialize(id)
    if id and @id = Resource.validate_id(id)
      @login = rdf.get_property(@id, 's::login')
      @full_name = rdf.get_property(@id, 's::fullName')

      @profile = {}
      prefs = Preferences.new(@login)
      config.plugins['profile'].each do |plugin|
        @profile[plugin.field] = plugin.current_value(prefs)
      end

    else
      @login = 'guest'
    end

    @full_name ||= @login

    @access = {}
    config.plugins['access'].each do |plugin|
      plugin.set_member_access(self)
    end
  end

  attr_reader :id, :login, :full_name, :profile, :access

  def allowed_to?(action)
    allow = false
    config.plugins.find_all('access', self, action).each do |plugin|
      if plugin.allow?
        allow = true
      else
        allow = false
        break
      end
    end

    allow
  end

  def assert_allowed_to(action)
    allowed_to?(action) or raise AuthError,
      sprintf(_('Your current access level (%s) does not allow to perform this action (%s)'),
        config.plugins['access'].collect {|plugin|
          plugin.display_member_access(self)
        }.join(', '), _(action))
  end
end
