//  Copyright (C) 2006-2008  CEA/DEN, EDF R&D
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
#ifndef __OUTPORT_HXX__
#define __OUTPORT_HXX__

#include "YACSlibEngineExport.hxx"
#include "DataPort.hxx"
#include "Exception.hxx"

#include <set>
#include <vector>

namespace YACS
{
  namespace ENGINE
  {
    class InPort;
    class LinkInfo;
    class YACSLIBENGINE_EXPORT OutPort : public virtual DataPort
    {
    protected:
      OutPort(const OutPort& other, Node *newHelder);
      OutPort(const std::string& name, Node *node, TypeCode* type);
    public:
      virtual void checkConsistency(LinkInfo& info) const;
      virtual int edGetNumberOfOutLinks() const;
      virtual std::set<InPort *> edSetInPort() const = 0;
      virtual bool isAlreadyLinkedWith(InPort *with) const = 0;
      virtual void getAllRepresented(std::set<OutPort *>& represented) const;
      virtual bool addInPort(InPort *inPort) throw(Exception) = 0;
      virtual int removeInPort(InPort *inPort, bool forward) throw(Exception) = 0;
      virtual ~OutPort();
      std::vector<DataPort *> calculateHistoryOfLinkWith(InPort *end);
      virtual std::string typeName() {return "YACS__ENGINE__OutPort";}
    };
  }
}

#endif
