# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

__xdata__items__ = [
    "Square",
    ]

from xdata import *

from shape2D import Shape2D
from shape import Point

class Polygon(Shape2D):
    __init__xattributes__ = [
        XAttribute("vertices", xtype=XList(len_min=3, sequence=XInstance(Point))),
        ]
    def setVertices(self, value):
        vertices = self.vertices
        val = vertices[0].getX()
        xmin, ymin, xmax, ymax = val, val, val, val
        for v in vertices:
            x, y = v.x, v.y
            if x < xmin : xmin = x
            if x > xmax : xmax = x
            if y < ymin : ymin = y
            if y > ymax : ymax = y
            pass
        self.bounds = [xmin, xmax, ymin, ymax]
        return
    pass

class Square(Polygon):
    __init__xattributes__ = [
        XAttribute("l", xtype=XFloat(open_min=0.0)),
        ]
    def setL(self, value):
        l = self.l
        min, max = -l/2, +l/2
        p0 = Point(min, min, 0)
        p1 = Point(max, min, 0)
        p2 = Point(max, max, 0)
        p3 = Point(min, max, 0)
        self.vertices = [p0, p1, p2, p3]
        return
    
    def _getToolTip(cls, target):
        if target is cls:
            from os import getenv
            resources_dir = getenv('TECHOBJ_ROOT_DIR') + '/share/salome/resources'
            text  = ''
            text += 'Image  : <img source="%s/TECHOBJ.png"><br>'%(resources_dir)
            text += 'Bold   : <b>Hello !!</b><br>'
            text += 'Italic : <i>Hello !!</i><br>'
            return text
        text  = ''
        text += 'GGGGG %s'%(target.name)
        return text
    
    getToolTip = classmethod(_getToolTip)
    
    pass
