# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

__xdata__items__ = [
    "AAAAAA",
    "BBBBBB",
    "geometry2D",
    "geometry3D",
    "XMed",
    "Creer",
    ]

def getToolTip(target):
    return "AAAAA %s"%(target)

from xdata import *

class AAAAAA(XObject):
    
    __init__xattributes__ = [
        XAttribute("aaaa", xtype=XInt()),
        XAttribute("bbbb", xtype=XInt(), default_value=1),
        XAttribute("cccc", xtype=XInt(), default_value=2),
        ]
    
    __object__xattributes__ = [
        XAttribute("hghgh", xtype=XInt(), mode="rw"),
        XAttribute("gfgfd", xtype=XInt(), default_value=1, mode="rw"),
        XAttribute("kggkg", xtype=XInt(), default_value=2, mode="rw"),
        ]
    
    def getEditionViews(cls, parent, obj):
        return ["Basic", "Expert", "Guru"]
    
    getEditionViews = classmethod(getEditionViews)
    
    def getEditionDefaultView(cls, parent, obj, views):
        return views[1]
    
    getEditionDefaultView = classmethod(getEditionDefaultView)
    
    def getXAttributesForEditionView(cls, parent, obj, view):
        if view == "Basic":
            view = "NoDefault"
        elif view == "Expert":
            view = "ValueHasChanged"
        elif view == "Guru":
            view = "All"
            pass
        res = super(AAAAAA, cls).getXAttributesForEditionView(parent, obj, view)
        return res
    
    getXAttributesForEditionView = classmethod(getXAttributesForEditionView)

    def __init__(self, *args, **kwargs):
        self.hghgh = 43
        return
    
    pass

class BBBBBB(XObject):
    
    __init__xattributes__ = [
        XAttribute("aaaa", xtype=XInt(), default_value=None),
        XAttribute("bbbb", xtype=XInt(), default_value=None),
        ]
    
    def getXAttributesForEditionView(cls, parent, obj, view):
        print parent, obj, view
        res = super(BBBBBB, cls).getXAttributesForEditionView(parent, obj, view)
        l = []
        for x in res:
            if x.name == "bbbb": continue
            l.append(x)
            pass
        return l
    
    getXAttributesForEditionView = classmethod(getXAttributesForEditionView)
    
    pass

class XMed(XObject):
    __init__xattributes__ = [
        XAttribute("med_file",
                   xtype=XInputFileName(suffix_into=[".med"]),
                   default_value="/home/is102430/adam/NEW/ALLIANCES_BUILD/share/alliances/med/quad_gros_5_3.med",
                   ),
        ]
    __object__xattributes__ = [
        XAttribute("meshes", xtype=XDict()),
        XAttribute("groups_MED_CELL", xtype=XDict()),
        XAttribute("groups_MED_EDGE", xtype=XDict()),
        ]
    def setMedFile(self, value):
        med_file = self.med_file
        from mesh import importMedFromFile
        med = importMedFromFile(med_file)
        #
        self.meshes = {}
        self.groups_MED_CELL = {}
        self.groups_MED_EDGE = {}
        #
        for mesh_name in med.getMeshesNames():
            mesh = med.getMesh(mesh_name)
            self.meshes[mesh_name] = mesh
            from mesh import MED_CELL
            for name in mesh.getGroupsNames(MED_CELL):
                group = mesh.getZone(name)
                self.groups_MED_CELL[name] = group
                pass
            from mesh import MED_EDGE
            for name in mesh.getGroupsNames(MED_EDGE):
                group = mesh.getBoundary(name)
                self.groups_MED_EDGE[name] = group
                pass
            pass
        #
        return
    pass

_xxx = XMulTypes(
    XInputFileName(suffix_into=[".med"]),
    XInputFileName(suffix_into=[".brep"]),
    XInputDirName(),
    XList(sequence=XInputFileName(suffix_into=[".brep"])),
    )

class Creer(XObject):
    __init__xattributes__ = [
        XAttribute("maillage", xtype=_xxx),
        XAttribute("z", xtype=XFloat()),
        ]
    pass
