# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xdata import *

from libMEDClient import *

class MedFieldCreator(XNamedObject):
    __init__xattributes__ = [
        XAttribute("mesh", xtype=XInstance(MESH)),
        ]
    __object__xmethods__ = [
        XMethod("run"),
        ]
    __object__xattributes__ = [
        XAttribute("field", xtype=XInstance("libMEDClient.FIELD_")),
        ]
    
    def run(self):
        mesh = self.mesh
        support = SUPPORT(mesh, "my_support", MED_CELL)
        field = FIELDDOUBLE(support, 1)
        # Keep a ref (avoid garbage of local support)
        field.__ref__support__ = support
        field.setName("my_field")
        #
        from time import sleep
        print "very complex computation ... patience"
        sleep(3)
        #
        nb_vals = support.getNumberOfElements(MED_ALL_ELEMENTS)
        vals = [ float(i)/(nb_vals-1) for i in range(nb_vals) ]
        field.setValue(vals)
        self.field = field
        return
    
    pass
