# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xutilities import message
from xqt import *
from xmainwindow import getMainWindow

class XPythonGui(object):
    def __init__(self, *argv):
        #
        argv = list(argv)
        #
        if "-geometry" not in argv:
            argv.append('-geometry')
            argv.append('800x600+200+100')
            pass
        #
        message(argv, cls=XPythonGui)
        a = QApplication(argv)
        argv = a.argv()
        message(argv, cls=XPythonGui)
        # --
        # Parsing argv ...
        cmd, argv = argv[0], argv[1:]
        message(cmd, argv, cls=XPythonGui)
        import getopt
        try:
            optlist, args = getopt.getopt(argv, "", ["modules=", "with-splitter=", "with-menus=", "without-menus="])
        except getopt.GetoptError, e:
            msg  = str(e)
            msg += '\n\n'
            msg += 'Usage : %s [--modules=] [--with-splitter=yes/no] [--with-menus=] [--without-menus=]'%(cmd)
            msg += '\n'
            raise getopt.GetoptError(msg)
        message(optlist, args, cls=XPythonGui)
        #
        modules = []
        with_splitter = 1
        menus = ['File', 'Edit', 'View', 'Modules', 'Tools', 'Preferences', 'Window', 'Help']
        for name, value in optlist:
            message(name, value, cls=XPythonGui)
            if name == "--modules":
                modules = value.split(',')
                pass
            if name == "--with-splitter":
                if value == "yes":
                    with_splitter = 1
                elif value == "no":
                    with_splitter = 0
                else:
                    msg  = "Warning: "
                    msg += "--with-splitter option must called with argument 'yes' or 'no'.\n"
                    msg += "For instance --with-splitter=no.\n"
                    msg += "Yout value '%s' is not taking into account."%(value)
                    print msg
                    pass
                pass
            if name == "--with-menus":
                new_menus = value.split(',')
                new_menus_cleaned = []
                for m in new_menus:
                    if m not in menus: continue
                    if m in new_menus_cleaned: continue
                    new_menus_cleaned.append(m)
                    pass
                menus = new_menus_cleaned
                pass    
            if name == "--without-menus":
                new_menus = value.split(',')
                for m in new_menus:
                    try:
                        menus.remove(m)
                    except ValueError:
                        pass
                    pass
                pass    
            pass
        message("modules =", modules, cls=XPythonGui)
        message("with_splitter =", with_splitter, cls=XPythonGui)
        message("menus =", menus, cls=XPythonGui)
        #
        for name in modules:
            from os import getenv
            dir = getenv("%s_ROOT_DIR"%(name))
            import sys
            if dir:
                dir = "%s/lib/python%s/site-packages/salome"%(dir,sys.version[:3])
                if dir not in sys.path:
                    message("insertion of", dir, "in sys.path")
                    sys.path.insert(0, dir)
                    pass
                pass
            pass
        #
        from xcontext import setInterface
        setInterface("gui")
        #
        # begin {G.F}
        a.connect(a, SIGNAL('lastWindowClosed()'), self.no_quit)
        #a.connect(a, SIGNAL('lastWindowClosed()'), a, SLOT('quit()'))
        # end {G.F}
        #
        mw = XGUIQMainWindow(modules, with_splitter, menus)
        a.setMainWidget(mw)
        mw.show()
        # begin {G.F}
	mw.app=a
        # end {G.F}
        #
        if args:
            file = args[0]
            getMainWindow().importpy(file)
            pass
        #
        loop = a.exec_loop()
        return
    # begin{G.F}
    def no_quit(self,**args):
        print "Use File->Exit to quit "
        # getMainWindow().show()
        getMainWindow().exit()
        pass
    # end{G.F}
    pass

# ------------

class XGUIQMainWindow(QMainWindow):
    
    def __init__(self, modules, with_splitter, menus):
        
        QMainWindow.__init__(self)
        # self.resize(800, 600)
        # self.move(200, 100)
        self.statusBar().message('',2000)
        
        if with_splitter:
            # --
            # split the main window in horizontal windows
            #
            main_widget = QSplitter(Qt.Horizontal, self)
            self.setCentralWidget(main_widget)
            # --
            # put an object explorer on main_left
            from xdataobjectexplorer import XDataObjectExplorer
            object_explorer = XDataObjectExplorer(main_widget)
            # --
            # put a vtk widget on main_top_left
            try:
                from qvtkwidget import QVtkWidget
                qvtkwidget = QVtkWidget(main_widget)
            except:
                qvtkwidget = QWidget(main_widget)
                pass
            self.qvtkwidget = qvtkwidget
        else:
            from xdataobjectexplorer import XDataObjectExplorer
            object_explorer = XDataObjectExplorer(self)
            main_widget = object_explorer
            self.setCentralWidget(main_widget)
            pass
        
        # --
        # File and View menu
        file_popup_menu = QPopupMenu(self)
        view_popup_menu = QPopupMenu(self)
        edit_popup_menu = QPopupMenu(self)
        modu_popup_menu = QPopupMenu(self)
        pref_popup_menu = QPopupMenu(self)
        tool_popup_menu = QPopupMenu(self)
        wind_popup_menu = QPopupMenu(self)
        help_popup_menu = QPopupMenu(self)
        
        init_pos_id = 0
        if "File" in menus: self.menuBar().insertItem('&File',       file_popup_menu, -1, 1) ; init_pos_id += 1
        if "Edit" in menus: self.menuBar().insertItem('&Edit',       edit_popup_menu, -1, 3) ; init_pos_id += 1
        if "View" in menus: self.menuBar().insertItem('&View',       view_popup_menu, -1, 2) ; init_pos_id += 1
        if "Modules" in menus: self.menuBar().insertItem('&Modules',    modu_popup_menu, -1, 8) ; init_pos_id += 1
        if "Tools" in menus: self.menuBar().insertItem('Tools',       tool_popup_menu, -1, 4)
        if "Preferences" in menus: self.menuBar().insertItem('Preferences', pref_popup_menu, -1, 5)
        if "Window" in menus: self.menuBar().insertItem('&Window',     wind_popup_menu, -1, 6)
        if "Help" in menus: self.menuBar().insertItem('&Help',       help_popup_menu, -1, 7)
        
        # --
        #
        actions = []
        actions.append( (file_popup_menu, "&Import", self.open, Qt.CTRL+Qt.Key_I, None) )
        actions.append( (file_popup_menu, "&Export", self.export, Qt.CTRL+Qt.Key_E, None) )
        actions.append( (file_popup_menu, "", None, None, None) )
        actions.append( (file_popup_menu, "E&xit", self.exit, Qt.CTRL+Qt.Key_Q, None) )
        actions.append( (edit_popup_menu, "Find", self.find, Qt.CTRL+Qt.Key_F, None) )
        # actions.append( (view_popup_menu, "Front", qvtkwidget.onViewFront, None, "view_front.png") )
        # actions.append( (view_popup_menu, "Back", qvtkwidget.onViewBack, None, "view_back.png") )
        # actions.append( (view_popup_menu, "Top", qvtkwidget.onViewTop, None, "view_top.png") )
        # actions.append( (view_popup_menu, "Bottom", qvtkwidget.onViewBottom, None, "view_bottom.png") )
        # actions.append( (view_popup_menu, "Left", qvtkwidget.onViewLeft, None, "view_left.png") )
        # actions.append( (view_popup_menu, "Right", qvtkwidget.onViewRight, None, "view_right.png") )
        #
        for a in actions:
            menu = a[0]
            menu_text = a[1]
            target = a[2]
            accel = a[3]
            icon = a[4]
            #
            if not menu_text:
                menu.insertSeparator()
                continue
            #
            qaction = QAction(self)
            qaction.setText(menu_text.replace("&", ""))
            qaction.setMenuText(menu_text)
            qaction.connect(qaction, SIGNAL("activated()"), target)
            if accel :
                qaction.setAccel(accel)
                pass
            if icon :
                import xdata
                from os.path import dirname
                dir  = dirname(xdata.__file__)
                dir += "/../../../../share/xdata/resources"
                from os.path import normpath
                dir  = normpath(dir)
                file = dir + '/' + icon
                qaction.setIconSet(QIconSet(QPixmap(file)))
                pass
            qaction.addTo(menu)
            pass
        
        # --
        #
        
        qaction = XGUIModuleSetSettingsQAction(self, "XData", init_pos_id)
        qaction.addTo(modu_popup_menu)
        for mod in modules:
            qaction = XGUIModuleSetSettingsQAction(self, mod, init_pos_id)
            qaction.addTo(modu_popup_menu)
            pass
        
        # --
        #
        
        from xmainwindow import setMainWindow
        setMainWindow(self)
        from xmainmenubar import setMenuBar
        setMenuBar(self.menuBar())
        from xmainmenubar import setMenuBarPopupMenus
        setMenuBarPopupMenus(File = file_popup_menu,
                             View = view_popup_menu,
                             Edit = edit_popup_menu,
                             Preferences = pref_popup_menu,
                             Tools = tool_popup_menu,
                             Window = wind_popup_menu,
                             Help = help_popup_menu,
                             )
        
        # --
        #
        
        self.connect(self, PYSIGNAL("update_with_xtree"), object_explorer.updateWithXTree)
        self.connect(self, PYSIGNAL("find_required"), object_explorer.findRequired)
        
        # --
        #
        
        self.connect(object_explorer, PYSIGNAL("selection_changed"), self.browserSelectionChanged)
        
        # --
        #
        
        if len(modules) == 1:
            mod = modules[0]
            qaction = XGUIModuleSetSettingsQAction(self, mod, init_pos_id)
            qaction.emit(SIGNAL("activated()"), ())
            pass
        
        # --
        #
        
        return
    
    def open(self):
        if hasattr(getMainWindow(), "__current__import__"):
            msg  = "A script is currently imported ....\n"
            msg += "You should wait that current import finished !\n"
            msg += "\n"
            QMessageBox.warning(getMainWindow(), "Warning", msg)
            return
        fn = QFileDialog.getOpenFileName(QString.null,
                                         "(*.py)",
                                         self)
        if fn.isEmpty(): return
        fileName = str(fn)
        suffix = fileName.split(".")[-1]
        exec "self.import%s(fileName)"%(suffix)
        return
    
    def export(self):
        try:
            xtree = self.xtree
        except AttributeError:
            msg = "Nothing to save"
            QMessageBox.warning(self, "Warning", msg)
            return
        #
        fn = QFileDialog.getSaveFileName(QString.null,
                                         "(*.py)",
                                         self,
                                         "save file dialog",
                                         "Choose a filename to save under" );
        if fn.isEmpty(): return
        fileName = str(fn)
        self.xtree.saveAs(fileName)
        return
    
    def exit(self):
        # begin{G.F}
        # exit is in exit_code to permit to change exit comportment
        self.exit_code()
        pass
    def exit_code(self):
        # print "ici_org"
        # self.close()
	getMainWindow().app.quit()
        # end{G.F}
        return
    
    def setSettings(self, item_id):
        # print "AAAA", item_id
        return
    
    def importpy(self, file_name):
        from xdatagui import importPy
        importPy(file_name, "python")
        return
    
    def find(self):
        message('Hello')
        d = FindDialog(getMainWindow())
        d.show()
        return
    
    pass

# --

class FindDialog(QDialog):
    
    def __init__(self, parent):
        QDialog.__init__(self, parent)
        self.parent = parent
        self.setWFlags(Qt.WDestructiveClose)
        self.setCaption('Find')
        #
        editor = QLineEdit(self)
        if hasattr(parent, "__previous__find__"):
            text = getattr(parent, "__previous__find__")
            editor.setText(text)
            pass
        self.editor = editor
        #
        editor_layout = QHBoxLayout(None)
        editor_layout.addWidget(editor)
        #
        button_all = QPushButton(self,"All")
        button_all.setText(self.trUtf8("All"))
        self.connect(button_all, SIGNAL("clicked()"), self.sendAll)
        button_previous = QPushButton(self,"Previous")
        button_previous.setText(self.trUtf8("Previous"))
        self.connect(button_previous, SIGNAL("clicked()"), self.sendPrevious)
        button_next = QPushButton(self,"Next")
        button_next.setText(self.trUtf8("Next"))
        self.connect(button_next, SIGNAL("clicked()"), self.sendNext)
        button_cancel = QPushButton(self,"Close")
        button_cancel.setText(self.trUtf8("Close"))
        self.connect(button_cancel, SIGNAL("clicked()"), self.sendClose)
        button_layout = QHBoxLayout(None)
        button2_layout = QHBoxLayout(None)
        button_layout.addWidget(button_all)
        button2_layout.addWidget(button_previous)
        button2_layout.addWidget(button_next)
        button_layout.addWidget(button_cancel)
        #
        grid_layout = QGridLayout(self, 3)
        grid_layout.addLayout(editor_layout, 0, 0)
        grid_layout.addLayout(button_layout, 1, 0)
        grid_layout.addLayout(button2_layout, 2, 0)
        return
    
    def sendFind(self, method):
        text = self.editor.text()
        message(text, cls=FindDialog)
        self.parent.__previous__find__ = text
        self.parent.emit(PYSIGNAL("find_required"), (text, method, ))
        return
    
    def sendAll(self):
        self.sendFind("all")
        return
    
    def sendNext(self):
        self.sendFind("next")
        return
    
    def sendPrevious(self):
        self.sendFind("previous")
        return
    
    def sendClose(self):
        message('Hello')
        self.close()
        return
    
    pass

# --

_current_item_id_2_xdata_name = {}
_separator_item_id_2_xdata_name = {}

class XGUIModuleSetSettingsQAction(QAction):
    
    def __init__(self, parent, module_name, init_pos_id):
        QAction.__init__(self, parent)
        QAction.setText(self, module_name)
        self.connect(self, SIGNAL("activated()"), self.activated)
        self.module_name = module_name
        self.init_pos_id = init_pos_id
        return
    
    def activated(self):
        #
        global _current_item_id_2_xdata_name
        global _separator_item_id_2_xdata_name
        items  = _current_item_id_2_xdata_name.items()
        items += _separator_item_id_2_xdata_name.items()
        for key, value in items:
            if value.find('/') > -1:
                menu_name = value.split('/')[0]
                from xmainmenubar import getMenuBarPopupMenus
                receiver = getMenuBarPopupMenus()[menu_name]
            else:
                from xmainmenubar import getMenuBar
                receiver = getMenuBar()
                pass
            receiver.removeItem(key)
            pass
        #
        init_pos_id = self.init_pos_id
        message('init_pos_id =', init_pos_id, cls=XGUIModuleSetSettingsQAction)
        component_name = self.module_name
        item_id_2_xdata_name = {}
        sep_item_id_2_xdata_name = {}
        #
        if component_name == "XData":
            _current_item_id_2_xdata_name = item_id_2_xdata_name
            _separator_item_id_2_xdata_name = sep_item_id_2_xdata_name
            return
        #
        from xitem import XDataItemTree
        self = XDataItemTree(component_name)
        #
        salome_keys = ["File", "View", "Edit", "Preferences", "Tools", "Window", "Help"]
        #
        for key in salome_keys:
            x = self.getItem(key)
            if x is None: continue
            #
            from xmainmenubar import getMenuBarPopupMenus
            receiver = getMenuBarPopupMenus()[key]
            #
            label_id = key
            item_id = salome_keys.index(key)+1
            item_id = 1000*item_id
            #
            for xx in x.children:
                pos_id = receiver.count()
                if key == "File":
                    pos_id -= 2
                    pass
                if xx.xdata_name:
                    item_id_2_xdata_name[item_id] = "%s/%s"%(key, xx.xdata_name)
                    receiver.insertItem(xx.xdata_name, item_id, pos_id)
                    item_id += 1
                else:
                    receiver.insertSeparator(pos_id)
                    idAt = receiver.idAt(pos_id)
                    sep_item_id_2_xdata_name[idAt] = "%s/"%(key)
                    pass
                pass
            pass
        #
        pos_id = init_pos_id
        for xdata_item in self.children:
            if xdata_item.is_final: continue
            label_id = xdata_item.xdata_name
            if label_id in salome_keys: continue
            item_id = 10*pos_id
            item_id_2_xdata_name[item_id] = label_id
            #
            from xmainmenubar import getMenuBar
            menu_bar = getMenuBar()
            menu_bar.insertItem(label_id, QPopupMenu(getMainWindow()), item_id, pos_id)
            #
            pos_id += 1
            pass
        #
        _current_item_id_2_xdata_name = item_id_2_xdata_name
        _separator_item_id_2_xdata_name = sep_item_id_2_xdata_name
        #
        from xmainmenubar import getMenuBar
        menu_bar = getMenuBar()
        menu_bar.setSettings(component_name, item_id_2_xdata_name)
        #
        return
    
    pass
