# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xqt import *
from xutilities import message
from xmainwindow import getMainWindow

# -----------------------

class DynamicTip( QToolTip ):
    
    def __init__( self, parent ):
        self.parent = parent
        if isinstance(parent, QListView):
            parent = parent.viewport()
            pass
        QToolTip.__init__( self, parent )
        return
    
    def maybeTip( self, pos ):
        message(self, pos, cls=DynamicTip)
        container = self.parent
        message(container, cls=DynamicTip)
        rect, text = container.tip(pos)
        message(rect, text)
        if not rect.isValid(): return
        if text : self.tip(rect, text)
        return
    
    pass

def tip( self, p ):
    pos_id = None
    if pyqt_module_name == "qt":
        for key in range(self.count()):
            try:
                r = self.itemGeometry(key)
            except AttributeError:
                r = None
                pass
            if r:
                if r.contains(p):
                    pos_id = key
                    break
                pass
            pass
        pass
    else:
        action = self.actionAt(p)
        if action:
            pos_id = self.actions().index(action)
            pass
        r = None
        pass
    if pos_id is None:
        return QRect( 0,0, -1,-1 ), None
    if 1:
        if 1:
            item_id = self.idAt(pos_id)
            item = self.item_ids[item_id]
            message(item, cls=DynamicTip)
            text = None
            if isinstance(item, XGUIQPopupMenu):
                item = item.xdata_item
                module = item.parent_module
                if hasattr(module, "getToolTip"):
                    text = module.getToolTip(item.xdata_name)
                    pass
                pass
            else:
                target = item.target
                message(target, cls=DynamicTip)
                from xdatagui import XObject
                from xutilities import myissubclass
                if myissubclass(target, XObject):
                    text = target.getToolTip(target)
                    message(text, cls=DynamicTip)
                else:
                    module = item.parent_module
                    if hasattr(module, "getToolTip"):
                        text = module.getToolTip(target)
                        pass
                    pass
                pass
            return r, text
        pass
    return QRect( 0,0, -1,-1 ), None

# -----------------------

_menu_bar = None

def setMenuBar(menu_bar):
    message(menu_bar, verbose_level_min=5)
    # --
    # E.A. : with --test runSalome option, the menu_bar is None
    # on the really first time we go here
    # --
    if menu_bar is None:
        return
    global _menu_bar
    #
    if _menu_bar:
        try:
            if pyqt_module_name == "qt":
                try:
                    menu_bar.disconnect(menu_bar, SIGNAL('highlighted(int)'), menu_bar.highlighted)
                except RuntimeError:
                    pass
            else:
                try:
                    menu_bar.disconnect(menu_bar, SIGNAL('x_highlighted(QAction*)'), menu_bar.highlighted)
                except RuntimeError:
                    pass
                pass
            pass
        except RuntimeError:
            pass
        pass
    #
    _menu_bar = menu_bar
    #
    cls = menu_bar.__class__
    cls.setSettings = setSettings
    cls.insertXDataItem = insertXDataItem
    cls.addItemId = addItemId
    cls.highlighted = highlighted
    cls.activated = activated
    cls.actionActivated = actionActivated
    cls.tip = tip
    # --
    # Initialize item_ids
    menu_bar.item_ids = {}
    if pyqt_module_name == "qt":
        menu_bar.connect(menu_bar, SIGNAL('highlighted(int)'), menu_bar.highlighted)
    else:
        menu_bar.connect(menu_bar, SIGNAL('x_highlighted(QAction*)'), menu_bar.highlighted)
        pass
    if pyqt_module_name == "qt":
        menu_bar.t = DynamicTip( menu_bar )
        pass
    #
    return

def getMenuBar():
    return _menu_bar

# -----------------------

_item_2_menu_bar_popup_menu = None

def setMenuBarPopupMenus(**kwargs):
    message(kwargs, verbose_level_min=5)
    global _item_2_menu_bar_popup_menu
    _item_2_menu_bar_popup_menu = kwargs
    #
    qmenu = kwargs['File']
    if qmenu is None: return
    #
    cls = qmenu.__class__
    cls.insertXDataItem = insertXDataItem
    cls.addItemId = addItemId
    cls.actionActivated = actionActivated
    cls.highlighted = highlighted
    #
    for val in kwargs.values():
        if val is None: continue
        val.item_ids = {}
        if pyqt_module_name == "qt":
            try:
                val.disconnect(val, SIGNAL('highlighted(int)'), val.highlighted)
            except RuntimeError:
                pass
            val.connect(val, SIGNAL('highlighted(int)'), val.highlighted)
        else:
            try:
                val.disconnect(val, SIGNAL('x_highlighted(QAction*)'), val.highlighted)
            except RuntimeError:
                pass
            val.connect(val, SIGNAL('x_highlighted(QAction*)'), val.highlighted)
            pass
        pass
    #
    return

def getMenuBarPopupMenus():
    return _item_2_menu_bar_popup_menu

# -----------------------

def setSettings(self, component_name, item_id_2_xdata_name):
    message(component_name, item_id_2_xdata_name, verbose_level_min=5)
    self.__current__component__name__ = component_name
    #
    from xitem import XDataItemTree
    root_xdata_item = XDataItemTree(component_name)
    #
    self.item_ids.clear()
    for val in getMenuBarPopupMenus().values():
        if val is None: continue
        val.item_ids.clear()
        pass
    #
    for item_id, xdata_name in item_id_2_xdata_name.items():
        message(item_id, xdata_name, verbose_level_min=5)
        if xdata_name in getMenuBarPopupMenus().keys(): continue
        xdata_item = root_xdata_item.getItem(xdata_name)
        #
        depth = xdata_item.depth
        message("depth =", depth, verbose_level_min=5)
        if depth == 1:
            receiver = self
        elif depth == 2:
            main_item = xdata_item.parent.xdata_name
            message(main_item)
            d = getMenuBarPopupMenus()
            message(d)
            try:
                receiver = d[main_item]
            except KeyError:
                continue
            message(receiver)
            if receiver is None:
                if xdata_name.split("/")[0] != "Preferences":
                    continue
                message('******* Preferences menu in Salome 3 (begin) ******')
                receiver = self
                xdata_item = root_xdata_item.getItem("Preferences")
                item_id = item_id / 1000
                message('******* Preferences menu in Salome 3 (end) ******')
                pass
            pass
        else:
            raise Exception('Very strange : item depth = %s'%(depth))
        #
        pos_id = receiver.indexOf(item_id)
        message("pos_id :", pos_id)
        if pos_id >= 0:
            receiver.removeItem(item_id)
            pass
        message(receiver, pos_id, item_id, verbose_level_min=5)
        receiver.insertXDataItem(xdata_item, pos_id, item_id)
        #
        pass
    return

def insertXDataItem(self, xdata_item, pos_id=-1, item_id=-1):
    message(self, xdata_item, pos_id, item_id, verbose_level_min=5)
    if xdata_item.is_final:
        if xdata_item.xdata_name:
            try:
                name = xdata_item.user_xdata_name
            except AttributeError:
                name = xdata_item.xdata_name
                pass
            item_id = self.insertItem(name, self.actionActivated, 0, item_id, pos_id)
            self.addItemId(item_id, xdata_item)
        else:
            self.insertSeparator(pos_id)
            pass
        pass
    else:
        xgui_menu = XGUIQPopupMenu(getMainWindow(), xdata_item)
        item_id = self.insertItem(xdata_item.xdata_name, xgui_menu, item_id, pos_id)
        self.addItemId(item_id, xgui_menu)
        pass
    return

def addItemId(self, item_id, target):
    message(self, item_id, target, verbose_level_min=5)
    self.item_ids[item_id] = target
    # message(self.item_ids)
    return

def highlighted(self, item_id):
    if item_id not in self.item_ids: return
    target = self.item_ids[item_id]
    message(item_id, target)
    if not hasattr(target, "insertXDataChildren"): return
    target.insertXDataChildren()
    return

def activated(self, item_id):
    message(item_id)
    return

def actionActivated(self, item_id):
    if item_id not in self.item_ids: return
    target = self.item_ids[item_id]
    message(item_id, target)
    xdata_item = target
    target = xdata_item.xdata_name
    module = xdata_item.parent_module
    message(target, module)
    #
    if hasattr(module, target):
        target = getattr(module, target)
        from xdatagui import XObject
        if issubclass(target, XObject):
            cls = target
            prefix = cls.getInstancePrefix()
            from xdata import getXObjects
            names = [ x.__instance__name__ for x in getXObjects() ]
            num = 0
            while 1:
                num += 1
                name = "%s_%s"%(prefix, num)
                if name not in names: break
                pass
            dialog = cls.createDialog(
                parent = getMainWindow(),
                instance_name = name,
                xobject = None,
                editor = None,
                xattribute = None,
                )
            if hasattr(dialog, "show"):
                dialog.show()
                pass
            return
        pass
    #
    msg  = ""
    msg += "You need to implement a createDialog(parent, target) function in python file:\n"
    msg += "%s.py for target %s\n"%(module.__name__, target.__repr__())
    msg += "If this function return a dialog, it will be shown by xdata (dialog.show())\n"
    #
    if not hasattr(module, "createDialog"):
        QMessageBox.warning(getMainWindow(), "Warning", msg)
        return
    #
    nodes = getMainWindow().selectedNodes()
    #
    dialog = module.createDialog(getMainWindow(), target)
    if hasattr(dialog, 'show'):
        dialog.show()
        pass
    #
    selection = nodes
    key = "createDialogGetModifiedSelection"
    if hasattr(module, key):
        f = getattr(module, key)
        selection = f(getMainWindow(), target, selection)
        pass
    try:
        for sel in selection:
            getMainWindow().oldObjectModified(sel)
            pass
        pass
    except TypeError:
        pass
    #
    return

##        cls = self.cls
##        # \begin{E.A.}
##        # It takes too long ... TO BE IMPROVED ...
##        from xtree import getMainXTree
##        xtree = getMainXTree()
##        # \end{E.A.}
##        if self.inplace_handler is None:
##            dialog = self.cls.createDialog(getMainWindow(), name, None, 0)
##        else:
##            dialog = self.cls.createDialog(getMainWindow(), name, None, 1)
##            # blockSelection() is not obligatory for in-place handlers
##            try:
##                self.inplace_handler.blockSelection( 1 )
##                dialog.connect(dialog, PYSIGNAL("object_created_inplace"),
##                               self.inplace_handler.inplaceObjectCreated)
##            except AttributeError:
##                dialog.connect(dialog, PYSIGNAL("init_object_created_inplace"),
##                               self.inplace_handler.initInplaceObjectCreated)
##                pass
            
##            pass
##        # dialog.connect(dialog, PYSIGNAL("new_object_created"), getMainWindow().newObjectCreated)
##        dialog.show()
    
# ---

class XGUIQPopupMenu(QPopupMenu):
    
    def __init__(self, parent, xdata_item, inplace_handler = None):
        QPopupMenu.__init__(self, parent)
        self.xdata_item = xdata_item
        self.inplace_handler = inplace_handler
        self.item_ids = {}
        if pyqt_module_name == "qt":
            try:
                self.disconnect(self, SIGNAL('highlighted(int)'), self.highlighted)
            except RuntimeError:
                pass
            self.connect(self, SIGNAL('highlighted(int)'), self.highlighted)
        else:
            try:
                self.disconnect(self, SIGNAL('x_highlighted(QAction*)'), self.highlighted)
            except RuntimeError:
                pass
            self.connect(self, SIGNAL('x_highlighted(QAction*)'), self.highlighted)
            pass
        if pyqt_module_name == "qt":
            self.t = DynamicTip( self )
            pass
        return
    
    insertXDataItem = insertXDataItem
    addItemId = addItemId
    highlighted = highlighted
    actionActivated = actionActivated
    tip = tip
    
    if pyqt_module_name != "qt":
        def event(self, event):
            if event.type() == QEvent.ToolTip:
                pos = event.pos()
                container = self
                rect, text = container.tip(pos)
                if text:
                    QToolTip.showText(event.globalPos(), text)
                    pass
                pass
            return QPopupMenu.event(self, event)
        pass
    
    def insertXDataChildren(self):
        message(cls="XGUIQPopupMenu")
        self.item_ids.clear()
        self.clear()
        modules = []
        for c in self.xdata_item.children:
            self.insertXDataItem(c)
            mod = c.parent_module
            if mod not in modules:
                modules.append(mod)
                pass
            pass
        for mod in modules:
            if hasattr(mod, "customXDataItemsPopupMenu"):
                mod.customXDataItemsPopupMenu(getMainWindow(), self)
                pass
            pass
        return
    
    pass
