# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xqt import *
from xutilities import message

#####---------------------------------------------------------------

####def getParentObj(item):
####    xobj = None
####    from xdata import XObject
####    while xobj is None:
####        node = item.xtree.node
####        if isinstance(node, XObject):
####            xobj = node
####            pass
####        if item.parent == item.listView():
####            break

####        item = item.parent
####        pass

####    return xobj

#---------------------------------------------------------------
#---------------------------------------------------------------

def simplifySeparators(popup):
    i = 0
    while i < popup.count():
        itemtext = popup.text(popup.idAt(i))
        if not itemtext: # seems to be separator
            if i == 0:
                popup.removeItemAt(i)
                continue
            elif i == popup.count()-1:
                popup.removeItemAt(i)
                i-=1
                continue
            elif not popup.text(popup.idAt(i-1)):
                popup.removeItemAt(i)
                continue
            pass
        i+=1
        pass
    return

#---------------------------------------------------------------
#---------------------------------------------------------------

from xdataqlistview import XDataQListView

class XDataObjectExplorer(XDataQListView):
    
    def __init__(self, parent):
        XDataQListView.__init__(self, parent)
        XDataQListView.addColumn(self, "Object")
        XDataQListView.addColumn(self, "Type")
        XDataQListView.addColumn(self, "Value")
        XDataQListView.setRootIsDecorated(self, 1)
        #
        self.items = []
        self.expanded = dict()
        self.currentMap = dict()
        #
        if pyqt_module_name == "qt":
            self.connect(self, SIGNAL('expanded(QListViewItem*)'), self.onExpanded)
            self.connect(self, SIGNAL('collapsed(QListViewItem*)'), self.onCollapsed)
        else:
            self.connect(self, SIGNAL('itemExpanded(QTreeWidgetItem*)'), self.onExpanded)
            self.connect(self, SIGNAL('itemCollapsed(QTreeWidgetItem*)'), self.onCollapsed)
            pass
        #
        from xmainmenubar import DynamicTip
        if pyqt_module_name == "qt":
            self.t = DynamicTip(self)
            pass
        #
        qaction = QAction(self)
        qaction.setAccel(Qt.CTRL+Qt.Key_C)
        qaction.connect(qaction, SIGNAL("activated()"), self.copy)
        qaction = QAction(self)
        qaction.setAccel(Qt.CTRL+Qt.Key_X)
        qaction.connect(qaction, SIGNAL("activated()"), self.cut)
        qaction = QAction(self)
        qaction.setAccel(Qt.CTRL+Qt.Key_V)
        qaction.connect(qaction, SIGNAL("activated()"), self.deeppaste)
        #
        return
    
    def copy(self):
        message('hello', cls=XDataObjectExplorer)
        return
    
    def cut(self):
        message('hello', cls=XDataObjectExplorer)
        return
    
    def deeppaste(self):
        message('hello', cls=XDataObjectExplorer)
        return
    
    def tip( self, p ):
        message(p, cls=XDataObjectExplorer)
        # --
        # Header height offset
        # p.setY(p.y()-self.header().sectionRect(0).bottom())
        # --
        # Find the item pointed
        item = self.itemAt(p)
        message(item, cls=XDataObjectExplorer)
        if item is None: return QRect( 0,0, -1,-1 ), None
        # --
        #
        px = p.x()
        pmax = 0
        for n in range(self.columns()):
            num_col = n
            pmax += self.columnWidth(n)
            if px <= pmax:
                break
            pass
        message('num col :', num_col, cls=XDataObjectExplorer)
        if num_col > 1: return QRect( 0,0, -1,-1 ), None
        # --
        # get the xtree object from the item one
        xtree = item.xtree
        message(xtree, cls=XDataObjectExplorer)
        # --
        #
        if num_col == 1:
            node = xtree.node
            message(node, cls=XDataObjectExplorer)
            if xtree.reference:
                node = node.node
                message(node, cls=XDataObjectExplorer)
                pass
            from xdata import XObject
            if not isinstance(node, XObject):
                return QRect( 0,0, -1,-1 ), None
            cls = node.__class__
            text = cls.getToolTip(cls)
            return self.itemRect(item), text
        # --
        # num_col == 0
        xattr = xtree.xattribute
        message(xattr, cls=XDataObjectExplorer)
        # --
        #
        if xattr:
            cls = xtree.parent.node
            message(cls, cls=XDataObjectExplorer)
            text = cls.getToolTip(xattr)
            message(text, cls=XDataObjectExplorer)
            return self.itemRect(item), text
        # --
        #
        node = xtree.node
        from xdata import XObject
        if isinstance(node, XObject):
            cls = node.__class__
            message(cls, cls=XDataObjectExplorer)
            if num_col == 0:
                target = node
            else:
                target = cls
                pass
            text = cls.getToolTip(target)
            return self.itemRect(item), text
        # --
        #
        return QRect( 0,0, -1,-1 ), None
    
    def clear(self):
        items = self.items
        # --
        # CAUTION: reset self.items before the takeItem part
        # since takeItem change selection and produce infinite loop
        # in searching in self.items ...
        # E.A. 2008/01/09 : From qt3.1 to qt3.3 doc :
        # ----
        # Note: For Single selection mode, if the selected item is part of the taken item(s),
        #       it is unselected and a selectionChanged is emitted. For Multi or Extended selection,
        #       no unselection happens and no selectionChanged signals are emitted.
        # ----
        # For qt <= 3.0 and qt >= 4.0 : nothing is noted thus it seems
        # that selectionChanged is always emited ...
        self.items = []
        #
        for item in items:
            self.takeItem(item)
            pass
        self.currentMap.clear()
        return
    
    def updateWithXTree(self, xtree):
        message("xtree:", xtree, cls=XDataObjectExplorer)
        self.clear()
        
        for t in xtree.children:
            try:
                last = self.items[-1]
            except IndexError:
                last = None
                pass
            item = ObjectExplorerItem(self, last, t)
            self.items.append(item)
            pass
        
        toRemove = []
        for k in self.expanded.keys():
            if not self.currentMap.has_key(k):
                toRemove.append(k)
                pass
            pass
        
        for i in toRemove:
            del self.expanded[i]
            pass
        return
    
    def theSelectionChanged(self):
        message("begin", cls=XDataObjectExplorer)
        # --
        #
        items = self.selectedItems()
        message(items, cls=XDataObjectExplorer)
        real_items = []
        for item in items:
            xtree = item.xtree
            if xtree.reference:
                # --
                # xtree.node --> referenced xtree
                referenced_xtree = xtree.node
                # --
                # referenced item
                referenced_item = self.findItemByXTree(referenced_xtree)
                real_items.append(referenced_item)
                message("referenced_item =", referenced_item, cls=XDataObjectExplorer)
                # --
                if not self.isSelected(referenced_item):
                    self.setSelected(referenced_item, 1)
                    return
                pass
            else:
                real_items.append(item)
                references = self.findReferenceItemsByXTree(xtree)
                message("references =", references, cls=XDataObjectExplorer)
                for ref in references:
                    if not self.isSelected(ref):
                        self.setSelected(ref, 1)
                        return
                    pass
                pass
            pass
        #
        message('emit(PYSIGNAL("selection_changed")', cls=XDataObjectExplorer)
        selection = []
        for i in real_items:
            if i in selection: continue
            selection.append(i)
            pass
        message("selection =", selection, cls=XDataObjectExplorer)
        message("len(selection) =", len(selection), cls=XDataObjectExplorer)
        self.emit(PYSIGNAL("selection_changed"), (selection, ))
        return
    
    def contextMenuRequested(self, item, position, col):
        message("begin", cls=XDataObjectExplorer)
        items = self.selectedItems()
        #
        selection = []
        has_collapsed = None
        #
        if items:
            # --
            # Clean the items of the reference
            # Normally, in xtree.reference, we could "continue"
            # since with the selection implementation, the real item
            # is selected too ... but to be sure, I re-extract the real_item !
            has_collapsed = 0
            for item in items:
                xtree = item.xtree
                if xtree.reference:
                    the_item = self.findItemByXTree(xtree.node)
                else:
                    the_item = item
                    pass
                if the_item not in selection:
                    has_collapsed = has_collapsed or self.hasCollapsed(the_item)
                    selection.append(the_item)
                    pass
                pass
            pass
        #
        message("selection =", selection, cls=XDataObjectExplorer)
        message("len(selection) =", len(selection), cls=XDataObjectExplorer)
        menu = QPopupMenu(self)
        from xdatagui import customPopup
        customPopup(menu, selection)
        #
        if has_collapsed:
            if menu.count() > 0:
                menu.insertSeparator()
                pass
            id = menu.insertItem("Expand All")
            menu.connectItem(id, self.expandAll)
            pass
        #
        message("menu.count() =", menu.count())
        simplifySeparators(menu)
        if menu.count():
            if pyqt_module_name == "PyQt4":
                position = self.mapToGlobal(position)
                pass
            menu.popup(position)
            pass
        return
    
####    def delete(self):
####        message(cls="XDataObjectExplorer")
####        items = self.selectedItems()
####        for item in items:
####            xtree = item.xtree
####            node = xtree.node
####            from xmetaclass import removeXObject
####            removeXObject(node)
####            pass
####        from xdatagui import getMainWindow
####        getMainWindow().updateObjectBrowser()
####        return
    
####    def listAdd(self):
####        from xdatagui import getMainWindow
####        from xdatalisteditor import XGuiAddDlg
        
####        item = self.selectedItems()[0]
        
####        from xguitools import isXList
####        isList, list_seq = isXList(item.xtree.xattribute)
        
####        dlg = XGuiAddDlg(list_seq, getMainWindow())
####        self.connect(dlg, PYSIGNAL("listitem_added"), item.listItemAdded)
####        dlg.show()
####        return
    
####    def listDelete(self):
####        from xdatagui import getMainWindow
####        from xdatalisteditor import XGuiDeleteDlg        
        
####        item = self.selectedItems()[0]
####        if item.xtree.reference:
####            node = item.xtree.node.node
####        else:
####            node = item.xtree.node
####            pass
####        dlg = XGuiDeleteDlg(node, getMainWindow())
####        self.connect(dlg, PYSIGNAL("listitem_deleted"), item.listItemDeleted)
####        dlg.show()
####        return
    
    def hasCollapsed(self, item):
        if item.childCount() and not item.isOpen():
            return 1
        
        res = 0
        child = item.firstChild()
        while child and res == 0:
            res = self.hasCollapsed(child)
            child = child.nextSibling()
            pass        
        return res
    
    def expandAll(self):
        items = self.selectedItems()
        if not items: return
        
        for item in items:
            self.expand(item)
            item.setOpen(1)
            pass
        return
    
    def expand(self, item):
        item.setOpen(1)
        child = item.firstChild()
        while child:
            self.expand(child)
            child = child.nextSibling()
            pass
        return
    
####    def oldObjectModified(self, obj):
####        from xdatagui import getMainWindow
####        getMainWindow().oldObjectModified(obj)
####        return
    
    def onExpanded(self, item):
        message("item =", item, cls=XDataObjectExplorer)
        if not self.expanded.has_key(id(item.node)):
            self.expanded[id(item.node)] = 1
            pass
        pass
    
    def onCollapsed(self, item):
        message("item =", item, cls=XDataObjectExplorer)
        if self.expanded.has_key(id(item.node)):
            del self.expanded[id(item.node)]
            pass        
        pass
    
####    def inplaceObjectCreated(self, item, obj):
####        if item.xtree.node.__class__ == list:
####            item.xtree.node.append(obj)
####            return
####        return
    
####    def listItemAdded(self, item, value):
####        if item.xtree.node.__class__ == list:
####            item.xtree.node.append(value)
####            pass
####        from xdatagui import getMainWindow
####        getMainWindow().oldObjectModified(getParentObj(item))  
####        return
    
####    def listItemDeleted(self, item, listobj):
####        from xdatagui import getMainWindow
####        getMainWindow().oldObjectModified(getParentObj(item))        
####        return
    
##    pass
    
    def findRequired(self, text, method):
        message('Hello', text, method, cls=XDataObjectExplorer)
        #
        if text == "":
            return
        #
        items = self.getAllItems()
        message(items, cls=XDataObjectExplorer)
        message(len(items), cls=XDataObjectExplorer)
        #
        selected_items = self.selectedItems()
        #
        # E.A. : in selected_items, the ref. are present
        # the following code remove the references, but
        # it is not cool !!
        # l = []
        # for item in selected_items:
        #     if item.xtree.reference: continue
        #     l.append(item)
        #     pass
        # selected_items = l
        #
        selected_indexes = [ items.index(item) for item in selected_items ]
        message(selected_indexes)
        #
        if method == "all":
            items = items[:]
        elif method == "next":
            try:
                items = items[max(selected_indexes)+1:]
            except ValueError:
                items = items[:]
                pass
            pass
        elif method == "previous":
            try:
                items = items[:min(selected_indexes)]
            except ValueError:
                items = items[:]
                pass
            pass
        else:
            items = []
            pass
        #
        self.clearSelection()
        #
        items_found = []
        nb_columns = self.columns()
        for item in items:
            found = 0
            for i in range(nb_columns):
                t = item.text(i)
                t = t.lower()
                if t.find(text.lower()) > -1:
                    found = 1
                    break
                pass
            if found:
                items_found.append(item)
                pass
            pass
        #
        if len(items_found) == 0:
            return
        #
        if method == "all":
            items_found = items_found[:]
        elif method == "next":
            items_found = [items_found[0]]
        elif method == "previous":
            items_found = [items_found[-1]]
        else:
            items_found = []
            pass
        #
        for item in items_found:
            self.ensureItemVisible(item)
            self.setSelected(item, 1)
            pass
        #
        return
    
    def getAllItems(self):
        items = []
        for item in self.items:
            items += item.getAllItems()
            pass
        return items
    
    pass

#---------------------------------------------------------------
#--------------------------------------------------------------- 

from xdataqlistview import XDataQListViewItem

class ObjectExplorerItem(XDataQListViewItem):
    def __init__(self, parent, after, xtree):
        XDataQListViewItem.__init__(self, parent, after)
        self.items = []
        self.xtree = xtree
        #
        if xtree.reference:
            self.status = "Reference"
            name = "%s *"%(xtree.name)
            self.node = xtree.node.node
            text = "ref. --> %s"%(xtree.node.full_name)
            cls = self.node.__class__
            try:
                typ = cls.__xdata__name__
            except AttributeError:
                typ = cls.__name__
                pass
            # typ = None
        else:
            name = xtree.name
            if [name[0], name[-1]] == ['[', ']']:
                name = name[1:-1]
                pass
            if [name[0], name[-1]] == ["'", "'"]:
                name = name[1:-1]
                pass
            self.node = xtree.node
            from xdata import XObject
            if isinstance(self.node, XObject):
                text = None
            else:
                from xutilities import value2text
                try:
                    text = str(self.node)
                except UnicodeEncodeError:
                    text = unicode(self.node)
                    pass
                pass
            cls = self.node.__class__
            try:
                typ = cls.__xdata__name__
            except AttributeError:
                typ = cls.__name__
                pass
            pass
        #
        self.setText(0, name)
        if typ is None:
            typ = ""
            pass
        self.setText(1, typ)
        if text is None:
            text = ""
            pass
        self.setText(2, text)
        #
        # Register a node in the list view map
        #
        lv = self.listView()
        if lv is not None:
            lv.currentMap[id(self.node)] = 0
            
            if lv.expanded.has_key(id(self.node)):
                self.setOpen(1)
            else:
                self.setOpen(0)
                pass
            pass
        #
        xattr = xtree.xattribute
        from xdata import XAttribute
        if isinstance(xattr, XAttribute):
            xtype = xattr.xtype
            from xdata import XMulTypes
            if isinstance(xtype, XMulTypes):
                xtypes = xtype.xtypes
                if len(xtypes) == 2:
                    from xdata import XNone
                    if isinstance(xtypes[0], XNone):
                        xtype = xtypes[1]
                        pass
                    pass
                pass
            if hasattr(xtype, "unpack_in_browser"):
                unpack = getattr(xtype, "unpack_in_browser")
                if not unpack:
                    return
                pass
            pass
        #
        for child_tree in xtree.children:
            try:
                last = self.items[-1]
            except IndexError:
                last = None
                pass
            item = ObjectExplorerItem(self, last, child_tree)
            # begin{G.F}
            # normally item.xtree=child_tree and so is not None
            # but if the user don't want that the ObjectExplorerItem is
            # append to the list then is set xtree to None
            if item.xtree:
                self.items.append(item)
                pass
            # end{G.F}
            pass
        return
    
##    def initInplaceObjectCreated(self, obj):
##        self.listView().inplaceObjectCreated(self, obj)
##        return
    
##    def listItemAdded(self, value):
##        self.listView().listItemAdded(self, value)
##        return
    
##    def listItemDeleted(self, listobj):
##        self.listView().listItemDeleted(self, listobj)
##        return

    def getAllItems(self):
        items = [self]
        for item in self.items:
            items += item.getAllItems()
            pass
        return items
    
    pass
