
from libMEDMEM_Swig import *

import os
import base64, re
import string
import omniORB

def tmpnam():
    num = 0
    import os.path
    while 1:
        fileName = "medpersistence_file%6.6i"%num
        if not os.path.exists(fileName):
            break
        num += 1
        pass
    return fileName

global theMedFile
global theMedMed
global theMedMeshes
global theMedFields
global theStudy

SALOME_REF_ID = "___SalomeReference_object_string_"
MED_OBJECT_ID = "___MED_object_string_" 

def initGlobals(study=None):
    global theStudy
    global theMedFile
    global theMedMed
    global theMedMeshes
    global theMedFields
    theStudy = study
    theMedFile = None
    theMedMed = None
    theMedMeshes = []
    theMedFields = []
    return

def getMedMesh(name):
    for m_name, m in theMedMeshes:
        if m_name == name :
            return m
        pass
    m = theMedMed.getMesh(name)
    m.read()
    m._theCppMedMed = theMedMed
    theMedMeshes.append((name, m))
    return getMedMesh(name)

def getMedField(name, it):
    for f_name, f_it, f in theMedFields:
        if (f_name, f_it) == (name, it):
            return f
        pass
    theMedMed.updateSupport()
    field_under_cpp = theMedMed.getField(name, it, -1)
    value_type = field_under_cpp.getValueType()
    nb_compos = field_under_cpp.getNumberOfComponents()
    if value_type == MED_INT32:
        field_cpp = createFieldIntFromField(field_under_cpp)
    elif value_type == MED_REEL64:
        field_cpp = createFieldDoubleFromField(field_under_cpp)
        pass
    field_cpp.read()
    theMedFields.append((name, it, field_cpp))
    return field_cpp

def MedToStream(theMedObject):
    objType = string.split(theMedObject.__repr__(), " ")[1]
    # construction of an ASCII stream with
    # - the type of the object
    # - the name of the object
    # - the name of the mesh (if "SUPPORT", "FAMILY", "GROUP", "FIELD")
    # - the iteration (if "FIELDDOUBLE", "FIELDINT")
    # - the content of the med file (if necessary)
    aStream  = objType+"\n"
    aStream += theMedObject.getName()+"\n"
    if objType in ["SUPPORT", "FAMILY", "GROUP"]:
        aStream += theMedObject.getMesh().getName()+"\n"
        pass
    if objType in ["FIELDDOUBLE", "FIELDINT"]:
        aStream += theMedObject.getSupport().getMesh().getName()+"\n"
        aStream += str(theMedObject.getIterationNumber())+"\n"
        pass
    #
    global theMedFile
    if theMedFile:
        aFile = open(theMedFile, "rb")
        aStream += aFile.read()
        aFile.close()
        os.system("rm "+theMedFile)
        theMedFile = None
        pass
    #
    aResultStream = base64.encodestring(aStream)
    aResultStream = re.sub("\n","",aResultStream[0:len(aResultStream)-1])
    return aResultStream

def StreamToMed(theStream):
    # get from the ASCII stream all specific information
    aStream = base64.decodestring(theStream+"\n")
    aSplitted = string.split(aStream,"\n")
    cutPos = 0
    #
    anObjType = aSplitted[0]
    cutPos += len(anObjType) + 1
    #
    anObjName = aSplitted[1]
    cutPos += len(anObjName) + 1
    #
    if anObjType in ["SUPPORT", "FAMILY", "GROUP"]:
        meshName = aSplitted[2]
        cutPos += len(meshName) + 1
        pass
    #
    if anObjType in ["FIELDDOUBLE", "FIELDINT"]:
        meshName = aSplitted[2]
        cutPos += len(meshName) + 1
        anIteration = int(aSplitted[3])
        cutPos += len(aSplitted[3]) + 1
        pass

    if anObjType in ["MESH"]:
        meshName = anObjName 
    #
    aStream = aStream[cutPos:len(aStream)]
    global theMedFile
    if aStream :
        theMedFile = tmpnam()
        aFile = open(theMedFile, "wb")
        aFile.write(aStream)
        aFile.close()
        global theMedMed
        theMedMed = MED()
        medDriver = MED_MED_RDONLY_DRIVER(theMedFile, theMedMed)
        medDriver.open()
        medDriver.readFileStruct()
        medDriver.close()
        pass
    #
    if anObjType == "MESH":
        return getMedMesh(anObjName)
    #
    if anObjType == "SUPPORT":
        return SUPPORT(getMedMesh(meshName), anObjName)
    #
    if anObjType == "FAMILY":
        mesh = getMedMesh(meshName)
        for entity in [MED_CELL, MED_FACE, MED_EDGE, MED_NODE]:
            for i in range(mesh.getNumberOfFamilies(entity)):
                support = mesh.getFamily(entity, i + 1)
                if support.getName() == anObjName:
                    return support
                pass
            pass
        return None
    #
    if anObjType == "GROUP":
        mesh = getMedMesh(meshName)
        for entity in [MED_CELL, MED_FACE, MED_EDGE, MED_NODE]:
            for i in range(mesh.getNumberOfGroups(entity)):
                support = mesh.getGroup(entity, i + 1)
                if support.getName() == anObjName:
                    return support
                pass
            pass
        return None
    #
    if anObjType in ["FIELDDOUBLE", "FIELDINT"]:
        mesh = getMedMesh(meshName)
        field = getMedField(anObjName, anIteration)
        return field
    #
    return None

def StreamToReference(theStream):
    global theStudy
    try:
        module, interface, entry = theStream.split("|")
        if theStudy and module and interface and entry:
            try:
                disableloadwith = int(os.getenv("XDATA_DISABLE_LOAD_WITH"))
            except:
                disableloadwith = 0
            if not disableloadwith:
                builder = theStudy.NewBuilder()
                component = theStudy.FindComponent(module)
                from xsalome import getORB
                from LifeCycleCORBA import LifeCycleCORBA
                lcc = LifeCycleCORBA(getORB())
                # try C++ container
                engine = lcc.FindOrLoadComponent("FactoryServer", module)
                # try Python container
                if not engine: engine = lcc.FindOrLoadComponent("FactoryServerPy", module)
                if engine and component:
                    builder.LoadWith(component, engine)
            sobject = theStudy.FindObjectID(entry)
            if sobject:
                return sobject.GetObject()
    except:
        pass
    return None

global _ids_already_inspected
from types import InstanceType, DictType, ListType, TupleType

def getMedObjects(theObject, medType=None):
    #
    # mpv: too slow to avoid cyclic recursion
    #
    #if id(theObject) in _ids_already_inspected: return []
    #_ids_already_inspected.append(id(theObject))
    #
    # init l
    #
    l = []
    #
    # Specific operations for FIELDS
    # 
    if isinstance(theObject, FIELDDOUBLE) or \
           isinstance(theObject, FIELDINT) :
        if not id(theObject) in _ids_already_inspected:
            _ids_already_inspected.append(id(theObject))
            l.append(theObject)
        pass
    #
    # Specific operations for MESHES
    # 
    if isinstance(theObject, MESH):
        if not id(theObject) in _ids_already_inspected:
            _ids_already_inspected.append(id(theObject))
            l.append(theObject)
        pass
    #
    # Recursif inspection
    #
    if type(theObject) is InstanceType:
        for att in theObject.__dict__.values():
            l += getMedObjects(att, medType)
            pass
        pass
    elif type(theObject) is DictType:
        for att in theObject.values():
            l += getMedObjects(att, medType)
            pass
        pass
    elif type(theObject) is ListType:
        for att in theObject:
            l += getMedObjects(att, medType)
            pass
        pass
    elif type(theObject) is TupleType:
        for att in range(len(theObject)):
            l += getMedObjects(theObject[att], medType)
            pass
        pass
    elif hasattr(theObject, "cpp"):
        l += getMedObjects(getattr(theObject,"cpp"), medType)
    #
    # re-order l to have meshes then fields
    #
    meshes, fields = [], []
    for obj in l:
        if isinstance(obj, MESH):
            meshes.append(obj)
            pass
        if isinstance(obj, FIELDDOUBLE) or \
               isinstance(obj, FIELDINT) :
            fields.append(obj)
            pass
        pass
    return meshes + fields

def makeFieldOnAll(aField):
    old_support = aField.getSupport()
    mesh = old_support.getMesh()

    #new_support = mesh.makeSupportOnAll('Extend',
    #                                    old_support.getEntity())
    new_support = SUPPORT(mesh, 'Extent', old_support.getEntity())
    new_support.update()
                 
    #nb_c = self.getNbComponents()
    nb_c = aField.getNumberOfComponents()
    #nb_e = mesh.getNbElements(old_support.getEntity(), MED_ALL_ELEMENTS)
    #typ = self.getType()
    #new_field = mesh.makeField(self.getName(), new_support, nb_c, typ)
    field = None
    if isinstance(aField, FIELDDOUBLE):
        field = FIELDDOUBLE(new_support, nb_c)
        field.setValueType(MED_REEL64)
    elif isinstance(aField, FIELDINT):
        field = FIELDINT(new_support, nb_c)
        field.setValueType(MED_INT32)
    else:
        raise NotImplementedError
    field.allocValue(nb_c)
    field.setName(aField.getName())

    #new_field.setComponentsNames(self.getComponentsNames())
    #new_field.setComponentsUnits(self.getComponentsUnits())
    for i in range(nb_c):
        field.setComponentName(i + 1, aField.getComponentName(i + 1))
        field.setMEDComponentUnit(i + 1, aField.getMEDComponentUnit(i + 1))
        
    #new_field.setTime(self.getTime())
    field.setTime(aField.getTime())
    
    
    #new_field.setIteration(self.getIteration())
    field.setIterationNumber(aField.getIterationNumber())
    
    #new_field.setValues(nb_e*nb_c*[0.])
    nb_e = mesh.getNumberOfElements(old_support.getEntity(), MED_ALL_ELEMENTS)
    field.setValue(MED_FULL_INTERLACE, nb_e*nb_c*[0.])
    
    #old_indexes = old_support.getGlobalIndexes()
    nb1 = mesh.getNumberOfElements(old_support.getEntity(), MED_ALL_ELEMENTS)
    old_indexes = old_support.getNumber(MED_ALL_ELEMENTS)
    #range(1, 1+nb1)
    
    for i in range(len(old_indexes)):
        j = old_indexes[i]
        vals = field.setValueI(MED_FULL_INTERLACE, j, aField.getValueI(MED_FULL_INTERLACE, i + 1))
        pass
    return field, new_support


def persistent_id(theObject):
    #
    aStream = None
    #
    global theStudy
    if hasattr(theObject,"_narrow"):
        from xsalome import getCorbaObjectModuleAndInterface
        module, interface = getCorbaObjectModuleAndInterface(theObject)
        from xsalome import getORB
        IOR = getORB().object_to_string(theObject)
        if theStudy and IOR:
            so = theStudy.FindObjectIOR(IOR)
            if so:
                aStream = "%s%s|%s|%s" % (SALOME_REF_ID, module, interface, so.GetID() )
    #
    elif isinstance(theObject, MESH) or \
           isinstance(theObject, FIELDDOUBLE) or \
           isinstance(theObject, FIELDINT) or \
           isinstance(theObject, SUPPORT) or \
           isinstance(theObject, FAMILY) or \
           isinstance(theObject, GROUP):
        aStream = MedToStream(theObject)
        aStream = MED_OBJECT_ID + aStream
        pass
    #
    return aStream

def persistent_load(aStream):
    if aStream.startswith(MED_OBJECT_ID):
        return StreamToMed(aStream[len(MED_OBJECT_ID):])
    if aStream.startswith(SALOME_REF_ID):
        return StreamToReference(aStream[len(SALOME_REF_ID):])
    return None

# ##############################################################

import StringIO, pickle

def DumpObject(theObject, study=None):

    #SRN BEGIN: Jul 23, 2004. Moved this piece of code from a method persistent_id
    initGlobals(study)
    global _ids_already_inspected
    _ids_already_inspected = []
    l = getMedObjects(theObject)
    if len(l):
        global theMedFile
        theMedFile = tmpnam()
        for medObj in l:
            toWrite = medObj
            # translate field to the field on all elements, otherwise field can not be writed
            if isinstance(medObj, FIELDDOUBLE) or isinstance(medObj, FIELDINT) :
                if not medObj.getSupport().isOnAllElements():
                    toWrite, support = makeFieldOnAll(medObj)
            #
            aWriteDriver = toWrite.addDriver(0, theMedFile, toWrite.getName())
            toWrite.write(aWriteDriver, "")
            toWrite.rmDriver(aWriteDriver)
            pass
        pass
    #
    #SRN END:
    
    aStream = StringIO.StringIO()
    aP = pickle.Pickler(aStream)
    aP.persistent_id = persistent_id
    aP.dump(theObject)
    value = aStream.getvalue()
    return value

def ConstructObject(theStream, study=None):
    #
    initGlobals(study)
    #
    aStream = StringIO.StringIO(theStream)
    aUnP = pickle.Unpickler(aStream)
    aUnP.persistent_load = persistent_load
    aUnP_load = aUnP.load()
    #
    if theMedFile:
        os.system("rm "+theMedFile)
        pass
    #
    return aUnP_load

def IsMed(theObject):
  try:
    if hasattr(theObject, "cpp"):
      return IsMed(theObject.cpp)
    if isinstance(theObject, omniORB.CORBA.ORB):
      return 0
    
    if isinstance(theObject, MESH) or \
       isinstance(theObject, FIELDDOUBLE) or \
       isinstance(theObject, FIELDINT) or \
       isinstance(theObject, SUPPORT) or \
       isinstance(theObject, FAMILY) or \
       isinstance(theObject, GROUP):  #Check if theObject is MED swigged object
      objType = string.split(theObject.__repr__(), " ")[1]
      if objType == "MESH" or objType in ["MESH", "SUPPORT", "FAMILY", "GROUP", "FIELDDOUBLE", "FIELDINT"]:
        return 1;
      pass
  except:
    pass
  return 0
  
def SaveMed(theObject, theFileName):
  objType = string.split(theObject.__repr__(), " ")[1]
  medMesh = None
  if objType == "MESH":
    medMesh = theObject
  elif objType in ["SUPPORT", "FAMILY", "GROUP"]:
    medMesh = theObject.getMesh()
  elif objType in ["FIELDDOUBLE", "FIELDINT"]:
    if not theObject.getSupport().isOnAllElements():
      medMesh, support = makeFieldOnAll(theObject)
    else:
      medMesh = theObject
  else:
    return 0

  try:
    aWriteDriver = medMesh.addDriver(0, theFileName, medMesh.getName())
    medMesh.write(aWriteDriver, "")
    medMesh.rmDriver(aWriteDriver)
    #if objType in ["FIELDDOUBLE", "FIELDINT"]:
    #    medMesh = medMesh.getSupport().getMesh();
    #    aWriteDriver = medMesh.addDriver(0, theFileName, medMesh.getName())
    #    medMesh.write(aWriteDriver, "")
    #    medMesh.rmDriver(aWriteDriver)
  except:
    return 0
  return 1
  
