# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

warning_sep  = '-------------------------------------------------------\n'
warning_line = 'WARNING WARNING WARNING WARNING WARNING WARNING WARNING\n'

from xdata import *
from time import clock
from xutilities import verbose

def write(code, filename, component_name):
    t_begin = clock()
    #
    code = code.replace("R1R1R1", component_name.upper())
    code = code.replace("R1r1r1", component_name)
    code = code.replace("r1r1r1", component_name.lower())
    filename = filename.replace("R1R1R1", component_name.upper())
    filename = filename.replace("R1r1r1", component_name)
    filename = filename.replace("r1r1r1", component_name.lower())
    #
    try:
        stream = open(filename)
        old_code = stream.read()
        stream.close()
    except IOError:
        old_code = None
        pass
    #
    if code != old_code:
        stream = open(filename, "w")
        stream.write(code)
        stream.close()
        print "%s written ..."%(filename)
        pass
    #
    if verbose(): print "write %s in %s s"%(filename, clock()-t_begin)
    return

# --
#

from xitem import XDataItemTree

class XData2SalomeItemTree(XDataItemTree):
    
    def getInterfaceName(self, cls):
        if hasattr(self, "__class2interface__"):
            try:
                interface = getattr(self, "__class2interface__")[cls]
            except KeyError:
                interface = cls.__name__
                pass
            return interface
        # --
        name2number = {}
        for c in self.getAllClasses():
            name = c.__name__
            try:
                name2number[name] += 1
            except KeyError:
                name2number[name] = 1
                pass
            pass
        # --
        c2i = {}
        for c in self.getAllClasses():
            name = c.__name__
            if name2number[name] > 1:
                interface = c.__module__ + c.__name__
            else:
                interface = c.__name__
                pass
            c2i[c] = interface
            pass
        setattr(self, "__class2interface__", c2i)
        # --
        return self.getInterfaceName(cls)
    
    def getComponentClasses(self):
        if hasattr(self, "__component__classes__"):
            return getattr(self, "__component__classes__")
        if self.depth==0: t_begin = clock()
        l = []
        for child in self.children:
            if child.is_final:
                target = child.xdata_name
                module = child.parent_module
                if not hasattr(module, target): continue
                target = getattr(module, target)
                from xsalome import myissubclass
                if not myissubclass(target, XObject): continue
                l.append(target)
            else:
                l += child.getComponentClasses()
                pass
            pass
        # --
        # If an instance is created in the python files
        # we need to put it in the gen_classes, otherwise
        # there will be an error at import in corba context
        #
        from xdata import getXObjects
        for obj in getXObjects():
            l.append(obj.__class__)
            pass
        # --
        # We have to add the class contained in XInstance instances.
        #
        for x in self.getAllXTypes():
            from xtypes import XInstance
            if not isinstance(x, XInstance): continue
            for c in x.classes:
                if isinstance(c, str):
                    from xutilities import getRealClassFromString
                    c = getRealClassFromString(c)
                    pass
                if not issubclass(c, XObject): continue
                if c is XObject: continue
                if c is XNamedObject: continue
                l.append(c)
                pass
            pass
        # --
        #
        ll = l[:]
        for c in self.getAllClasses():
            if c in ll : continue
            for b in l:
                if not issubclass(c, b): continue
                ll.append(c)
                break
            pass
        l = ll
        # --
        # Remove multiple occurences of the same class
        #
        ll = []
        for c in l:
            if c in ll: continue
            ll.append(c)
            pass
        #
        setattr(self, "__component__classes__", ll)
        if self.depth==0 and verbose(): print "getComponentClasses in %s s"%(clock()-t_begin)
        return self.getComponentClasses()
    
    def getAllClasses(self):
        if hasattr(self, "__all__classes__"):
            return getattr(self, "__all__classes__")
        t_begin = clock()
        from xdata import getXClasses
        self.__all__classes__ = getXClasses()
        if verbose(): print "getAllClasses in %s s"%(clock()-t_begin)
        return self.getAllClasses()
    
    def getAllXTypes(self):
        if hasattr(self, "__all__xtypes__"):
            return getattr(self, "__all__xtypes__")
        t_begin = clock()
        all_xtypes = []
        for c in self.getAllClasses():
            xattrs = []
            xattrs += c.getAllInitXAttributes()
            xattrs += getattr(c, "____object__xattributes__")
            for x in xattrs:
                xtype = getattr(x, '__xtype')
                xtypes = xtype.getAllXTypes()
                all_xtypes += xtypes
                pass
            for x in getattr(c, '____object__xmethods__'):
                xtype = x.out_xtype
                if xtype:
                    xtypes = xtype.getAllXTypes()
                    all_xtypes += xtypes
                    pass
                for key in ["__in_xattributes", "__out_xattributes"]:
                    xattrs = getattr(x, key)
                    if xattrs:
                        for xa in xattrs:
                            xtype = getattr(xa, '__xtype')
                            xtypes = xtype.getAllXTypes()
                            all_xtypes += xtypes
                            pass
                        pass
                    pass
                pass
            pass
        self.__all__xtypes__ = []
        for x in all_xtypes:
            if x in self.__all__xtypes__ : continue
            self.__all__xtypes__.append(x)
            pass
        if verbose(): print "getAllXTypes in %s s"%(clock()-t_begin)
        return self.getAllXTypes()
    
    def writeCatalog(self, for_yacs):
        l = self.getComponentClasses()
        l = self.getAllClasses()
        l = self.getAllXTypes()
        #
        t_begin = clock()
        code_list = []
        code_list.append('<?xml version="1.0" encoding="us-ascii" ?>')
        code_list.append('<begin-catalog>')
        # --
        if for_yacs:
            dtypes = {}
            dtypes["XDATA_CORBA::XInt"] = None
            dtypes["XDATA_CORBA::XFloat"] = None
            dtypes["XDATA_CORBA::XString"] = None
            dtypes["XDATA_CORBA::XObject"] = None
            dtypes["XDATA_CORBA::XObjectSequence"] = None
            for xt in self.getAllXTypes():
                idl_type = self.getCatalogType(xt, for_yacs)
                if idl_type in ("double","string","int") : continue
                dtypes[idl_type] = xt
                pass
            for cl in self.getAllClasses():
                idl_type = "R1r1r1_CORBA::%s" % self.getInterfaceName(cl)
                dtypes[idl_type] = cl
                pass
            code_list.append('  <type-list>')
            # first XObject and sequence of XObject
            del dtypes["XDATA_CORBA::XObject"]
            del dtypes["XDATA_CORBA::XObjectSequence"]
            code_list.append('    <objref name="XDATA_CORBA::XObject" />')
            code_list.append('    <sequence name="XDATA_CORBA::XObjectSequence" content="XDATA_CORBA::XObject" />')
            typnames = dtypes.keys()
            typnames.sort()
            for typname in typnames:
                typ = dtypes[typname]
                if isinstance(typ,type) and issubclass(typ,XObject):
                    code_list.append('    <objref name="%s" >'%typname)
                    code_list.append('    <base>XDATA_CORBA::XObject</base>')
                    code_list.append('    </objref>')
                else:
                    code_list.append('    <objref name="%s" />'%typname)
                    pass
                pass
            code_list.append('  </type-list>')
            pass
        # --
        code_list.append('  <component-list>')
        code_list.append('    <component>')
        code_list.append('      <component-name>R1r1r1</component-name>')
        code_list.append('      <component-username>R1r1r1</component-username>')
        code_list.append('      <component-icone>R1r1r1.png</component-icone>')
        code_list.append('      <component-impltype>0</component-impltype>')
        #
        mod = __import__("%s_xdata"%(self.xdata_name))
        kw = "__version__"
        if hasattr(mod, kw):
            v = getattr(mod, kw)
            code_list.append('      <component-version>%s</component-version>'%v)
            pass
        kw = "__comment__"
        if hasattr(mod, kw):
            v = getattr(mod, kw)
            code_list.append('      <component-comment>%s</component-comment>'%v)
            pass
        #
        code_list.append('      <component-interface-list>')
        if not for_yacs:
            code_list.append('        <component-interface-name>XDATA</component-interface-name>')
        else:
            code_list.append('        <component-interface-name>R1r1r1</component-interface-name>')
            pass
        code_list.append('        <component-service-list>')
        code_list.append('          <component-service>')
        code_list.append('            <service-name>newXInt</service-name>')
        code_list.append('            <service-by-default>1</service-by-default>')
        code_list.append('            <inParameter-list>')
        code_list.append('              <inParameter>')
        code_list.append('                <inParameter-type>long</inParameter-type>')
        code_list.append('                <inParameter-name>value</inParameter-name>')
        code_list.append('              </inParameter>')
        code_list.append('            </inParameter-list>')
        code_list.append('            <outParameter-list>')
        code_list.append('              <outParameter>')
        code_list.append('                <outParameter-type>XDATA_CORBA::XInt</outParameter-type>')
        code_list.append('                <outParameter-name>result</outParameter-name>')
        code_list.append('              </outParameter>')
        code_list.append('            </outParameter-list>')
        code_list.append('          </component-service>')
        code_list.append('          <component-service>')
        code_list.append('            <service-name>newXFloat</service-name>')
        code_list.append('            <service-by-default>1</service-by-default>')
        code_list.append('            <inParameter-list>')
        code_list.append('              <inParameter>')
        code_list.append('                <inParameter-type>double</inParameter-type>')
        code_list.append('                <inParameter-name>value</inParameter-name>')
        code_list.append('              </inParameter>')
        code_list.append('            </inParameter-list>')
        code_list.append('            <outParameter-list>')
        code_list.append('              <outParameter>')
        code_list.append('                <outParameter-type>XDATA_CORBA::XFloat</outParameter-type>')
        code_list.append('                <outParameter-name>result</outParameter-name>')
        code_list.append('              </outParameter>')
        code_list.append('            </outParameter-list>')
        code_list.append('          </component-service>')
        code_list.append('          <component-service>')
        code_list.append('            <service-name>newXString</service-name>')
        code_list.append('            <service-by-default>1</service-by-default>')
        code_list.append('            <inParameter-list>')
        code_list.append('              <inParameter>')
        code_list.append('                <inParameter-type>string</inParameter-type>')
        code_list.append('                <inParameter-name>value</inParameter-name>')
        code_list.append('              </inParameter>')
        code_list.append('            </inParameter-list>')
        code_list.append('            <outParameter-list>')
        code_list.append('              <outParameter>')
        code_list.append('                <outParameter-type>XDATA_CORBA::XString</outParameter-type>')
        code_list.append('                <outParameter-name>result</outParameter-name>')
        code_list.append('              </outParameter>')
        code_list.append('            </outParameter-list>')
        code_list.append('          </component-service>')
        if not for_yacs:
            code_list.append('        </component-service-list>')
            code_list.append('        <component-interface-name>R1r1r1</component-interface-name>')
            code_list.append('        <component-service-list>')
            pass
        for c in self.getComponentClasses():
            code_list.append('          <component-service>')
            code_list.append('            <service-name>new%s</service-name>'%(self.getInterfaceName(c)))
            code_list.append('            <service-by-default>1</service-by-default>')
            #
            xattrs = []
            xattrs += c.getAllInitXAttributes()
            #
            code_list.append('            <inParameter-list>')
            for i in range(len(xattrs)):
                code_list.append('              <inParameter>')
                xattr = xattrs[i]
                xtype = getattr(xattr, '__xtype')
                idl_type = self.getCatalogType(xtype, for_yacs)
                code_list.append('                <inParameter-type>%s</inParameter-type>'%(idl_type))
                code_list.append('                <inParameter-name>%s</inParameter-name>'%(getattr(xattr, '__name')))
                code_list.append('              </inParameter>')
                pass
            code_list.append('            </inParameter-list>')
            #
            code_list.append('            <outParameter-list>')
            code_list.append('              <outParameter>')
            code_list.append('                <outParameter-type>R1r1r1_CORBA::%s</outParameter-type>'%(self.getInterfaceName(c)))
            code_list.append('                <outParameter-name>result</outParameter-name>')
            code_list.append('              </outParameter>')
            code_list.append('            </outParameter-list>')
            code_list.append('          </component-service>')
            #
            pass
        if not for_yacs:
            code_list.append('        </component-service-list>')
            pass
        if verbose(): print "writeCatalog (after component classes) in %s s"%(clock()-t_begin)
        for c in self.getAllClasses():
            c___name__ = self.getInterfaceName(c)
            if not for_yacs:
                code_list.append('        <component-interface-name>%s</component-interface-name>'%(c___name__))
                code_list.append('        <component-service-list>')
                pass
            xattrs = []
            xattrs += c.getXAttributesMRO()
            for xattr in xattrs:
                from xutilities import name2capname
                capname = name2capname(getattr(xattr, '__name'))
                code_list.append('          <component-service>')
                code_list.append('            <service-name>%s_get%s</service-name>'%(c___name__, capname))
                code_list.append('            <service-by-default>1</service-by-default>')
                code_list.append('            <inParameter-list>')
                code_list.append('              <inParameter>')
                code_list.append('                <inParameter-type>R1r1r1_CORBA::%s</inParameter-type>'%(c___name__))
                code_list.append('                <inParameter-name>object</inParameter-name>')
                code_list.append('              </inParameter>')
                code_list.append('            </inParameter-list>')
                xtype = getattr(xattr, '__xtype')
                idl_type = self.getCatalogType(xtype, for_yacs)
                code_list.append('            <outParameter-list>')
                code_list.append('              <outParameter>')
                code_list.append('                <outParameter-type>R1r1r1_CORBA::%s</outParameter-type>'%(c___name__))
                code_list.append('                <outParameter-name>object</outParameter-name>')
                code_list.append('              </outParameter>')
                code_list.append('              <outParameter>')
                code_list.append('                <outParameter-type>%s</outParameter-type>'%(idl_type))
                code_list.append('                <outParameter-name>result</outParameter-name>')
                code_list.append('              </outParameter>')
                code_list.append('            </outParameter-list>')
                code_list.append('          </component-service>')
                pass
            for x in getattr(c, '____object__xmethods__'):
                code_list.append('          <component-service>')
                code_list.append('            <service-name>%s_%s</service-name>'%(c___name__, getattr(x, '__name')))
                code_list.append('            <service-by-default>1</service-by-default>')
                code_list.append('            <inParameter-list>')
                code_list.append('              <inParameter>')
                code_list.append('                <inParameter-type>R1r1r1_CORBA::%s</inParameter-type>'%(c___name__))
                code_list.append('                <inParameter-name>object</inParameter-name>')
                code_list.append('              </inParameter>')
                xattrs = x.in_xattributes
                if xattrs is None: xattrs = []
                for xx in xattrs:
                    xtype = xx.xtype
                    idl_type = self.getCatalogType(xtype, for_yacs)
                    code_list.append('              <inParameter>')
                    code_list.append('                <inParameter-type>%s</inParameter-type>'%(idl_type))
                    code_list.append('                <inParameter-name>%s</inParameter-name>'%(getattr(xx, '__name')))
                    code_list.append('              </inParameter>')
                    pass
                code_list.append('            </inParameter-list>')
                code_list.append('            <outParameter-list>')
                code_list.append('              <outParameter>')
                code_list.append('                <outParameter-type>R1r1r1_CORBA::%s</outParameter-type>'%(c___name__))
                code_list.append('                <outParameter-name>object</outParameter-name>')
                code_list.append('              </outParameter>')
                xtype = x.out_xtype
                if xtype:
                    idl_type = self.getCatalogType(xtype, for_yacs)
                    code_list.append('              <outParameter>')
                    code_list.append('                <outParameter-type>%s</outParameter-type>'%(idl_type))
                    code_list.append('                <outParameter-name>%s</outParameter-name>'%("result"))
                    code_list.append('              </outParameter>')
                    pass
                xattrs = x.out_xattributes
                if xattrs is None: xattrs = []
                for xx in xattrs:
                    xtype = xx.xtype
                    idl_type = self.getCatalogType(xtype, for_yacs)
                    code_list.append('              <outParameter>')
                    code_list.append('                <outParameter-type>%s</outParameter-type>'%(idl_type))
                    code_list.append('                <outParameter-name>%s</outParameter-name>'%(getattr(xx, '__name')))
                    code_list.append('              </outParameter>')
                    pass
                code_list.append('            </outParameter-list>')
                code_list.append('          </component-service>')
                pass
            if not for_yacs:
                code_list.append('        </component-service-list>')
                pass
            pass
        if verbose(): print "writeCatalog (after all classes) in %s s"%(clock()-t_begin)
        if for_yacs:
            code_list.append('        </component-service-list>')
            pass
        code_list.append('      </component-interface-list>')
        code_list.append('    </component>')
        code_list.append('  </component-list>')
        code_list.append('</begin-catalog>')
        code_list.append('')
        if verbose(): print "writeCatalog in %s s"%(clock()-t_begin)
        code = '\n'.join(code_list)
        if for_yacs:
            code = code.replace('::', '/')
            pass
        write(code, "R1r1r1Catalog.xml", self.xdata_name)
        return
    
    def getCatalogType(self, t, for_yacs):
        idl_type = t.getIdlType()
        if for_yacs:
            if idl_type == "long" : return "int"
            if idl_type == "XDATA_CORBA::longSequence" : return "intvec"
            if idl_type == "XDATA_CORBA::doubleSequence" : return "dblevec"
            if idl_type == "XDATA_CORBA::stringSequence" : return "stringvec"
            pass
        return idl_type
    
    def writeDescriptionIdl(self):
        t_begin = clock()
        code_list = []
        code_list.append("#ifndef __R1r1r1_Description__IDL__")
        code_list.append("#define __R1r1r1_Description__IDL__")
        code_list.append("")
        
        # --
        # include other idl ...
        
        code_list.append('#include "XDATA_Description.idl"')
        
        idl_included = []
        for xtype in self.getAllXTypes():
            idl = None
            if 0:
                pass
            elif isinstance(xtype, XSalomeReference):
                idl = xtype.idl
                component = xtype.component
                pass
            elif isinstance(xtype, XInstance):
                cls = xtype.classes[0]
                if isinstance(cls, str):
                    from xutilities import getRealClassFromString
                    try:
                        cls = getRealClassFromString(cls)
                    except:
                        continue
                    pass
                if cls.__module__ == "libMEDClient":
                    idl = "MED.idl"
                    component = "MED"
                    pass
                pass
            #
            if idl is None: continue
            if idl in idl_included : continue
            #
            if component != self.xdata_name:
                component_env = "%s_ROOT_DIR"%(component)
                from os import getenv
                component_dir = getenv(component_env)
                if component_dir is None:
                    msg  = ''
                    msg += warning_sep
                    msg += warning_line
                    msg += '%s_ROOT_DIR variable not found ... hope that %s is local\n'%(component, component)
                    msg += warning_line
                    msg += warning_sep
                    print msg
                    pass
                pass
            idl_included.append(idl)
            #
            pass
        #
        for idl in idl_included:
            code_list.append('#include "%s"'%(idl))
            pass
        
        code_list.append('')
        
        # --
        # open module
        # --
        # If there is no class at all, we should not create
        # an empty module ... otherwise, omniidl fails !
        
        if len(self.getAllClasses()) > 0 :
            code_list.append("module R1r1r1_CORBA {")
            code_list.append('')
            pass
        
        # --
        # declaration of all interfaces
        
        for c in self.getAllClasses():
            code_list.append("  interface %s;"%(self.getInterfaceName(c)))
            pass
        if len(self.getAllClasses()) > 0 :
            code_list.append('')
            pass
        
        # --
        #
        
        for c in self.getAllClasses():
            c_code  = "  interface %s "%(self.getInterfaceName(c))
            #
            bases = []
            for b in c.__bases__:
                if issubclass(b, XObject):
                    bases.append(b)
                    pass
                pass
            if bases:
                c_code += ": "
                for b in bases:
                    if bases.index(b) > 0:
                        c_code += ", "
                        pass
                    if b in (XObject, XNamedObject, XSolver):
                        c_code += "XDATA_CORBA::"
                        pass
                    c_code += "%s"%(self.getInterfaceName(b))
                    pass
                pass
            c_code += " {"
            code_list.append(c_code)
            #
            xattrs  = []
            xattrs += c.getAllInitXAttributes()
            xattrs += getattr(c, '____object__xattributes__')
            for xattr in xattrs:
                #
                mro_defined = 0
                from xutilities import getMRO
                for b in getMRO(c, XObject)[1:]:
                    b_xattrs  = []
                    b_xattrs += b.getAllInitXAttributes()
                    b_xattrs += getattr(b, '____object__xattributes__')
                    for bx in b_xattrs:
                        if getattr(bx, '__name') == getattr(xattr, '__name'):
                            mro_defined = 1
                            break
                        pass
                    pass
                if mro_defined: continue
                #
                xtype = getattr(xattr, '__xtype')
                name = getattr(xattr, '__name')
                #
##                if isinstance(xtype, XSalomeReference):
##                    idl = xtype.idl
##                    if idl not in idl_included:
##                    msg  = ''
##                    msg += warning_sep
##                    msg += warning_line
##                    msg += '%s not included ... attribute %s of %s not included\n'%(idl.__repr__(), name, self.getInterfaceName(c))
##                    msg += warning_line
##                    msg += warning_sep
##                    print msg
##                    continue
##                pass
                #
                from xutilities import name2capname
                capname = name2capname(name)
                idl_type = xtype.getIdlType()
                code_list.append("    void get%s(out %s %s) raises(XDATA_CORBA::XException);"%(capname, idl_type, name))
                if xattr.mode == "rw":
                    code_list.append("    void set%s(in  %s %s) raises(XDATA_CORBA::XException);"%(capname, idl_type, name))
                    pass
                pass
            #
            for x in c.__object__xmethods__:
                mro_defined = 0
                from xutilities import getMRO
                for b in getMRO(c, XObject)[1:]:
                    b_xmeths = b.__object__xmethods__
                    for bx in b_xmeths:
                        if getattr(bx, '__name') == getattr(x, '__name'):
                            mro_defined = 1
                            break
                        pass
                    pass
                if mro_defined: continue
                cc = ''
                if x.out_xtype is None:
                    cc += "    void "
                else:
                    cc += "    %s "%(x.out_xtype.getIdlType())
                    pass
                cc += "%s("%(getattr(x, '__name'))
                if x.in_xattributes:
                    for xattr in x.in_xattributes:
                        cc += "in %s %s, "%(getattr(xattr, '__xtype').getIdlType(), getattr(xattr, '__name'))
                        pass
                    cc = cc[:-2]
                    pass
                if x.out_xattributes:
                    if cc[-1] != "(":
                        cc += ", "
                        pass
                    for xattr in x.out_xattributes:
                        cc += "out %s %s, "%(getattr(xattr, '__xtype').getIdlType(), getattr(xattr, '__name'))
                        pass
                    cc = cc[:-2]
                    pass
                cc += ") raises(XDATA_CORBA::XException);"
                code_list.append(cc)
                pass
            #
            code_list.append("  };")
            code_list.append("")
            pass
        if len(self.getAllClasses()) > 0 :
            code_list.append("};")
            code_list.append("")
            pass
        code_list.append("#endif")
        code_list.append("")
        if verbose(): print "writeDescriptionIdl in %s s"%(clock()-t_begin)
        write('\n'.join(code_list), "R1r1r1_Description.idl", self.xdata_name)
        return
    
    def writeComponentIdl(self):
        t_begin = clock()
        code_list = []
        code_list.append("#ifndef __R1r1r1_Component__IDL__")
        code_list.append("#define __R1r1r1_Component__IDL__")
        code_list.append("")
        code_list.append('#include "XDATA_Component.idl"')
        code_list.append('#include "XDATA_Description.idl"')
        code_list.append('#include "R1r1r1_Description.idl"')
        code_list.append("")
        code_list.append("module R1R1R1_CORBA {")
        code_list.append("  ")
        code_list.append("  interface R1R1R1_Component : XDATA_CORBA::XDATA_Component {")
        code_list.append("    ")
        for c in self.getComponentClasses():
            for suffix in ['', '_no_superv']:
                # We need explicitely the component name for the offset
                line = "    %s_CORBA::%s new%s%s("%(self.xdata_name.upper(), self.getInterfaceName(c), self.getInterfaceName(c), suffix)
                offset = len(line)*' '
                c_code  = ''
                c_code += line
                #
                xattrs = []
                #
                for xattr in c.getAllInitXAttributes():
                    xtype = getattr(xattr, '__xtype')
                    name = getattr(xattr, '__name')
##                if isinstance(xtype, XSalomeReference):
##                idl = xtype.idl
##                if idl not in idl_included:
##                    msg  = ''
##                    msg += warning_sep
##                    msg += warning_line
##                    msg += '%s not included ... attribute %s of %s not included\n'%(idl.__repr__(), name, self.getInterfaceName(c))
##                    msg += warning_line
##                    msg += warning_sep
##                    print msg
##                    continue
##                pass
                    xattrs.append(xattr)
                    pass
                #
                for i in range(len(xattrs)):
                    if i > 0: c_code += offset
                    c_code += "in "
                    xattr = xattrs[i]
                    xtype = getattr(xattr, '__xtype')
                    idl_type = xtype.getIdlType()
                    c_code += "%s %s"%(idl_type, getattr(xattr, '__name'))
                    if i < len(xattrs)-1:
                        c_code += ',\n'
                        pass
                    pass
                c_code += ") raises(XDATA_CORBA::XException);\n"
                c_code += "    "
                code_list.append(c_code)
                pass
            pass
        
        for c in self.getAllClasses():
            for suffix in ['', '_no_superv']:
                c_code  = ''
                xattrs = []
                xattrs += c.getXAttributesMRO()
                for xattr in xattrs:
                    from xutilities import name2capname
                    capname = name2capname(getattr(xattr, '__name'))
                    xtype = getattr(xattr, '__xtype')
                    idl_type = xtype.getIdlType()
                    line = "    void %s_get%s%s("%(self.getInterfaceName(c), capname, suffix)
                    offset = len(line)*' '
                    c_code += line
                    c_code += "in R1r1r1_CORBA::%s %s,\n"%(self.getInterfaceName(c), self.getInterfaceName(c)[0].lower()+self.getInterfaceName(c)[1:])
                    c_code += offset + "out R1r1r1_CORBA::%s implied_object_out,\n"%(self.getInterfaceName(c))
                    c_code += offset + "out %s result) raises(XDATA_CORBA::XException);\n"%(idl_type)
                    c_code += "    \n"
                    pass
                for x in c.__object__xmethods__:
                    line = "    void %s_%s%s("%(self.getInterfaceName(c), getattr(x, '__name'), suffix)
                    offset = len(line)*' '
                    c_code += line
                    # c_code += "in R1r1r1_CORBA::%s %s,\n"%(self.getInterfaceName(c), self.getInterfaceName(c)[0].lower()+self.getInterfaceName(c)[1:])
                    c_code += "in R1r1r1_CORBA::%s implied_object_in,\n"%(self.getInterfaceName(c))
                    xattrs = x.in_xattributes
                    if xattrs is None: xattrs = []
                    for xattr in xattrs:
                        xtype = getattr(xattr, '__xtype')
                        idl_type = xtype.getIdlType()
                        c_code += offset + "in %s %s,\n"%(idl_type, getattr(xattr, '__name'))
                        pass
                    c_code += offset + "out R1r1r1_CORBA::%s implied_object_out,"%(self.getInterfaceName(c))
                    xtype = x.out_xtype
                    if xtype:
                        idl_type = xtype.getIdlType()
                        c_code += " out %s result,"%(idl_type)
                        pass
                    xattrs = x.out_xattributes
                    if xattrs:
                        c_code += "\n"
                        for xattr in xattrs:
                            xtype = getattr(xattr, '__xtype')
                            idl_type = xtype.getIdlType()
                            c_code += offset + "out %s %s,\n"%(idl_type, getattr(xattr, '__name'))
                            pass
                        c_code = c_code[:-1]
                        pass
                    c_code = c_code[:-1]
                    c_code += ") raises(XDATA_CORBA::XException);\n"
                    c_code += "    \n"
                    pass
                code_list.append(c_code[:-1])
                pass
            pass
        
        # --
        # The "c.__module__, self.getInterfaceName(c)" definitions are used only
        # when searching the engine corresponding to a class
        # Those methods are not implemented ...
        
        for c in self.getComponentClasses():
            s = "    void %s_mod_cls_sep_%s() raises(XDATA_CORBA::XException);"%(c.__module__, self.getInterfaceName(c))
            s = s.replace(".", "_dot_")
            code_list.append(s)
            pass
        
        code_list.append("  };")
        code_list.append("};")
        code_list.append("")
        code_list.append("#endif")
        code_list.append("")
        
        if verbose(): print "writeComponentIdl in %s s"%(clock()-t_begin)
        write('\n'.join(code_list), "R1r1r1_Component.idl", self.xdata_name)
        return
    
    def writeImplementation(self):
        t_begin = clock()
        code  = ""
        code += '\n'
        code += 'import XDATA_i\n'  # E.A. : CAUTION do this import first !! I don't know why ???
        code += 'import R1R1R1_CORBA__POA\n'
        # code += 'from R1R1R1_CORBA__POA import R1r1r1_Component\n'
        # code += 'from XDATA_i import XDATA\n'
        code += '\n'
        code += 'class R1r1r1(R1R1R1_CORBA__POA.R1r1r1_Component, XDATA_i.XDATA):\n'
        
        # SRN: Aug 24, 2004, added a method ComponentDataType
        code += "    def ComponentDataType(self):\n"
        code += "        return \"R1r1r1\"\n"
        # SRN: END 

        for key in ["Save", "Load", "IORToLocalPersistentID", "LocalPersistentIDToIOR", "Close"]:
            mod = __import__("%s_xdata"%(self.xdata_name))
            if hasattr(mod, key):
                code += "    def %s(self, *args, **kwargs):\n"%(key)
                code += "        from R1r1r1_xdata import %s\n"%(key)
                code += "        return %s(self, *args, **kwargs)\n"%(key)
                pass
            pass
        
        for c in self.getComponentClasses():
            for suffix in ['', '_no_superv']:
                c_code  = ''
                c_code += "    def new%s%s(self, *args, **kwargs):\n"%(self.getInterfaceName(c), suffix)
                c_code += "        from xutilities import message\n"
                c_code += "        message('args:', args, cls='R1r1r1')\n"
                c_code += "        from %s import %s\n"%(c.__module__, c.__name__)
                if suffix == '_no_superv':
                    c_code += "        res = self.newCorbaObject(%s, *args, **kwargs)\n"%(c.__name__)
                else:
                    c_code += "        try:\n"
                    c_code += "            res = self.newCorbaObject(%s, *args, **kwargs)\n"%(c.__name__)
                    c_code += "        except Exception, e:\n"
                    c_code += "            from xsalome import corba2python\n"
                    c_code += "            print corba2python(e)\n"
                    c_code += "            raise e\n"
                    pass
                c_code += "        return res\n"
                code += c_code
                pass
            pass
        for c in self.getAllClasses():
            for suffix in ['', '_no_superv']:
                c_code  = ''
                xattrs = []
                xattrs += c.getXAttributesMRO()
                for xattr in xattrs:
                    from xutilities import name2capname
                    capname = name2capname(getattr(xattr, '__name'))
                    service_name = "%s_get%s%s"%(self.getInterfaceName(c), capname, suffix)
                    c_code += "    def %s(self, obj):\n"%(service_name)
                    if suffix == '_no_superv':
                        c_code += "        result = obj.get%s()\n"%(capname)
                    else:
                        c_code += "        self.beginService('%s')\n"%(service_name)
                        c_code += "        try:\n"
                        c_code += "            result = obj.get%s()\n"%(capname)
                        c_code += "        except Exception, e:\n"
                        c_code += "            from xsalome import corba2python\n"
                        c_code += "            print corba2python(e)\n"
                        c_code += "            raise e\n"
                        c_code += "        self.endService('%s')\n"%(service_name)
                        pass
                    c_code += "        return obj, result\n"
                    pass
                for xmeth in c.__object__xmethods__:
                    service_name = "%s_%s%s"%(self.getInterfaceName(c), getattr(xmeth, '__name'), suffix)
                    c_code += "    def %s(self, obj, *args):\n"%(service_name)
                    if suffix == '_no_superv':
                        c_code += "        result = obj.%s(*args)\n"%(getattr(xmeth, '__name'))
                    else:
                        c_code += "        self.beginService('%s')\n"%(service_name)
                        c_code += "        try:\n"
                        c_code += "            result = obj.%s(*args)\n"%(getattr(xmeth, '__name'))
                        c_code += "        except Exception, e:\n"
                        c_code += "            from xsalome import corba2python\n"
                        c_code += "            print corba2python(e)\n"
                        c_code += "            raise e\n"
                        c_code += "        self.endService('%s')\n"%(service_name)
                        pass
                    if xmeth.out_xtype:
                        c_code += "        return obj, result\n"
                    elif xmeth.out_xattributes:
                        if len(xmeth.out_xattributes) == 1:
                            c_code += "        return obj, result\n"
                        else:
                            c_code += "        return (obj, ) + result\n"
                            pass
                        pass
                    else:
                        c_code += "        return obj\n"
                        pass
                    pass
                code += c_code
                pass
            pass
        code += "    pass\n"
        code += '\n'
        for cls in  self.getAllClasses():
            c_code  = ""
            c_code += "class %s_i(R1R1R1_CORBA__POA.%s"%(self.getInterfaceName(cls), self.getInterfaceName(cls))
            bases = []
            for b in cls.__bases__:
                if issubclass(b, XObject):
                    bases.append(b)
                    pass
                pass
            if bases:
                c_code += ", "
                for b in bases:
                    if bases.index(b) > 0:
                        c_code += ", "
                        pass
                    if b in (XObject, XNamedObject, ):
                        c_code += "XDATA_i.XObject_i"
                    elif b in (XSolver, ):
                        c_code += "XDATA_i.XSolver_i"
                    else:
                        c_code += "%s_i"%(self.getInterfaceName(b))
                        pass
                    pass
                pass
            c_code += "):\n"
            for x in cls.getXAttributesMRO():
                from xutilities import name2capname
                capname = name2capname(x.name)
                fname = "get%s"%(capname)
                c_code += "    def %s(self, *args, **kwargs):\n"%(fname)
                c_code += "        return self.get_impl('"+x.name+"', *args, **kwargs)\n"
                if x.mode == "rw":
                    fname = "set%s"%(capname)
                    c_code += "    def %s(self, *args, **kwargs):\n"%(fname)
                    c_code += "        return self.set_impl('"+x.name+"', *args, **kwargs)\n"
                    pass
                pass
            for x in cls.__object__xmethods__:
                fname = x.name
                c_code += "    def %s(self, *args, **kwargs):\n"%(fname)
                c_code += "        return self.apply_impl('"+fname+"', *args, **kwargs)\n"
                pass
            c_code += "    pass\n"
            c_code += '\n'
            code += c_code
            pass
        if verbose(): print "writeImplementation in %s s"%(clock()-t_begin)
        write(code, "R1r1r1.py", self.xdata_name)
        return
    
    def getPopupItemStream(self, ddd, menu_label, label_id, pos_id, item_id, accel_id=""):
        if ddd is not None: ddd[item_id] = "%s/%s"%(menu_label, label_id)
        code  = ''
        code += '<popup-item label-id="%s" pos-id="%s" item-id="%s"'%(label_id, pos_id, item_id)
        code += ' icon-id="" tooltip-id="" accel-id="%s" toggle-id="" execute-action=""/>\n'%(accel_id)
        return code
    
    def getMenuItemStream(self, ddd, label_id, pos_id):
        item_id = 10*pos_id
        ddd[item_id] = label_id
        code  = ''
        code += '<menu-item label-id="%s" pos-id="%s" item-id="%s">\n'%(label_id, pos_id, item_id)
        # code += '<popup-item item-id="9999" label-id="TO_BE_REMOVE" icon-id="" tooltip-id="" accel-id="" toggle-id="" execute-action=""/>\n'
        code += '</menu-item>\n'
        return code
    
    def writeGuiFiles(self):
        t_begin = clock()
        item_id_2_xdata_name = {}
        salome_keys = ["File", "View", "Edit", "Preferences", "Tools", "Window", "Help"]
        #
        code  = ''
        code += '<?xml version="1.0" encoding="us-ascii"?>\n'
        code += '<!DOCTYPE application PUBLIC "" "desktop.dtd">\n'
        code += '<application>\n'
        code += '<desktop>\n'
        code += '<menubar>\n'
        #
        code += '<menu-item label-id="File" pos-id="" item-id="1">\n'
        code += '<separator pos-id="-4"/>\n'
        code += self.getPopupItemStream(None, "File", "Import", -4, 1000, "Ctrl+I")
        code += self.getPopupItemStream(None, "File", "Export", -4, 1001, "Ctrl+E")
        code += '</menu-item>\n'
        #
        for key in salome_keys:
            x = self.getItem(key)
            if x is None: continue
            if key == "Window":
                msg  = ""
                msg += warning_sep
                msg += warning_line
                msg += "The Window menu of salome 2.x is not customizable for the moment ...\n"
                msg += "Your items in Window will not appear ...\n"
                msg += warning_line
                msg += warning_sep
                print msg
                pass
            label_id = key
            item_id = salome_keys.index(key)+1
            code += '<menu-item label-id="%s" pos-id="" item-id="%s">\n'%(label_id, item_id)
            item_id = 1000*item_id
            if key == "File":
                pos_id = -4
                item_id += 2 # E.A. 'cause 100 and 101 are for Import / Export
            elif key == "Preferences":
                pos_id = -2
            elif key == "Help":
                pos_id = -2
            else:
                pos_id = ""
                pass
            for xx in x.children:
                if xx.xdata_name:
                    code += self.getPopupItemStream(item_id_2_xdata_name,
                                                    key, xx.xdata_name, pos_id, item_id)
                    # pos_id += 1
                    item_id += 1
                else:
                    code += '<separator pos-id="%s"/>\n'%(pos_id)
                    pass
                pass
            # code += '<separator pos-id="%s"/>\n'%(pos_id)
            code += '</menu-item>\n'
            pass
        #
        pos_id = 3
        for xdata_item in self.children:
            if xdata_item.is_final: continue
            label_id = xdata_item.xdata_name
            if label_id in salome_keys: continue
            code += self.getMenuItemStream(item_id_2_xdata_name, label_id, pos_id)
            pos_id += 1
            pass
        #
        code += '</menubar>\n'
        code += '</desktop>	\n'
        code += '</application>\n'
        write(code, "R1r1r1_en.xml", self.xdata_name)
        
        code  = ''
        code += '\n'
        code += 'from xcontext import setContext\n'
        code += 'setContext("clt")\n'
        code += 'from xcontext import setInterface\n'
        code += 'setInterface("gui")\n'
        code += '\n'
        #
        code += 'item_id_2_xdata_name = {}\n'
        for key, value in item_id_2_xdata_name.items():
            code += 'item_id_2_xdata_name[%s] = "%s"\n'%(key, value)
            pass
        code += '\n'
##        code += 'classes = []\n'
##        for c in self.getAllClasses():
##            code += 'from %s import %s\n'%(c.__module__, self.getInterfaceName(c))
##            code += 'classes.append(%s)\n'%(self.getInterfaceName(c))
##            pass
##        code += '\n'
        code += 'from xsalomegui import *\n'
        code += 'from xutilities import message\n'
        code += '\n'
        code += 'def setSettings():\n'
        code += '    message("Hello", verbose_level_min=4)\n'
        code += '    setSettingsForModule("R1r1r1", item_id_2_xdata_name)\n'
        code += '    message("Good bye", verbose_level_min=4)\n'
        code += '    return\n'
        code += '\n'
        code += 'def activeStudyChanged(ID):\n'
        code += '    message("Hello", ID, verbose_level_min=4)\n'
        code += '    setSettings()\n'
        code += '    message("Good bye", verbose_level_min=4)\n'
        code += '    return\n'
##        code += 'def customPopup(*args):\n'
##        code += '    args = list(args)+[classes]\n'
##        code += '    from xsalomegui import customPopup\n'
##        code += '    customPopup(*args)\n'
##        code += '    return\n'
##        code += '\n'
        
        if verbose(): print "writeGuiFiles in %s s"%(clock()-t_begin)
        write(code, "R1r1r1GUI.py", self.xdata_name)
        return
    
    def writeSalomeSharedModulesPythonFile(self):
        code  = ''
        code += '\n'
        code += 'from xutilities import verbose\n'
        code += '\n'
        code += 'if verbose(): print "============== import XDATA_CORBA ======================="\n'
        code += 'import XDATA_CORBA\n'
        code += 'if verbose(): print "============== import R1r1r1_CORBA ======================="\n'
        code += 'import R1r1r1_CORBA\n'
        try:
            l = self.module.__salome__shared__modules__
        except AttributeError:
            l = []
            pass
        for name in l:
            code += 'if verbose(): print "============== import %s ======================="\n'%(name)
            code += 'import %s\n'%(name)
            pass
        code += '\n'
        code += 'def init_shared_modules():\n'
        code += '    return\n'
        code += '\n'
        write(code, "R1r1r1_shared_modules.py", self.xdata_name)
        return

    pass

def compile(file_name):
    import os.path
    full_file_name = os.path.abspath(file_name)
    file_path = os.path.dirname(full_file_name)
    file_name = os.path.basename(full_file_name)
    module_path = file_path
    module_name = file_name[:-3]      # R1r1r1_xdata.py --> R1r1r1_xdata
    component_name = module_name[:-6] # R1r1r1_xdata    --> R1r1r1
    # Test if component_name is upper
    if not component_name.isupper():
        msg  = '\n\n'
        msg += 'It seems that in salome, the component names must be upper case ...\n'
        msg += "It's only for the gui to work !\n"
        msg += "It's not true for %s, "%(component_name.__repr__())
        msg += "please, rename in %s.\n"%(component_name.upper().__repr__())
        msg += 'OK, OK, I could do that myself but I prefer you to be conscious of that ...\n'
        raise Exception(msg)
    #
    from xcontext import getInterface, setInterface
    val = getInterface()
    setInterface('tui')
    main_tree = XData2SalomeItemTree(component_name)
    if verbose() : print main_tree.getPresentation()
    # --
    from os import getenv
    super_root_dir = getenv('SUPERV_ROOT_DIR')
    yacs_root_dir = getenv('YACS_ROOT_DIR')
    for_yacs = 0
    if yacs_root_dir:
        if not super_root_dir:
            for_yacs = 1
            pass
        pass
    # --
    main_tree.writeCatalog(for_yacs)
    main_tree.writeDescriptionIdl()
    main_tree.writeComponentIdl()
    main_tree.writeImplementation()
    main_tree.writeGuiFiles()
    main_tree.writeSalomeSharedModulesPythonFile()
    setInterface(val)
    return
