# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xsalome import XSalomeSession
from SAB_geom import A

salome = XSalomeSession(modules=["SAB"])

class TestCase(unittest.TestCase):
    def checkSM(self, obj):
        objs = [ getattr(obj, "shape%s"%(i)) for i in range(4) ]
        for obj in objs:
            if obj is None: continue
            self.failUnlessEqual(obj.GetOpenStudies(), [])
            pass
        return
    def test(self):
        #
        shape = salome.study_manager
        #
        s = "<SALOMEDS._objref_StudyManager instance"
        #
        a = A(shape0=shape,
              shape1=None,
              shape2=None,
              )
        self.failUnlessEqual(str(a.shape0)[:len(s)], s)
        self.failUnlessEqual(a.shape1, None)
        self.failUnlessEqual(a.shape2, None)
        self.failUnlessEqual(a.shape3, None)
        self.checkSM(a)
        #
        a = A(shape0=shape,
              shape1=None,
              shape2=None,
              shape3=None,
              )
        self.failUnlessEqual(str(a.shape0)[:len(s)], s)
        self.failUnlessEqual(a.shape1, None)
        self.failUnlessEqual(a.shape2, None)
        self.failUnlessEqual(a.shape3, None)
        self.checkSM(a)
        #
        a = A(shape0=shape,
              shape1=None,
              shape2=None,
              shape3=shape,
              )
        self.failUnlessEqual(str(a.shape0)[:len(s)], s)
        self.failUnlessEqual(a.shape1, None)
        self.failUnlessEqual(a.shape2, None)
        self.failUnlessEqual(str(a.shape3)[:len(s)], s)
        self.checkSM(a)
        #
        a = A(shape0=shape,
              shape1=shape,
              shape2=shape,
              shape3=shape,
              )
        self.failUnlessEqual(str(a.shape0)[:len(s)], s)
        self.failUnlessEqual(str(a.shape1)[:len(s)], s)
        self.failUnlessEqual(str(a.shape2)[:len(s)], s)
        self.failUnlessEqual(str(a.shape3)[:len(s)], s)
        self.checkSM(a)
        #
        return
    
    def test_AAAA(self):
        val = salome.study_manager
        s = "<SALOMEDS._objref_StudyManager instance"
        d = {"val": val}
        from SAB_geom import AAAA
        a = AAAA(val, d)
        self.failUnlessEqual(str(a.val)[:len(s)], s)
        self.failUnlessEqual(str(a.d['val'])[:len(s)], s)
        return
    
    def testException(self):
        shape = salome.study_manager
        a = A(shape, None, None)
        #
        try:
            a.foo()
            raise "KO"
        except:
            from sys import exc_info
            exc_type, exc_value, exc_traceback = exc_info()
            self.failUnlessEqual(exc_type, TypeError)
            exc_msg = str(exc_value)
            exc_msg = exc_msg.strip()
            exc_msg_lines = exc_msg.split('\n')
            try:
                self.failUnlessEqual(exc_msg_lines[-1].strip(), 'TypeError: unsubscriptable object')
            except AssertionError:
                self.failUnlessEqual(exc_msg_lines[-1].strip(), "TypeError: 'object' object is unsubscriptable")
                pass
            self.failUnlessEqual(exc_msg_lines[-2].strip(), 'res = a[43]')
            pass
        #
        try:
            a.bar()
            raise "KO"
        except:
            from sys import exc_info
            exc_type, exc_value, exc_traceback = exc_info()
            self.failUnlessEqual(exc_value, None)
            exc_msg = str(exc_type)
            exc_msg = exc_msg.strip()
            exc_msg_lines = exc_msg.split('\n')
            self.failUnlessEqual(exc_msg_lines[-1].strip(), 'aaaaa')
            self.failUnlessEqual(exc_msg_lines[-2].strip(), 'raise "aaaaa"')
            pass
        
        return
    
    def testB(self):
        from SAB_geom import B
        b = B()
        res = b.getD()
        self.failUnlessEqual(res, {0.0000001: 'a', 0.0000002: 'b'})
        return
    
    def testC(self):
        #
        d = {
            "m": {1.0: 0.0, 2.0: 4.0}
            }
        from SAB_geom import C
        c = C(d)
        m = c.getM()
        self.failUnlessEqual(m, {1.0: 0.0, 2.0: 4.0})
        #
        d = {
            "m": {0.0000001: 0.0, 0.0000002: 4.0}
            }
        from SAB_geom import C
        c = C(d)
        m = c.getM()
        self.failUnlessEqual(m, {0.0000001: 0.0, 0.0000002: 4.0})
        #
        return
    
    def testAA(self):
        from SAB_geom import AA
        a = AA()
        from xdata import XValueError
        self.failUnlessRaises(XValueError, a.foo)
        return
    
    def test_DDDD(self):
        sm = salome.study_manager
        l = [ sm ]
        from SAB_geom import DDDD
        d = DDDD(l)
##        val = salome.study_manager
##        s = "<SALOMEDS._objref_StudyManager instance"
##        d = {"val": val}
##        from SAB_geom import AAAA
##        a = AAAA(val, d)
##        self.failUnlessEqual(str(a.val)[:len(s)], s)
##        self.failUnlessEqual(str(a.d['val'])[:len(s)], s)
        return
    
    pass

if __name__ == '__main__':
    unittest.main()
    pass
