# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xsomething import XSomething
from xexceptions import XValueError, XAttributeError
from xutilities import value2text

class XType(XSomething):
    __init__argslen__ = 0
    __python__type__ = object
    __xtype__ = 1
    
    def __init__(self, *args, **kwargs):
        inames = self.__inames__namelast__
        inames_not_None_keys = []
        inames_not_None_values = []
        for key in inames:
            value = getattr(self, "__%s"%(key))
            if value is None : continue
            inames_not_None_keys.append(key)
            inames_not_None_values.append(value)
            pass
        self.__inames_not_None_len__ = len(inames_not_None_keys)
        self.__inames_not_None_keys__ = inames_not_None_keys
        self.__inames_not_None_values__ = inames_not_None_values
        return
    
    def testValueRaised(self, msg):
        raise XValueError(msg)
    
    def testValue(self, value):
        return self.__call__(value)
    
    def __call__(self, value):
        # --
        # CAUTION : this function is called a large number of times !!!
        # --
        
        init_value = value
        
        python_type = self.__python__type__

        ok = 1
        if not isinstance(value, python_type):
            ok = 0
            # Fix for unicode objects
            if python_type is str:
                if isinstance(value, unicode):
                    ok = 1
                    pass
                pass
            #
            pass
        if not ok:
            text = value2text(value)
            msg = 'type(%s) is not '%(text)
            if python_type in (int, float, ):
                msg += 'compatible with '
                pass
            msg += '%s'%(python_type)
            self.testValueRaised(msg)
            pass
        
        if python_type is tuple:
            # transform the tuple into list
            # to modify it if required
            # it will be reversed before return
            value = list(value)
            pass
        
        inames_not_None_len = self.__inames_not_None_len__
        inames_not_None_keys = self.__inames_not_None_keys__
        inames_not_None_values = self.__inames_not_None_values__
        
        for i in range(inames_not_None_len):
            kw = inames_not_None_keys[i]
            kwval = inames_not_None_values[i]
            
            if kw == "min":
                if value < kwval:
                    msg = "%s < (min = %s)"%(value2text(value), value2text(kwval))
                    return self.testValueRaised(msg)
                continue
            
            if kw == "max":
                if value > kwval:
                    msg = "%s > (max = %s)"%(value2text(value), value2text(kwval))
                    return self.testValueRaised(msg)
                continue
            
            if kw == "open_min":
                if value <= kwval:
                    msg = "%s <= (min = %s)"%(value2text(value), value2text(kwval))
                    return self.testValueRaised(msg)
                continue
            
            if kw == "open_max":
                if value >= kwval:
                    msg = "%s >= (max = %s)"%(value2text(value), value2text(kwval))
                    return self.testValueRaised(msg)
                continue
            
            if kw == "into":
                if python_type is int:
                    if value not in kwval:
                        msg = "%s not in %s"%(value2text(value), value2text(kwval))
                        return self.testValueRaised(msg)
                    pass
                elif python_type is str:
                    into_lower = getattr(self, '__into__lower')
                    value_lower = value.lower()
                    ok = 0
                    for i in range(len(kwval)):
                        if value_lower != into_lower[i]: continue
                        value = kwval[i]
                        ok = 1
                        break
                    if not ok:
                        msg = "%s not in %s even without the case"%(value2text(value), value2text(kwval))
                        return self.testValueRaised(msg)
                    pass
                continue
            
            if kw == "not_into":
                if value in kwval:
                    msg = "%s in %s ... it should not"%(value2text(value), value2text(kwval))
                    return self.testValueRaised(msg)
                continue
            
            if kw == "len":
                if len(value) != kwval:
                    msg = "len(%s) != %s"%(value2text(value), value2text(kwval))
                    return self.testValueRaised(msg)
                continue
            
            if kw == "len_min":
                if len(value) < kwval:
                    msg = "len(%s) < (min = %s)"%(value2text(value), value2text(kwval))
                    return self.testValueRaised(msg)
                continue
            
            if kw == "len_max":
                if len(value) > kwval:
                    msg = "len(%s) > (max = %s)"%(value2text(value), value2text(kwval))
                    return self.testValueRaised(msg)
                continue
            
            if kw == "sequence":
                for i in range(len(value)):
                    v, xtype = value[i], kwval[i%len(kwval)]
                    res = xtype(v)
                    value[i] = res
                    pass
                continue
            
            if kw == "len_multiple":
                if len(value)%kwval != 0:
                    msg  = "len(%s) "%(value2text(init_value))
                    msg += "is not a multiple of "
                    msg += "%s "%(kwval)
                    return self.testValueRaised(msg)
                continue
            
            if kw == "keys":
                for k, v in value.items():
                    del value[k]
                    value[kwval(k)] = v
                    pass
                continue
            
            if kw == "values":
                for k, v in value.items():
                    value[k] = kwval(v)
                    pass
                continue
            
            pass
        
        if python_type is tuple:
            value = tuple(value)
            pass
        
        return value
    
    def getIdlType(self):
        name = self.__class__.__name__
        if name == "XMulTypes":
            name = "XType"
            pass
        return "XDATA_CORBA::%s"%(name)
    
    def getAllXTypes(self):
        return [self]
    
    pass

# --
#

class XNone(XType):
    __python__type__ = type(None)
    
    def __call__(self, value):
        if isinstance(value, str):
            if value == "None":
                value = None
                pass
            pass
        return XType.__call__(self, value)
    
    pass

# --
#

from xattribute import XAttribute
from xbootstrap import xtype_bootstrap

class XInt(XType):
    __python__type__ = int
    __init__xattributes__ = [
        XAttribute("min", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("max", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("into", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("not_into", xtype=xtype_bootstrap, default_value=None, mode="r"),
        ]
    
    def __call__(self, value):
        if type(value) is str:
            try: value = eval(value)
            except: pass
            pass
        if value is True:
            return 1
        if value is False:
            return 0
        return XType.__call__(self, value)
    
    def getIdlType(self):
        return "long"
    
    pass

class XFloat(XType):
    __python__type__ = float
    __init__xattributes__ = [
        XAttribute("min", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("max", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("open_min", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("open_max", xtype=xtype_bootstrap, default_value=None, mode="r"),
        ]
    
    def __call__(self, value):
        #
        try:
            value = float(value)
        except:
            ok = 1
            try:
                value = eval(value)
            except:
                ok = 0
                pass
            if ok:
                if not isinstance(value, float):
                    ok = 0
                    pass
                pass
            if not ok:
                python_type = self.__python__type__
                text = value2text(value)
                msg = 'type(%s) is not '%(text)
                msg += 'compatible with '
                msg += '%s'%(python_type)
                self.testValueRaised(msg)
                pass
            pass
        #
        if self.__inames_not_None_len__:
            value = XType.__call__(self, value)
            pass
        #
        return value
    
    def getIdlType(self):
        return "double"
    
    pass

class XString(XType):
    __python__type__ = str
    __init__xattributes__ = [
        XAttribute("len", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("len_min", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("len_max", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("into", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("not_into", xtype=xtype_bootstrap, default_value=None, mode="r"),
        ]
    def setInto(self, value):
        into = getattr(self, '__into')
        if into is None: return
        setattr(self, '__into__lower', [ s.lower() for s in into ])
        return
    def getIdlType(self):
        return "string"
    pass

class XBoolean(XString):
    
    def __init__(self):
        super(XBoolean, self).__init__(into=['True', 'False'])
        return
    
    def __call__(self, value):
        if isinstance(value, str):
            if value.lower() == "true":
                return True
            if value.lower() == "false":
                return False
            pass
        return not not value
    
    def getIdlType(self):
        return "boolean"
    
    pass

class XFileName(XString):
    __init__xattributes__ = XString.__init__xattributes__ + [
        XAttribute("suffix_into", xtype=xtype_bootstrap, default_value=None, mode="r"),
        ]
    pass

class XInputFileName(XFileName):
    pass

class XOutputFileName(XFileName):
    pass

class XDirName(XString):
    pass

class XInputDirName(XFileName):
    pass

class XOutputDirName(XFileName):
    pass

class XList(XType):
    __python__type__ = list
    __init__xattributes__ = [
        XAttribute("len", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("len_min", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("len_max", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("sequence", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("len_multiple", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("unpack_in_browser", xtype=xtype_bootstrap, default_value=1, mode="r"),
        ]
    
    def setSequence(self, value):
        seq = getattr(self, '__sequence')
        if isinstance(seq, list): return
        if seq is None: return
        if isinstance(seq, tuple): return
        setattr(self, '__sequence', [seq])
        return
    
    def setLenMultiple(self, value):
        seq = getattr(self, '__sequence')
        if seq is None: return
        len_multiple = getattr(self, '__len_multiple')
        if len_multiple is None:
            setattr(self, '__len_multiple', len(seq))
            pass
        return
    
    def __conversion__(self, value, python_type):
        # --
        # Conversion list <--> tuple
        if python_type is list:
            if isinstance(value, tuple):
                value = list(value)
                pass
            pass
        else:
            if isinstance(value, list):
                value = tuple(value)
                pass
            pass
        return value
    
    def __call__(self, value):
        # --
        python_type = self.__python__type__
        # --
        if value is None:
            # --
            # Do nothing !!!
            # otherwise None is accepted as [None] and
            # thus there is a problem when declare something like
            # XAttribute("l", xtype=XList(), default_value=None)
            pass
        elif isinstance(value, (list, tuple, )):
            value = self.__conversion__(value, python_type)
        elif type(value) is str:
            # --
            # Convert "a, b, c, d" in "a", "b", "c", "d" list or tuple
            #
            s = value
            #
            s = s.strip()
            if s[0] != "(" and s[0] != "[":
                s = '[' + s + ']'
                pass
            #
            try:
                exec "value = %s"%(s)
                ok = 1
            except:
                ok = 0
                pass
            #
            if not ok:
                while 1:
                    s_new = s.replace(', ', ',')
                    if s_new == s:
                        break
                    s = s_new
                    pass
                #
                s = s.replace("'", "")
                s = s.replace('"', "")
                s = s.replace(",","','")
                s = s.replace("(","('")
                s = s.replace(")","')")
                s = s.replace("[","['")
                s = s.replace("]","']")
                s = s.replace("'(","(")
                s = s.replace(")'",")")
                s = s.replace("'[","[")
                s = s.replace("]'","]")
                s = s.replace("''","")
                #
                exec "value = %s"%(s)
                pass
            #
            value = self.__conversion__(value, python_type)
            pass
        else:
            # --
            # If (sequence is None) or (len(sequence) == 1):
            # convert value in [value]
            seq = getattr(self, '__sequence')
            if ( seq is None ) or ( len(seq) == 1 ):
                if type(value) is not python_type:
                    value = [value]
                    value = self.__conversion__(value, python_type)
                    pass
                pass
            pass
        # --
        #
        return XType.__call__(self, value)
    
    def getIdlType(self):
        seq = getattr(self, '__sequence')
        if seq and len(seq) == 1:
            xtype = seq[0]
            seq_idl_type = xtype.getIdlType()
            if seq_idl_type in ["long", "double", "string"]:
                return "XDATA_CORBA::%sSequence"%(seq_idl_type)
            pass
        return "XDATA_CORBA::XObjectSequence"
    
    def getAllXTypes(self):
        l = XType.getAllXTypes(self)
        sequence = self.sequence
        if sequence:
            for x in sequence:
                l += x.getAllXTypes()
                pass
            pass
        return l
            
    pass

class XTuple(XList):
    __python__type__ = tuple
    pass

class XDict(XType):
    __python__type__ = dict
    __init__xattributes__ = [
        XAttribute("keys", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("values", xtype=xtype_bootstrap, default_value=None, mode="r"),
        XAttribute("sort_in_browser", xtype=xtype_bootstrap, default_value=1, mode="r"),
        XAttribute("unpack_in_browser", xtype=xtype_bootstrap, default_value=1, mode="r"),
        ]
    
    def __call__(self, value):
        if type(value) is str:
            try: value = eval(value)
            except: pass
            pass
        return XType.__call__(self, value)
    
    def getIdlType(self):
        keys = getattr(self, "__keys")
        if keys:
            if isinstance(keys, XInt):
                return "XDATA_CORBA::XDictLongKeys"
            if isinstance(keys, XFloat):
                return "XDATA_CORBA::XDictDoubleKeys"
            if isinstance(keys, XString):
                return "XDATA_CORBA::XDictStringKeys"
            pass
        return "XDATA_CORBA::XDictXObjectKeys"
    
    def getAllXTypes(self):
        l = []
        keys, values = self.keys, self.values
        if keys: l += keys.getAllXTypes()
        if values : l += values.getAllXTypes()
        return l
    
    pass

class XReferenceAbstract(XType):
    pass

class XInstance(XReferenceAbstract):
    __init__xattributes__ = [
        XAttribute("classes", xtype=xtype_bootstrap, mode="r"),
        ]
    __init__argslen__ = -1
    
    def setClasses(self, value):
        msg  = "%s must be a list of classes\n"%(value2text("classes"))
        msg += "or a string like 'module.class'\n"
        for v in getattr(self, '__classes'):
            if isinstance(v, str):
                if len(v.split('.')) < 2:
                    msg += "%s is not ..."%(str(v))
                    self.testValueRaised(msg)
                    pass
                pass
            else:
                try:
                    str_v = "%s.%s"%(v.__module__, v.__name__)
                except AttributeError:
                    msg += "%s is not ..."%(str(v))
                    self.testValueRaised(msg)
                    pass
                pass
            pass
        return
    
    def __call__(self, value):
        kwval = getattr(self, '__classes')
        ok = 0
        for c in kwval:
            if isinstance(c, str):
                # --
                # If c is given as "module.class", get the
                # real class now (at run-time)
                from xutilities import getRealClassFromString
                c = getRealClassFromString(c)
                pass
            ok = isinstance(value, c)
            if ok: 
                break
            pass
        if not ok:
            msg  = "%s is not an instance of one of %s"%(value2text(value), value2text(kwval))
            return self.testValueRaised(msg)
        return value
    
    def getIdlType(self):
        classes = self.classes
        if len(classes) > 1:
            # Try to find a common sub-class
            c = classes[0]
            base = None
            try:
                mro = c.__mro__
            except:
                from xobject import XObject
                mro = [XObject]
                pass
            for b in mro:
                ok = 1
                for c in classes[1:]:
                    ok = b in c.__mro__
                    if ok: break
                    pass
                if ok:
                    base = b
                    break
                pass
            if b is None:
                message  = "len(classes) > 1 and can't find a common sub-class"
                raise NotImplementedError(message)
            c = base
        else:
            c = classes[0]
            pass
        # --
        if isinstance(c, str):
            from xutilities import getRealClassFromString
            c = getRealClassFromString(c)
            pass
        # --
        module_name, name = c.__module__, c.__name__
        #
        if module_name == "libMEDClient":
            corba_module = "SALOME_MED"
            if name == "FIELD_":
                name = "FIELD"
                pass
            pass
        else:
            corba_module = "XDATA_CORBA"
            name = "XObject"
            pass
        #
        return "%s::%s"%(corba_module, name)
    pass

class XSalomeReference(XReferenceAbstract):
    __init__xattributes__ = [
        XAttribute("component", xtype=xtype_bootstrap, mode="r"),
        XAttribute("idl", xtype=xtype_bootstrap, mode="r"),
        XAttribute("module", xtype=xtype_bootstrap, mode="r"),
        XAttribute("interface", xtype=xtype_bootstrap, mode="r"),
        ]
    
    def setComponent(self, value):
##        if self.component == "MED":
##            msg  = "Please, use the python module libMEDClient to refer\n"
##            msg += "med objects ... For instance :\n"
##            msg += "XInstance('libMEDClient.MESH') to refer a mesh.\n"
##            msg += "It will work in pure python and in salome !!\n"
##            raise msg
        return
    
    def __call__(self, value):
        #
        value = XType.__call__(self, value)
        #
        try:
            mod = __import__(self.module)
        except ImportError, e:
            raise XValueError(e)
        #
        c = getattr(mod, self.interface)
        #
        if self.module == "SALOME_MED":
            if self.interface == "MESH":
                from libMEDClient import MESHClient
                if isinstance(value, MESHClient):
                    from libMedCorba_Swig import createCorbaMesh
                    value = createCorbaMesh(value)
                    pass
                pass
            pass
        #
        msg  = "The corba object cannot be narrowed to %s.%s"%(self.module, self.interface)
        try:
            v = value._narrow(c)
        except AttributeError:
            raise XValueError(msg)
        if v is None:
            raise XValueError(msg)
        return value
    
    def getIdlType(self):
        idl_type = "%s::%s"%(self.module, self.interface)
        return idl_type
    
    pass

class XMulTypes(XType):
    __init__xattributes__ = [
        XAttribute("xtypes", xtype=xtype_bootstrap, mode="r"),
        ]
    __init__argslen__ = -1
    
    def __call__(self, value):
        kwval = getattr(self, '__xtypes')
        msg = "\n"
        ok = 0
        for i in range(len(kwval)):
            x = kwval[i]
            try:
                value = x(value)
                ok = 1
                break
            except XValueError, e:
                msg += str(e)
                if i < len(kwval)-1: msg += '\n'
                pass
            pass
        if not ok:
            self.testValueRaised(msg)
            pass
        return value
    
    def getAllXTypes(self):
        l = []
        for x in self.xtypes:
            l += x.getAllXTypes()
            pass
        return l
    
    def getIdlType(self):
        #
        xtypes = self.xtypes
        if len(xtypes) == 2:
            if isinstance(xtypes[0], XNone):
                if isinstance(xtypes[1], XSalomeReference):
                    return xtypes[1].getIdlType()
                pass
            if isinstance(xtypes[1], XNone):
                if isinstance(xtypes[0], XSalomeReference):
                    return xtypes[0].getIdlType()
                pass
            pass
        #
        return "XDATA_CORBA::XObject"
    
    pass

# --
#

xnone_empty = XNone()
xint_empty = XInt()
xint_min_0 = XInt(min=0)
xint_min_1 = XInt(min=1)
xint_into_0_1 = XInt(into=[0, 1])
xfloat_empty = XFloat()
xstring_empty = XString()
xlist_empty = XList()

xinstance_classes_XType = XInstance(classes=[XType])
xinstance_classes_XAttribute = XInstance(classes=[XAttribute])

xlist_xint_empty = XList(sequence=[xint_empty])
xlist_xstring_empty = XList(sequence=[xstring_empty])
xlist_xinstance_classes_XType = XList(len_min=1, sequence=[xinstance_classes_XType])
xlist_xinstance_classes_XAttribute = XList(sequence=[xinstance_classes_XAttribute])

xmultypes_xnone_empty_xint_empty = XMulTypes(xtypes=[xnone_empty, xint_empty])
xmultypes_xnone_empty_xint_min_0 = XMulTypes(xtypes=[xnone_empty, xint_min_0])
xmultypes_xnone_empty_xint_min_1 = XMulTypes(xtypes=[xnone_empty, xint_min_1])
xmultypes_xnone_empty_xfloat_empty = XMulTypes(xtypes=[xnone_empty, xfloat_empty])
xmultypes_xnone_empty_xinstance_classes_XType = XMulTypes(xtypes=[xnone_empty, xinstance_classes_XType])
xmultypes_xnone_empty_xlist_xint_empty = XMulTypes(xtypes=[xnone_empty, xlist_xint_empty])
xmultypes_xnone_empty_xlist_xstring_empty = XMulTypes(xtypes=[xnone_empty, xlist_xstring_empty])

# --
#

XAttribute.name.fset.xattr.__xtype = XString(len_min=1)
XAttribute.xtype.fset.xattr.__xtype = xmultypes_xnone_empty_xinstance_classes_XType
XAttribute.mode.fset.xattr.__xtype = XMulTypes(xtypes=[xnone_empty, XString(into=["r", "rw"])])

# --
#

XInt.min.fset.xattr.__xtype = xmultypes_xnone_empty_xint_empty
XInt.max.fset.xattr.__xtype = xmultypes_xnone_empty_xint_empty
XInt.into.fset.xattr.__xtype = xmultypes_xnone_empty_xlist_xint_empty
XInt.not_into.fset.xattr.__xtype = xmultypes_xnone_empty_xlist_xint_empty

XFloat.min.fset.xattr.__xtype = xmultypes_xnone_empty_xfloat_empty
XFloat.max.fset.xattr.__xtype = xmultypes_xnone_empty_xfloat_empty
XFloat.open_min.fset.xattr.__xtype = xmultypes_xnone_empty_xfloat_empty
XFloat.open_max.fset.xattr.__xtype = xmultypes_xnone_empty_xfloat_empty

XString.len.fset.xattr.__xtype = xmultypes_xnone_empty_xint_min_0
XString.len_min.fset.xattr.__xtype = xmultypes_xnone_empty_xint_min_0
XString.len_max.fset.xattr.__xtype = xmultypes_xnone_empty_xint_min_0
XString.into.fset.xattr.__xtype = xmultypes_xnone_empty_xlist_xstring_empty
XString.not_into.fset.xattr.__xtype = xmultypes_xnone_empty_xlist_xstring_empty

XFileName.suffix_into.fset.xattr.__xtype = xmultypes_xnone_empty_xlist_xstring_empty

XList_sequence_xtypes  = [ xnone_empty ]
XList_sequence_xtypes += [ xinstance_classes_XType ]
XList_sequence_xtypes += [ xlist_xinstance_classes_XType ]
XList_sequence_xtypes += [ XTuple(len_min=1, sequence=[xinstance_classes_XType]) ]
XList.sequence.fset.xattr.__xtype = XMulTypes(xtypes=XList_sequence_xtypes)
XList.len.fset.xattr.__xtype = xmultypes_xnone_empty_xint_min_0
XList.len_min.fset.xattr.__xtype = xmultypes_xnone_empty_xint_min_0
XList.len_max.fset.xattr.__xtype = xmultypes_xnone_empty_xint_min_0
XList.len_multiple.fset.xattr.__xtype = xmultypes_xnone_empty_xint_min_1
XList.unpack_in_browser.fset.xattr.__xtype = xint_into_0_1

XDict.keys.fset.xattr.__xtype = xmultypes_xnone_empty_xinstance_classes_XType
XDict.values.fset.xattr.__xtype = xmultypes_xnone_empty_xinstance_classes_XType
XDict.unpack_in_browser.fset.xattr.__xtype = xint_into_0_1
XDict.sort_in_browser.fset.xattr.__xtype = xint_into_0_1

XInstance.classes.fset.xattr.__xtype = xlist_empty

XMulTypes.xtypes.fset.xattr.__xtype = xlist_xinstance_classes_XType

# --
#

from xmetaclass import XMetaClass
xtype = xlist_xinstance_classes_XAttribute
for name in ('__init__xattributes__', '__object__xattributes__', ):
    desc = getattr(XMetaClass, name)
    desc.xattr = XAttribute(name, xtype=xtype)
    pass
