# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

class XTree(object):
    
    def __init__(self, parent, node, depth_max, name=None, xattribute=None):
        #
        self.parent = parent
        self.depth_max = depth_max
        self.node = node
        self.name = name
        self.xattribute = xattribute
        #
        depth = 0
        tree = self
        while 1:
            if tree.parent is None:
                root = tree
                break
            depth += 1
            tree = tree.parent
            pass
        self.depth = depth
        self.root = root
        if self.depth == 0:
            self.id2tree = {}
            pass
        #
        self.children = []
        #
        if self.depth > 0:
            full_name = ""
            # names = []
            tree = self
            while 1:
                if tree.parent is None: break
                if isinstance(tree.parent.node, dict):
                    txt = "%s"%(tree.name)
                elif isinstance(tree.parent.node, (list, tuple, )):
                    txt = "%s"%(tree.name)
                else:
                    txt = ".%s"%(tree.name)
                    pass
                full_name = "%s%s"%(txt, full_name)
                # names.insert(0, tree.name)
                tree = tree.parent
                pass
            # Remove the first dot
            self.full_name = full_name[1:]
            pass
        #
        self.reference = 0
        if isinstance(self.node, XTree):
            self.reference = 1
            pass
        #
        return
    
    def addChildren(self, node, name=None, xattribute=None):
        # --
        # Search if node is referenced
        if self.root.id2tree.has_key(id(node)):
            node = self.root.id2tree[id(node)]
            pass
        # --
        # New xtree
        if self.depth == self.depth_max:
            return
        self.children.append(XTree(self, node, self.depth_max, name, xattribute))
        xtree = self.children[-1]
        # --
        # Add a ref. to the main tree.
        # but not for avoided_types
        avoided_types = (type(None), int, float, str)
        if not isinstance(node, avoided_types):
            self.root.id2tree[id(node)] = xtree
            pass
        # --
        # recursion begin
        from xobject import XObject
        if isinstance(node, XObject):
            xclass = node.__class__
            xattrs = xclass.getXAttributesMRO(name_first=1)
            #
            for xattr in xattrs:
                # ENK commented: seems to be obsolete (it doesn't work in SALOME mode)
                #                    try:
                #                        value = getattr(node, "__%s"%(xattr.name))
                #                        xtree.addChildren(value, xattr.name, xattr)
                #                    except:
                #                        pass
                if hasattr(node,xattr.name):
                    try:
                        value = getattr(node, xattr.name)
                        xtree.addChildren(value, xattr.name, xattr)
                    except:
                        pass
                    pass
                pass
            pass
        elif isinstance(node, (tuple, list)):
            for i in range(len(node)):
                value = node[i]
                xtree.addChildren(value, "[%s]"%(i), None)
                pass
            pass
        elif isinstance(node, (dict)):
            if hasattr(xattribute, "sort_in_browser"):
                sort = xattribute.sort_in_browser
            else:
                sort = 1
                pass
            keys = node.keys()
            if sort:
                keys.sort()
                pass
            for key in keys:
                value = node[key]
                from xutilities import value2text
                xtree.addChildren(value, "[%s]"%(value2text(key)), None)
                pass
            pass
        # recursion end
        return
    
    def getPresentation(self):
        txt = ""
        if self.parent:
            prefix = (self.depth-1)*"|   "
            name = self.name
            txt += "%s|-- "%(prefix)
            txt += "%s "%(name)
            if self.reference:
                txt += "* %s\n"%(self.node.full_name)
            else:
                from xutilities import value2text
                txt += "%s %s\n"%(type(self.node).__name__, value2text(self.node))
                pass
            pass
        for xtree in self.children:
            txt += xtree.getPresentation()
            pass
        return txt
    
    def getNeededClasses(self):
        l = []
        for xtree in self.children:
            l += xtree.getNeededClasses()
            pass
        node = self.node
        from xobject import XObject
        if isinstance(node, XObject):
            l.append(node.__class__)
            pass
        return l
    
    def getText(self, special_type=None):
        txt = ""
        #
        if self.depth == 1:
            classes = self.getNeededClasses()
            txt += "\n"
            ccc = []
            for c in classes:
                if c in ccc : continue
                txt += "from %s import %s\n"%(c.__module__, c.__name__)
                ccc.append(c)
                pass
            txt += "\n"
            pass
        #
        if self.depth > 0:
            if special_type:
                if special_type == "dict":
                    txt += "%s:"%(self.name[1:-1])
                    pass
                pass
            else :
                txt += "%s="%(self.name)
                pass
            node = self.node
            from xobject import XObject
            if self.reference:
                txt += "%s"%(self.node.full_name)
            elif isinstance(node, XObject):
                txt += "%s("%(node.__class__.__name__)
            elif isinstance(node, list):
                txt += "["
            elif isinstance(node, tuple):
                txt += "("
            elif isinstance(node, dict):
                txt += "{"
            else:
                from xutilities import value2text
                txt += value2text(node)
                pass
            pass
        #
        for xtree in self.children:
            xattr = xtree.xattribute
            if xattr:
                cls = self.node.__class__
                if xattr not in cls.__init__xattributes__:
                    continue
                pass
            if isinstance(self.node, (list, tuple, )):
                txt += xtree.getText(special_type=1)
            elif isinstance(self.node, (dict, )):
                txt += xtree.getText(special_type="dict")
            else:
                txt += xtree.getText()
                pass
            pass
        #
        if self.depth > 0:
            node = self.node
            from xobject import XObject
            if isinstance(node, XObject):
                txt += ")"
            elif isinstance(node, list):
                txt += "]"
            elif isinstance(node, tuple):
                txt += ")"
            elif isinstance(node, dict):
                txt += "}"
                pass
            pass
        if self.depth == 1:
            txt = txt.replace(",]", "]")
            txt = txt.replace(",)", ")")
            txt += "\n"
            node = self.node
            from xobject import XObject
            if isinstance(node, XObject):
                txt = node.customPythonScript(txt)
                pass
            pass
        if self.depth > 1:
            txt += ","
            pass
        #
        if self.depth == 0:
            txt = txt.replace(",]", "]")
            txt = txt.replace(",)", ")")
            ## ENK commented:
            ## 1. Larger file size after Export python File operation
            ## 2. Resulting text is not recognized correctly by some solvers
##            txt = txt.replace("=", " = ") 
##            txt = txt.replace(",", ", ")
            pass
        #
        return txt
    
    def saveAs(self, fileName):
        txt = self.getText()
        stream = file(fileName, "w")
        stream.write(txt)
        stream.close()
        return
    
    pass

def getMainXTree(depth_max=-1):
    xtree = None
    from xmetaclass import getXObjects
    xobjects = getXObjects()
    # STORE_NAME xobjects
    store_name_xobjects = []
    for xobject in xobjects:
        if hasattr(xobject, '__code__next__operation__'):
            op = getattr(xobject, '__code__next__operation__')
            if op == "STORE_NAME":
                store_name_xobjects.append(xobject)
                pass
            pass
        pass
    #
    xtree = XTree(parent=None, node=None, depth_max=depth_max)
    #
    for xobject in store_name_xobjects:
        xtree.addChildren(xobject, xobject.__instance__name__)
        pass
    return xtree
