
from xobject import XObject
from xmethod import XMethod
from xtypes import XInt

class XSolver(XObject):
    
    __object__xmethods__ = [
        XMethod("run", popup="single"),
        ]
    
    #
    # clt part
    #
    
    def popupActivated(cls, parent, target, selection):
        if target != "run": return
        self = selection[0]
        from xsolvergui import XSolverDialog
        from xmainwindow import getMainWindow
        d = XSolverDialog(getMainWindow(), self)
        return d
    
    popupActivated = classmethod(popupActivated)
    
    def getTimeInterval(self):
        return 500
    
    def getTotalSteps(self):
        print "getTotalSteps must be re-implemented in your XSolver class ..."
        return 0
    
    def getProgress(self):
        print "getProgress must be re-implemented in your XSolver class ..."
        return 0
    
    def stop(self):
        print "stop must be re-implemented in your XSolver class ..."
        return
    
    def quit(self):
        print "quit must be re-implemented in your XSolver class ..."
        return
    
    #
    # srv part
    #
    
    def run(self):
        print "run must be re-implemented in your XSolver class ..."
        return
    
    pass

from xmetaclass import resetXClasses

resetXClasses()
