# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

class XDescriptor(object):
    
    def __init__(self, name, xattr):
        self.name = name
        self.hidden_name = "__%s"%(name)
        self.xattr = xattr
        return
    
    def __set__check__(self, obj, value):
        xattr = self.xattr
        #
        mode = getattr(xattr, '__mode')
        if mode == "r":
            if obj.__xcontext__ is None:
                msg = '%s is a readonly attribute'%(self.name)
                raise XAttributeError(msg)
            pass
        #
        xtype = getattr(xattr, '__xtype')
        value = xtype(value)
        return value
    
    pass

class XMetaClassDescriptor(XDescriptor):
    
    def __get__(self, obj, typ):
        if obj is None: return self
        return getattr(obj, self.hidden_name)
    
    def __set__(self, obj, val):
        
        name = self.name
        
        val = self.__set__check__(obj, val)
        
        # --
        # Deprecated keywords : "__init__xproperties__", "__object__xproperties__"
        
        if name in ["__init__xproperties__", "__object__xproperties__"]:
            new_name = name.replace('xproperties', 'xattributes')
            warning_sep  = '-------------------------------------------------------\n'
            warning_line = 'WARNING WARNING WARNING WARNING WARNING WARNING WARNING\n'
            msg  = warning_sep
            msg += warning_line
            msg += "The use of '%s' is deprecated.\n"%(name)
            msg += "Please, use '%s' instead.\n"%(new_name)
            msg += warning_line
            msg += warning_sep
            print msg
            return setattr(obj, new_name, val)
        
        # --
        #
        
        if name in ["__init__xattributes__", "__object__xattributes__"]:
            
            if name == "__init__xattributes__":
                # --
                # cleaning val
                val_tmp = []
                for v in val:
                    if v in val_tmp: continue
                    val_tmp.append(v)
                    pass
                val = val_tmp
                # --
                # Check that optional attributes follows mandatory attributes
                opt_flag = 0
                for x in val:
                    has_def = x.hasDefaultValue()
                    if not has_def:
                        if opt_flag:
                            from xutilities import value2text
                            msg = "non-default argument %s follows default arguments"%(value2text(x.name))
                            from xexceptions import XAttributeError
                            raise XAttributeError(msg)
                        pass
                    opt_flag = has_def
                    pass
                
                keys = [ getattr(x, '__name') for x in val ]
                
                ixattrs_namefirst = val[:]
                ixattrs_namelast = val[:]
                inames_namefirst = keys[:]
                inames_namelast = keys[:]
                
                if obj.__xnamedobject__:
                    name_xattr = obj.__name__xattribute__
                    ixattrs_namefirst.insert(0, name_xattr)
                    ixattrs_namelast.append(name_xattr)
                    inames_namefirst.insert(0, "name")
                    inames_namelast.append("name")
                    pass
                
                setattr(obj, "__ixattrs__namefirst__", tuple(ixattrs_namefirst))
                setattr(obj, "__ixattrs__namelast__", tuple(ixattrs_namelast))
                setattr(obj, "__inames__namefirst__", tuple(inames_namefirst))
                setattr(obj, "__inames__namelast__", tuple(inames_namelast))
                
                # --
                # Check that names are defined once
                keys = []
                for key in inames_namelast:
                    if key in keys:
                        from xutilities import value2text
                        msg = "duplicate argument %s in %s definition"%(value2text(key), name)
                        from xexceptions import XAttributeError
                        raise XAttributeError(msg)
                    keys.append(key)
                    pass
                
                pass
            
            if name == "__object__xattributes__":
                keys = [ getattr(x, '__name') for x in val ]
                setattr(obj, "__oxattrs__", tuple(val))
                setattr(obj, "__onames__", tuple(keys))
                pass
            
            for x in val:
                # --
                # set the mode attribute if necessary
                mode = getattr(x, '__mode')
                if mode is None:
                    if name == "__init__xattributes__":
                        mode = "rw"
                    else:
                        mode = "r"
                        pass
                    setattr(x, "__mode", mode)
                    pass
                # --
                #
                obj.setXAttribute(x)
                pass
            
            pass
        
        # --
        #
        
        if name == "__xnamedobject__":
            if val:
                x = obj.__name__xattribute__
                obj.setXAttribute(x)
                pass
            pass
        
        # --
        #
        
        if name == "__object__xmethods__":
            for xmeth in val:
                name = getattr(xmeth, "__name")
                if hasattr(obj, name):
                    real_method = getattr(obj, name)
                    setattr(obj, name, real_method)
                    pass
                pass
            pass
        
        # --
        #
        
        return setattr(obj, self.hidden_name, val)
    
    pass
