# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class XFloatTestCase(unittest.TestCase):
    def test(self):
        x = XFloat()
        self.failUnlessRaises(XValueError, x, x)
        self.failUnlessRaises(XValueError, x, "toto")
        self.failUnlessEqual(x(3.2), 3.2)
        self.failUnlessEqual(x("3.2"), 3.2)
        self.failUnlessEqual(x(123), 123)
        self.failUnlessEqual(x("123"), 123)
        self.failUnlessEqual(x("3.2e3"), 3200)
        #
        self.failUnlessEqual(x("3.*2"), 6.0)
        self.failUnlessEqual(x("3./2"), 1.5)
        return
    def test_min_max(self):
        x = XFloat(min=10.0, max=15.3)
        self.failUnlessRaises(XValueError, x, 5)
        self.failUnlessRaises(XValueError, x, 20)
        self.failUnlessEqual(x("10"), 10)
        self.failUnlessEqual(x(10.0), 10)
        return
    def test_openmin_openmax(self):
        x = XFloat(open_min=0.0, open_max=10)
        self.failUnlessRaises(XValueError, x, 10)
        self.failUnlessRaises(XValueError, x, 0)
        self.failUnlessEqual(x("9.0"), 9)
        return
    def test_xtypes(self):
        self.failUnlessRaises(XValueError, XFloat, min="toto")
        self.failUnlessRaises(XValueError, XFloat, max="toto")
        self.failUnlessRaises(XValueError, XFloat, open_min="toto")
        self.failUnlessRaises(XValueError, XFloat, open_max="toto")
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
