# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class PointXYZ(XNamedObject):
    __init__xattributes__ = [
        XAttribute("x", xtype=XFloat()),
        XAttribute("y", xtype=XFloat()),
        XAttribute("z", xtype=XFloat()),
        ]
    pass

class PointTuple(PointXYZ):
    __init__xattributes__ = [
        XAttribute("xyz", xtype=XTuple(len=3, sequence=XFloat())),
        ]
    def __init__(self, *args, **kwargs):
        xyz = self.xyz
        PointXYZ.__init__(self, xyz[0], xyz[1], xyz[2])
        return
    pass

class TestCase(unittest.TestCase):
    def test(self):
        coords = (1.0, 2.0, 3.0, )
        pt = PointTuple(coords)
        self.failUnlessEqual(pt.getX(), 1.0)
        self.failUnlessEqual(pt.getY(), 2.0)
        self.failUnlessEqual(pt.getZ(), 3.0)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
