# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class A(XNamedObject):
    __init__xattributes__ = [
        XAttribute("attributdeA", xtype=XInt(min=0)),
        ]
    pass


class B(A):
    __init__xattributes__ = A.__init__xattributes__ + [
        XAttribute("attributdeB", xtype=XInt(min=0)),
        ] 
    pass

class ABTestCase(unittest.TestCase):
    def testA(self):
        a = A(1)
        self.failUnlessEqual(a.getName(), "a")
        self.failUnlessEqual(a.name, "a")
        self.failUnlessEqual(a.attributdeA, 1)
        return
    def testB(self):
        b = B(1, 2)
        self.failUnlessEqual(b.getName(), "b")
        self.failUnlessEqual(b.name, "b")
        self.failUnlessEqual(b.attributdeA, 1)
        self.failUnlessEqual(b.getAttributdeA(), 1)
        self.failUnlessEqual(b.attributdeB, 2)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
