# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

def toto(val):
    global _val
    _val = val
    return

class A:
    def toto(self, val):
        self.val = val
        return
    pass

class AA(object):
    def toto(self, val):
        self.val = val
        return
    pass

class AAA(XObject):
    def toto(self, val):
        self.val = val
        return
    pass

class FuelRod(XNamedObject):
    
    def __init__(self, *args, **kwargs):
        self.xconnect(self, 'here', self.toto)
        self.xconnect(self, 'f', toto)
        self.a = A()
        self.xconnect(self, 'a', self.a.toto)
        self.aa = AA()
        self.xconnect(self, 'aa', self.aa.toto)
        self.aaa = AAA()
        self.xconnect(self, 'aaa', self.aaa.toto)
        return
    
    def toto(self, val):
        self.val = val
        return
    
    def emit_here(self, val): self.xemit('here', val)
    def emit_f(self, val): self.xemit('f', val)
    def emit_a(self, val): self.xemit("a", val)
    def emit_aa(self, val): self.xemit("aa", val)
    def emit_aaa(self, val): self.xemit("aaa", val)
    
    pass

class TestCase(unittest.TestCase):
    def dump(self, file_name):
        #
        val = 0
        fr = FuelRod()
        val += 1 ; fr.emit_here(val) ; self.failUnlessEqual(fr.val, val)
        val += 1 ; fr.emit_f(val) ; self.failUnlessEqual(_val, val)
        val += 1 ; fr.emit_a(val) ; self.failUnlessEqual(fr.a.val, val)
        val += 1 ; fr.emit_aa(val) ; self.failUnlessEqual(fr.aa.val, val)
        val += 1 ; fr.emit_aaa(val) ; self.failUnlessEqual(fr.aaa.val, val)
        #
        import pickle
        res = pickle.dump(fr,open(file_name, 'w'))
        #
        return
    def load(self, file_name):
        import pickle
        fr = pickle.load(open(file_name))
        val = 100
        val += 1 ; fr.emit_here(val) ; self.failUnlessEqual(fr.val, val)
        val += 1 ; fr.emit_f(val) ; self.failUnlessEqual(_val, val)
        val += 1 ; fr.emit_a(val) ; self.failUnlessEqual(fr.a.val, val)
        val += 1 ; fr.emit_aa(val) ; self.failUnlessEqual(fr.aa.val, val)
        val += 1 ; fr.emit_aaa(val) ; self.failUnlessEqual(fr.aaa.val, val)
        return
    def test(self):
        file_name = './toto.dump'
        self.dump(file_name)
        self.load(file_name)
        import os
        os.remove(file_name)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
