//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  SALOME VTKViewer : build VTK viewer into Salome desktop
//  File   : 
//  Author : 
//  Module : SALOME
//  $Header$
//
#include "VVTK_ViewWindow.h"
#include "VVTK_ViewModel.h"
#include "VVTK_MainWindow.h"
#include "SVTK_View.h"

#include "SUIT_Session.h"

#include "VVTK_Renderer.h"
#include "SVTK_Selector.h"
#include "SVTK_InteractorStyle.h"
#include "SVTK_RenderWindowInteractor.h"
#include "SVTK_GenericRenderWindowInteractor.h"

#include <vtkRenderWindow.h>

#include <QLayout>
#include <QList>
#include <QSplitter>
#include <QToolBar>

//----------------------------------------------------------------------------
VVTK_ViewWindow
::VVTK_ViewWindow(SUIT_Desktop* theDesktop):
  SVTK_ViewWindow(theDesktop),
  myMainWindow1(NULL),
  myMainWindow2(NULL),
  myView2(NULL),
  myDumpImage(QImage())
{}

//----------------------------------------------------------------------------
void VVTK_ViewWindow::Initialize(SVTK_ViewModelBase* theModel)
{
  if(SUIT_ResourceMgr* aResourceMgr = SUIT_Session::session()->resourceMgr()){

    QSplitter* s = new QSplitter( Qt::Vertical, this );
    setCentralWidget( s );

    VISU_WidgetCtrl* aWidgetCtrl = NULL;
    VISU_InsideCursorSettings* anInsideCursorSettings = NULL;
    VISU_OutsideCursorSettings* anOutsideCursorSettings = NULL;
    VISU_PickingSettings* aPickingSettings = NULL;
    SVTK_Selector* aSelector = SVTK_Selector::New();
    {
      myMainWindow1 = new VVTK_MainWindow1(s,
					   "VVTK_MainWindow",
					   aResourceMgr,
					   this);

      anInsideCursorSettings = myMainWindow1->GetInsideCursorSettings();
      anOutsideCursorSettings = myMainWindow1->GetOutsideCursorSettings();
      aPickingSettings = myMainWindow1->GetPickingSettings();

      SVTK_RenderWindowInteractor* anIteractor = 
	new SVTK_RenderWindowInteractor(myMainWindow1,"SVTK_RenderWindowInteractor1");
      
      SVTK_GenericRenderWindowInteractor* aDevice = 
	SVTK_GenericRenderWindowInteractor::New();
      aDevice->SetRenderWidget(anIteractor);
      aDevice->SetSelector(aSelector);
    
      VVTK_Renderer1* aRenderer = VVTK_Renderer1::New();
      aRenderer->Initialize(aDevice,aSelector);

      aWidgetCtrl = aRenderer->GetWidgetCtrl();

      aRenderer->SetInsideCursorSettings(anInsideCursorSettings);
      aRenderer->SetOutsideCursorSettings(anOutsideCursorSettings);
      aRenderer->SetPickingSettings(aPickingSettings);

      anIteractor->Initialize(aDevice,aRenderer,aSelector);

      SVTK_InteractorStyle* aStyle = SVTK_InteractorStyle::New();
      anIteractor->PushInteractorStyle(aStyle);
      aStyle->Delete();

      aDevice->Delete();
      aRenderer->Delete();

      myMainWindow1->Initialize(anIteractor,aRenderer);

      myView1 = new SVTK_View(myMainWindow1);
      SVTK_ViewWindow::Initialize(myView1,theModel);

      anIteractor->getRenderWindow()->Render();
      myMainWindow1->onResetView();
    }
    {
      myMainWindow2 = myMainWindow1->CreateMainWindow2(s,
						       "VVTK_SegmantationWindow",
						       aResourceMgr,
						       this);
      SVTK_RenderWindowInteractor* anIteractor = 
	new SVTK_RenderWindowInteractor(myMainWindow2,"SVTK_RenderWindowInteractor1");
      
      SVTK_GenericRenderWindowInteractor* aDevice = 
	SVTK_GenericRenderWindowInteractor::New();
      aDevice->SetRenderWidget(anIteractor);
      aDevice->SetSelector(aSelector);
    
      VVTK_Renderer2* aRenderer = VVTK_Renderer2::New();
      aRenderer->Initialize(aDevice,aSelector);
      
      aRenderer->SetWidgetCtrl(aWidgetCtrl);
      
      aRenderer->SetInsideCursorSettings(anInsideCursorSettings);
      aRenderer->SetPickingSettings(aPickingSettings);
      
      anIteractor->Initialize(aDevice,aRenderer,aSelector);

      SVTK_InteractorStyle* aStyle = SVTK_InteractorStyle::New();
      anIteractor->PushInteractorStyle(aStyle);
      aStyle->Delete();

      aDevice->Delete();
      aRenderer->Delete();

      myMainWindow2->Initialize(anIteractor);
      
      myView2 = new SVTK_View(myMainWindow2);
      SVTK_ViewWindow::Initialize(myView2,theModel);

      anIteractor->getRenderWindow()->Render();
      myMainWindow2->onResetView();
    }
    aSelector->Delete();

    int h = height() / 2;
    QList<int> aSizes;
    aSizes.append( h );
    aSizes.append( h );
    s->setSizes( aSizes );
    myMainWindow2->hide();

    myMainWindow = myMainWindow1;
    myView = myView1;
  }
}

//----------------------------------------------------------------------------
VVTK_ViewWindow
::~VVTK_ViewWindow()
{}


//----------------------------------------------------------------------------
VVTK_MainWindow1* 
VVTK_ViewWindow
::getMainWindow1()
{
  return myMainWindow1;
}

VVTK_MainWindow2* 
VVTK_ViewWindow
::getMainWindow2()
{
  return myMainWindow2;
}


//----------------------------------------------------------------------------
void
VVTK_ViewWindow
::AddActor(VTKViewer_Actor* theActor, 
	   bool theIsUpdate)
{
  myMainWindow1->AddActor(theActor,theIsUpdate);
  myMainWindow2->AddActor(theActor,theIsUpdate);
}

//----------------------------------------------------------------------------
void
VVTK_ViewWindow
::RemoveActor(VTKViewer_Actor* theActor, 
	      bool theIsUpdate)
{
  myMainWindow1->RemoveActor(theActor,theIsUpdate);
  myMainWindow2->RemoveActor(theActor,theIsUpdate);
}

//----------------------------------------------------------------------------
void
VVTK_ViewWindow
::Repaint(bool theUpdateTrihedron)
{
  myMainWindow1->Repaint(theUpdateTrihedron);
  myMainWindow2->Repaint(theUpdateTrihedron);
}

//----------------------------------------------------------------
void 
VVTK_ViewWindow
::unHighlightAll() 
{
  myView1->unHighlightAll();
  myView2->unHighlightAll();
}

//----------------------------------------------------------------
void
VVTK_ViewWindow
::highlight(const Handle(SALOME_InteractiveObject)& theIO, 
	    bool theIsHighlight, 
	    bool theIsUpdate ) 
{
  if(GetSelector()->AddIObject(theIO))
    GetSelector()->EndPickCallback();
  myView1->highlight( theIO, theIsHighlight, theIsUpdate );
  myView2->highlight( theIO, theIsHighlight, theIsUpdate );
}

//----------------------------------------------------------------
void
VVTK_ViewWindow
::onSelectionChanged()
{
  myView1->onSelectionChanged();
  myView2->onSelectionChanged();
}

//----------------------------------------------------------------------------
void
VVTK_ViewWindow
::onResetView()
{
  myMainWindow1->onResetView();
  myMainWindow2->onResetView();
}

//----------------------------------------------------------------------------
void
VVTK_ViewWindow
::onFitAll()
{
  myMainWindow1->onFitAll();
  myMainWindow2->onFitAll();
}

//----------------------------------------------------------------------------
bool 
VVTK_ViewWindow
::action( const int accelAction  )
{
  if ( myMainWindow1->hasFocus() )
    myMainWindow1->action( accelAction );
  else if ( myMainWindow2->hasFocus() )
    myMainWindow2->action( accelAction );
  else
    return false;
  return true;
}

//----------------------------------------------------------------------------
QImage
VVTK_ViewWindow
::dumpView()
{
  if( myMainWindow1->GetInteractor()->hasFocus() )
    {
      if ( myMainWindow1->getToolBar()->testAttribute(Qt::WA_UnderMouse) || myDumpImage.isNull() )
	return myMainWindow1->dumpView();
      else
	return myDumpImage;
    }
  
  if( myMainWindow2->GetInteractor()->hasFocus() )
    {
      if ( myMainWindow1->getToolBar()->testAttribute(Qt::WA_UnderMouse) || myDumpImage.isNull() )
	return myMainWindow2->dumpView();
      else
	return myDumpImage;
    }

  return QImage();
}

//----------------------------------------------------------------------------
void
VVTK_ViewWindow
::setBackgroundColor( const QColor& theColor )
{
  myMainWindow1->SetBackgroundColor( theColor );
  myMainWindow2->SetBackgroundColor( theColor );
}


//----------------------------------------------------------------------------
void
VVTK_ViewWindow
::RefreshDumpImage()
{ 
  if( myMainWindow1->GetInteractor()->hasFocus() )
    myDumpImage = myMainWindow1->dumpView();
  else if ( myMainWindow2->GetInteractor()->hasFocus() )
    myDumpImage = myMainWindow2->dumpView();
}
