//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  VISU VISUGUI : GUI of VISU component
//  File   : VVTK_SizeBox.cxx
//  Author : Oleg UVAROV
//  Module : VISU
//
#include "VVTK_SizeBox.h"

#include "SUIT_ResourceMgr.h"
#include "SUIT_Session.h"

#include <QtxDoubleSpinBox.h>
#include <QtxIntSpinBox.h>
#include <QtxColorButton.h>

#include <QLayout>
#include <QLabel>
#include <QLineEdit>
#include <QCheckBox>
#include <QGroupBox>
#include <QButtonGroup>
#include <QRadioButton>
#include <QPushButton>
#include <QColorDialog>

using namespace std;

VVTK_SizeBox::VVTK_SizeBox( QWidget* parent ) :
  QWidget( parent )
{
  QVBoxLayout* aMainLayout = new QVBoxLayout( this );
  aMainLayout->setSpacing( 0 );
  aMainLayout->setMargin( 0 );

  // Size
  QGroupBox* SizeGroup = new QGroupBox ( tr( "SIZE_TITLE" ), this );
  //SizeGroup->setColumnLayout(0, Qt::Vertical );
  //SizeGroup->layout()->setSpacing( 0 );
  //SizeGroup->layout()->setMargin( 0 );

  QGridLayout* SizeGroupLayout = new QGridLayout (SizeGroup);
  SizeGroupLayout->setAlignment(Qt::AlignTop | Qt::AlignCenter);
  SizeGroupLayout->setSpacing(6);
  SizeGroupLayout->setMargin(11);

  // Outside Size
  myOutsideSizeLabel = new QLabel( tr( "OUTSIDE_SIZE" ), SizeGroup );
  myOutsideSizeSpinBox = new QtxIntSpinBox( 0, 100, 1, SizeGroup );
  myOutsideSizeSpinBox->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed ) );

  SizeGroupLayout->addWidget( myOutsideSizeLabel, 0, 0 );
  SizeGroupLayout->addWidget( myOutsideSizeSpinBox, 0, 1 );

  // Geometry Size
  myGeomSizeLabel = new QLabel( tr( "GEOM_SIZE" ), SizeGroup );
  myGeomSizeSpinBox = new QtxIntSpinBox( 0, 100, 1, SizeGroup );
  myGeomSizeSpinBox->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed ) );

  SizeGroupLayout->addWidget( myGeomSizeLabel, 0, 0 );
  SizeGroupLayout->addWidget( myGeomSizeSpinBox, 0, 1 );

  // Min Size
  myMinSizeLabel = new QLabel( tr( "MIN_SIZE" ), SizeGroup );
  myMinSizeSpinBox = new QtxIntSpinBox( 0, 100, 1, SizeGroup );
  myMinSizeSpinBox->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed ) );

  SizeGroupLayout->addWidget( myMinSizeLabel, 1, 0 );
  SizeGroupLayout->addWidget( myMinSizeSpinBox, 1, 1 );

  // Max Size
  myMaxSizeLabel = new QLabel( tr( "MAX_SIZE" ), SizeGroup );
  myMaxSizeSpinBox = new QtxIntSpinBox( 0, 100, 1, SizeGroup );
  myMaxSizeSpinBox->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed ) );

  SizeGroupLayout->addWidget( myMaxSizeLabel, 1, 2 );
  SizeGroupLayout->addWidget( myMaxSizeSpinBox, 1, 3 );

  // Magnification
  myMagnificationLabel = new QLabel( tr( "MAGNIFICATION" ), SizeGroup );
  myMagnificationSpinBox = new QtxIntSpinBox( 1, 10000, 10, SizeGroup );
  myMagnificationSpinBox->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed ) );

  SizeGroupLayout->addWidget( myMagnificationLabel, 2, 0 );
  SizeGroupLayout->addWidget( myMagnificationSpinBox, 2, 1 );

  // Increment
  myIncrementLabel = new QLabel( tr( "INCREMENT" ), SizeGroup );
  myIncrementSpinBox = new QtxDoubleSpinBox( 0.01, 10, 0.1, SizeGroup );
  myIncrementSpinBox->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed ) );

  SizeGroupLayout->addWidget( myIncrementLabel, 2, 2 );
  SizeGroupLayout->addWidget( myIncrementSpinBox, 2, 3 );

  aMainLayout->addWidget( SizeGroup );

  // Color
  myColorGroup = new QGroupBox ( tr( "COLOR_TITLE" ), this );
  //myColorGroup->setColumnLayout(0, Qt::Vertical );
  //myColorGroup->layout()->setSpacing( 0 );
  //myColorGroup->layout()->setMargin( 0 );

  QGridLayout* ColorGroupLayout = new QGridLayout ( myColorGroup );
  ColorGroupLayout->setAlignment(Qt::AlignTop | Qt::AlignLeft);
  ColorGroupLayout->setSpacing(6);
  ColorGroupLayout->setMargin(11);

  myUniformCheckBox = new QCheckBox( tr( "UNIFORM_COLOR" ), myColorGroup );

  myColorLabel = new QLabel( tr( "COLOR" ), myColorGroup );
  myColorButton = new QtxColorButton( myColorGroup );

  ColorGroupLayout->addWidget( myUniformCheckBox, 0, 0 );
  ColorGroupLayout->addWidget( myColorLabel, 0, 1 );
  ColorGroupLayout->addWidget( myColorButton, 0, 2 );

  aMainLayout->addWidget( myColorGroup );

  connect( myUniformCheckBox, SIGNAL( toggled( bool ) ), myColorButton, SLOT( setEnabled( bool ) ) );
  //connect( myColorButton, SIGNAL( clicked() ), this, SLOT( onColorButtonPressed() ) );

  setType( VVTK_SizeBox::Results );
}

void VVTK_SizeBox::onToggleResults()
{
  myType = VVTK_SizeBox::Results;

  myOutsideSizeLabel->hide();
  myOutsideSizeSpinBox->hide();

  myGeomSizeLabel->hide();
  myGeomSizeSpinBox->hide();

  myMinSizeLabel->show();
  myMinSizeSpinBox->show();

  myMaxSizeLabel->show();
  myMaxSizeSpinBox->show();

  myMagnificationLabel->show();
  myMagnificationSpinBox->show();

  myIncrementLabel->show();
  myIncrementSpinBox->show();

  myColorGroup->hide();

  myUniformCheckBox->hide();
}

void VVTK_SizeBox::onToggleGeometry()
{
  myType = VVTK_SizeBox::Geometry;

  myOutsideSizeLabel->hide();
  myOutsideSizeSpinBox->hide();

  myGeomSizeLabel->show();
  myGeomSizeSpinBox->show();

  myMinSizeLabel->hide();
  myMinSizeSpinBox->hide();

  myMaxSizeLabel->hide();
  myMaxSizeSpinBox->hide();

  myMagnificationLabel->show();
  myMagnificationSpinBox->show();

  myIncrementLabel->show();
  myIncrementSpinBox->show();

  myColorGroup->show();

  myUniformCheckBox->hide();
}

void VVTK_SizeBox::onToggleInside()
{
  myType = VVTK_SizeBox::Inside;

  myOutsideSizeLabel->hide();
  myOutsideSizeSpinBox->hide();

  myGeomSizeLabel->hide();
  myGeomSizeSpinBox->hide();

  myMinSizeLabel->show();
  myMinSizeSpinBox->show();

  myMaxSizeLabel->show();
  myMaxSizeSpinBox->show();

  myMagnificationLabel->hide();
  myMagnificationSpinBox->hide();

  myIncrementLabel->hide();
  myIncrementSpinBox->hide();

  myColorGroup->hide();

  myUniformCheckBox->hide();
}

void VVTK_SizeBox::onToggleOutside()
{
  myType = VVTK_SizeBox::Outside;

  myOutsideSizeLabel->show();
  myOutsideSizeSpinBox->show();

  myGeomSizeLabel->hide();
  myGeomSizeSpinBox->hide();

  myMinSizeLabel->hide();
  myMinSizeSpinBox->hide();

  myMaxSizeLabel->hide();
  myMaxSizeSpinBox->hide();

  myMagnificationLabel->hide();
  myMagnificationSpinBox->hide();

  myIncrementLabel->hide();
  myIncrementSpinBox->hide();

  myColorGroup->show();

  myUniformCheckBox->show();
}

void VVTK_SizeBox::setType( int theType )
{
  myType = theType;

  switch( myType )
  {
    case VVTK_SizeBox::Results  : onToggleResults(); break;
    case VVTK_SizeBox::Geometry : onToggleGeometry(); break;
    case VVTK_SizeBox::Inside   : onToggleInside();  break;
    case VVTK_SizeBox::Outside  : onToggleOutside();  break;
    default : break;
  }
}

float VVTK_SizeBox::getOutsideSize() const
{
  return myOutsideSizeSpinBox->value() / 100.0;
}

void VVTK_SizeBox::setOutsideSize( float theOutsideSize )
{
  myOutsideSizeSpinBox->setValue( ( int )( theOutsideSize * 100 ) );
}

float VVTK_SizeBox::getGeomSize() const
{
  return myGeomSizeSpinBox->value() / 100.0;
}

void VVTK_SizeBox::setGeomSize( float theGeomSize )
{
  myGeomSizeSpinBox->setValue( ( int )( theGeomSize * 100 ) );
}

float VVTK_SizeBox::getMinSize() const
{
  return myMinSizeSpinBox->value() / 100.0;
}

void VVTK_SizeBox::setMinSize( float theMinSize )
{
  myMinSizeSpinBox->setValue( ( int )( theMinSize * 100 ) );
}

float VVTK_SizeBox::getMaxSize() const
{
  return myMaxSizeSpinBox->value() / 100.0;
}

void VVTK_SizeBox::setMaxSize( float theMaxSize )
{
  myMaxSizeSpinBox->setValue( ( int )( theMaxSize * 100 ) );
}

float VVTK_SizeBox::getMagnification() const
{
  return myMagnificationSpinBox->value() / 100.0;
}

void VVTK_SizeBox::setMagnification( float theMagnification )
{
  myMagnificationSpinBox->setValue( ( int )( theMagnification * 100 ) );
}

float VVTK_SizeBox::getIncrement() const
{
  return myIncrementSpinBox->value();
}

void VVTK_SizeBox::setIncrement( float theIncrement )
{
  myIncrementSpinBox->setValue( theIncrement );
}

bool VVTK_SizeBox::getUniform() const
{
  return myUniformCheckBox->isChecked();
}

void VVTK_SizeBox::setUniform( bool theUniform )
{
  myUniformCheckBox->setChecked( theUniform );
  myColorButton->setEnabled( theUniform );
}

QColor VVTK_SizeBox::getColor() const
{
  return myColorButton->color();//palette().color( myColorButton->backgroundRole() );
  //return myColorButton->paletteBackgroundColor();
}

void VVTK_SizeBox::setColor( const QColor& theColor )
{
  if ( theColor.isValid() )
  {
    //QPalette aPalette( myColorButton->palette() );
    //aPalette.setColor( myColorButton->backgroundRole(), theColor );
    myColorButton->setColor( theColor );
  }
  //myColorButton->setPaletteBackgroundColor( theColor );
}

void VVTK_SizeBox::enableSizeControls( bool enabled )
{
  myMagnificationSpinBox->setEnabled( enabled );
  myMaxSizeSpinBox->setEnabled( enabled );
  myMinSizeSpinBox->setEnabled( enabled );
  myIncrementSpinBox->setEnabled( enabled );
  myGeomSizeSpinBox->setEnabled( enabled );
}

/*void VVTK_SizeBox::onColorButtonPressed()
{
  QPalette aPalette( myColorButton->palette() );
  QColor aColor = QColorDialog::
    getColor( aPalette.color(myColorButton->backgroundRole() ), this );

  if( aColor.isValid() )
  {
      aPalette.setColor( myColorButton->backgroundRole(), aColor );
      myColorButton->setPalette( aPalette );
  }
}*/
