#  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
#
#  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
#  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com

#  Author : Roman NIKOLAEV Open CASCADE S.A.S. (roman.nikolaev@opencascade.com)
#  Date   : 13/04/2009

import traceback
from SalomePyQt import *
import PYLIGHT_DataModel
from PyQt4.QtGui import *
from PyQt4.QtCore import *
import libSALOME_Swig

import os
import libSalomePy
import vtk

# Get SALOME PyQt interface
sgPyQt=SalomePyQt()
# Get SALOME Swig interface
sg = libSALOME_Swig.SALOMEGUI_Swig()

# Create DataModel
DM = PYLIGHT_DataModel.PYLIGHT_DataModel()

# Create actions and menus
def initialize():
    
    print "PYLIGHTGUI::initialize()"
    # Load File action
    sgPyQt.createAction(dict_actions["loadfile"], "Load text File", "Load text file")
    # Save File action
    sgPyQt.createAction(dict_actions["savefile"], "Save text File", "Save text file")
    # Insert Line action
    sgPyQt.createAction(dict_actions["insertLine"], "Insert Line", "Insert new text line")
    # Separator
    separator = sgPyQt.createSeparator()
    # Get Menu 'File'
    menuFile = sgPyQt.createMenu( "File", -1, -1 )
    # Add actions in the menu 'File'
    sgPyQt.createMenu( separator ,menuFile, -1, 10)
    sgPyQt.createMenu( dict_actions["loadfile"],  menuFile, 10 );
    sgPyQt.createMenu( dict_actions["savefile"],  menuFile, 10 );
    sgPyQt.createMenu( separator ,menuFile, -1, 10)
    
    # Insert new line action
    sgPyQt.createAction(dict_actions["insertLine"], "Insert Line", "Insert new line")
    # Edit selected line action
    sgPyQt.createAction(dict_actions["editLine"], "Edit Line", "Edit selected line")
    # Remove selected line action
    sgPyQt.createAction(dict_actions["removeLine"], "Remove Lines", "Remove selected lines")
    # Clear all paragraphs
    sgPyQt.createAction(dict_actions["clearAll"], "Clear All", "Clear all paragraphs")
    # Display line
    sgPyQt.createAction(dict_actions["displayLine"], "Display Line", "Display selected line")
    # Erase line
    sgPyQt.createAction(dict_actions["eraseLine"], "Erase Line", "Erase selected line")
    
    # Create 'PyLight' menu 
    menuPyLight = sgPyQt.createMenu( "PyLight",-1,-1,50)
    # Add actions in the menu 'PyLight'
    sgPyQt.createMenu( dict_actions["insertLine"],  menuPyLight, 10 );
    sgPyQt.createMenu( dict_actions["editLine"],  menuPyLight, 10 );
    sgPyQt.createMenu( dict_actions["removeLine"],  menuPyLight, 10 );
    sgPyQt.createMenu( separator, menuPyLight, -1, 10);
    sgPyQt.createMenu( dict_actions["clearAll"],  menuPyLight, 10 );
    sgPyQt.createMenu( separator, menuPyLight, -1, 10);
    sgPyQt.createMenu( dict_actions["displayLine"],  menuPyLight, 10 );
    sgPyQt.createMenu( dict_actions["eraseLine"],  menuPyLight, 10 );
    
    return


# Process GUI action
def OnGUIEvent(commandID):
    print "PYLIGHTGUI::OnGUIEvent : commandID =",commandID
    if dict_command.has_key( commandID ):
        try:
            dict_command[commandID]()
        except:
            traceback.print_exc()
    else:
       print "The command is not implemented: ",commandID
    pass

# Customize popup menu
def createPopupMenu(popup, context):


    
    if context != 'ObjectBrowser':
        return
    
    selcount = sg.SelectedCount()
    if selcount == 1:
        entry = sg.getSelected( 0 )
        obj = DM.getObject(entry)
        if obj is not None:
            if obj.getText() != "\n":
                #Line is selected
                popup.addAction(sgPyQt.action(dict_actions["editLine"]))
                popup.addAction(sgPyQt.action(dict_actions["removeLine"]))
                popup.addSeparator()
                popup.addAction(sgPyQt.action(dict_actions["displayLine"]))
                popup.addAction(sgPyQt.action(dict_actions["displayLine"]))
                popup.addAction(sgPyQt.action(dict_actions["eraseLine"]))

                                                
            else:
                #Paragraph is selected
                popup.addAction(sgPyQt.action(dict_actions["insertLine"]))
                popup.addAction(sgPyQt.action(dict_actions["clearParagraph"]))
        else:
            onlyLines = True            
    pass

# For saving data in the study
def saveFiles(prefix):
    print "PYLIGHTGUI::saveFile()"
    postfix = "PYLIGHT.txt"
    filename = prefix+postfix
    DM.saveFile(QString(filename))
    return postfix

# For restore data from the study
def openFiles(filelist):
    print "PYLIGHTGUI::openFile()"
    filename =  filelist[0]
    filename.append(filelist[1])
    DM.loadFile(filename)
    return True

# Loading a text file
def loadfile():
    aFilter = "Text files (*.txt)"
    filename = QFileDialog.getOpenFileName(sgPyQt.getDesktop(), "Open text file", "", aFilter, "Choose a text file to open")
    if filename.isEmpty():
        return
    
    if os.access(str(filename),os.R_OK):
        DM.loadFile(filename)
    else:
        QMessageBox.warning(sgPyQt.getDesktop(),
                            "Error!",
                            QString("Can not read file:\n%1").arg(filename))
        pass
    sg.updateObjBrowser(True)
    pass

# Saving a text file
def savefile():
    aFilter = "Text files (*.txt)"
    filename = QFileDialog.getSaveFileName(sgPyQt.getDesktop(),"Save text file", "", aFilter, "Choose a text file to save")
    if filename.contains(".txt") == 0:
        filename.append(".txt")
        pass
    fn = filename
    print filename
    # Get directory name and check access
    if os.access(str(fn.left(fn.lastIndexOf("/"))), os.W_OK):
        DM.saveFile(filename)
    else:
        QMessageBox.warning(sgPyQt.getDesktop(),
                            "Error!",
                            QString("Can not save file:\n%1").arg(filename))
        pass
    pass

def insertLine():
    '''
    Insert new line in the selected paragraph.
    '''
    #Get result
    res = QInputDialog.getText(sgPyQt.getDesktop(),
                               "Add new line",
                               "Enter the text",
                               QLineEdit.Normal)
    if not res[1]: ### user click cancel button
        return
    
    text = res[0]
    # Nb selected objects
    selcount = sg.SelectedCount()
    # Nb object in the Data Model
    paragrCount = len(DM.getParagraphs())

    # Create first paragraph
    if paragrCount == 0:
        DM.createObject()
        # If line not empty create first line
        if text != "\n":
            DM.createObject(text,DM.getParagraphs()[0])
        sg.updateObjBrowser(True)
        return
    # Create paragraph
    if text == "\n":
        DM.createObject()
        sg.updateObjBrowser(True)
        return
    else:
        if selcount == 0:
            QMessageBox.warning(sgPyQt.getDesktop(),
                                'Error!',
                                'Please, select paragraph!')
            return
        if selcount == 1:
            entry = sg.getSelected( 0 )
            obj = DM.getObject(entry)
            if obj is not None:
                # Create line
                if(obj.getText() == "\n"):
                    DM.createObject(text,entry)
                    sg.updateObjBrowser(True);
                    return
                else:
                    QMessageBox.warning(sgPyQt.getDesktop(),
                                        'Error!',
                                        'Please, select paragraph!')
            elif selcount > 1:
                QMessageBox.warning(sgPyQt.getDesktop(),
                                    'Error!',
                                    'Please, select only one paragraph!')
    pass
        
        
# Edit selected line
def editLine():
    if sg.SelectedCount() == 1:
        entry = sg.getSelected( 0 )
        obj = DM.getObject(entry)
        if(obj.getText() != "\n"):
            #Get text line
            res = QInputDialog.getText(sgPyQt.getDesktop(),
                                       "Edit line",
                                       "Enter the text",
                                       QLineEdit.Normal,
                                       PYLIGHT_DataModel.processText(obj.getText()))
            if not res[1]: ### user click cancel button
                return
            text = res[0]
            
            obj.setText(text)
        else:
            QMessageBox.information(sgPyQt.getDesktop(),
                                    'Info',
                                    'Please, select line!') 
    else:
        QMessageBox.information(sgPyQt.getDesktop(),
                                'Info',
                                'Please, select one line!')
    sg.updateObjBrowser(True);
    pass

# Remove selected lines
def removeLine():
    selcount = sg.SelectedCount()
    onlyLines = True
    lines = []
    while selcount != 0:
        entry = sg.getSelected( selcount - 1)
        #Check what only lines selected
        if DM.getObject(entry).getText() == "\n":
            onlyLines = False
            break
        lines.append(entry)
        selcount = selcount-1
        pass
    if not onlyLines:
        return
    else:
        renderer=libSalomePy.getRenderer()
        for ln in lines:
            actor = getActor(ln)
            if actor is not None:
                renderer.RemoveActor(actor)
                pass
            pass
        DM.removeObjects(lines)
        sg.updateObjBrowser(True)
        pass
    pass

# Remove all lines from all paragraphs
def clearAll():
    paragraphs = DM.getParagraphs()
    for paragr in paragraphs:
        lines = sgPyQt.getChildren(paragr)
        DM.removeObjects(lines)
        renderer=libSalomePy.getRenderer()
        for l in lines:
            actor = getActor(l)
            if actor is not None:
                renderer.RemoveActor(actor)
                pass
            pass
    sg.updateObjBrowser(True)
    pass

# Display the selected line
def displayLine():
    if sg.SelectedCount() != 1:
        return
    entry = sg.getSelected(0)
    text = DM.getObject(entry).getText()
    if text == "\n":
        return
    renderer=libSalomePy.getRenderer()
    actor = getActor(entry)
    if actor is None:
        actor = vtk.vtkTextActor()
        dict_actors[entry] = actor
        pass
    center = renderer.GetCenter()
    actor.SetInput(str(text))
    actor.SetPosition(center[0],center[1])
    txtPr = vtk.vtkTextProperty()
    txtPr.SetFontSize(30)
    actor.SetTextProperty(txtPr)
    for act in  dict_actors.values():
        renderer.RemoveActor(act)
    renderer.AddActor(actor)
    pass

# Clear remove all lines under selected paragraph
def clearParagraph():
    lines = sgPyQt.getChildren(sg.getSelected(0))
    DM.removeObjects(lines)
    sg.updateObjBrowser(True)
    pass

# Erase the selected line
def eraseLine():
    if sg.SelectedCount() != 1:
        return
    entry = sg.getSelected(0)
    text = DM.getObject(entry).getText()
    if text == "\n":
        return
    renderer=libSalomePy.getRenderer()
    actor = getActor(entry)
    if actor is not None:
        renderer.RemoveActor(actor)
        pass
    pass

# Return vtkActor by entry
def getActor(entry):
    if isinstance(entry,QString):
        entry = entry.toLatin1().data()
    if dict_actors.has_key(entry):
        return dict_actors[entry]
    return None

# Define commands
dict_command = {
    951 : loadfile,
    952 : savefile,
    961 : insertLine,
    962 : editLine,
    963 : removeLine,
    964 : clearAll,
    971 : displayLine,
    972 : eraseLine,
    973 : clearParagraph,
    }

# Define actions
dict_actions = {
    "loadfile"   :    951,
    "savefile"   :    952,
    "insertLine" :    961,
    "editLine"   :    962,
    "removeLine" :    963,
    "clearAll"   :    964,
    "displayLine":    971,
    "eraseLine"  :    972,
    "clearParagraph": 973,
    }

# Define Actors
dict_actors = {}
