/* rygel-user-config.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-user-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <config.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_USER_CONFIG (rygel_user_config_get_type ())
#define RYGEL_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfig))
#define RYGEL_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))
#define RYGEL_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))

typedef struct _RygelUserConfig RygelUserConfig;
typedef struct _RygelUserConfigClass RygelUserConfigClass;
typedef struct _RygelUserConfigPrivate RygelUserConfigPrivate;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelUserConfig {
	GObject parent_instance;
	RygelUserConfigPrivate * priv;
	GKeyFile* key_file;
	GKeyFile* sys_key_file;
};

struct _RygelUserConfigClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()

static gpointer rygel_user_config_parent_class = NULL;
static RygelUserConfig* rygel_user_config_config;
static RygelUserConfig* rygel_user_config_config = NULL;
static RygelConfigurationIface* rygel_user_config_rygel_configuration_parent_iface = NULL;

GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_user_config_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_USER_CONFIG_DUMMY_PROPERTY
};
#define RYGEL_USER_CONFIG_CONFIG_FILE "rygel.conf"
#define RYGEL_USER_CONFIG_IFACE_KEY "interface"
#define RYGEL_USER_CONFIG_PORT_KEY "port"
#define RYGEL_USER_CONFIG_ENABLED_KEY "enabled"
#define RYGEL_USER_CONFIG_UPNP_ENABLED_KEY "upnp-" RYGEL_USER_CONFIG_ENABLED_KEY
#define RYGEL_USER_CONFIG_TITLE_KEY "title"
#define RYGEL_USER_CONFIG_TRANSCODING_KEY "enable-transcoding"
#define RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY "enable-mp3-transcoder"
#define RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY "enable-mp2ts-transcoder"
#define RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY "enable-lpcm-transcoder"
#define RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY "enable-wmv-transcoder"
#define RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY "allow-upload"
#define RYGEL_USER_CONFIG_ALLOW_DELETION_KEY "allow-deletion"
#define RYGEL_USER_CONFIG_LOG_LEVELS_KEY "log-level"
#define RYGEL_USER_CONFIG_PLUGIN_PATH_KEY "plugin-path"
#define RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY "upload-folder"
#define RYGEL_USER_CONFIG_VIDEO_UPLOAD_DIR_PATH_KEY "video-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
#define RYGEL_USER_CONFIG_MUSIC_UPLOAD_DIR_PATH_KEY "music-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
#define RYGEL_USER_CONFIG_PICTURE_UPLOAD_DIR_PATH_KEY "picture-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
static gboolean rygel_user_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_bool (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static gchar* rygel_user_config_real_get_interface (RygelConfiguration* base, GError** error);
gchar* rygel_configuration_get_string (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static gint rygel_user_config_real_get_port (RygelConfiguration* base, GError** error);
gint rygel_configuration_get_int (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_allow_upload (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_allow_deletion (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_log_levels (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_plugin_path (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_video_upload_folder (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_music_upload_folder (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_picture_upload_folder (RygelConfiguration* base, GError** error);
RygelUserConfig* rygel_user_config_get_default (GError** error);
RygelUserConfig* rygel_user_config_new (const gchar* file, GError** error);
RygelUserConfig* rygel_user_config_construct (GType object_type, const gchar* file, GError** error);
static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error);
static gchar* rygel_user_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error);
static gchar* rygel_user_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
GQuark rygel_configuration_error_quark (void);
static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gint rygel_user_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static void rygel_user_config_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean rygel_user_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_UPNP_ENABLED_KEY, &_inner_error_);
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return FALSE;
#line 185 "rygel-user-config.c"
	}
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp1_;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 191 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_interface (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_IFACE_KEY, &_inner_error_);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return NULL;
#line 213 "rygel-user-config.c"
	}
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp1_;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 219 "rygel-user-config.c"
}


static gint rygel_user_config_real_get_port (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gint result = 0;
	guint16 _tmp0_;
	guint16 _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	GError * _inner_error_ = NULL;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = 0U;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = G_MAXUINT16;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp2_ = rygel_configuration_get_int ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_PORT_KEY, (gint) _tmp0_, (gint) _tmp1_, &_inner_error_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp3_ = _tmp2_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return 0;
#line 247 "rygel-user-config.c"
	}
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp3_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 253 "rygel-user-config.c"
}


static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_TRANSCODING_KEY, &_inner_error_);
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return FALSE;
#line 275 "rygel-user-config.c"
	}
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp1_;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 281 "rygel-user-config.c"
}


static gboolean rygel_user_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY, &_inner_error_);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return FALSE;
#line 303 "rygel-user-config.c"
	}
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp1_;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 309 "rygel-user-config.c"
}


static gboolean rygel_user_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY, &_inner_error_);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return FALSE;
#line 331 "rygel-user-config.c"
	}
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp1_;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 337 "rygel-user-config.c"
}


static gboolean rygel_user_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY, &_inner_error_);
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return FALSE;
#line 359 "rygel-user-config.c"
	}
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp1_;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 365 "rygel-user-config.c"
}


static gboolean rygel_user_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY, &_inner_error_);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return FALSE;
#line 387 "rygel-user-config.c"
	}
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp1_;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 393 "rygel-user-config.c"
}


static gboolean rygel_user_config_real_get_allow_upload (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY, &_inner_error_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return FALSE;
#line 415 "rygel-user-config.c"
	}
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp1_;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 421 "rygel-user-config.c"
}


static gboolean rygel_user_config_real_get_allow_deletion (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_ALLOW_DELETION_KEY, &_inner_error_);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return FALSE;
#line 443 "rygel-user-config.c"
	}
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp1_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 449 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_log_levels (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_LOG_LEVELS_KEY, &_inner_error_);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return NULL;
#line 471 "rygel-user-config.c"
	}
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp1_;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 477 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_plugin_path (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_PLUGIN_PATH_KEY, &_inner_error_);
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return NULL;
#line 499 "rygel-user-config.c"
	}
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp1_;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 505 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_video_upload_folder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_VIDEO_UPLOAD_DIR_PATH_KEY, &_inner_error_);
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return NULL;
#line 527 "rygel-user-config.c"
	}
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp1_;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 533 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_music_upload_folder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_MUSIC_UPLOAD_DIR_PATH_KEY, &_inner_error_);
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return NULL;
#line 555 "rygel-user-config.c"
	}
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp1_;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 561 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_picture_upload_folder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_PICTURE_UPLOAD_DIR_PATH_KEY, &_inner_error_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return NULL;
#line 583 "rygel-user-config.c"
	}
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp1_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 589 "rygel-user-config.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return self ? g_object_ref (self) : NULL;
#line 596 "rygel-user-config.c"
}


RygelUserConfig* rygel_user_config_get_default (GError** error) {
	RygelUserConfig* result = NULL;
	RygelUserConfig* _tmp0_;
	RygelUserConfig* _tmp6_;
	RygelUserConfig* _tmp7_;
	GError * _inner_error_ = NULL;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = rygel_user_config_config;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_tmp0_ == NULL) {
#line 610 "rygel-user-config.c"
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* path;
		const gchar* _tmp3_;
		RygelUserConfig* _tmp4_;
		RygelUserConfig* _tmp5_;
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp1_ = g_get_user_config_dir ();
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp2_ = g_build_filename (_tmp1_, RYGEL_USER_CONFIG_CONFIG_FILE, NULL);
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		path = _tmp2_;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp3_ = path;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp4_ = rygel_user_config_new (_tmp3_, &_inner_error_);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp5_ = _tmp4_;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			g_propagate_error (error, _inner_error_);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_g_free0 (path);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			return NULL;
#line 637 "rygel-user-config.c"
		}
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_object_unref0 (rygel_user_config_config);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		rygel_user_config_config = _tmp5_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_free0 (path);
#line 645 "rygel-user-config.c"
	}
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp6_ = rygel_user_config_config;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp7_;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 655 "rygel-user-config.c"
}


RygelUserConfig* rygel_user_config_construct (GType object_type, const gchar* file, GError** error) {
	RygelUserConfig * self = NULL;
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* path;
	GKeyFile* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError * _inner_error_ = NULL;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) g_object_new (object_type, NULL);
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = g_key_file_new ();
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_g_key_file_free0 (self->key_file);
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self->key_file = _tmp0_;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = g_key_file_new ();
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_g_key_file_free0 (self->sys_key_file);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self->sys_key_file = _tmp1_;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp2_ = g_build_filename (SYS_CONFIG_DIR, RYGEL_USER_CONFIG_CONFIG_FILE, NULL);
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	path = _tmp2_;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp3_ = self->sys_key_file;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp4_ = path;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_key_file_load_from_file (_tmp3_, _tmp4_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_free0 (path);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_object_unref0 (self);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return NULL;
#line 705 "rygel-user-config.c"
	}
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp5_ = path;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_debug ("rygel-user-config.vala:141: Loaded system configuration from file '%s'", _tmp5_);
#line 711 "rygel-user-config.c"
	{
		GKeyFile* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp6_ = self->key_file;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp7_ = file;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_key_file_load_from_file (_tmp6_, _tmp7_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 724 "rygel-user-config.c"
			goto __catch0_g_error;
		}
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp8_ = file;
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_debug ("rygel-user-config.vala:148: Loaded user configuration from file '%s'", _tmp8_);
#line 731 "rygel-user-config.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		gsize size = 0UL;
		GKeyFile* _tmp12_;
		gsize _tmp13_ = 0UL;
		gchar* _tmp14_ = NULL;
		gchar* data;
		GKeyFile* _tmp15_;
		const gchar* _tmp16_;
		gsize _tmp17_;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_error_ = _inner_error_;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp9_ = file;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp10_ = _error_;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp11_ = _tmp10_->message;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_debug ("rygel-user-config.vala:150: Failed to load user configuration from fil" \
"e '%s': %s", _tmp9_, _tmp11_);
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp12_ = self->sys_key_file;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp14_ = g_key_file_to_data (_tmp12_, &_tmp13_, NULL);
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		size = _tmp13_;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		data = _tmp14_;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp15_ = self->key_file;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp16_ = data;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp17_ = size;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_key_file_load_from_data (_tmp15_, _tmp16_, _tmp17_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_g_free0 (data);
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_g_error_free0 (_error_);
#line 782 "rygel-user-config.c"
			goto __finally0;
		}
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_free0 (data);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_error_free0 (_error_);
#line 789 "rygel-user-config.c"
	}
	__finally0:
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_free0 (path);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_object_unref0 (self);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return NULL;
#line 802 "rygel-user-config.c"
	}
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_g_free0 (path);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return self;
#line 808 "rygel-user-config.c"
}


RygelUserConfig* rygel_user_config_new (const gchar* file, GError** error) {
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return rygel_user_config_construct (RYGEL_TYPE_USER_CONFIG, file, error);
#line 815 "rygel-user-config.c"
}


static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = section;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = rygel_configuration_get_bool ((RygelConfiguration*) self, _tmp0_, RYGEL_USER_CONFIG_ENABLED_KEY, &_inner_error_);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp2_ = _tmp1_;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return FALSE;
#line 842 "rygel-user-config.c"
	}
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp2_;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 848 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = section;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, _tmp0_, RYGEL_USER_CONFIG_TITLE_KEY, &_inner_error_);
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp2_ = _tmp1_;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return NULL;
#line 875 "rygel-user-config.c"
	}
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = _tmp2_;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 881 "rygel-user-config.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return self ? g_error_copy (self) : NULL;
#line 888 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* val = NULL;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	gboolean _tmp19_;
	GError * _inner_error_ = NULL;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 906 "rygel-user-config.c"
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp0_ = self->key_file;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp1_ = section;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp2_ = key;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp3_ = g_key_file_get_string (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp4_ = _tmp3_;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 927 "rygel-user-config.c"
				goto __catch1_g_key_file_error;
			}
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_g_free0 (val);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			g_clear_error (&_inner_error_);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			return NULL;
#line 938 "rygel-user-config.c"
		}
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_free0 (val);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		val = _tmp4_;
#line 944 "rygel-user-config.c"
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp5_ = FALSE;
		GError* _tmp6_;
		gboolean _tmp8_;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_error_ = _inner_error_;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp6_ = _error_;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp5_ = TRUE;
#line 963 "rygel-user-config.c"
		} else {
			GError* _tmp7_;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp7_ = _error_;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp5_ = g_error_matches (_tmp7_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
#line 970 "rygel-user-config.c"
		}
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp8_ = _tmp5_;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (_tmp8_) {
#line 976 "rygel-user-config.c"
			GKeyFile* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp9_ = self->sys_key_file;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp10_ = section;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp11_ = key;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp12_ = g_key_file_get_string (_tmp9_, _tmp10_, _tmp11_, &_inner_error_);
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp13_ = _tmp12_;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			if (_inner_error_ != NULL) {
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
				_g_error_free0 (_error_);
#line 996 "rygel-user-config.c"
				goto __finally1;
			}
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_g_free0 (val);
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			val = _tmp13_;
#line 1003 "rygel-user-config.c"
		} else {
			GError* _tmp14_;
			GError* _tmp15_;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp14_ = _error_;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp15_ = _g_error_copy0 (_tmp14_);
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_inner_error_ = _tmp15_;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_g_error_free0 (_error_);
#line 1015 "rygel-user-config.c"
			goto __finally1;
		}
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_error_free0 (_error_);
#line 1020 "rygel-user-config.c"
	}
	__finally1:
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_free0 (val);
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return NULL;
#line 1031 "rygel-user-config.c"
	}
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp17_ = val;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_tmp17_ == NULL) {
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp16_ = TRUE;
#line 1039 "rygel-user-config.c"
	} else {
		const gchar* _tmp18_;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp18_ = val;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp16_ = g_strcmp0 (_tmp18_, "") == 0;
#line 1046 "rygel-user-config.c"
	}
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp19_ = _tmp16_;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_tmp19_) {
#line 1052 "rygel-user-config.c"
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_;
		GError* _tmp22_;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp20_ = _ ("No value available for '%s'");
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp21_ = key;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp22_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp20_, _tmp21_);
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_inner_error_ = _tmp22_;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_free0 (val);
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return NULL;
#line 1070 "rygel-user-config.c"
	}
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = val;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 1076 "rygel-user-config.c"
}


static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* str_list;
	gchar** strings = NULL;
	gint strings_length1 = 0;
	gint _strings_size_ = 0;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GError * _inner_error_ = NULL;
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	str_list = _tmp0_;
#line 1101 "rygel-user-config.c"
	{
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gsize _tmp4_;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gint __tmp6__size_;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp1_ = self->key_file;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp2_ = section;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp3_ = key;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp5_ = g_key_file_get_string_list (_tmp1_, _tmp2_, _tmp3_, &_tmp4_, &_inner_error_);
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp6_ = _tmp5_;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp6__length1 = _tmp4_;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		__tmp6__size_ = _tmp6__length1;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 1129 "rygel-user-config.c"
				goto __catch2_g_key_file_error;
			}
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_g_object_unref0 (str_list);
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			g_clear_error (&_inner_error_);
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			return NULL;
#line 1142 "rygel-user-config.c"
		}
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		strings = _tmp6_;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		strings_length1 = _tmp6__length1;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_strings_size_ = strings_length1;
#line 1152 "rygel-user-config.c"
	}
	goto __finally2;
	__catch2_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp7_ = FALSE;
		GError* _tmp8_;
		gboolean _tmp10_;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_error_ = _inner_error_;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp8_ = _error_;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (g_error_matches (_tmp8_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp7_ = TRUE;
#line 1171 "rygel-user-config.c"
		} else {
			GError* _tmp9_;
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp9_ = _error_;
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp7_ = g_error_matches (_tmp9_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
#line 1178 "rygel-user-config.c"
		}
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp10_ = _tmp7_;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (_tmp10_) {
#line 1184 "rygel-user-config.c"
			GKeyFile* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gsize _tmp14_;
			gchar** _tmp15_ = NULL;
			gchar** _tmp16_;
			gint _tmp16__length1;
			gint __tmp16__size_;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp11_ = self->sys_key_file;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp12_ = section;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp13_ = key;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp15_ = g_key_file_get_string_list (_tmp11_, _tmp12_, _tmp13_, &_tmp14_, &_inner_error_);
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp16_ = _tmp15_;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp16__length1 = _tmp14_;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			__tmp16__size_ = _tmp16__length1;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			if (_inner_error_ != NULL) {
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
				_g_error_free0 (_error_);
#line 1211 "rygel-user-config.c"
				goto __finally2;
			}
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			strings = _tmp16_;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			strings_length1 = _tmp16__length1;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_strings_size_ = strings_length1;
#line 1222 "rygel-user-config.c"
		} else {
			GError* _tmp17_;
			GError* _tmp18_;
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp17_ = _error_;
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp18_ = _g_error_copy0 (_tmp17_);
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_inner_error_ = _tmp18_;
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_g_error_free0 (_error_);
#line 1234 "rygel-user-config.c"
			goto __finally2;
		}
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_error_free0 (_error_);
#line 1239 "rygel-user-config.c"
	}
	__finally2:
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_object_unref0 (str_list);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return NULL;
#line 1252 "rygel-user-config.c"
	}
#line 211 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp19_ = strings;
#line 211 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp19__length1 = strings_length1;
#line 1258 "rygel-user-config.c"
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
#line 211 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		str_collection = _tmp19_;
#line 211 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		str_collection_length1 = _tmp19__length1;
#line 211 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		for (str_it = 0; str_it < _tmp19__length1; str_it = str_it + 1) {
#line 1270 "rygel-user-config.c"
			gchar* _tmp20_;
			gchar* str = NULL;
#line 211 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp20_ = g_strdup (str_collection[str_it]);
#line 211 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			str = _tmp20_;
#line 1277 "rygel-user-config.c"
			{
				GeeArrayList* _tmp21_;
				const gchar* _tmp22_;
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
				_tmp21_ = str_list;
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
				_tmp22_ = str;
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
#line 211 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
				_g_free0 (str);
#line 1289 "rygel-user-config.c"
			}
		}
	}
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = str_list;
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 1299 "rygel-user-config.c"
}


static gint rygel_user_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error) {
	RygelUserConfig * self;
	gint result = 0;
	gint val = 0;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gint _tmp18_;
	gboolean _tmp21_;
	gboolean _tmp24_;
	GError * _inner_error_ = NULL;
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, 0);
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 1319 "rygel-user-config.c"
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_;
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp0_ = self->key_file;
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp1_ = section;
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp2_ = key;
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp3_ = g_key_file_get_integer (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp4_ = _tmp3_;
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 1340 "rygel-user-config.c"
				goto __catch3_g_key_file_error;
			}
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			g_clear_error (&_inner_error_);
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			return 0;
#line 1349 "rygel-user-config.c"
		}
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		val = _tmp4_;
#line 1353 "rygel-user-config.c"
	}
	goto __finally3;
	__catch3_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp5_ = FALSE;
		GError* _tmp6_;
		gboolean _tmp8_;
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_error_ = _inner_error_;
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp6_ = _error_;
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp5_ = TRUE;
#line 1372 "rygel-user-config.c"
		} else {
			GError* _tmp7_;
#line 229 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp7_ = _error_;
#line 229 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp5_ = g_error_matches (_tmp7_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
#line 1379 "rygel-user-config.c"
		}
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp8_ = _tmp5_;
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (_tmp8_) {
#line 1385 "rygel-user-config.c"
			GKeyFile* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gint _tmp12_ = 0;
			gint _tmp13_;
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp9_ = self->sys_key_file;
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp10_ = section;
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp11_ = key;
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp12_ = g_key_file_get_integer (_tmp9_, _tmp10_, _tmp11_, &_inner_error_);
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp13_ = _tmp12_;
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			if (_inner_error_ != NULL) {
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
				_g_error_free0 (_error_);
#line 1405 "rygel-user-config.c"
				goto __finally3;
			}
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			val = _tmp13_;
#line 1410 "rygel-user-config.c"
		} else {
			GError* _tmp14_;
			GError* _tmp15_;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp14_ = _error_;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp15_ = _g_error_copy0 (_tmp14_);
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_inner_error_ = _tmp15_;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_g_error_free0 (_error_);
#line 1422 "rygel-user-config.c"
			goto __finally3;
		}
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_error_free0 (_error_);
#line 1427 "rygel-user-config.c"
	}
	__finally3:
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return 0;
#line 1436 "rygel-user-config.c"
	}
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp18_ = val;
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_tmp18_ == 0) {
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp17_ = TRUE;
#line 1444 "rygel-user-config.c"
	} else {
		gint _tmp19_;
		gint _tmp20_;
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp19_ = val;
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp20_ = min;
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp17_ = _tmp19_ < _tmp20_;
#line 1454 "rygel-user-config.c"
	}
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp21_ = _tmp17_;
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_tmp21_) {
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp16_ = TRUE;
#line 1462 "rygel-user-config.c"
	} else {
		gint _tmp22_;
		gint _tmp23_;
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp22_ = val;
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp23_ = max;
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp16_ = _tmp22_ > _tmp23_;
#line 1472 "rygel-user-config.c"
	}
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp24_ = _tmp16_;
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_tmp24_) {
#line 1478 "rygel-user-config.c"
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_;
		GError* _tmp27_;
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp25_ = _ ("Value of '%s' out of range");
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp26_ = key;
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp27_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE, _tmp25_, _tmp26_);
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_inner_error_ = _tmp27_;
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return 0;
#line 1494 "rygel-user-config.c"
	}
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = val;
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 1500 "rygel-user-config.c"
}


static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* int_list;
	gint* ints = NULL;
	gint ints_length1 = 0;
	gint _ints_size_ = 0;
	gint* _tmp19_;
	gint _tmp19__length1;
	GError * _inner_error_ = NULL;
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 247 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
#line 247 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	int_list = _tmp0_;
#line 1525 "rygel-user-config.c"
	{
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gsize _tmp4_;
		gint* _tmp5_ = NULL;
		gint* _tmp6_;
		gint _tmp6__length1;
		gint __tmp6__size_;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp1_ = self->key_file;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp2_ = section;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp3_ = key;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp5_ = g_key_file_get_integer_list (_tmp1_, _tmp2_, _tmp3_, &_tmp4_, &_inner_error_);
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp6_ = _tmp5_;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp6__length1 = _tmp4_;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		__tmp6__size_ = _tmp6__length1;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 1553 "rygel-user-config.c"
				goto __catch4_g_key_file_error;
			}
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			ints = (g_free (ints), NULL);
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_g_object_unref0 (int_list);
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			g_clear_error (&_inner_error_);
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			return NULL;
#line 1566 "rygel-user-config.c"
		}
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		ints = (g_free (ints), NULL);
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		ints = _tmp6_;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		ints_length1 = _tmp6__length1;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_ints_size_ = ints_length1;
#line 1576 "rygel-user-config.c"
	}
	goto __finally4;
	__catch4_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp7_ = FALSE;
		GError* _tmp8_;
		gboolean _tmp10_;
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_error_ = _inner_error_;
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 253 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp8_ = _error_;
#line 253 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (g_error_matches (_tmp8_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
#line 253 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp7_ = TRUE;
#line 1595 "rygel-user-config.c"
		} else {
			GError* _tmp9_;
#line 254 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp9_ = _error_;
#line 254 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp7_ = g_error_matches (_tmp9_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
#line 1602 "rygel-user-config.c"
		}
#line 253 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp10_ = _tmp7_;
#line 253 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (_tmp10_) {
#line 1608 "rygel-user-config.c"
			GKeyFile* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gsize _tmp14_;
			gint* _tmp15_ = NULL;
			gint* _tmp16_;
			gint _tmp16__length1;
			gint __tmp16__size_;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp11_ = self->sys_key_file;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp12_ = section;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp13_ = key;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp15_ = g_key_file_get_integer_list (_tmp11_, _tmp12_, _tmp13_, &_tmp14_, &_inner_error_);
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp16_ = _tmp15_;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp16__length1 = _tmp14_;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			__tmp16__size_ = _tmp16__length1;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			if (_inner_error_ != NULL) {
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
				_g_error_free0 (_error_);
#line 1635 "rygel-user-config.c"
				goto __finally4;
			}
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			ints = (g_free (ints), NULL);
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			ints = _tmp16_;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			ints_length1 = _tmp16__length1;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_ints_size_ = ints_length1;
#line 1646 "rygel-user-config.c"
		} else {
			GError* _tmp17_;
			GError* _tmp18_;
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp17_ = _error_;
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp18_ = _g_error_copy0 (_tmp17_);
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_inner_error_ = _tmp18_;
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_g_error_free0 (_error_);
#line 1658 "rygel-user-config.c"
			goto __finally4;
		}
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_error_free0 (_error_);
#line 1663 "rygel-user-config.c"
	}
	__finally4:
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		ints = (g_free (ints), NULL);
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_object_unref0 (int_list);
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return NULL;
#line 1676 "rygel-user-config.c"
	}
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp19_ = ints;
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_tmp19__length1 = ints_length1;
#line 1682 "rygel-user-config.c"
	{
		gint* num_collection = NULL;
		gint num_collection_length1 = 0;
		gint _num_collection_size_ = 0;
		gint num_it = 0;
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		num_collection = _tmp19_;
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		num_collection_length1 = _tmp19__length1;
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		for (num_it = 0; num_it < _tmp19__length1; num_it = num_it + 1) {
#line 1694 "rygel-user-config.c"
			gint num = 0;
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			num = num_collection[num_it];
#line 1698 "rygel-user-config.c"
			{
				GeeArrayList* _tmp20_;
				gint _tmp21_;
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
				_tmp20_ = int_list;
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
				_tmp21_ = num;
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, GINT_TO_POINTER (_tmp21_));
#line 1708 "rygel-user-config.c"
			}
		}
	}
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = int_list;
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	ints = (g_free (ints), NULL);
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 1718 "rygel-user-config.c"
}


static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean val = FALSE;
	GError * _inner_error_ = NULL;
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 1733 "rygel-user-config.c"
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp0_ = self->key_file;
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp1_ = section;
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp2_ = key;
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp3_ = g_key_file_get_boolean (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp4_ = _tmp3_;
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 1754 "rygel-user-config.c"
				goto __catch5_g_key_file_error;
			}
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			g_clear_error (&_inner_error_);
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			return FALSE;
#line 1763 "rygel-user-config.c"
		}
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		val = _tmp4_;
#line 1767 "rygel-user-config.c"
	}
	goto __finally5;
	__catch5_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp5_ = FALSE;
		GError* _tmp6_;
		gboolean _tmp8_;
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_error_ = _inner_error_;
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 276 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp6_ = _error_;
#line 276 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
#line 276 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp5_ = TRUE;
#line 1786 "rygel-user-config.c"
		} else {
			GError* _tmp7_;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp7_ = _error_;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp5_ = g_error_matches (_tmp7_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
#line 1793 "rygel-user-config.c"
		}
#line 276 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_tmp8_ = _tmp5_;
#line 276 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		if (_tmp8_) {
#line 1799 "rygel-user-config.c"
			GKeyFile* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_;
#line 278 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp9_ = self->sys_key_file;
#line 278 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp10_ = section;
#line 278 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp11_ = key;
#line 278 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp12_ = g_key_file_get_boolean (_tmp9_, _tmp10_, _tmp11_, &_inner_error_);
#line 278 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp13_ = _tmp12_;
#line 278 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			if (_inner_error_ != NULL) {
#line 278 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
				_g_error_free0 (_error_);
#line 1819 "rygel-user-config.c"
				goto __finally5;
			}
#line 278 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			val = _tmp13_;
#line 1824 "rygel-user-config.c"
		} else {
			GError* _tmp14_;
			GError* _tmp15_;
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp14_ = _error_;
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_tmp15_ = _g_error_copy0 (_tmp14_);
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_inner_error_ = _tmp15_;
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
			_g_error_free0 (_error_);
#line 1836 "rygel-user-config.c"
			goto __finally5;
		}
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		_g_error_free0 (_error_);
#line 1841 "rygel-user-config.c"
	}
	__finally5:
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
		return FALSE;
#line 1850 "rygel-user-config.c"
	}
#line 284 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	result = val;
#line 284 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	return result;
#line 1856 "rygel-user-config.c"
}


static void rygel_user_config_class_init (RygelUserConfigClass * klass) {
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	rygel_user_config_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_user_config_finalize;
#line 1865 "rygel-user-config.c"
}


static void rygel_user_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	rygel_user_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_upnp_enabled = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_upnp_enabled;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_interface = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_interface;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_port = (gint (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_port;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_transcoding = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_transcoding;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_mp3_transcoder = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_mp3_transcoder;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_mp2ts_transcoder = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_mp2ts_transcoder;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_lpcm_transcoder = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_lpcm_transcoder;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_wmv_transcoder = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_wmv_transcoder;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_allow_upload = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_allow_upload;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_allow_deletion = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_allow_deletion;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_log_levels = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_log_levels;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_plugin_path = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_plugin_path;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_video_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_video_upload_folder;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_music_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_music_upload_folder;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_picture_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_picture_upload_folder;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_enabled = (gboolean (*)(RygelConfiguration*, const gchar*, GError**)) rygel_user_config_real_get_enabled;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_title = (gchar* (*)(RygelConfiguration*, const gchar*, GError**)) rygel_user_config_real_get_title;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_string = (gchar* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_string;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_string_list = (GeeArrayList* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_string_list;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_int = (gint (*)(RygelConfiguration*, const gchar*, const gchar*, gint, gint, GError**)) rygel_user_config_real_get_int;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_int_list = (GeeArrayList* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_int_list;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	iface->get_bool = (gboolean (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_bool;
#line 1916 "rygel-user-config.c"
}


static void rygel_user_config_instance_init (RygelUserConfig * self) {
}


static void rygel_user_config_finalize (GObject* obj) {
	RygelUserConfig * self;
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	self = RYGEL_USER_CONFIG (obj);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_g_key_file_free0 (self->key_file);
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	_g_key_file_free0 (self->sys_key_file);
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-user-config.vala"
	G_OBJECT_CLASS (rygel_user_config_parent_class)->finalize (obj);
#line 1934 "rygel-user-config.c"
}


/**
 * Manages the user configuration for Rygel.
 */
GType rygel_user_config_get_type (void) {
	static volatile gsize rygel_user_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_user_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelUserConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_user_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelUserConfig), 0, (GInstanceInitFunc) rygel_user_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_user_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_user_config_type_id;
		rygel_user_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelUserConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_user_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_user_config_type_id__volatile, rygel_user_config_type_id);
	}
	return rygel_user_config_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



