/* rygel-simple-container.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-simple-container.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_SIMPLE_CONTAINER (rygel_simple_container_get_type ())
#define RYGEL_SIMPLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer))
#define RYGEL_SIMPLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainerClass))
#define RYGEL_IS_SIMPLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SIMPLE_CONTAINER))
#define RYGEL_IS_SIMPLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SIMPLE_CONTAINER))
#define RYGEL_SIMPLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainerClass))

typedef struct _RygelSimpleContainer RygelSimpleContainer;
typedef struct _RygelSimpleContainerClass RygelSimpleContainerClass;
typedef struct _RygelSimpleContainerPrivate RygelSimpleContainerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelSimpleContainerGetChildrenData RygelSimpleContainerGetChildrenData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _RygelSimpleContainerFindObjectData RygelSimpleContainerFindObjectData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelSimpleContainerSearchData RygelSimpleContainerSearchData;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	gint64 storage_used;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelSimpleContainer {
	RygelMediaContainer parent_instance;
	RygelSimpleContainerPrivate * priv;
	RygelMediaObjects* children;
};

struct _RygelSimpleContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelSimpleContainerPrivate {
	RygelMediaObjects* empty_children;
	GeeArrayList* _search_classes;
};

struct _RygelSimpleContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	guint _tmp0_;
	guint _tmp1_;
	guint stop;
	guint _tmp2_;
	gint _tmp3_;
	guint _tmp4_;
	RygelMediaObjects* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	GeeList* _tmp8_;
};

struct _Block5Data {
	int _ref_count_;
	RygelSimpleContainer * self;
	gint restart_count;
	gboolean restart;
	gpointer _async_data_;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	gulong updated_id;
};

struct _RygelSimpleContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	Block5Data* _data5_;
	RygelMediaObject* media_object;
	gboolean _tmp0_;
	Block6Data* _data6_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	RygelMediaObjects* _tmp6_;
	RygelMediaObjects* _tmp7_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _child_size;
	gint _child_index;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	RygelMediaObjects* _tmp14_;
	gint _tmp15_;
	gpointer _tmp16_;
	RygelMediaObject* child;
	RygelMediaObject* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	RygelMediaObject* _tmp20_;
	RygelMediaObject* _tmp21_;
	RygelMediaObject* _tmp22_;
	gulong _tmp23_;
	RygelMediaObject* _tmp24_;
	RygelMediaContainer* _tmp25_;
	RygelMediaContainer* container;
	RygelMediaContainer* _tmp26_;
	const gchar* _tmp27_;
	GCancellable* _tmp28_;
	RygelMediaObject* _tmp29_;
	RygelMediaObject* _tmp30_;
	RygelMediaObject* _tmp31_;
	gboolean _tmp32_;
	gulong _tmp33_;
	gulong _tmp34_;
	GError * _inner_error_;
};

struct _RygelSimpleContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelSearchExpression* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GCancellable* _tmp3_;
	guint _tmp4_;
	RygelMediaObjects* _tmp5_;
	RygelMediaObjects* _tmp6_;
	GError * _inner_error_;
};


static gpointer rygel_simple_container_parent_class = NULL;
static RygelSearchableContainerIface* rygel_simple_container_rygel_searchable_container_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_simple_container_get_type (void) G_GNUC_CONST;
#define RYGEL_SIMPLE_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainerPrivate))
enum  {
	RYGEL_SIMPLE_CONTAINER_DUMMY_PROPERTY,
	RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES
};
RygelSimpleContainer* rygel_simple_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelSimpleContainer* rygel_simple_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelMediaContainer* rygel_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value);
RygelSimpleContainer* rygel_simple_container_new_root (const gchar* title);
RygelSimpleContainer* rygel_simple_container_construct_root (GType object_type, const gchar* title);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_simple_container_add_child_item (RygelSimpleContainer* self, RygelMediaItem* child);
static void rygel_simple_container_add_child (RygelSimpleContainer* self, RygelMediaObject* child);
RygelMediaObjects* rygel_simple_container_get_all_children (RygelSimpleContainer* self);
void rygel_simple_container_add_child_container (RygelSimpleContainer* self, RygelMediaContainer* child);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
static void rygel_simple_container_on_container_updated (RygelSimpleContainer* self, RygelMediaContainer* source, RygelMediaContainer* updated);
static void _rygel_simple_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
void rygel_simple_container_remove_child (RygelSimpleContainer* self, RygelMediaObject* child);
void rygel_simple_container_clear (RygelSimpleContainer* self);
gboolean rygel_simple_container_is_child_id_unique (RygelSimpleContainer* self, const gchar* child_id);
static void rygel_simple_container_real_get_children_data_free (gpointer _data);
static void rygel_simple_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_simple_container_real_get_children_co (RygelSimpleContainerGetChildrenData* _data_);
static void rygel_simple_container_real_find_object_data_free (gpointer _data);
static void rygel_simple_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_simple_container_real_find_object_co (RygelSimpleContainerFindObjectData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void ________lambda13_ (Block6Data* _data6_, RygelMediaContainer* _, RygelMediaContainer* updated);
static void _________lambda13__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_simple_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_simple_container_real_search_data_free (gpointer _data);
static void rygel_simple_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_simple_container_real_search_co (RygelSimpleContainerSearchData* _data_);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_simple_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_updated (RygelMediaContainer* self);
static void rygel_simple_container_finalize (GObject* obj);
static void _vala_rygel_simple_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_simple_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelSimpleContainer* rygel_simple_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title) {
	RygelSimpleContainer * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = id;
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp1_ = parent;
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp2_ = title;
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) rygel_media_container_construct (object_type, _tmp0_, _tmp1_, _tmp2_, 0);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp3_ = rygel_media_objects_new ();
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (self->children);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	self->children = _tmp3_;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp4_ = rygel_media_objects_new ();
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (self->priv->empty_children);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	self->priv->empty_children = _tmp4_;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp6_ = _tmp5_;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, _tmp6_);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (_tmp6_);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return self;
#line 419 "rygel-simple-container.c"
}


RygelSimpleContainer* rygel_simple_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title) {
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return rygel_simple_container_construct (RYGEL_TYPE_SIMPLE_CONTAINER, id, parent, title);
#line 426 "rygel-simple-container.c"
}


RygelSimpleContainer* rygel_simple_container_construct_root (GType object_type, const gchar* title) {
	RygelSimpleContainer * self = NULL;
	const gchar* _tmp0_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = title;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) rygel_simple_container_construct (object_type, "0", NULL, _tmp0_);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return self;
#line 441 "rygel-simple-container.c"
}


RygelSimpleContainer* rygel_simple_container_new_root (const gchar* title) {
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return rygel_simple_container_construct_root (RYGEL_TYPE_SIMPLE_CONTAINER, title);
#line 448 "rygel-simple-container.c"
}


void rygel_simple_container_add_child_item (RygelSimpleContainer* self, RygelMediaItem* child) {
	RygelMediaItem* _tmp0_;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_if_fail (child != NULL);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = child;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	rygel_simple_container_add_child (self, (RygelMediaObject*) _tmp0_);
#line 462 "rygel-simple-container.c"
}


RygelMediaObjects* rygel_simple_container_get_all_children (RygelSimpleContainer* self) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* all;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* _tmp2_;
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = rygel_media_objects_new ();
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	all = _tmp0_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp1_ = self->children;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	gee_abstract_collection_add_all ((GeeAbstractCollection*) all, (GeeCollection*) _tmp1_);
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp2_ = self->priv->empty_children;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	gee_abstract_collection_add_all ((GeeAbstractCollection*) all, (GeeCollection*) _tmp2_);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	result = all;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return result;
#line 490 "rygel-simple-container.c"
}


/**
     * NOTE: This method only actually adds the child container to the hierarchy
     * until it has any children to offer.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 501 "rygel-simple-container.c"
}


static void _rygel_simple_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	rygel_simple_container_on_container_updated (self, _sender, container);
#line 508 "rygel-simple-container.c"
}


void rygel_simple_container_add_child_container (RygelSimpleContainer* self, RygelMediaContainer* child) {
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp8_;
	gint _tmp9_;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_if_fail (child != NULL);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = child;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (RYGEL_IS_SEARCHABLE_CONTAINER (_tmp0_)) {
#line 524 "rygel-simple-container.c"
		RygelMediaContainer* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* search_classes;
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp1_ = child;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp2_ = rygel_searchable_container_get_search_classes (RYGEL_IS_SEARCHABLE_CONTAINER (_tmp1_) ? ((RygelSearchableContainer*) _tmp1_) : NULL);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp3_ = _tmp2_;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		search_classes = _tmp4_;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp5_ = rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self);
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp6_ = _tmp5_;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp7_ = search_classes;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp6_, (GeeCollection*) _tmp7_);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_g_object_unref0 (search_classes);
#line 553 "rygel-simple-container.c"
	}
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp8_ = child;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp9_ = _tmp8_->child_count;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (_tmp9_ > 0) {
#line 561 "rygel-simple-container.c"
		RygelMediaContainer* _tmp10_;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp10_ = child;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		rygel_simple_container_add_child (self, (RygelMediaObject*) _tmp10_);
#line 567 "rygel-simple-container.c"
	} else {
		RygelMediaContainer* _tmp11_;
		const gchar* _tmp12_;
		RygelMediaObjects* _tmp13_;
		RygelMediaContainer* _tmp14_;
		RygelMediaContainer* _tmp15_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp11_ = child;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp12_ = ((RygelMediaObject*) _tmp11_)->id;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_debug ("Container '%s' empty, refusing to add to hierarchy " "until it has any children to offer.", _tmp12_);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp13_ = self->priv->empty_children;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp14_ = child;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, (RygelMediaObject*) _tmp14_);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp15_ = child;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_signal_connect_object (_tmp15_, "container-updated", (GCallback) _rygel_simple_container_on_container_updated_rygel_media_container_container_updated, self, 0);
#line 590 "rygel-simple-container.c"
	}
}


void rygel_simple_container_remove_child (RygelSimpleContainer* self, RygelMediaObject* child) {
	RygelMediaObjects* _tmp0_;
	RygelMediaObject* _tmp1_;
	gint _tmp2_;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_if_fail (child != NULL);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = self->children;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp1_ = child;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp2_ = ((RygelMediaContainer*) self)->child_count;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	((RygelMediaContainer*) self)->child_count = _tmp2_ - 1;
#line 613 "rygel-simple-container.c"
}


void rygel_simple_container_clear (RygelSimpleContainer* self) {
	RygelMediaObjects* _tmp0_;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = self->children;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	((RygelMediaContainer*) self)->child_count = 0;
#line 627 "rygel-simple-container.c"
}


gboolean rygel_simple_container_is_child_id_unique (RygelSimpleContainer* self, const gchar* child_id) {
	gboolean result = FALSE;
	gboolean unique;
	gboolean _tmp14_;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_val_if_fail (child_id != NULL, FALSE);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	unique = TRUE;
#line 641 "rygel-simple-container.c"
	{
		RygelMediaObjects* _tmp0_;
		RygelMediaObjects* _tmp1_;
		RygelMediaObjects* _child_list;
		RygelMediaObjects* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _child_size;
		gint _child_index;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp0_ = self->children;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_child_list = _tmp1_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp2_ = _child_list;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp4_ = _tmp3_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_child_size = _tmp4_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_child_index = -1;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		while (TRUE) {
#line 669 "rygel-simple-container.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			RygelMediaObjects* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			RygelMediaObject* child;
			RygelMediaObject* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_tmp5_ = _child_index;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_child_index = _tmp5_ + 1;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_tmp6_ = _child_index;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_tmp7_ = _child_size;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				break;
#line 692 "rygel-simple-container.c"
			}
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_tmp8_ = _child_list;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_tmp9_ = _child_index;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			child = (RygelMediaObject*) _tmp10_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_tmp11_ = child;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_tmp12_ = _tmp11_->id;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_tmp13_ = child_id;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				unique = FALSE;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_g_object_unref0 (child);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				break;
#line 716 "rygel-simple-container.c"
			}
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_g_object_unref0 (child);
#line 720 "rygel-simple-container.c"
		}
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_g_object_unref0 (_child_list);
#line 724 "rygel-simple-container.c"
	}
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp14_ = unique;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (_tmp14_) {
#line 730 "rygel-simple-container.c"
		{
			RygelMediaObjects* _tmp15_;
			RygelMediaObjects* _tmp16_;
			RygelMediaObjects* _child_list;
			RygelMediaObjects* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _child_size;
			gint _child_index;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_tmp15_ = self->priv->empty_children;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_tmp16_ = _g_object_ref0 (_tmp15_);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_child_list = _tmp16_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_tmp17_ = _child_list;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_tmp19_ = _tmp18_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_child_size = _tmp19_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_child_index = -1;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			while (TRUE) {
#line 758 "rygel-simple-container.c"
				gint _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				RygelMediaObjects* _tmp23_;
				gint _tmp24_;
				gpointer _tmp25_ = NULL;
				RygelMediaObject* child;
				RygelMediaObject* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_tmp20_ = _child_index;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_child_index = _tmp20_ + 1;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_tmp21_ = _child_index;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_tmp22_ = _child_size;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				if (!(_tmp21_ < _tmp22_)) {
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					break;
#line 781 "rygel-simple-container.c"
				}
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_tmp23_ = _child_list;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_tmp24_ = _child_index;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _tmp24_);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				child = (RygelMediaObject*) _tmp25_;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_tmp26_ = child;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_tmp27_ = _tmp26_->id;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_tmp28_ = child_id;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				if (g_strcmp0 (_tmp27_, _tmp28_) == 0) {
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					unique = FALSE;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_g_object_unref0 (child);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					break;
#line 805 "rygel-simple-container.c"
				}
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_g_object_unref0 (child);
#line 809 "rygel-simple-container.c"
			}
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_g_object_unref0 (_child_list);
#line 813 "rygel-simple-container.c"
		}
	}
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	result = unique;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return result;
#line 820 "rygel-simple-container.c"
}


static void rygel_simple_container_real_get_children_data_free (gpointer _data) {
	RygelSimpleContainerGetChildrenData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_slice_free (RygelSimpleContainerGetChildrenData, _data_);
#line 835 "rygel-simple-container.c"
}


static void rygel_simple_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainer * self;
	RygelSimpleContainerGetChildrenData* _data_;
	RygelSimpleContainer* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_ = g_slice_new0 (RygelSimpleContainerGetChildrenData);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_real_get_children);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_real_get_children_data_free);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp1_ = offset;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->offset = _tmp1_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp2_ = max_count;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->max_count = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp3_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->cancellable = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	rygel_simple_container_real_get_children_co (_data_);
#line 875 "rygel-simple-container.c"
}


static RygelMediaObjects* rygel_simple_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelSimpleContainerGetChildrenData* _data_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		return NULL;
#line 886 "rygel-simple-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return result;
#line 896 "rygel-simple-container.c"
}


static gboolean rygel_simple_container_real_get_children_co (RygelSimpleContainerGetChildrenData* _data_) {
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	switch (_data_->_state_) {
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		case 0:
#line 905 "rygel-simple-container.c"
		goto _state_0;
		default:
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_assert_not_reached ();
#line 910 "rygel-simple-container.c"
	}
	_state_0:
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp0_ = _data_->offset;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp1_ = _data_->max_count;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->stop = _data_->_tmp0_ + _data_->_tmp1_;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp2_ = _data_->stop;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp3_ = ((RygelMediaContainer*) _data_->self)->child_count;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp4_ = 0U;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp4_ = CLAMP (_data_->_tmp2_, (guint) 0, (guint) _data_->_tmp3_);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->stop = _data_->_tmp4_;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp5_ = _data_->self->children;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp6_ = _data_->offset;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp7_ = _data_->stop;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp8_ = NULL;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp8_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp5_, (gint) _data_->_tmp6_, (gint) _data_->_tmp7_);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->result = RYGEL_IS_MEDIA_OBJECTS (_data_->_tmp8_) ? ((RygelMediaObjects*) _data_->_tmp8_) : NULL;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 945 "rygel-simple-container.c"
	} else {
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 949 "rygel-simple-container.c"
	}
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return FALSE;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 959 "rygel-simple-container.c"
	} else {
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 963 "rygel-simple-container.c"
	}
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return FALSE;
#line 969 "rygel-simple-container.c"
}


static void rygel_simple_container_real_find_object_data_free (gpointer _data) {
	RygelSimpleContainerFindObjectData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_free0 (_data_->id);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_slice_free (RygelSimpleContainerFindObjectData, _data_);
#line 986 "rygel-simple-container.c"
}


static void rygel_simple_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainer * self;
	RygelSimpleContainerFindObjectData* _data_;
	RygelSimpleContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_ = g_slice_new0 (RygelSimpleContainerFindObjectData);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_real_find_object);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_real_find_object_data_free);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp1_ = id;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->id = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp3_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->cancellable = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	rygel_simple_container_real_find_object_co (_data_);
#line 1024 "rygel-simple-container.c"
}


static RygelMediaObject* rygel_simple_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelSimpleContainerFindObjectData* _data_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		return NULL;
#line 1035 "rygel-simple-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return result;
#line 1045 "rygel-simple-container.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return _data5_;
#line 1054 "rygel-simple-container.c"
}


static void block5_data_unref (Block5Data* _data5_) {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_g_object_unref0 (_data5_->self);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_slice_free (Block5Data, _data5_);
#line 1065 "rygel-simple-container.c"
	}
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return _data6_;
#line 1075 "rygel-simple-container.c"
}


static void block6_data_unref (Block6Data* _data6_) {
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		block5_data_unref (_data6_->_data5_);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_data6_->_data5_ = NULL;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_slice_free (Block6Data, _data6_);
#line 1088 "rygel-simple-container.c"
	}
}


static void ________lambda13_ (Block6Data* _data6_, RygelMediaContainer* _, RygelMediaContainer* updated) {
	Block5Data* _data5_;
	RygelSimpleContainer * self;
	RygelMediaContainer* _tmp0_;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data5_ = _data6_->_data5_;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	self = _data5_->self;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_if_fail (_ != NULL);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_if_fail (updated != NULL);
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = updated;
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (_tmp0_ == RYGEL_MEDIA_CONTAINER (self)) {
#line 1109 "rygel-simple-container.c"
		gint _tmp1_;
		gulong _tmp2_;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_data5_->restart = TRUE;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp1_ = _data5_->restart_count;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_data5_->restart_count = _tmp1_ + 1;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp2_ = _data6_->updated_id;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_signal_handler_disconnect ((GObject*) self, _tmp2_);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_data6_->updated_id = (gulong) 0;
#line 1124 "rygel-simple-container.c"
	}
}


static void _________lambda13__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	________lambda13_ (self, _sender, container);
#line 1132 "rygel-simple-container.c"
}


static void rygel_simple_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSimpleContainerFindObjectData* _data_;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_ = _user_data_;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_source_object_ = source_object;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_res_ = _res_;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	rygel_simple_container_real_find_object_co (_data_);
#line 1146 "rygel-simple-container.c"
}


static gboolean rygel_simple_container_real_find_object_co (RygelSimpleContainerFindObjectData* _data_) {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	switch (_data_->_state_) {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		case 0:
#line 1155 "rygel-simple-container.c"
		goto _state_0;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		case 1:
#line 1159 "rygel-simple-container.c"
		goto _state_1;
		default:
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_assert_not_reached ();
#line 1164 "rygel-simple-container.c"
	}
	_state_0:
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_data5_ = g_slice_new0 (Block5Data);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_data5_->_ref_count_ = 1;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_data5_->self = g_object_ref (_data_->self);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_data5_->_async_data_ = _data_;
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->media_object = NULL;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_data5_->restart_count = 0;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_data5_->restart = FALSE;
#line 1181 "rygel-simple-container.c"
	{
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_data_->_tmp0_ = TRUE;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		while (TRUE) {
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_data_->_data6_ = g_slice_new0 (Block6Data);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_data_->_data6_->_ref_count_ = 1;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_data_->_data6_->_data5_ = block5_data_ref (_data_->_data5_);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_data_->_tmp1_ = _data_->_tmp0_;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			if (!_data_->_tmp1_) {
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_data_->_tmp3_ = _data_->_data5_->restart;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				if (_data_->_tmp3_) {
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_tmp4_ = _data_->_data5_->restart_count;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_tmp2_ = _data_->_tmp4_ < 10;
#line 1205 "rygel-simple-container.c"
				} else {
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_tmp2_ = FALSE;
#line 1209 "rygel-simple-container.c"
				}
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_data_->_tmp5_ = _data_->_tmp2_;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				if (!_data_->_tmp5_) {
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					block6_data_unref (_data_->_data6_);
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_data6_ = NULL;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					break;
#line 1221 "rygel-simple-container.c"
				}
			}
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_data_->_tmp0_ = FALSE;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_data_->_data5_->restart = FALSE;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_data_->_data6_->updated_id = (gulong) 0;
#line 1230 "rygel-simple-container.c"
			{
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_data_->_tmp6_ = _data_->self->children;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_data_->_child_list = _data_->_tmp7_;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_data_->_tmp8_ = _data_->_child_list;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_data_->_tmp9_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp8_);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_data_->_tmp10_ = _data_->_tmp9_;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_data_->_child_size = _data_->_tmp10_;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_data_->_child_index = -1;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				while (TRUE) {
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_tmp11_ = _data_->_child_index;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_child_index = _data_->_tmp11_ + 1;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_tmp12_ = _data_->_child_index;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_tmp13_ = _data_->_child_size;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					if (!(_data_->_tmp12_ < _data_->_tmp13_)) {
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
						break;
#line 1262 "rygel-simple-container.c"
					}
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_tmp14_ = _data_->_child_list;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_tmp15_ = _data_->_child_index;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_tmp16_ = NULL;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp14_, _data_->_tmp15_);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->child = (RygelMediaObject*) _data_->_tmp16_;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_tmp17_ = _data_->child;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_tmp18_ = _data_->_tmp17_->id;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_data_->_tmp19_ = _data_->id;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					if (g_strcmp0 (_data_->_tmp18_, _data_->_tmp19_) == 0) {
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
						_data_->_tmp20_ = _data_->child;
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
						_data_->_tmp21_ = _g_object_ref0 (_data_->_tmp20_);
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
						_g_object_unref0 (_data_->media_object);
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
						_data_->media_object = _data_->_tmp21_;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
						_g_object_unref0 (_data_->child);
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
						break;
#line 1294 "rygel-simple-container.c"
					} else {
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
						_data_->_tmp22_ = _data_->child;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
						if (RYGEL_IS_MEDIA_CONTAINER (_data_->_tmp22_)) {
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_tmp23_ = 0UL;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_tmp23_ = g_signal_connect_data ((RygelMediaContainer*) _data_->self, "container-updated", (GCallback) _________lambda13__rygel_media_container_container_updated, block6_data_ref (_data_->_data6_), (GClosureNotify) block6_data_unref, 0);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_data6_->updated_id = _data_->_tmp23_;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_tmp24_ = _data_->child;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_tmp25_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (_data_->_tmp24_) ? ((RygelMediaContainer*) _data_->_tmp24_) : NULL);
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->container = _data_->_tmp25_;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_tmp26_ = _data_->container;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_tmp27_ = _data_->id;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_tmp28_ = _data_->cancellable;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_state_ = 1;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							rygel_media_container_find_object (_data_->_tmp26_, _data_->_tmp27_, _data_->_tmp28_, rygel_simple_container_find_object_ready, _data_);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							return FALSE;
#line 1324 "rygel-simple-container.c"
							_state_1:
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_tmp29_ = NULL;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_tmp29_ = rygel_media_container_find_object_finish (_data_->_tmp26_, _data_->_res_, &_data_->_inner_error_);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_tmp30_ = _data_->_tmp29_;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							if (_data_->_inner_error_ != NULL) {
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								g_error_free (_data_->_inner_error_);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								_g_object_unref0 (_data_->container);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								_g_object_unref0 (_data_->child);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								_g_object_unref0 (_data_->_child_list);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								block6_data_unref (_data_->_data6_);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								_data_->_data6_ = NULL;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								_g_object_unref0 (_data_->media_object);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								block5_data_unref (_data_->_data5_);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								_data_->_data5_ = NULL;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								if (_data_->_state_ == 0) {
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
									g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1358 "rygel-simple-container.c"
								} else {
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
									g_simple_async_result_complete (_data_->_async_result);
#line 1362 "rygel-simple-container.c"
								}
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								g_object_unref (_data_->_async_result);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								return FALSE;
#line 1368 "rygel-simple-container.c"
							}
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_g_object_unref0 (_data_->media_object);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->media_object = _data_->_tmp30_;
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_tmp31_ = _data_->media_object;
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							if (_data_->_tmp31_ != NULL) {
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								_data_->_data5_->restart = FALSE;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								_g_object_unref0 (_data_->container);
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								_g_object_unref0 (_data_->child);
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								break;
#line 1386 "rygel-simple-container.c"
							}
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_tmp32_ = _data_->_data5_->restart;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							if (_data_->_tmp32_) {
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								_g_object_unref0 (_data_->container);
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								_g_object_unref0 (_data_->child);
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								break;
#line 1398 "rygel-simple-container.c"
							}
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_data_->_tmp33_ = _data_->_data6_->updated_id;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							if (_data_->_tmp33_ != ((gulong) 0)) {
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								_data_->_tmp34_ = _data_->_data6_->updated_id;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
								g_signal_handler_disconnect ((GObject*) _data_->self, _data_->_tmp34_);
#line 1408 "rygel-simple-container.c"
							}
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
							_g_object_unref0 (_data_->container);
#line 1412 "rygel-simple-container.c"
						}
					}
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
					_g_object_unref0 (_data_->child);
#line 1417 "rygel-simple-container.c"
				}
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
				_g_object_unref0 (_data_->_child_list);
#line 1421 "rygel-simple-container.c"
			}
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			block6_data_unref (_data_->_data6_);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			_data_->_data6_ = NULL;
#line 1427 "rygel-simple-container.c"
		}
	}
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->result = _data_->media_object;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	block5_data_unref (_data_->_data5_);
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_data5_ = NULL;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1440 "rygel-simple-container.c"
	} else {
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1444 "rygel-simple-container.c"
	}
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return FALSE;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (_data_->media_object);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	block5_data_unref (_data_->_data5_);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_data5_ = NULL;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1460 "rygel-simple-container.c"
	} else {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1464 "rygel-simple-container.c"
	}
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return FALSE;
#line 1470 "rygel-simple-container.c"
}


static void rygel_simple_container_real_search_data_free (gpointer _data) {
	RygelSimpleContainerSearchData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_slice_free (RygelSimpleContainerSearchData, _data_);
#line 1487 "rygel-simple-container.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 1494 "rygel-simple-container.c"
}


static void rygel_simple_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainer * self;
	RygelSimpleContainerSearchData* _data_;
	RygelSimpleContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_ = g_slice_new0 (RygelSimpleContainerSearchData);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_real_search);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_real_search_data_free);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp1_ = expression;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->expression = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp3_ = offset;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->offset = _tmp3_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp4_ = max_count;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->max_count = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp5_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->cancellable = _tmp6_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	rygel_simple_container_real_search_co (_data_);
#line 1542 "rygel-simple-container.c"
}


static RygelMediaObjects* rygel_simple_container_real_search_finish (RygelSearchableContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelSimpleContainerSearchData* _data_;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		return NULL;
#line 1553 "rygel-simple-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (total_matches) {
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		*total_matches = _data_->total_matches;
#line 1561 "rygel-simple-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return result;
#line 1569 "rygel-simple-container.c"
}


static void rygel_simple_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSimpleContainerSearchData* _data_;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_ = _user_data_;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_source_object_ = source_object;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_res_ = _res_;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	rygel_simple_container_real_search_co (_data_);
#line 1583 "rygel-simple-container.c"
}


static gboolean rygel_simple_container_real_search_co (RygelSimpleContainerSearchData* _data_) {
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	switch (_data_->_state_) {
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		case 0:
#line 1592 "rygel-simple-container.c"
		goto _state_0;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		case 1:
#line 1596 "rygel-simple-container.c"
		goto _state_1;
		default:
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_assert_not_reached ();
#line 1601 "rygel-simple-container.c"
	}
	_state_0:
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp0_ = _data_->expression;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp1_ = _data_->offset;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp2_ = _data_->max_count;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp3_ = _data_->cancellable;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp4_ = 0U;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_state_ = 1;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, rygel_simple_container_search_ready, _data_);
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return FALSE;
#line 1620 "rygel-simple-container.c"
	_state_1:
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp5_ = NULL;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp5_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp4_, &_data_->_inner_error_);
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->total_matches = _data_->_tmp4_;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_error_free (_data_->_inner_error_);
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		if (_data_->_state_ == 0) {
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1640 "rygel-simple-container.c"
		} else {
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1644 "rygel-simple-container.c"
		}
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_object_unref (_data_->_async_result);
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		return FALSE;
#line 1650 "rygel-simple-container.c"
	}
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_data_->result = _data_->_tmp6_;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1658 "rygel-simple-container.c"
	} else {
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1662 "rygel-simple-container.c"
	}
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return FALSE;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1672 "rygel-simple-container.c"
	} else {
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1676 "rygel-simple-container.c"
	}
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return FALSE;
#line 1682 "rygel-simple-container.c"
}


static void rygel_simple_container_add_child (RygelSimpleContainer* self, RygelMediaObject* child) {
	RygelMediaObjects* _tmp0_;
	RygelMediaObject* _tmp1_;
	gint _tmp2_;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_if_fail (child != NULL);
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = self->children;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp1_ = child;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp2_ = ((RygelMediaContainer*) self)->child_count;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	((RygelMediaContainer*) self)->child_count = _tmp2_ + 1;
#line 1704 "rygel-simple-container.c"
}


static void rygel_simple_container_on_container_updated (RygelSimpleContainer* self, RygelMediaContainer* source, RygelMediaContainer* updated) {
	RygelMediaContainer* _tmp0_;
	gint _tmp1_;
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_if_fail (source != NULL);
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_return_if_fail (updated != NULL);
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = updated;
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp1_ = _tmp0_->child_count;
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	if (_tmp1_ > 0) {
#line 1723 "rygel-simple-container.c"
		RygelMediaObjects* _tmp2_;
		RygelMediaContainer* _tmp3_;
		gboolean _tmp4_ = FALSE;
		RygelMediaObjects* _tmp5_;
		RygelMediaContainer* _tmp6_;
		RygelMediaContainer* _tmp7_;
		RygelMediaContainer* _tmp8_;
		const gchar* _tmp9_;
#line 209 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp2_ = self->priv->empty_children;
#line 209 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp3_ = updated;
#line 209 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp4_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp2_, (RygelMediaObject*) _tmp3_);
#line 209 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		if (!_tmp4_) {
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			return;
#line 1742 "rygel-simple-container.c"
		}
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp5_ = self->priv->empty_children;
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp6_ = updated;
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp5_, (RygelMediaObject*) _tmp6_);
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp7_ = updated;
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		rygel_simple_container_add_child (self, (RygelMediaObject*) _tmp7_);
#line 217 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		rygel_media_container_updated ((RygelMediaContainer*) self);
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp8_ = updated;
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp9_ = ((RygelMediaObject*) _tmp8_)->id;
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_debug ("rygel-simple-container.vala:219: Container '%s' now non-empty, added i" \
"t to hierarchy now.", _tmp9_);
#line 1762 "rygel-simple-container.c"
	} else {
		RygelMediaObjects* _tmp10_;
		RygelMediaContainer* _tmp11_;
		gboolean _tmp12_ = FALSE;
		RygelMediaContainer* _tmp13_;
		RygelMediaObjects* _tmp14_;
		RygelMediaContainer* _tmp15_;
		RygelMediaContainer* _tmp16_;
		const gchar* _tmp17_;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp10_ = self->children;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp11_ = updated;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp12_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp10_, (RygelMediaObject*) _tmp11_);
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		if (!_tmp12_) {
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
			return;
#line 1782 "rygel-simple-container.c"
		}
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp13_ = updated;
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		rygel_simple_container_remove_child (self, (RygelMediaObject*) _tmp13_);
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp14_ = self->priv->empty_children;
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp15_ = updated;
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, (RygelMediaObject*) _tmp15_);
#line 229 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		rygel_media_container_updated ((RygelMediaContainer*) self);
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp16_ = updated;
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		_tmp17_ = ((RygelMediaObject*) _tmp16_)->id;
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_debug ("rygel-simple-container.vala:231: Container '%s' now empty, removing it" \
" from hierarchy now.", _tmp17_);
#line 1802 "rygel-simple-container.c"
	}
}


static GeeArrayList* rygel_simple_container_real_get_search_classes (RygelSearchableContainer* base) {
	GeeArrayList* result;
	RygelSimpleContainer* self;
	GeeArrayList* _tmp0_;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = self->priv->_search_classes;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	return result;
#line 1819 "rygel-simple-container.c"
}


static void rygel_simple_container_real_set_search_classes (RygelSearchableContainer* base, GeeArrayList* value) {
	RygelSimpleContainer* self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp0_ = value;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	self->priv->_search_classes = _tmp1_;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_object_notify ((GObject *) self, "search-classes");
#line 1839 "rygel-simple-container.c"
}


static void rygel_simple_container_class_init (RygelSimpleContainerClass * klass) {
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	rygel_simple_container_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_type_class_add_private (klass, sizeof (RygelSimpleContainerPrivate));
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_simple_container_real_get_children;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_simple_container_real_get_children_finish;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_simple_container_real_find_object;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_simple_container_real_find_object_finish;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_simple_container_get_property;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_simple_container_set_property;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_simple_container_finalize;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES, "search-classes");
#line 1864 "rygel-simple-container.c"
}


static void rygel_simple_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface) {
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	rygel_simple_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	iface->search = (RygelMediaObjects* (*)(RygelSearchableContainer*, RygelSearchExpression*, guint, guint, guint*, GCancellable*, GError**)) rygel_simple_container_real_search;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	iface->search_finish = rygel_simple_container_real_search_finish;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	iface->get_search_classes = rygel_simple_container_real_get_search_classes;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	iface->set_search_classes = rygel_simple_container_real_set_search_classes;
#line 1879 "rygel-simple-container.c"
}


static void rygel_simple_container_instance_init (RygelSimpleContainer * self) {
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	self->priv = RYGEL_SIMPLE_CONTAINER_GET_PRIVATE (self);
#line 1886 "rygel-simple-container.c"
}


static void rygel_simple_container_finalize (GObject* obj) {
	RygelSimpleContainer * self;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	self = RYGEL_SIMPLE_CONTAINER (obj);
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (self->children);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (self->priv->empty_children);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	G_OBJECT_CLASS (rygel_simple_container_parent_class)->finalize (obj);
#line 1902 "rygel-simple-container.c"
}


/**
 * A simple implementation of MediaContainer that keeps all MediaObjects
 * in memory. In order for it to be of any use, you must add children to
 * children ArrayList field.
 */
GType rygel_simple_container_get_type (void) {
	static volatile gsize rygel_simple_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_simple_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSimpleContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_simple_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSimpleContainer), 0, (GInstanceInitFunc) rygel_simple_container_instance_init, NULL };
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_simple_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_simple_container_type_id;
		rygel_simple_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelSimpleContainer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_simple_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		g_once_init_leave (&rygel_simple_container_type_id__volatile, rygel_simple_container_type_id);
	}
	return rygel_simple_container_type_id__volatile;
}


static void _vala_rygel_simple_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelSimpleContainer * self;
	self = RYGEL_SIMPLE_CONTAINER (object);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		case RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES:
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		break;
#line 1936 "rygel-simple-container.c"
		default:
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		break;
#line 1942 "rygel-simple-container.c"
	}
}


static void _vala_rygel_simple_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelSimpleContainer * self;
	self = RYGEL_SIMPLE_CONTAINER (object);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		case RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES:
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		break;
#line 1958 "rygel-simple-container.c"
		default:
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-simple-container.vala"
		break;
#line 1964 "rygel-simple-container.c"
	}
}



