/* rygel-searchable-container.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-searchable-container.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _RygelSearchableContainerSimpleSearchData RygelSearchableContainerSimpleSearchData;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelSearchableContainerFindObjectData RygelSearchableContainerFindObjectData;
typedef struct _RygelSearchableContainerSearchInChildrenData RygelSearchableContainerSearchInChildrenData;

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	gint64 storage_used;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelSearchableContainerSimpleSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* _result_;
	gint _tmp1_;
	GCancellable* _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* children;
	guint limit;
	gboolean _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	gboolean _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	RygelMediaObjects* _tmp10_;
	RygelMediaObjects* _tmp11_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _child_size;
	gint _child_index;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	RygelMediaObjects* _tmp18_;
	gint _tmp19_;
	gpointer _tmp20_;
	RygelMediaObject* child;
	gboolean _tmp21_;
	RygelSearchExpression* _tmp22_;
	RygelSearchExpression* _tmp23_;
	RygelMediaObject* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	RygelMediaObjects* _tmp27_;
	RygelMediaObject* _tmp28_;
	gboolean _tmp29_;
	guint _tmp30_;
	RygelMediaObjects* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	guint _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	guint _tmp37_;
	RygelMediaObjects* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	guint _tmp41_;
	gboolean _tmp42_;
	guint _tmp43_;
	guint _tmp44_;
	guint _tmp45_;
	RygelMediaObjects* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	guint _tmp49_;
	guint child_limit;
	RygelSearchExpression* _tmp50_;
	RygelMediaObjects* _tmp51_;
	guint _tmp52_;
	GCancellable* _tmp53_;
	RygelMediaObjects* _tmp54_;
	RygelMediaObjects* child_results;
	RygelMediaObjects* _tmp55_;
	RygelMediaObjects* _tmp56_;
	gboolean _tmp57_;
	RygelMediaObjects* _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	guint _tmp61_;
	gboolean _tmp62_;
	guint start;
	guint stop;
	guint _tmp63_;
	RygelMediaObjects* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	guint _tmp67_;
	gboolean _tmp68_;
	guint _tmp69_;
	guint _tmp70_;
	guint _tmp71_;
	RygelMediaObjects* _tmp72_;
	gint _tmp73_;
	gint _tmp74_;
	gboolean _tmp75_;
	guint _tmp76_;
	guint _tmp77_;
	RygelMediaObjects* _tmp78_;
	gint _tmp79_;
	gint _tmp80_;
	RygelMediaObjects* _tmp81_;
	guint _tmp82_;
	guint _tmp83_;
	GeeList* _tmp84_;
	RygelMediaObjects* _tmp85_;
	gint _tmp86_;
	gint _tmp87_;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelSearchableContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelRelationalExpression* _tmp0_;
	RygelRelationalExpression* expression;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	guint total_matches;
	GCancellable* _tmp4_;
	guint _tmp5_;
	RygelMediaObjects* _tmp6_;
	RygelMediaObjects* results;
	gint _tmp7_;
	gint _tmp8_;
	gpointer _tmp9_;
	GError * _inner_error_;
};

struct _RygelSearchableContainerSearchInChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	RygelSearchExpression* expression;
	RygelMediaObjects* children;
	guint limit;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* _result_;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _child_size;
	gint _child_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	RygelMediaObjects* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	RygelMediaObject* child;
	RygelMediaObject* _tmp12_;
	RygelMediaObject* _tmp13_;
	RygelSearchableContainer* _tmp14_;
	RygelSearchableContainer* container;
	guint tmp;
	RygelSearchableContainer* _tmp15_;
	RygelSearchExpression* _tmp16_;
	guint _tmp17_;
	GCancellable* _tmp18_;
	guint _tmp19_;
	RygelMediaObjects* _tmp20_;
	RygelMediaObjects* child_result;
	RygelMediaObjects* _tmp21_;
	RygelMediaObjects* _tmp22_;
	gboolean _tmp23_;
	guint _tmp24_;
	RygelMediaObjects* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	guint _tmp28_;
	gboolean _tmp29_;
	GError * _inner_error_;
};



GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_searchable_container_simple_search_data_free (gpointer _data);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_);
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_search_expression_satisfied_by (RygelSearchExpression* self, RygelMediaObject* media_object);
static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, RygelSearchExpression* expression, RygelMediaObjects* children, guint limit, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_searchable_container_find_object_data_free (gpointer _data);
void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_searchable_container_search_in_children_data_free (gpointer _data);
static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_);
static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value);


void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search (self, expression, offset, max_count, cancellable, _callback_, _user_data_);
#line 423 "rygel-searchable-container.c"
}


RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search_finish (self, _res_, total_matches, error);
#line 430 "rygel-searchable-container.c"
}


static void rygel_searchable_container_simple_search_data_free (gpointer _data) {
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerSimpleSearchData, _data_);
#line 447 "rygel-searchable-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 454 "rygel-searchable-container.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 461 "rygel-searchable-container.c"
}


void rygel_searchable_container_simple_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
	RygelSearchableContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerSimpleSearchData);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_searchable_container_simple_search);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_simple_search_data_free);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp1_ = expression;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->expression = _tmp2_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp3_ = offset;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->offset = _tmp3_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp4_ = max_count;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->max_count = _tmp4_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp5_ = cancellable;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->cancellable = _tmp6_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	rygel_searchable_container_simple_search_co (_data_);
#line 506 "rygel-searchable-container.c"
}


RygelMediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelSearchableContainerSimpleSearchData* _data_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		return NULL;
#line 517 "rygel-searchable-container.c"
	}
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (total_matches) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		*total_matches = _data_->total_matches;
#line 525 "rygel-searchable-container.c"
	}
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	return result;
#line 533 "rygel-searchable-container.c"
}


/**
     * Utility method that retrieves all children and recursively searches for
     * all media objects that satisfy the given search expression in this
     * container.
     *
     * @param expression the search expression or `null` for wildcard
     * @param offet zero-based index of the first object to return
     * @param max_count maximum number of objects to return
     * @param total_matches sets it to the actual number of objects that satisfy
     *                      the given search expression. If it is not possible
     *                      to compute this value (in a timely mannger), it is
     *                      set to '0'.
     * @param cancellable optional cancellable for this operation
     *
     * return A list of media objects.
     */
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	rygel_searchable_container_simple_search_co (_data_);
#line 563 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_) {
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		case 0:
#line 572 "rygel-searchable-container.c"
		goto _state_0;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		case 1:
#line 576 "rygel-searchable-container.c"
		goto _state_1;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		case 2:
#line 580 "rygel-searchable-container.c"
		goto _state_2;
		default:
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 585 "rygel-searchable-container.c"
	}
	_state_0:
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp0_ = rygel_media_objects_new ();
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp1_ = ((RygelMediaContainer*) _data_->self)->child_count;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp2_ = _data_->cancellable;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_state_ = 1;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	rygel_media_container_get_children ((RygelMediaContainer*) _data_->self, (guint) 0, (guint) _data_->_tmp1_, _data_->_tmp2_, rygel_searchable_container_simple_search_ready, _data_);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	return FALSE;
#line 602 "rygel-searchable-container.c"
	_state_1:
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp3_ = NULL;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp3_ = rygel_media_container_get_children_finish ((RygelMediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error_);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->children = _data_->_tmp3_;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_error_free (_data_->_inner_error_);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 622 "rygel-searchable-container.c"
		} else {
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 626 "rygel-searchable-container.c"
		}
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		return FALSE;
#line 632 "rygel-searchable-container.c"
	}
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp5_ = _data_->offset;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (_data_->_tmp5_ > ((guint) 0)) {
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp4_ = TRUE;
#line 640 "rygel-searchable-container.c"
	} else {
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp6_ = _data_->max_count;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp4_ = _data_->_tmp6_ > ((guint) 0);
#line 646 "rygel-searchable-container.c"
	}
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp7_ = _data_->_tmp4_;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (_data_->_tmp7_) {
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp8_ = _data_->offset;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp9_ = _data_->max_count;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->limit = _data_->_tmp8_ + _data_->_tmp9_;
#line 658 "rygel-searchable-container.c"
	} else {
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->limit = (guint) 0;
#line 662 "rygel-searchable-container.c"
	}
	{
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp10_ = _data_->children;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp11_ = _g_object_ref0 (_data_->_tmp10_);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_child_list = _data_->_tmp11_;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp12_ = _data_->_child_list;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp13_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp12_);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_child_size = _data_->_tmp14_;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_child_index = -1;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		while (TRUE) {
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp15_ = _data_->_child_index;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_child_index = _data_->_tmp15_ + 1;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp16_ = _data_->_child_index;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp17_ = _data_->_child_size;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			if (!(_data_->_tmp16_ < _data_->_tmp17_)) {
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				break;
#line 695 "rygel-searchable-container.c"
			}
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp18_ = _data_->_child_list;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp19_ = _data_->_child_index;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp20_ = NULL;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp18_, _data_->_tmp19_);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->child = (RygelMediaObject*) _data_->_tmp20_;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp22_ = _data_->expression;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			if (_data_->_tmp22_ == NULL) {
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp21_ = TRUE;
#line 713 "rygel-searchable-container.c"
			} else {
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp23_ = _data_->expression;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp24_ = _data_->child;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp25_ = FALSE;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp25_ = rygel_search_expression_satisfied_by (_data_->_tmp23_, _data_->_tmp24_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp21_ = _data_->_tmp25_;
#line 725 "rygel-searchable-container.c"
			}
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp26_ = _data_->_tmp21_;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			if (_data_->_tmp26_) {
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp27_ = _data_->_result_;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp28_ = _data_->child;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp27_, _data_->_tmp28_);
#line 737 "rygel-searchable-container.c"
			}
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp30_ = _data_->limit;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			if (_data_->_tmp30_ > ((guint) 0)) {
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp31_ = _data_->_result_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp32_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp31_);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp33_ = _data_->_tmp32_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp34_ = _data_->limit;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp29_ = ((guint) _data_->_tmp33_) >= _data_->_tmp34_;
#line 753 "rygel-searchable-container.c"
			} else {
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp29_ = FALSE;
#line 757 "rygel-searchable-container.c"
			}
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp35_ = _data_->_tmp29_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			if (_data_->_tmp35_) {
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child);
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				break;
#line 767 "rygel-searchable-container.c"
			}
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->child);
#line 771 "rygel-searchable-container.c"
		}
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_child_list);
#line 775 "rygel-searchable-container.c"
	}
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp37_ = _data_->limit;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (_data_->_tmp37_ == ((guint) 0)) {
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp36_ = TRUE;
#line 783 "rygel-searchable-container.c"
	} else {
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp38_ = _data_->_result_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp39_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp38_);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp40_ = _data_->_tmp39_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp41_ = _data_->limit;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp36_ = ((guint) _data_->_tmp40_) < _data_->_tmp41_;
#line 795 "rygel-searchable-container.c"
	}
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp42_ = _data_->_tmp36_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (_data_->_tmp42_) {
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp44_ = _data_->limit;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		if (_data_->_tmp44_ == ((guint) 0)) {
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp43_ = (guint) 0;
#line 807 "rygel-searchable-container.c"
		} else {
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp45_ = _data_->limit;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp46_ = _data_->_result_;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp47_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp46_);
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp48_ = _data_->_tmp47_;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp43_ = _data_->_tmp45_ - _data_->_tmp48_;
#line 819 "rygel-searchable-container.c"
		}
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp49_ = _data_->_tmp43_;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->child_limit = _data_->_tmp49_;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp50_ = _data_->expression;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp51_ = _data_->children;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp52_ = _data_->child_limit;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp53_ = _data_->cancellable;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_state_ = 2;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		rygel_searchable_container_search_in_children (_data_->self, _data_->_tmp50_, _data_->_tmp51_, _data_->_tmp52_, _data_->_tmp53_, rygel_searchable_container_simple_search_ready, _data_);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		return FALSE;
#line 839 "rygel-searchable-container.c"
		_state_2:
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp54_ = NULL;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp54_ = rygel_searchable_container_search_in_children_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->child_results = _data_->_tmp54_;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_error_free (_data_->_inner_error_);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->children);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->_result_);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			if (_data_->_state_ == 0) {
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 861 "rygel-searchable-container.c"
			} else {
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 865 "rygel-searchable-container.c"
			}
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_object_unref (_data_->_async_result);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			return FALSE;
#line 871 "rygel-searchable-container.c"
		}
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp55_ = _data_->_result_;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp56_ = _data_->child_results;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		gee_abstract_collection_add_all ((GeeAbstractCollection*) _data_->_tmp55_, (GeeCollection*) _data_->_tmp56_);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->child_results);
#line 881 "rygel-searchable-container.c"
	}
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp58_ = _data_->_result_;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp59_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp58_);
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp60_ = _data_->_tmp59_;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (_data_->_tmp60_ > 0) {
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp61_ = _data_->limit;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp57_ = _data_->_tmp61_ > ((guint) 0);
#line 895 "rygel-searchable-container.c"
	} else {
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp57_ = FALSE;
#line 899 "rygel-searchable-container.c"
	}
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp62_ = _data_->_tmp57_;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (_data_->_tmp62_) {
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp63_ = _data_->offset;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp64_ = _data_->_result_;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp65_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp64_);
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp66_ = _data_->_tmp65_;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp67_ = 0U;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp67_ = CLAMP (_data_->_tmp63_, (guint) 0, (guint) (_data_->_tmp66_ - 1));
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->start = _data_->_tmp67_;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp69_ = _data_->max_count;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		if (_data_->_tmp69_ != ((guint) 0)) {
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp70_ = _data_->start;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp71_ = _data_->max_count;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp72_ = _data_->_result_;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp73_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp72_);
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp74_ = _data_->_tmp73_;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp68_ = (_data_->_tmp70_ + _data_->_tmp71_) <= ((guint) _data_->_tmp74_);
#line 935 "rygel-searchable-container.c"
		} else {
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp68_ = FALSE;
#line 939 "rygel-searchable-container.c"
		}
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp75_ = _data_->_tmp68_;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		if (_data_->_tmp75_) {
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp76_ = _data_->start;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp77_ = _data_->max_count;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->stop = _data_->_tmp76_ + _data_->_tmp77_;
#line 951 "rygel-searchable-container.c"
		} else {
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp78_ = _data_->_result_;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp79_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp78_);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp80_ = _data_->_tmp79_;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->stop = (guint) _data_->_tmp80_;
#line 961 "rygel-searchable-container.c"
		}
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->total_matches = (guint) 0;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp81_ = _data_->_result_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp82_ = _data_->start;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp83_ = _data_->stop;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp84_ = NULL;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp84_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp81_, (gint) _data_->_tmp82_, (gint) _data_->_tmp83_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->result = RYGEL_IS_MEDIA_OBJECTS (_data_->_tmp84_) ? ((RygelMediaObjects*) _data_->_tmp84_) : NULL;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->children);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 985 "rygel-searchable-container.c"
		} else {
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 989 "rygel-searchable-container.c"
		}
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		return FALSE;
#line 995 "rygel-searchable-container.c"
	} else {
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp85_ = _data_->_result_;
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp86_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp85_);
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp87_ = _data_->_tmp86_;
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->total_matches = (guint) _data_->_tmp87_;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->result = _data_->_result_;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->children);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1013 "rygel-searchable-container.c"
		} else {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1017 "rygel-searchable-container.c"
		}
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		return FALSE;
#line 1023 "rygel-searchable-container.c"
	}
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->_result_);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1033 "rygel-searchable-container.c"
	} else {
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1037 "rygel-searchable-container.c"
	}
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	return FALSE;
#line 1043 "rygel-searchable-container.c"
}


static void rygel_searchable_container_find_object_data_free (gpointer _data) {
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_free0 (_data_->id);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerFindObjectData, _data_);
#line 1060 "rygel-searchable-container.c"
}


void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
	RygelSearchableContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerFindObjectData);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_searchable_container_find_object);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_find_object_data_free);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp1_ = id;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->id = _tmp2_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp3_ = cancellable;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->cancellable = _tmp4_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	rygel_searchable_container_find_object_co (_data_);
#line 1095 "rygel-searchable-container.c"
}


RygelMediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelSearchableContainerFindObjectData* _data_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		return NULL;
#line 1106 "rygel-searchable-container.c"
	}
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	return result;
#line 1116 "rygel-searchable-container.c"
}


/**
     * Recursively searches for media object with the given id in this
     * container.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     * @param callback function to call when result is ready
     *
     * return the found media object.
     */
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	rygel_searchable_container_find_object_co (_data_);
#line 1140 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_) {
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		case 0:
#line 1149 "rygel-searchable-container.c"
		goto _state_0;
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		case 1:
#line 1153 "rygel-searchable-container.c"
		goto _state_1;
		default:
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 1158 "rygel-searchable-container.c"
	}
	_state_0:
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp0_ = rygel_relational_expression_new ();
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->expression = _data_->_tmp0_;
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	((RygelSearchExpression*) _data_->expression)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp1_ = g_strdup ("@id");
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand1);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	((RygelSearchExpression*) _data_->expression)->operand1 = _data_->_tmp1_;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp2_ = _data_->id;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand2);
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	((RygelSearchExpression*) _data_->expression)->operand2 = _data_->_tmp3_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp4_ = _data_->cancellable;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp5_ = 0U;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_state_ = 1;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	rygel_searchable_container_search (_data_->self, (RygelSearchExpression*) _data_->expression, (guint) 0, (guint) 1, _data_->_tmp4_, rygel_searchable_container_find_object_ready, _data_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	return FALSE;
#line 1191 "rygel-searchable-container.c"
	_state_1:
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp6_ = NULL;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp6_ = rygel_searchable_container_search_finish (_data_->self, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->total_matches = _data_->_tmp5_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->results = _data_->_tmp6_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_error_free (_data_->_inner_error_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1213 "rygel-searchable-container.c"
		} else {
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1217 "rygel-searchable-container.c"
		}
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		return FALSE;
#line 1223 "rygel-searchable-container.c"
	}
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp7_ = gee_collection_get_size ((GeeCollection*) _data_->results);
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (_data_->_tmp8_ > 0) {
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp9_ = NULL;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _data_->results, 0);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->result = (RygelMediaObject*) _data_->_tmp9_;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->results);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1245 "rygel-searchable-container.c"
		} else {
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1249 "rygel-searchable-container.c"
		}
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		return FALSE;
#line 1255 "rygel-searchable-container.c"
	} else {
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->result = NULL;
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->results);
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1267 "rygel-searchable-container.c"
		} else {
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1271 "rygel-searchable-container.c"
		}
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		return FALSE;
#line 1277 "rygel-searchable-container.c"
	}
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->results);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1287 "rygel-searchable-container.c"
	} else {
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1291 "rygel-searchable-container.c"
	}
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	return FALSE;
#line 1297 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children_data_free (gpointer _data) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerSearchInChildrenData, _data_);
#line 1316 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, RygelSearchExpression* expression, RygelMediaObjects* children, guint limit, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	RygelSearchableContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* _tmp4_;
	guint _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerSearchInChildrenData);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_searchable_container_search_in_children);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_search_in_children_data_free);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp1_ = expression;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->expression = _tmp2_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp3_ = children;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->children = _tmp4_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp5_ = limit;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->limit = _tmp5_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp6_ = cancellable;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->cancellable = _tmp7_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	rygel_searchable_container_search_in_children_co (_data_);
#line 1364 "rygel-searchable-container.c"
}


static RygelMediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelSearchableContainerSearchInChildrenData* _data_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		return NULL;
#line 1375 "rygel-searchable-container.c"
	}
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	return result;
#line 1385 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	rygel_searchable_container_search_in_children_co (_data_);
#line 1399 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_) {
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		case 0:
#line 1408 "rygel-searchable-container.c"
		goto _state_0;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		case 1:
#line 1412 "rygel-searchable-container.c"
		goto _state_1;
		default:
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 1417 "rygel-searchable-container.c"
	}
	_state_0:
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_tmp0_ = rygel_media_objects_new ();
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 1424 "rygel-searchable-container.c"
	{
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp1_ = _data_->children;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_child_list = _data_->_tmp2_;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp3_ = _data_->_child_list;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp4_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_child_size = _data_->_tmp5_;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_data_->_child_index = -1;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		while (TRUE) {
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp6_ = _data_->_child_index;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_child_index = _data_->_tmp6_ + 1;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp7_ = _data_->_child_index;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp8_ = _data_->_child_size;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				break;
#line 1456 "rygel-searchable-container.c"
			}
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp9_ = _data_->_child_list;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp10_ = _data_->_child_index;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp11_ = NULL;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->child = (RygelMediaObject*) _data_->_tmp11_;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp12_ = _data_->child;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			if (RYGEL_IS_SEARCHABLE_CONTAINER (_data_->_tmp12_)) {
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp13_ = _data_->child;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp14_ = _g_object_ref0 (RYGEL_IS_SEARCHABLE_CONTAINER (_data_->_tmp13_) ? ((RygelSearchableContainer*) _data_->_tmp13_) : NULL);
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->container = _data_->_tmp14_;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp15_ = _data_->container;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp16_ = _data_->expression;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp17_ = _data_->limit;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp18_ = _data_->cancellable;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp19_ = 0U;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_state_ = 1;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				rygel_searchable_container_search (_data_->_tmp15_, _data_->_tmp16_, (guint) 0, _data_->_tmp17_, _data_->_tmp18_, rygel_searchable_container_search_in_children_ready, _data_);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				return FALSE;
#line 1494 "rygel-searchable-container.c"
				_state_1:
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp20_ = NULL;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp20_ = rygel_searchable_container_search_finish (_data_->_tmp15_, _data_->_res_, &_data_->_tmp19_, &_data_->_inner_error_);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->tmp = _data_->_tmp19_;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->child_result = _data_->_tmp20_;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				if (_data_->_inner_error_ != NULL) {
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
					g_error_free (_data_->_inner_error_);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->container);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->child);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->_child_list);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->_result_);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
					if (_data_->_state_ == 0) {
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1522 "rygel-searchable-container.c"
					} else {
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 1526 "rygel-searchable-container.c"
					}
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
					g_object_unref (_data_->_async_result);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
					return FALSE;
#line 1532 "rygel-searchable-container.c"
				}
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp21_ = _data_->_result_;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp22_ = _data_->child_result;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				gee_abstract_collection_add_all ((GeeAbstractCollection*) _data_->_tmp21_, (GeeCollection*) _data_->_tmp22_);
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child_result);
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->container);
#line 1544 "rygel-searchable-container.c"
			}
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp24_ = _data_->limit;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			if (_data_->_tmp24_ > ((guint) 0)) {
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp25_ = _data_->_result_;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp26_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp25_);
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp27_ = _data_->_tmp26_;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp28_ = _data_->limit;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp23_ = ((guint) _data_->_tmp27_) >= _data_->_tmp28_;
#line 1560 "rygel-searchable-container.c"
			} else {
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_data_->_tmp23_ = FALSE;
#line 1564 "rygel-searchable-container.c"
			}
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_data_->_tmp29_ = _data_->_tmp23_;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			if (_data_->_tmp29_) {
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				break;
#line 1574 "rygel-searchable-container.c"
			}
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->child);
#line 1578 "rygel-searchable-container.c"
		}
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_child_list);
#line 1582 "rygel-searchable-container.c"
	}
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_data_->result = _data_->_result_;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1590 "rygel-searchable-container.c"
	} else {
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1594 "rygel-searchable-container.c"
	}
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	return FALSE;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->_result_);
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1606 "rygel-searchable-container.c"
	} else {
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1610 "rygel-searchable-container.c"
	}
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	return FALSE;
#line 1616 "rygel-searchable-container.c"
}


void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container) {
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	g_return_if_fail (didl_container != NULL);
#line 1623 "rygel-searchable-container.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _search_class_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _search_class_size;
		gint _search_class_index;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_tmp0_ = rygel_searchable_container_get_search_classes (self);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_tmp1_ = _tmp0_;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_search_class_list = _tmp2_;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_tmp3_ = _search_class_list;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_tmp5_ = _tmp4_;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_search_class_size = _tmp5_;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_search_class_index = -1;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		while (TRUE) {
#line 1654 "rygel-searchable-container.c"
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			gchar* search_class;
			GUPnPDIDLLiteContainer* _tmp12_;
			const gchar* _tmp13_;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_tmp6_ = _search_class_index;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_search_class_index = _tmp6_ + 1;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_tmp7_ = _search_class_index;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_tmp8_ = _search_class_size;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
				break;
#line 1676 "rygel-searchable-container.c"
			}
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_tmp9_ = _search_class_list;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_tmp10_ = _search_class_index;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			search_class = (gchar*) _tmp11_;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_tmp12_ = didl_container;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_tmp13_ = search_class;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			gupnp_didl_lite_container_add_search_class (_tmp12_, _tmp13_);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
			_g_free0 (search_class);
#line 1694 "rygel-searchable-container.c"
		}
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		_g_object_unref0 (_search_class_list);
#line 1698 "rygel-searchable-container.c"
	}
}


GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self) {
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->get_search_classes (self);
#line 1708 "rygel-searchable-container.c"
}


void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value) {
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	g_return_if_fail (self != NULL);
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->set_search_classes (self, value);
#line 1717 "rygel-searchable-container.c"
}


static void rygel_searchable_container_base_init (RygelSearchableContainerIface * iface) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	static gboolean initialized = FALSE;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
	if (!initialized) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		initialized = TRUE;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-searchable-container.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1730 "rygel-searchable-container.c"
	}
}


GType rygel_searchable_container_get_type (void) {
	static volatile gsize rygel_searchable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_searchable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchableContainerIface), (GBaseInitFunc) rygel_searchable_container_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_searchable_container_type_id;
		rygel_searchable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelSearchableContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_searchable_container_type_id, RYGEL_TYPE_MEDIA_CONTAINER);
		g_once_init_leave (&rygel_searchable_container_type_id__volatile, rygel_searchable_container_type_id);
	}
	return rygel_searchable_container_type_id__volatile;
}



