/* rygel-rendering-control.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-rendering-control.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_RENDERING_CONTROL (rygel_rendering_control_get_type ())
#define RYGEL_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl))
#define RYGEL_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))
#define RYGEL_IS_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_IS_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_RENDERING_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))

typedef struct _RygelRenderingControl RygelRenderingControl;
typedef struct _RygelRenderingControlClass RygelRenderingControlClass;
typedef struct _RygelRenderingControlPrivate RygelRenderingControlPrivate;

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;

struct _RygelRenderingControl {
	GUPnPService parent_instance;
	RygelRenderingControlPrivate * priv;
};

struct _RygelRenderingControlClass {
	GUPnPServiceClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, GstClockTime time);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_position) (RygelMediaPlayer* self);
};

struct _RygelRenderingControlPrivate {
	gboolean _mute;
	guint _volume;
	gchar* preset_name_list;
	RygelChangeLog* changelog;
	RygelMediaPlayer* player;
};


static gpointer rygel_rendering_control_parent_class = NULL;

GType rygel_rendering_control_get_type (void) G_GNUC_CONST;
GType rygel_change_log_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
#define RYGEL_RENDERING_CONTROL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlPrivate))
enum  {
	RYGEL_RENDERING_CONTROL_DUMMY_PROPERTY,
	RYGEL_RENDERING_CONTROL_MUTE,
	RYGEL_RENDERING_CONTROL_VOLUME
};
#define RYGEL_RENDERING_CONTROL_UPNP_ID "urn:upnp-org:serviceId:RenderingControl"
#define RYGEL_RENDERING_CONTROL_UPNP_TYPE "urn:schemas-upnp-org:service:RenderingControl:2"
#define RYGEL_RENDERING_CONTROL_DESCRIPTION_PATH "xml/RenderingControl2.xml"
#define RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/RCS/"
static void rygel_rendering_control_real_constructed (GObject* base);
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const gchar* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const gchar* service_ns);
static RygelMediaPlayer* rygel_rendering_control_get_player (RygelRenderingControl* self);
static void rygel_rendering_control_query_last_change_cb (RygelRenderingControl* self, GUPnPService* service, const gchar* variable, GValue* value);
static void _rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_rendering_control_list_presets_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_select_preset_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_get_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_set_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_get_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_set_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
guint rygel_volume_to_percentage (gdouble volume);
gdouble rygel_media_player_get_volume (RygelMediaPlayer* self);
gboolean rygel_rendering_control_get_mute (RygelRenderingControl* self);
void rygel_change_log_log_with_channel (RygelChangeLog* self, const gchar* variable, const gchar* value, const gchar* channel);
guint rygel_rendering_control_get_volume (RygelRenderingControl* self);
gchar* rygel_change_log_finish (RygelChangeLog* self);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
static gboolean rygel_rendering_control_check_instance_id (RygelRenderingControl* self, GUPnPServiceAction* action);
static gboolean rygel_rendering_control_check_channel (RygelRenderingControl* self, GUPnPServiceAction* action);
void rygel_rendering_control_set_mute (RygelRenderingControl* self, gboolean value);
void rygel_rendering_control_set_volume (RygelRenderingControl* self, guint value);
RygelRenderingControl* rygel_rendering_control_new (void);
RygelRenderingControl* rygel_rendering_control_construct (GType object_type);
void rygel_media_player_set_volume (RygelMediaPlayer* self, gdouble value);
gdouble rygel_volume_from_percentage (guint percentage);
static void rygel_rendering_control_finalize (GObject* obj);
static void _vala_rygel_rendering_control_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_rendering_control_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	rygel_rendering_control_query_last_change_cb (self, _sender, variable, value);
#line 181 "rygel-rendering-control.c"
}


static void _rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	rygel_rendering_control_list_presets_cb (self, _sender, action);
#line 188 "rygel-rendering-control.c"
}


static void _rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	rygel_rendering_control_select_preset_cb (self, _sender, action);
#line 195 "rygel-rendering-control.c"
}


static void _rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	rygel_rendering_control_get_mute_cb (self, _sender, action);
#line 202 "rygel-rendering-control.c"
}


static void _rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	rygel_rendering_control_set_mute_cb (self, _sender, action);
#line 209 "rygel-rendering-control.c"
}


static void _rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	rygel_rendering_control_get_volume_cb (self, _sender, action);
#line 216 "rygel-rendering-control.c"
}


static void _rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	rygel_rendering_control_set_volume_cb (self, _sender, action);
#line 223 "rygel-rendering-control.c"
}


static void rygel_rendering_control_real_constructed (GObject* base) {
	RygelRenderingControl * self;
	RygelChangeLog* _tmp0_;
	RygelMediaPlayer* _tmp1_ = NULL;
	RygelMediaPlayer* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	guint _tmp5_ = 0U;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	self = (RygelRenderingControl*) base;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = rygel_change_log_new ((GUPnPService*) self, RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_g_object_unref0 (self->priv->changelog);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	self->priv->changelog = _tmp0_;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_get_player (self);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_g_object_unref0 (self->priv->player);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	self->priv->player = _tmp1_;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable, self, 0);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::ListPresets", (GCallback) _rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked, self, 0);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SelectPreset", (GCallback) _rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked, self, 0);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMute", (GCallback) _rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked, self, 0);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetMute", (GCallback) _rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked, self, 0);
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetVolume", (GCallback) _rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked, self, 0);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetVolume", (GCallback) _rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked, self, 0);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp2_ = self->priv->player;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp3_ = rygel_media_player_get_volume (_tmp2_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp4_ = _tmp3_;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp5_ = rygel_volume_to_percentage (_tmp4_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	self->priv->_volume = _tmp5_;
#line 273 "rygel-rendering-control.c"
}


static void rygel_rendering_control_query_last_change_cb (RygelRenderingControl* self, GUPnPService* service, const gchar* variable, GValue* value) {
	RygelChangeLog* _tmp0_;
	RygelChangeLog* log;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean _tmp3_;
	RygelChangeLog* _tmp4_;
	const gchar* _tmp5_;
	RygelChangeLog* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	RygelChangeLog* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (variable != NULL);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (value != NULL);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = rygel_change_log_new (NULL, RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	log = _tmp0_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp2_ = rygel_rendering_control_get_mute (self);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp3_ = _tmp2_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (_tmp3_) {
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp1_ = "1";
#line 313 "rygel-rendering-control.c"
	} else {
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp1_ = "0";
#line 317 "rygel-rendering-control.c"
	}
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp4_ = log;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp5_ = _tmp1_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	rygel_change_log_log_with_channel (_tmp4_, "Mute", _tmp5_, "Master");
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp6_ = log;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp7_ = rygel_rendering_control_get_volume (self);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp8_ = _tmp7_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp9_ = g_strdup_printf ("%u", _tmp8_);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp10_ = _tmp9_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	rygel_change_log_log_with_channel (_tmp6_, "Volume", _tmp10_, "Master");
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_g_free0 (_tmp10_);
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_value_init (value, G_TYPE_STRING);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp11_ = log;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp12_ = rygel_change_log_finish (_tmp11_);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp13_ = _tmp12_;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_value_set_string (value, _tmp13_);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_g_free0 (_tmp13_);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_g_object_unref0 (log);
#line 353 "rygel-rendering-control.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	return self ? g_object_ref (self) : NULL;
#line 360 "rygel-rendering-control.c"
}


static RygelMediaPlayer* rygel_rendering_control_get_player (RygelRenderingControl* self) {
	RygelMediaPlayer* result = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelMediaRendererPlugin* _tmp5_;
	RygelMediaRendererPlugin* _tmp6_;
	RygelMediaRendererPlugin* plugin;
	RygelMediaPlayer* _tmp7_ = NULL;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp1_ = _tmp0_;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp2_ = _tmp1_;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp4_ = _tmp3_;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp5_ = _g_object_ref0 (RYGEL_IS_MEDIA_RENDERER_PLUGIN (_tmp4_) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp6_ = _tmp5_;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_g_object_unref0 (_tmp2_);
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	plugin = _tmp6_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp7_ = rygel_media_renderer_plugin_get_player (plugin);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	result = _tmp7_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_g_object_unref0 (plugin);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	return result;
#line 403 "rygel-rendering-control.c"
}


static gboolean rygel_rendering_control_check_instance_id (RygelRenderingControl* self, GUPnPServiceAction* action) {
	gboolean result = FALSE;
	guint instance_id = 0U;
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	gupnp_service_action_get (_tmp0_, "InstanceID", G_TYPE_UINT, &instance_id, NULL);
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp1_ = instance_id;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 424 "rygel-rendering-control.c"
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp2_ = action;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp3_ = _ ("Invalid InstanceID");
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 702, _tmp3_);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		result = FALSE;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		return result;
#line 437 "rygel-rendering-control.c"
	}
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	result = TRUE;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	return result;
#line 443 "rygel-rendering-control.c"
}


static void rygel_rendering_control_list_presets_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	GUPnPServiceAction* _tmp4_;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_check_instance_id (self, _tmp0_);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (!_tmp1_) {
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		return;
#line 467 "rygel-rendering-control.c"
	}
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp2_ = action;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp3_ = self->priv->preset_name_list;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	gupnp_service_action_set (_tmp2_, "CurrentPresetNameList", G_TYPE_STRING, _tmp3_, NULL);
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp4_ = action;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	gupnp_service_action_return (_tmp4_);
#line 479 "rygel-rendering-control.c"
}


static void rygel_rendering_control_select_preset_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* preset_name = NULL;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	GUPnPServiceAction* _tmp6_;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_check_instance_id (self, _tmp0_);
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (!_tmp1_) {
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		return;
#line 504 "rygel-rendering-control.c"
	}
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp2_ = action;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	gupnp_service_action_get (_tmp2_, "PresetName", G_TYPE_STRING, &preset_name, NULL);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp3_ = preset_name;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (g_strcmp0 (_tmp3_, "") != 0) {
#line 514 "rygel-rendering-control.c"
		GUPnPServiceAction* _tmp4_;
		const gchar* _tmp5_ = NULL;
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp4_ = action;
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp5_ = _ ("Invalid Name");
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		gupnp_service_action_return_error (_tmp4_, (guint) 701, _tmp5_);
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_g_free0 (preset_name);
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		return;
#line 527 "rygel-rendering-control.c"
	}
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp6_ = action;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	gupnp_service_action_return (_tmp6_);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_g_free0 (preset_name);
#line 535 "rygel-rendering-control.c"
}


static gboolean rygel_rendering_control_check_channel (RygelRenderingControl* self, GUPnPServiceAction* action) {
	gboolean result = FALSE;
	gchar* channel = NULL;
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	gupnp_service_action_get (_tmp0_, "Channel", G_TYPE_STRING, &channel, NULL);
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp1_ = channel;
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (g_strcmp0 (_tmp1_, "Master") != 0) {
#line 556 "rygel-rendering-control.c"
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp2_ = action;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp3_ = _ ("Action Failed");
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 501, _tmp3_);
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		result = FALSE;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_g_free0 (channel);
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		return result;
#line 571 "rygel-rendering-control.c"
	}
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	result = TRUE;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_g_free0 (channel);
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	return result;
#line 579 "rygel-rendering-control.c"
}


static void rygel_rendering_control_get_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GUPnPServiceAction* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GUPnPServiceAction* _tmp7_;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_check_instance_id (self, _tmp0_);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (!_tmp1_) {
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		return;
#line 606 "rygel-rendering-control.c"
	}
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp2_ = action;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp3_ = rygel_rendering_control_check_channel (self, _tmp2_);
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (!_tmp3_) {
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		return;
#line 616 "rygel-rendering-control.c"
	}
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp4_ = action;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp5_ = rygel_rendering_control_get_mute (self);
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp6_ = _tmp5_;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	gupnp_service_action_set (_tmp4_, "CurrentMute", G_TYPE_BOOLEAN, _tmp6_, NULL);
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp7_ = action;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	gupnp_service_action_return (_tmp7_);
#line 630 "rygel-rendering-control.c"
}


static void rygel_rendering_control_set_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean mute = FALSE;
	GUPnPServiceAction* _tmp4_;
	gboolean _tmp5_;
	GUPnPServiceAction* _tmp6_;
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_check_instance_id (self, _tmp0_);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (!_tmp1_) {
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		return;
#line 657 "rygel-rendering-control.c"
	}
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp2_ = action;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp3_ = rygel_rendering_control_check_channel (self, _tmp2_);
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (!_tmp3_) {
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		return;
#line 667 "rygel-rendering-control.c"
	}
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp4_ = action;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	gupnp_service_action_get (_tmp4_, "DesiredMute", G_TYPE_BOOLEAN, &mute, NULL);
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp5_ = mute;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	rygel_rendering_control_set_mute (self, _tmp5_);
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp6_ = action;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	gupnp_service_action_return (_tmp6_);
#line 681 "rygel-rendering-control.c"
}


static void rygel_rendering_control_get_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GUPnPServiceAction* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GUPnPServiceAction* _tmp7_;
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_check_instance_id (self, _tmp0_);
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (!_tmp1_) {
#line 211 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		return;
#line 708 "rygel-rendering-control.c"
	}
#line 214 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp2_ = action;
#line 214 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp3_ = rygel_rendering_control_check_channel (self, _tmp2_);
#line 214 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (!_tmp3_) {
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		return;
#line 718 "rygel-rendering-control.c"
	}
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp4_ = action;
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp5_ = rygel_rendering_control_get_volume (self);
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp6_ = _tmp5_;
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	gupnp_service_action_set (_tmp4_, "CurrentVolume", G_TYPE_UINT, _tmp6_, NULL);
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp7_ = action;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	gupnp_service_action_return (_tmp7_);
#line 732 "rygel-rendering-control.c"
}


static void rygel_rendering_control_set_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	gboolean _tmp3_ = FALSE;
	guint volume = 0U;
	GUPnPServiceAction* _tmp4_;
	guint _tmp5_;
	guint _tmp8_;
	GUPnPServiceAction* _tmp9_;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_check_instance_id (self, _tmp0_);
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (!_tmp1_) {
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		return;
#line 760 "rygel-rendering-control.c"
	}
#line 229 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp2_ = action;
#line 229 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp3_ = rygel_rendering_control_check_channel (self, _tmp2_);
#line 229 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (!_tmp3_) {
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		return;
#line 770 "rygel-rendering-control.c"
	}
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp4_ = action;
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	gupnp_service_action_get (_tmp4_, "DesiredVolume", G_TYPE_UINT, &volume, NULL);
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp5_ = volume;
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (_tmp5_ > ((guint) 100)) {
#line 780 "rygel-rendering-control.c"
		GUPnPServiceAction* _tmp6_;
		const gchar* _tmp7_ = NULL;
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp6_ = action;
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp7_ = _ ("Action Failed");
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		gupnp_service_action_return_error (_tmp6_, (guint) 501, _tmp7_);
#line 239 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		return;
#line 791 "rygel-rendering-control.c"
	}
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp8_ = volume;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	rygel_rendering_control_set_volume (self, _tmp8_);
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp9_ = action;
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	gupnp_service_action_return (_tmp9_);
#line 801 "rygel-rendering-control.c"
}


RygelRenderingControl* rygel_rendering_control_construct (GType object_type) {
	RygelRenderingControl * self = NULL;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	self = (RygelRenderingControl*) g_object_new (object_type, NULL);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	return self;
#line 811 "rygel-rendering-control.c"
}


RygelRenderingControl* rygel_rendering_control_new (void) {
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	return rygel_rendering_control_construct (RYGEL_TYPE_RENDERING_CONTROL);
#line 818 "rygel-rendering-control.c"
}


gboolean rygel_rendering_control_get_mute (RygelRenderingControl* self) {
	gboolean result;
	gboolean _tmp0_;
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = self->priv->_mute;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	return result;
#line 833 "rygel-rendering-control.c"
}


void rygel_rendering_control_set_mute (RygelRenderingControl* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_;
	gboolean _tmp9_;
	RygelChangeLog* _tmp10_;
	const gchar* _tmp11_;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = value;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	self->priv->_mute = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp1_ = self->priv->_mute;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (_tmp1_) {
#line 855 "rygel-rendering-control.c"
		RygelMediaPlayer* _tmp2_;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp2_ = self->priv->player;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		rygel_media_player_set_volume (_tmp2_, (gdouble) 0);
#line 861 "rygel-rendering-control.c"
	} else {
		RygelMediaPlayer* _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		gdouble _tmp6_ = 0.0;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp3_ = self->priv->player;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp4_ = rygel_rendering_control_get_volume (self);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp5_ = _tmp4_;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp6_ = rygel_volume_from_percentage (_tmp5_);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		rygel_media_player_set_volume (_tmp3_, _tmp6_);
#line 877 "rygel-rendering-control.c"
	}
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp8_ = rygel_rendering_control_get_mute (self);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp9_ = _tmp8_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (_tmp9_) {
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp7_ = "1";
#line 887 "rygel-rendering-control.c"
	} else {
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp7_ = "0";
#line 891 "rygel-rendering-control.c"
	}
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp10_ = self->priv->changelog;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp11_ = _tmp7_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	rygel_change_log_log_with_channel (_tmp10_, "Mute", _tmp11_, "Master");
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_object_notify ((GObject *) self, "mute");
#line 901 "rygel-rendering-control.c"
}


guint rygel_rendering_control_get_volume (RygelRenderingControl* self) {
	guint result;
	guint _tmp0_;
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = self->priv->_volume;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	result = _tmp0_;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	return result;
#line 916 "rygel-rendering-control.c"
}


void rygel_rendering_control_set_volume (RygelRenderingControl* self, guint value) {
	guint _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	RygelChangeLog* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = value;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	self->priv->_volume = _tmp0_;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_get_mute (self);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp2_ = _tmp1_;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	if (!_tmp2_) {
#line 941 "rygel-rendering-control.c"
		RygelMediaPlayer* _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		gdouble _tmp6_ = 0.0;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp3_ = self->priv->player;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp4_ = rygel_rendering_control_get_volume (self);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp5_ = _tmp4_;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		_tmp6_ = rygel_volume_from_percentage (_tmp5_);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		rygel_media_player_set_volume (_tmp3_, _tmp6_);
#line 956 "rygel-rendering-control.c"
	}
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp7_ = self->priv->changelog;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp8_ = rygel_rendering_control_get_volume (self);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp9_ = _tmp8_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp10_ = g_strdup_printf ("%u", _tmp9_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp11_ = _tmp10_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	rygel_change_log_log_with_channel (_tmp7_, "Volume", _tmp11_, "Master");
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_g_free0 (_tmp11_);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_object_notify ((GObject *) self, "volume");
#line 974 "rygel-rendering-control.c"
}


static void rygel_rendering_control_class_init (RygelRenderingControlClass * klass) {
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	rygel_rendering_control_parent_class = g_type_class_peek_parent (klass);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_type_class_add_private (klass, sizeof (RygelRenderingControlPrivate));
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_rendering_control_real_constructed;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_rendering_control_get_property;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_rendering_control_set_property;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_rendering_control_finalize;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_RENDERING_CONTROL_MUTE, g_param_spec_boolean ("mute", "mute", "mute", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_RENDERING_CONTROL_VOLUME, g_param_spec_uint ("volume", "volume", "volume", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 995 "rygel-rendering-control.c"
}


static void rygel_rendering_control_instance_init (RygelRenderingControl * self) {
	gchar* _tmp0_;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	self->priv = RYGEL_RENDERING_CONTROL_GET_PRIVATE (self);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	self->priv->_mute = FALSE;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	self->priv->_volume = (guint) 0;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_tmp0_ = g_strdup ("");
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	self->priv->preset_name_list = _tmp0_;
#line 1011 "rygel-rendering-control.c"
}


static void rygel_rendering_control_finalize (GObject* obj) {
	RygelRenderingControl * self;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	self = RYGEL_RENDERING_CONTROL (obj);
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_g_free0 (self->priv->preset_name_list);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_g_object_unref0 (self->priv->changelog);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	_g_object_unref0 (self->priv->player);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	G_OBJECT_CLASS (rygel_rendering_control_parent_class)->finalize (obj);
#line 1027 "rygel-rendering-control.c"
}


GType rygel_rendering_control_get_type (void) {
	static volatile gsize rygel_rendering_control_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_rendering_control_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRenderingControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_rendering_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRenderingControl), 0, (GInstanceInitFunc) rygel_rendering_control_instance_init, NULL };
		GType rygel_rendering_control_type_id;
		rygel_rendering_control_type_id = g_type_register_static (GUPNP_TYPE_SERVICE, "RygelRenderingControl", &g_define_type_info, 0);
		g_once_init_leave (&rygel_rendering_control_type_id__volatile, rygel_rendering_control_type_id);
	}
	return rygel_rendering_control_type_id__volatile;
}


static void _vala_rygel_rendering_control_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelRenderingControl * self;
	self = RYGEL_RENDERING_CONTROL (object);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	switch (property_id) {
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		case RYGEL_RENDERING_CONTROL_MUTE:
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		g_value_set_boolean (value, rygel_rendering_control_get_mute (self));
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		case RYGEL_RENDERING_CONTROL_VOLUME:
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		g_value_set_uint (value, rygel_rendering_control_get_volume (self));
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		break;
#line 1060 "rygel-rendering-control.c"
		default:
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		break;
#line 1066 "rygel-rendering-control.c"
	}
}


static void _vala_rygel_rendering_control_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelRenderingControl * self;
	self = RYGEL_RENDERING_CONTROL (object);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
	switch (property_id) {
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		case RYGEL_RENDERING_CONTROL_MUTE:
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		rygel_rendering_control_set_mute (self, g_value_get_boolean (value));
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		case RYGEL_RENDERING_CONTROL_VOLUME:
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		rygel_rendering_control_set_volume (self, g_value_get_uint (value));
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		break;
#line 1088 "rygel-rendering-control.c"
		default:
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-rendering-control.vala"
		break;
#line 1094 "rygel-rendering-control.c"
	}
}



