/* rygel-mp3-transcoder.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-mp3-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_MP3_TRANSCODER (rygel_mp3_transcoder_get_type ())
#define RYGEL_MP3_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3Transcoder))
#define RYGEL_MP3_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderClass))
#define RYGEL_IS_MP3_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP3_TRANSCODER))
#define RYGEL_IS_MP3_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP3_TRANSCODER))
#define RYGEL_MP3_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderClass))

typedef struct _RygelMP3Transcoder RygelMP3Transcoder;
typedef struct _RygelMP3TranscoderClass RygelMP3TranscoderClass;
typedef struct _RygelMP3TranscoderPrivate RygelMP3TranscoderPrivate;

#define RYGEL_TYPE_MP3_LAYER (rygel_mp3_layer_get_type ())

#define RYGEL_TYPE_MP3_TRANSCODER_BIN (rygel_mp3_transcoder_bin_get_type ())
#define RYGEL_MP3_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP3_TRANSCODER_BIN, RygelMP3TranscoderBin))
#define RYGEL_MP3_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP3_TRANSCODER_BIN, RygelMP3TranscoderBinClass))
#define RYGEL_IS_MP3_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP3_TRANSCODER_BIN))
#define RYGEL_IS_MP3_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP3_TRANSCODER_BIN))
#define RYGEL_MP3_TRANSCODER_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP3_TRANSCODER_BIN, RygelMP3TranscoderBinClass))

typedef struct _RygelMP3TranscoderBin RygelMP3TranscoderBin;
typedef struct _RygelMP3TranscoderBinClass RygelMP3TranscoderBinClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define TYPE_ENDIANNESS (endianness_get_type ())

#define RYGEL_TYPE_L16_TRANSCODER (rygel_l16_transcoder_get_type ())
#define RYGEL_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16Transcoder))
#define RYGEL_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))
#define RYGEL_IS_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_IS_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_L16_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))

typedef struct _RygelL16Transcoder RygelL16Transcoder;
typedef struct _RygelL16TranscoderClass RygelL16TranscoderClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
	GstElement* (*create_source) (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
	guint (*get_distance) (RygelTranscoder* self, RygelMediaItem* item);
};

struct _RygelMP3Transcoder {
	RygelTranscoder parent_instance;
	RygelMP3TranscoderPrivate * priv;
};

struct _RygelMP3TranscoderClass {
	RygelTranscoderClass parent_class;
};

typedef enum  {
	RYGEL_MP3_LAYER_TWO = 1,
	RYGEL_MP3_LAYER_THREE = 2
} RygelMP3Layer;

struct _RygelMP3TranscoderPrivate {
	RygelMP3Layer layer;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

typedef enum  {
	ENDIANNESS_LITTLE = G_LITTLE_ENDIAN,
	ENDIANNESS_BIG = G_BIG_ENDIAN
} Endianness;


static gpointer rygel_mp3_transcoder_parent_class = NULL;

GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_mp3_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_mp3_layer_get_type (void) G_GNUC_CONST;
#define RYGEL_MP3_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderPrivate))
enum  {
	RYGEL_MP3_TRANSCODER_DUMMY_PROPERTY
};
#define RYGEL_MP3_TRANSCODER_BITRATE 256
#define RYGEL_MP3_TRANSCODER_AUDIO_PARSER "mp3parse"
#define RYGEL_MP3_TRANSCODER_CONVERT_SINK_PAD "convert-sink-pad"
RygelMP3Transcoder* rygel_mp3_transcoder_new (RygelMP3Layer layer);
RygelMP3Transcoder* rygel_mp3_transcoder_construct (GType object_type, RygelMP3Layer layer);
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* upnp_class);
static GstElement* rygel_mp3_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error);
RygelMP3TranscoderBin* rygel_mp3_transcoder_bin_new (RygelMediaItem* item, GstElement* src, RygelMP3Transcoder* transcoder, GError** error);
RygelMP3TranscoderBin* rygel_mp3_transcoder_bin_construct (GType object_type, RygelMediaItem* item, GstElement* src, RygelMP3Transcoder* transcoder, GError** error);
GType rygel_mp3_transcoder_bin_get_type (void) G_GNUC_CONST;
static GUPnPDIDLLiteResource* rygel_mp3_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static guint rygel_mp3_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GstElement* rygel_mp3_transcoder_create_encoder (RygelMP3Transcoder* self, RygelMediaItem* item, const gchar* src_pad_name, const gchar* sink_pad_name, GError** error);
GType endianness_get_type (void) G_GNUC_CONST;
RygelL16Transcoder* rygel_l16_transcoder_new (Endianness endianness);
RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type, Endianness endianness);
GType rygel_l16_transcoder_get_type (void) G_GNUC_CONST;
GstElement* rygel_l16_transcoder_create_encoder (RygelL16Transcoder* self, RygelMediaItem* item, const gchar* src_pad_name, const gchar* sink_pad_name, GError** error);
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
static inline void _dynamic_set_quality1 (GstElement* obj, gint value);
static inline void _dynamic_set_bitrate2 (GstElement* obj, gint value);
static void rygel_mp3_transcoder_finalize (GObject* obj);

static const gchar* RYGEL_MP3_TRANSCODER_AUDIO_ENCODER[3] = {NULL, "twolame", "lame"};

RygelMP3Transcoder* rygel_mp3_transcoder_construct (GType object_type, RygelMP3Layer layer) {
	RygelMP3Transcoder * self = NULL;
	RygelMP3Layer _tmp0_;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	self = (RygelMP3Transcoder*) rygel_transcoder_construct (object_type, "audio/mpeg", "MP3", RYGEL_AUDIO_ITEM_UPNP_CLASS);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp0_ = layer;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	self->priv->layer = _tmp0_;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	return self;
#line 300 "rygel-mp3-transcoder.c"
}


RygelMP3Transcoder* rygel_mp3_transcoder_new (RygelMP3Layer layer) {
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	return rygel_mp3_transcoder_construct (RYGEL_TYPE_MP3_TRANSCODER, layer);
#line 307 "rygel-mp3-transcoder.c"
}


static GstElement* rygel_mp3_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error) {
	RygelMP3Transcoder * self;
	GstElement* result = NULL;
	RygelMediaItem* _tmp0_;
	GstElement* _tmp1_;
	RygelMP3TranscoderBin* _tmp2_;
	RygelMP3TranscoderBin* _tmp3_;
	GError * _inner_error_ = NULL;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	self = (RygelMP3Transcoder*) base;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp0_ = item;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp1_ = src;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp2_ = rygel_mp3_transcoder_bin_new (_tmp0_, _tmp1_, self, &_inner_error_);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	gst_object_ref_sink (_tmp2_);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp3_ = _tmp2_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		return NULL;
#line 341 "rygel-mp3-transcoder.c"
	}
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	gst_object_ref_sink (_tmp3_);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	result = (GstElement*) _tmp3_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	return result;
#line 349 "rygel-mp3-transcoder.c"
}


static GUPnPDIDLLiteResource* rygel_mp3_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	RygelMP3Transcoder * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteItem* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelTranscodeManager* _tmp2_;
	GUPnPDIDLLiteResource* _tmp3_ = NULL;
	GUPnPDIDLLiteResource* resource;
	GError * _inner_error_ = NULL;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	self = (RygelMP3Transcoder*) base;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp0_ = didl_item;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp1_ = item;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp2_ = manager;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp3_ = RYGEL_TRANSCODER_CLASS (rygel_mp3_transcoder_parent_class)->add_resource (RYGEL_TRANSCODER (self), _tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	resource = _tmp3_;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		return NULL;
#line 386 "rygel-mp3-transcoder.c"
	}
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	if (resource == NULL) {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		result = NULL;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_g_object_unref0 (resource);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		return result;
#line 396 "rygel-mp3-transcoder.c"
	}
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	gupnp_didl_lite_resource_set_bitrate (resource, (RYGEL_MP3_TRANSCODER_BITRATE * 1000) / 8);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	result = resource;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	return result;
#line 404 "rygel-mp3-transcoder.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	return self ? g_object_ref (self) : NULL;
#line 411 "rygel-mp3-transcoder.c"
}


static guint rygel_mp3_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item) {
	RygelMP3Transcoder * self;
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	RygelMediaItem* _tmp1_;
	gboolean _tmp3_;
	RygelMediaItem* _tmp5_;
	RygelAudioItem* _tmp6_;
	RygelAudioItem* audio_item;
	guint _tmp7_;
	guint distance;
	RygelAudioItem* _tmp8_;
	gint _tmp9_;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	self = (RygelMP3Transcoder*) base;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	g_return_val_if_fail (item != NULL, 0U);
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp1_ = item;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	if (!RYGEL_IS_AUDIO_ITEM (_tmp1_)) {
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_tmp0_ = TRUE;
#line 438 "rygel-mp3-transcoder.c"
	} else {
		RygelMediaItem* _tmp2_;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_tmp2_ = item;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_tmp0_ = RYGEL_IS_VIDEO_ITEM (_tmp2_);
#line 445 "rygel-mp3-transcoder.c"
	}
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp3_ = _tmp0_;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	if (_tmp3_) {
#line 451 "rygel-mp3-transcoder.c"
		guint _tmp4_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_tmp4_ = G_MAXUINT;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		result = _tmp4_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		return result;
#line 459 "rygel-mp3-transcoder.c"
	}
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp5_ = item;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp6_ = _g_object_ref0 (RYGEL_IS_AUDIO_ITEM (_tmp5_) ? ((RygelAudioItem*) _tmp5_) : NULL);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	audio_item = _tmp6_;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp7_ = 0;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	distance = _tmp7_;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp8_ = audio_item;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp9_ = _tmp8_->bitrate;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	if (_tmp9_ > 0) {
#line 477 "rygel-mp3-transcoder.c"
		guint _tmp10_;
		RygelAudioItem* _tmp11_;
		gint _tmp12_;
		gint _tmp13_ = 0;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_tmp10_ = distance;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_tmp11_ = audio_item;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_tmp12_ = _tmp11_->bitrate;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_tmp13_ = abs (_tmp12_ - RYGEL_MP3_TRANSCODER_BITRATE);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		distance = _tmp10_ + _tmp13_;
#line 492 "rygel-mp3-transcoder.c"
	}
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	result = distance;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_g_object_unref0 (audio_item);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	return result;
#line 500 "rygel-mp3-transcoder.c"
}


static inline void _dynamic_set_quality1 (GstElement* obj, gint value) {
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	g_object_set (obj, "quality", value, NULL);
#line 507 "rygel-mp3-transcoder.c"
}


static inline void _dynamic_set_bitrate2 (GstElement* obj, gint value) {
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	g_object_set (obj, "bitrate", value, NULL);
#line 514 "rygel-mp3-transcoder.c"
}


static gpointer _gst_object_ref0 (gpointer self) {
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	return self ? gst_object_ref (self) : NULL;
#line 521 "rygel-mp3-transcoder.c"
}


GstElement* rygel_mp3_transcoder_create_encoder (RygelMP3Transcoder* self, RygelMediaItem* item, const gchar* src_pad_name, const gchar* sink_pad_name, GError** error) {
	GstElement* result = NULL;
	RygelL16Transcoder* _tmp0_;
	RygelL16Transcoder* l16_transcoder;
	RygelL16Transcoder* _tmp1_;
	RygelMediaItem* _tmp2_;
	GstElement* _tmp3_ = NULL;
	GstElement* convert;
	RygelMP3Layer _tmp4_;
	const gchar* _tmp5_;
	RygelMP3Layer _tmp6_;
	const gchar* _tmp7_;
	GstElement* _tmp8_ = NULL;
	GstElement* encoder;
	GstElement* _tmp9_ = NULL;
	GstElement* parser;
	RygelMP3Layer _tmp10_;
	GstElement* _tmp12_;
	GstBin* _tmp13_;
	GstBin* bin;
	GstBin* _tmp14_;
	GstElement* _tmp15_;
	GstElement* _tmp16_;
	GstElement* _tmp17_;
	GstElement* _tmp18_;
	GstElement* _tmp19_;
	GstElement* _tmp20_;
	GstElement* _tmp21_;
	GstElement* _tmp22_;
	GstElement* _tmp23_;
	GstElement* _tmp24_;
	GstPad* _tmp25_ = NULL;
	GstPad* pad;
	const gchar* _tmp26_;
	GstPad* _tmp27_;
	GstGhostPad* _tmp28_;
	GstGhostPad* ghost;
	GstBin* _tmp29_;
	GstGhostPad* _tmp30_;
	GstPad* _tmp31_;
	GstElement* _tmp32_;
	GstPad* _tmp33_ = NULL;
	const gchar* _tmp34_;
	GstPad* _tmp35_;
	GstGhostPad* _tmp36_;
	GstBin* _tmp37_;
	GstGhostPad* _tmp38_;
	GstPad* _tmp39_;
	GError * _inner_error_ = NULL;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp0_ = rygel_l16_transcoder_new (ENDIANNESS_LITTLE);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	l16_transcoder = _tmp0_;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp1_ = l16_transcoder;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp2_ = item;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp3_ = rygel_l16_transcoder_create_encoder (_tmp1_, _tmp2_, NULL, RYGEL_MP3_TRANSCODER_CONVERT_SINK_PAD, &_inner_error_);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	convert = _tmp3_;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_g_object_unref0 (l16_transcoder);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		return NULL;
#line 598 "rygel-mp3-transcoder.c"
	}
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp4_ = self->priv->layer;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp5_ = RYGEL_MP3_TRANSCODER_AUDIO_ENCODER[_tmp4_];
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp6_ = self->priv->layer;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp7_ = RYGEL_MP3_TRANSCODER_AUDIO_ENCODER[_tmp6_];
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp8_ = rygel_gst_utils_create_element (_tmp5_, _tmp7_, &_inner_error_);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	encoder = _tmp8_;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_gst_object_unref0 (convert);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_g_object_unref0 (l16_transcoder);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		return NULL;
#line 622 "rygel-mp3-transcoder.c"
	}
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp9_ = rygel_gst_utils_create_element (RYGEL_MP3_TRANSCODER_AUDIO_PARSER, RYGEL_MP3_TRANSCODER_AUDIO_PARSER, &_inner_error_);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	parser = _tmp9_;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_gst_object_unref0 (encoder);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_gst_object_unref0 (convert);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_g_object_unref0 (l16_transcoder);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		return NULL;
#line 640 "rygel-mp3-transcoder.c"
	}
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp10_ = self->priv->layer;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	if (_tmp10_ == RYGEL_MP3_LAYER_THREE) {
#line 646 "rygel-mp3-transcoder.c"
		GstElement* _tmp11_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_tmp11_ = encoder;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
		_dynamic_set_quality1 (_tmp11_, 0);
#line 652 "rygel-mp3-transcoder.c"
	}
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp12_ = encoder;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_dynamic_set_bitrate2 (_tmp12_, RYGEL_MP3_TRANSCODER_BITRATE);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp13_ = (GstBin*) gst_bin_new ("mp3-encoder-bin");
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	gst_object_ref_sink (_tmp13_);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	bin = _tmp13_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp14_ = bin;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp15_ = convert;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp16_ = _gst_object_ref0 (_tmp15_);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp17_ = encoder;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp18_ = _gst_object_ref0 (_tmp17_);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp19_ = parser;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp20_ = _gst_object_ref0 (_tmp19_);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	gst_bin_add_many (_tmp14_, _tmp16_, _tmp18_, _tmp20_, NULL);
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp21_ = convert;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp22_ = encoder;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp23_ = parser;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	gst_element_link_many (_tmp21_, _tmp22_, _tmp23_, NULL);
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp24_ = convert;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp25_ = gst_element_get_static_pad (_tmp24_, RYGEL_MP3_TRANSCODER_CONVERT_SINK_PAD);
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	pad = _tmp25_;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp26_ = sink_pad_name;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp27_ = pad;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp28_ = (GstGhostPad*) gst_ghost_pad_new (_tmp26_, _tmp27_);
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	gst_object_ref_sink (_tmp28_);
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	ghost = _tmp28_;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp29_ = bin;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp30_ = ghost;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp31_ = _gst_object_ref0 ((GstPad*) _tmp30_);
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	gst_element_add_pad ((GstElement*) _tmp29_, _tmp31_);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp32_ = parser;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp33_ = gst_element_get_static_pad (_tmp32_, "src");
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_gst_object_unref0 (pad);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	pad = _tmp33_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp34_ = src_pad_name;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp35_ = pad;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp36_ = (GstGhostPad*) gst_ghost_pad_new (_tmp34_, _tmp35_);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	gst_object_ref_sink (_tmp36_);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_gst_object_unref0 (ghost);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	ghost = _tmp36_;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp37_ = bin;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp38_ = ghost;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_tmp39_ = _gst_object_ref0 ((GstPad*) _tmp38_);
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	gst_element_add_pad ((GstElement*) _tmp37_, _tmp39_);
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	result = (GstElement*) bin;
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_gst_object_unref0 (ghost);
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_gst_object_unref0 (pad);
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_gst_object_unref0 (parser);
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_gst_object_unref0 (encoder);
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_gst_object_unref0 (convert);
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	_g_object_unref0 (l16_transcoder);
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	return result;
#line 756 "rygel-mp3-transcoder.c"
}


static void rygel_mp3_transcoder_class_init (RygelMP3TranscoderClass * klass) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	rygel_mp3_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	g_type_class_add_private (klass, sizeof (RygelMP3TranscoderPrivate));
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->create_source = rygel_mp3_transcoder_real_create_source;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_mp3_transcoder_real_add_resource;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_mp3_transcoder_real_get_distance;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_mp3_transcoder_finalize;
#line 773 "rygel-mp3-transcoder.c"
}


static void rygel_mp3_transcoder_instance_init (RygelMP3Transcoder * self) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	self->priv = RYGEL_MP3_TRANSCODER_GET_PRIVATE (self);
#line 780 "rygel-mp3-transcoder.c"
}


static void rygel_mp3_transcoder_finalize (GObject* obj) {
	RygelMP3Transcoder * self;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	self = RYGEL_MP3_TRANSCODER (obj);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-mp3-transcoder.vala"
	G_OBJECT_CLASS (rygel_mp3_transcoder_parent_class)->finalize (obj);
#line 790 "rygel-mp3-transcoder.c"
}


/**
 * Transcoder for mpeg 1 layer 2 and 3 audio. This element uses MP3TrancoderBin
 * for actual transcoding.
 */
GType rygel_mp3_transcoder_get_type (void) {
	static volatile gsize rygel_mp3_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mp3_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMP3TranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mp3_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMP3Transcoder), 0, (GInstanceInitFunc) rygel_mp3_transcoder_instance_init, NULL };
		GType rygel_mp3_transcoder_type_id;
		rygel_mp3_transcoder_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODER, "RygelMP3Transcoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_mp3_transcoder_type_id__volatile, rygel_mp3_transcoder_type_id);
	}
	return rygel_mp3_transcoder_type_id__volatile;
}



