/* rygel-http-get.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-http-get.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_http_get_handler_unref0(var) ((var == NULL) ? NULL : (var = (rygel_http_get_handler_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;
#define _rygel_transcoder_unref0(var) ((var == NULL) ? NULL : (var = (rygel_transcoder_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHttpGetHandleData RygelHttpGetHandleData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
#define _rygel_media_object_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_object_unref (var), NULL)))

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;
typedef struct _RygelHttpGetFindItemData RygelHttpGetFindItemData;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHttpGetHandleItemRequestData RygelHttpGetHandleItemRequestData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelHTTPGetPrivate {
	gint thumbnail_index;
	gint subtitle_index;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
	gchar* item_id;
	gint thumbnail_index;
	gint subtitle_index;
	gchar* transcode_target;
	RygelHTTPServer* http_server;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

struct _RygelHttpGetHandleData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* header;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	GError* _tmp11_;
	RygelTranscoder* _tmp12_;
	RygelTranscoder* transcoder;
	GCancellable* _tmp13_;
	RygelHTTPTranscodeHandler* _tmp14_;
	GCancellable* _tmp15_;
	RygelHTTPIdentityHandler* _tmp16_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
	gchar* id;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	GeeArrayList* subtitles;
	GeeArrayList* thumbnails;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelHttpGetFindItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	gboolean _tmp0_;
	GError* _tmp1_;
	RygelMediaItem* _tmp2_;
	RygelMusicItem* _tmp3_;
	RygelMusicItem* music;
	RygelThumbnail* _tmp4_;
	RygelMediaItem* _tmp5_;
	RygelVisualItem* _tmp6_;
	RygelVisualItem* visual;
	GeeArrayList* _tmp7_;
	gpointer _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	RygelMediaItem* _tmp11_;
	gpointer _tmp12_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelHttpGetHandleItemRequestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	gboolean _tmp0_;
	gboolean need_time_seek;
	gboolean _tmp1_;
	gboolean need_byte_seek;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError* _tmp7_;
	RygelHTTPTimeSeek* _tmp8_;
	RygelHTTPTimeSeek* _tmp9_;
	RygelHTTPByteSeek* _tmp10_;
	RygelHTTPByteSeek* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	RygelHTTPResponse* _tmp15_;
	RygelHTTPResponse* response;
	GError * _inner_error_;
};


static gpointer rygel_http_get_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
gpointer rygel_http_get_handler_ref (gpointer instance);
void rygel_http_get_handler_unref (gpointer instance);
GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_http_get_handler (GValue* value, gpointer v_object);
void rygel_value_take_http_get_handler (GValue* value, gpointer v_object);
gpointer rygel_value_get_http_get_handler (const GValue* value);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GET, RygelHTTPGetPrivate))
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_TRANSFER_MODE_HEADER "transferMode.dlna.org"
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
static void rygel_http_get_real_handle_data_free (gpointer _data);
static void rygel_http_get_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_get_real_handle_co (RygelHttpGetHandleData* data);
GQuark rygel_http_request_error_quark (void);
gpointer rygel_transcoder_ref (gpointer instance);
void rygel_transcoder_unref (gpointer instance);
GParamSpec* rygel_param_spec_transcoder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_transcoder (GValue* value, gpointer v_object);
void rygel_value_take_transcoder (GValue* value, gpointer v_object);
gpointer rygel_value_get_transcoder (const GValue* value);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
static void rygel_http_get_ensure_correct_mode (RygelHTTPGet* self, GError** error);
static void rygel_http_get_handle_item_request (RygelHTTPGet* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_handle_item_request_finish (RygelHTTPGet* self, GAsyncResult* _res_, GError** error);
static void rygel_http_get_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_get_real_find_item_data_free (gpointer _data);
static void rygel_http_get_real_find_item (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_get_real_find_item_co (RygelHttpGetFindItemData* data);
void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
static void rygel_http_get_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
GType rygel_video_item_get_type (void) G_GNUC_CONST;
static void rygel_http_get_handle_item_request_data_free (gpointer _data);
static gboolean rygel_http_get_handle_item_request_co (RygelHttpGetHandleItemRequestData* data);
gboolean rygel_http_time_seek_needed (RygelHTTPGet* request);
gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request);
gboolean rygel_http_time_seek_requested (RygelHTTPGet* request);
gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request);
GQuark rygel_http_seek_error_quark (void);
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
static void _lambda3_ (const gchar* name, const gchar* value, RygelHTTPGet* self);
static void __lambda3__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self);
void rygel_http_request_end (RygelHTTPRequest* self, guint status);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static void rygel_http_get_handle_item_request_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
static void rygel_http_get_finalize (GObject* obj);


RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPGet * self = NULL;
	g_return_val_if_fail (http_server != NULL, NULL);
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	self = (RygelHTTPGet*) rygel_http_request_construct (object_type, http_server, server, msg);
	self->priv->thumbnail_index = -1;
	self->priv->subtitle_index = -1;
	return self;
}


RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, http_server, server, msg);
}


static void rygel_http_get_real_handle_data_free (gpointer _data) {
	RygelHttpGetHandleData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpGetHandleData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_http_get_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPGet * self;
	RygelHttpGetHandleData* _data_;
	self = (RygelHTTPGet*) base;
	_data_ = g_slice_new0 (RygelHttpGetHandleData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_real_handle);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_real_handle_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_http_get_real_handle_co (_data_);
}


static void rygel_http_get_real_handle_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpGetHandleData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_get_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetHandleData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_http_get_real_handle_co (data);
}


static gboolean rygel_http_get_real_handle_co (RygelHttpGetHandleData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = soup_message_headers_get_one (((RygelHTTPRequest*) data->self)->msg->request_headers, "getcontentFeatures.dlna.org");
	data->_tmp1_ = g_strdup (data->_tmp0_);
	data->header = data->_tmp1_;
	data->_tmp4_ = NULL;
	g_object_get (((RygelHTTPRequest*) data->self)->msg, "method", &data->_tmp4_, NULL);
	data->_tmp5_ = data->_tmp4_;
	data->_tmp6_ = g_strcmp0 (data->_tmp5_, "HEAD") != 0;
	_g_free0 (data->_tmp5_);
	if (data->_tmp6_) {
		data->_tmp7_ = NULL;
		g_object_get (((RygelHTTPRequest*) data->self)->msg, "method", &data->_tmp7_, NULL);
		data->_tmp8_ = data->_tmp7_;
		data->_tmp3_ = g_strcmp0 (data->_tmp8_, "GET") != 0;
		_g_free0 (data->_tmp8_);
	} else {
		data->_tmp3_ = FALSE;
	}
	if (data->_tmp3_) {
		data->_tmp2_ = TRUE;
	} else {
		if (data->header != NULL) {
			data->_tmp9_ = g_strcmp0 (data->header, "1") != 0;
		} else {
			data->_tmp9_ = FALSE;
		}
		data->_tmp2_ = data->_tmp9_;
	}
	if (data->_tmp2_) {
		data->_tmp10_ = NULL;
		data->_tmp10_ = _ ("Invalid Request");
		data->_tmp11_ = NULL;
		data->_tmp11_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, data->_tmp10_);
		data->_inner_error_ = data->_tmp11_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->header);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (((RygelHTTPRequest*) data->self)->uri->transcode_target != NULL) {
		data->_tmp12_ = NULL;
		data->_tmp12_ = rygel_http_server_get_transcoder (((RygelHTTPRequest*) data->self)->http_server, ((RygelHTTPRequest*) data->self)->uri->transcode_target, &data->_inner_error_);
		data->transcoder = data->_tmp12_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->header);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->_tmp13_ = NULL;
		data->_tmp13_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		data->_tmp14_ = NULL;
		data->_tmp14_ = rygel_http_transcode_handler_new (data->transcoder, data->_tmp13_);
		_rygel_http_get_handler_unref0 (data->self->handler);
		data->self->handler = (RygelHTTPGetHandler*) data->_tmp14_;
		_rygel_transcoder_unref0 (data->transcoder);
	}
	if (data->self->handler == NULL) {
		data->_tmp15_ = NULL;
		data->_tmp15_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		data->_tmp16_ = NULL;
		data->_tmp16_ = rygel_http_identity_handler_new (data->_tmp15_);
		_rygel_http_get_handler_unref0 (data->self->handler);
		data->self->handler = (RygelHTTPGetHandler*) data->_tmp16_;
	}
	rygel_http_get_ensure_correct_mode (data->self, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->header);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 1;
	rygel_http_get_handle_item_request (data->self, rygel_http_get_handle_ready, data);
	return FALSE;
	_state_1:
	rygel_http_get_handle_item_request_finish (data->self, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->header);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_free0 (data->header);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_http_get_real_find_item_data_free (gpointer _data) {
	RygelHttpGetFindItemData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpGetFindItemData, data);
}


static void rygel_http_get_real_find_item (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPGet * self;
	RygelHttpGetFindItemData* _data_;
	self = (RygelHTTPGet*) base;
	_data_ = g_slice_new0 (RygelHttpGetFindItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_real_find_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_real_find_item_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_http_get_real_find_item_co (_data_);
}


static void rygel_http_get_real_find_item_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpGetFindItemData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_get_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetFindItemData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_http_get_real_find_item_co (data);
}


static gpointer _rygel_media_object_ref0 (gpointer self) {
	return self ? rygel_media_object_ref (self) : NULL;
}


static gpointer _rygel_thumbnail_ref0 (gpointer self) {
	return self ? rygel_thumbnail_ref (self) : NULL;
}


static gboolean rygel_http_get_real_find_item_co (RygelHttpGetFindItemData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	RYGEL_HTTP_REQUEST_CLASS (rygel_http_get_parent_class)->find_item (RYGEL_HTTP_REQUEST (data->self), rygel_http_get_find_item_ready, data);
	return FALSE;
	_state_1:
	RYGEL_HTTP_REQUEST_CLASS (rygel_http_get_parent_class)->find_item_finish (RYGEL_HTTP_REQUEST (data->self), data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp0_ = G_UNLIKELY (((RygelHTTPRequest*) data->self)->item->size == 0);
	if (data->_tmp0_) {
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "Item '%s' is empty", ((RygelMediaObject*) ((RygelHTTPRequest*) data->self)->item)->id);
		data->_inner_error_ = data->_tmp1_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (((RygelHTTPRequest*) data->self)->uri->thumbnail_index >= 0) {
		if (RYGEL_IS_MUSIC_ITEM (((RygelHTTPRequest*) data->self)->item)) {
			data->_tmp2_ = ((RygelHTTPRequest*) data->self)->item;
			data->_tmp3_ = _rygel_media_object_ref0 (RYGEL_IS_MUSIC_ITEM (data->_tmp2_) ? ((RygelMusicItem*) data->_tmp2_) : NULL);
			data->music = data->_tmp3_;
			data->_tmp4_ = _rygel_thumbnail_ref0 (data->music->album_art);
			_rygel_thumbnail_unref0 (data->self->thumbnail);
			data->self->thumbnail = data->_tmp4_;
			_rygel_media_object_unref0 (data->music);
		} else {
			if (RYGEL_IS_VISUAL_ITEM (((RygelHTTPRequest*) data->self)->item)) {
				data->_tmp5_ = ((RygelHTTPRequest*) data->self)->item;
				data->_tmp6_ = _rygel_media_object_ref0 (RYGEL_IS_VISUAL_ITEM (data->_tmp5_) ? ((RygelVisualItem*) data->_tmp5_) : NULL);
				data->visual = data->_tmp6_;
				data->_tmp7_ = NULL;
				data->_tmp7_ = rygel_visual_item_get_thumbnails (data->visual);
				data->_tmp8_ = NULL;
				data->_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) data->_tmp7_, ((RygelHTTPRequest*) data->self)->uri->thumbnail_index);
				_rygel_thumbnail_unref0 (data->self->thumbnail);
				data->self->thumbnail = (RygelThumbnail*) data->_tmp8_;
				_rygel_media_object_unref0 (data->visual);
			} else {
				data->_tmp9_ = NULL;
				data->_tmp9_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No Thumbnail available for item '%s", ((RygelMediaObject*) ((RygelHTTPRequest*) data->self)->item)->id);
				data->_inner_error_ = data->_tmp9_;
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	} else {
		if (((RygelHTTPRequest*) data->self)->uri->subtitle_index >= 0) {
			if (!RYGEL_IS_VIDEO_ITEM (((RygelHTTPRequest*) data->self)->item)) {
				data->_tmp10_ = NULL;
				data->_tmp10_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No subtitles available for item '%s", ((RygelMediaObject*) ((RygelHTTPRequest*) data->self)->item)->id);
				data->_inner_error_ = data->_tmp10_;
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			data->_tmp11_ = ((RygelHTTPRequest*) data->self)->item;
			data->_tmp12_ = NULL;
			data->_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) (RYGEL_IS_VIDEO_ITEM (data->_tmp11_) ? ((RygelVideoItem*) data->_tmp11_) : NULL)->subtitles, ((RygelHTTPRequest*) data->self)->uri->subtitle_index);
			_rygel_subtitle_unref0 (data->self->subtitle);
			data->self->subtitle = (RygelSubtitle*) data->_tmp12_;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_http_get_handle_item_request_data_free (gpointer _data) {
	RygelHttpGetHandleItemRequestData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpGetHandleItemRequestData, data);
}


static void rygel_http_get_handle_item_request (RygelHTTPGet* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpGetHandleItemRequestData* _data_;
	_data_ = g_slice_new0 (RygelHttpGetHandleItemRequestData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_handle_item_request);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_handle_item_request_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_http_get_handle_item_request_co (_data_);
}


static void rygel_http_get_handle_item_request_finish (RygelHTTPGet* self, GAsyncResult* _res_, GError** error) {
	RygelHttpGetHandleItemRequestData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _lambda3_ (const gchar* name, const gchar* value, RygelHTTPGet* self) {
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	g_debug ("rygel-http-get.vala:132: %s : %s", name, value);
}


static void __lambda3__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self) {
	_lambda3_ (name, value, self);
}


static void rygel_http_get_handle_item_request_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetHandleItemRequestData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_http_get_handle_item_request_co (data);
}


static gboolean rygel_http_get_handle_item_request_co (RygelHttpGetHandleItemRequestData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = rygel_http_time_seek_needed (data->self);
	data->need_time_seek = data->_tmp0_;
	data->_tmp1_ = rygel_http_byte_seek_needed (data->self);
	data->need_byte_seek = data->_tmp1_;
	data->_tmp4_ = rygel_http_time_seek_requested (data->self);
	if (data->_tmp4_) {
		data->_tmp3_ = !data->need_time_seek;
	} else {
		data->_tmp3_ = FALSE;
	}
	if (data->_tmp3_) {
		data->_tmp2_ = TRUE;
	} else {
		data->_tmp6_ = rygel_http_byte_seek_requested (data->self);
		if (data->_tmp6_) {
			data->_tmp5_ = !data->need_byte_seek;
		} else {
			data->_tmp5_ = FALSE;
		}
		data->_tmp2_ = data->_tmp5_;
	}
	if (data->_tmp2_) {
		data->_tmp7_ = NULL;
		data->_tmp7_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, "Invalid seek request");
		data->_inner_error_ = data->_tmp7_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->need_time_seek) {
		data->_tmp8_ = NULL;
		data->_tmp8_ = rygel_http_time_seek_new (data->self, &data->_inner_error_);
		data->_tmp9_ = data->_tmp8_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->self->seek);
		data->self->seek = (RygelHTTPSeek*) data->_tmp9_;
	} else {
		if (data->need_byte_seek) {
			data->_tmp10_ = NULL;
			data->_tmp10_ = rygel_http_byte_seek_new (data->self, &data->_inner_error_);
			data->_tmp11_ = data->_tmp10_;
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->self->seek);
			data->self->seek = (RygelHTTPSeek*) data->_tmp11_;
		}
	}
	rygel_http_get_handler_add_response_headers (data->self->handler, data->self);
	g_debug ("rygel-http-get.vala:130: Following HTTP headers appended to response:");
	soup_message_headers_foreach (((RygelHTTPRequest*) data->self)->msg->response_headers, __lambda3__soup_message_headers_foreach_func, data->self);
	data->_tmp12_ = NULL;
	g_object_get (((RygelHTTPRequest*) data->self)->msg, "method", &data->_tmp12_, NULL);
	data->_tmp13_ = data->_tmp12_;
	data->_tmp14_ = g_strcmp0 (data->_tmp13_, "HEAD") == 0;
	_g_free0 (data->_tmp13_);
	if (data->_tmp14_) {
		soup_server_unpause_message (((RygelHTTPRequest*) data->self)->server, ((RygelHTTPRequest*) data->self)->msg);
		rygel_http_request_end ((RygelHTTPRequest*) data->self, (guint) SOUP_STATUS_OK);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp15_ = NULL;
	data->_tmp15_ = rygel_http_get_handler_render_body (data->self->handler, data->self);
	data->response = data->_tmp15_;
	data->_state_ = 1;
	rygel_state_machine_run ((RygelStateMachine*) data->response, rygel_http_get_handle_item_request_ready, data);
	return FALSE;
	_state_1:
	rygel_state_machine_run_finish ((RygelStateMachine*) data->response, data->_res_);
	rygel_http_request_end ((RygelHTTPRequest*) data->self, (guint) SOUP_STATUS_NONE);
	_g_object_unref0 (data->response);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_http_get_ensure_correct_mode (RygelHTTPGet* self, GError** error) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* mode;
	gboolean correct;
	const gchar* _tmp2_;
	GQuark _tmp3_;
	static GQuark _tmp3__label0 = 0;
	static GQuark _tmp3__label1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = soup_message_headers_get_one (((RygelHTTPRequest*) self)->msg->request_headers, RYGEL_HTTP_GET_TRANSFER_MODE_HEADER);
	_tmp1_ = g_strdup (_tmp0_);
	mode = _tmp1_;
	correct = TRUE;
	_tmp2_ = mode;
	_tmp3_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp3_ == ((0 != _tmp3__label0) ? _tmp3__label0 : (_tmp3__label0 = g_quark_from_static_string ("Streaming")))) {
		switch (0) {
			default:
			{
				gboolean _tmp4_ = FALSE;
				if (RYGEL_IS_HTTP_TRANSCODE_HANDLER (self->handler)) {
					_tmp4_ = TRUE;
				} else {
					gboolean _tmp5_ = FALSE;
					gboolean _tmp6_ = FALSE;
					gboolean _tmp7_;
					_tmp7_ = rygel_media_item_streamable (((RygelHTTPRequest*) self)->item);
					if (_tmp7_) {
						_tmp6_ = self->subtitle == NULL;
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						_tmp5_ = self->thumbnail == NULL;
					} else {
						_tmp5_ = FALSE;
					}
					_tmp4_ = _tmp5_;
				}
				correct = _tmp4_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp3__label1) ? _tmp3__label1 : (_tmp3__label1 = g_quark_from_static_string ("Interactive")))) {
		switch (0) {
			default:
			{
				gboolean _tmp8_ = FALSE;
				if (RYGEL_IS_HTTP_IDENTITY_HANDLER (self->handler)) {
					gboolean _tmp9_ = FALSE;
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_;
					_tmp11_ = rygel_media_item_is_live_stream (((RygelHTTPRequest*) self)->item);
					if (!_tmp11_) {
						_tmp10_ = TRUE;
					} else {
						_tmp10_ = self->subtitle != NULL;
					}
					if (_tmp10_) {
						_tmp9_ = TRUE;
					} else {
						_tmp9_ = self->thumbnail != NULL;
					}
					_tmp8_ = _tmp9_;
				} else {
					_tmp8_ = FALSE;
				}
				correct = _tmp8_;
				break;
			}
		}
	}
	if (!correct) {
		GError* _tmp12_ = NULL;
		_tmp12_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, "%s mode not supported for '%s'", mode, ((RygelMediaObject*) ((RygelHTTPRequest*) self)->item)->id);
		_inner_error_ = _tmp12_;
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (mode);
			return;
		} else {
			_g_free0 (mode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (mode);
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPGetPrivate));
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle = rygel_http_get_real_handle;
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle_finish = rygel_http_get_real_handle_finish;
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item = rygel_http_get_real_find_item;
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item_finish = rygel_http_get_real_find_item_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
	self->priv = RYGEL_HTTP_GET_GET_PRIVATE (self);
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
	self = RYGEL_HTTP_GET (obj);
	_rygel_thumbnail_unref0 (self->thumbnail);
	_rygel_subtitle_unref0 (self->subtitle);
	_g_object_unref0 (self->seek);
	_rygel_http_get_handler_unref0 (self->handler);
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
}


/**
 * Responsible for handling HTTP GET & HEAD client requests.
 */
GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (RYGEL_TYPE_HTTP_REQUEST, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}



