//plugin-info.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2011-2012
 *
 *  This file is part of roard a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include <roard/include/roard.h>

static int static_counter = 0;
int nonstatic_counter = 0;

static int global_data_init = 0;
static int * global_data;

static void print_counter  (void) {
 static int static_func_counter = 0;

 printf("static_counter=%i, nonstatic_counter=%i, static_func_counter=%i, *global_data=%i\n",
        static_counter, nonstatic_counter, static_func_counter, *global_data);

 static_counter++;
 nonstatic_counter++;
 static_func_counter++;
 (*global_data)++;
}

static void print_parameter(struct roar_dl_librarypara * para) {
 size_t i;
 char c;

 roar_vio_printf(roar_stdout, "version    = %i (%smatching)\n",
                 para->version, para->version == ROAR_DL_LIBPARA_VERSION ? "" : "not ");
 roar_vio_printf(roar_stdout, "length     = %zu (%smatching)\n",
                 para->len, para->len == sizeof(*para) ? "" : "not ");

 if ( para->version != ROAR_DL_LIBPARA_VERSION || para->len != sizeof(*para) ) {
  roar_vio_printf(roar_stdout, "Warning: Unsupported para block. Version or length missmatch.\n");
  return;
 }

 roar_vio_printf(roar_stdout, "refc       = %zu\n", para->refc);
 if ( para->argv == NULL ) {
  roar_vio_printf(roar_stdout, "argv[]     = <not set>\n");
 } else {
  roar_vio_printf(roar_stdout, "argv[]     = <kv array>\n");
  for (i = 0; i < para->argc; i++) {
   c = i == (para->argc - 1) ? '\\' : '|';
   if ( para->argv[i].value == NULL ) {
    roar_vio_printf(roar_stdout, " %c- \"%s\" has no value.\n", c, para->argv[i].key);
   } else {
    roar_vio_printf(roar_stdout, " %c- \"%s\" has value \"%s\".\n", c, para->argv[i].key, para->argv[i].value);
   }
  }
 }

 roar_vio_printf(roar_stdout, para->binargv    == NULL ? "binargv    = <not set>\n" : "binargv    = %p\n", para->binargv);
 roar_vio_printf(roar_stdout, para->appname    == NULL ? "appname    = <not set>\n" : "appname    = \"%s\"\n", para->appname);
 roar_vio_printf(roar_stdout, para->abiversion == NULL ? "abiversion = <not set>\n" : "abiversion = \"%s\"\n", para->abiversion);
 roar_vio_printf(roar_stdout, para->notifycore == NULL ? "notifycore = <not set>\n" : "notifycore = \"%s\"\n", para->notifycore);
}

static void print_notifycore (struct roar_dl_librarypara * para) {
 struct roar_notify_core * tmp;

 tmp = roar_notify_core_swap_global(NULL);
 roar_notify_core_swap_global(tmp);

 if ( para->notifycore == NULL || para->notifycore == tmp ) {
  roar_vio_printf(roar_stdout,
                 tmp == NULL ? "global notify core= <not set> (matching)\n" : "global notify core= %p (matching)\n",
                 tmp);
 } else {
  roar_vio_printf(roar_stdout,
                  tmp == NULL ? "global notify core= <not set> (not matching)\n" :
                                "global notify core= %p (not matching)\n",
                  tmp);
 }

 roar_notify_core_unref(tmp);
}

static void print_env(void) {
 const char * server = roar_libroar_get_server();
 roar_vio_printf(roar_stdout, "Default server: %s%s%s\n",
                              server == NULL ? "" : "\"",
                              server == NULL ? "<not set>" : server,
                              server == NULL ? "" : "\"");
}

static int init  (struct roar_dl_librarypara * para) {
 print_parameter(para);
 print_notifycore(para);
 print_env();
 print_counter();
 return 0;
}

static struct roar_dl_appsched sched = {
 .init   = init,
 .free   = NULL,
 .update = NULL,
 .tick   = NULL,
 .wait   = NULL
};

ROAR_DL_PLUGIN_START(plugin_info) {
 ROAR_DL_PLUGIN_META_PRODUCT_NIV("plugin-info", ROAR_VID_ROARAUDIO, ROAR_VNAME_ROARAUDIO);
 ROAR_DL_PLUGIN_META_VERSION(ROAR_VERSION_STRING);
 ROAR_DL_PLUGIN_META_LICENSE_TAG(GPLv3_0); 
 ROAR_DL_PLUGIN_META_CONTACT_FLNE("Philipp", "Schafft", "ph3-der-loewe", "lion@lion.leolix.org");
 ROAR_DL_PLUGIN_META_DESC("Display information about the plugin context");

 ROAR_DL_PLUGIN_REG_GLOBAL_DATA(global_data, global_data_init);
 ROAR_DL_PLUGIN_REG_APPSCHED(&sched);
} ROAR_DL_PLUGIN_END

//ll
