myexample <-
function (topic, package = NULL, lib.loc = NULL, local = FALSE, 
    echo = TRUE, verbose = getOption("verbose"), setRNG = FALSE, 
    ask = getOption("example.ask"), prompt.prefix = abbreviate(topic, 
        6)) 
{
#     topic <- substitute(topic) # to avoid error
    if (!is.character(topic)) 
        topic <- deparse(topic)[1L]
    INDICES <- .find.package(package, lib.loc, verbose = verbose)
    file <- index.search(topic, INDICES, "AnIndex", "R-ex")
    if (file == "") {
        warning(gettextf("no help file found for '%s'", topic), 
            domain = NA)
        return(invisible())
    }
    packagePath <- dirname(dirname(file))
    if (length(file) > 1L) {
        packagePath <- packagePath[1L]
        warning(gettextf("more than one help file found: using package '%s'", 
            basename(packagePath)), domain = NA)
        file <- file[1L]
    }
    pkg <- basename(packagePath)
    lib <- dirname(packagePath)
    zfile <- zip.file.extract(file, "Rex.zip")
    if (zfile != file) 
        on.exit(unlink(zfile))
    if (!file.exists(zfile)) {
        warning(gettextf("'%s' has a help file but no examples file", 
            topic), domain = NA)
        return(invisible())
    }
    if (pkg != "base") 
        library(pkg, lib.loc = lib, character.only = TRUE)
    if (!is.logical(setRNG) || setRNG) {
        if ((exists(".Random.seed", envir = .GlobalEnv))) {
            oldSeed <- get(".Random.seed", envir = .GlobalEnv)
            on.exit(assign(".Random.seed", oldSeed, envir = .GlobalEnv))
        }
        else {
            oldRNG <- RNGkind()
            on.exit(RNGkind(oldRNG[1L], oldRNG[2L]))
        }
        if (is.logical(setRNG)) {
            RNGkind("default", "default")
            set.seed(1)
        }
        else eval(setRNG)
    }
    encoding <- if (length(enc <- localeToCharset()) > 1L) 
        c(enc[-length(enc)], "latin1")
    else ""
    zz <- readLines(zfile, n = 1L)
    if (length(grep("^### Encoding: ", zz)) && !identical(Sys.getlocale("LC_CTYPE"), 
        "C")) 
        encoding <- substring(zz, 15L)
    skips <- 0L
    if (echo) {
        zcon <- file(zfile, open = "rt")
        while (length(zz) && !length(grep("^### \\*\\*", zz))) {
            skips <- skips + 1L
            zz <- readLines(zcon, n = 1L)
        }
        close(zcon)
    }
    if (ask == "default") 
        ask <- echo && grDevices::dev.interactive(orNone = TRUE)
    if (ask) {
        if (.Device != "null device") {
            oldask <- grDevices::devAskNewPage(ask = TRUE)
            if (!oldask) 
                on.exit(grDevices::devAskNewPage(oldask), add = TRUE)
        }
        op <- options(device.ask.default = TRUE)
        on.exit(options(op), add = TRUE)
    }
    source(zfile, local, echo = echo, prompt.echo = paste(prompt.prefix, 
        getOption("prompt"), sep = ""), continue.echo = paste(prompt.prefix, 
        getOption("continue"), sep = ""), verbose = verbose, 
        max.deparse.length = Inf, encoding = encoding, skip.echo = skips, 
        keep.source = TRUE)
}

pkgs <- c("base", "stats", "utils", "graphics", "grDevices")

# These cause rwkard to crash, at least sometimes
CRASH <- c("anova.mlm", "check.options", "close.screen", "erase.screen")

# These cause script to terminate with an error, but expected behavior in some cases
ERROR <- c("bzfile", "geterrmessage", "match.fun", "addmargins", "browseEnv", "wsbrowser", "check.options")

# These sometimes cause the script to terminate with an error, so not the expected behavior
RANDOM <- c("closeAllConnections", "stderr")

# These cause rkward to raise a popup, which prevents the script from running automatically but is expected behavior
POPUP <- c("library", "print.libraryIQR", "print.packageInfo", "readline", "require", "stop", "stopifnot", "trace", "tracingState", "untrace",
	  "?", "Filters", "RSiteSearch", "data", "demo", "help", "loadRconsole", "package.skeleton", "promptPackage", "vignette", "file.access", 
	  "file.info", "file.create", "file.show", "file.copy", "file.exists", "file.rename", "file.symlink", "file.append", "file.remove", 
	  "choose.files", "help", "help.search", "read.ftable", "write.ftable", "choose.dir")

# These cause the user to have to click a plot to continue, due to the example calling example() but not passing on ask=FALSE. Not a bug in rkward
CLICK <- c("add1", "drop1", "lag.plot", "plot.lm", "plot.mlm", "step", "weighted.residuals", "example", "plot.design")

SKIP <- c(CRASH, ERROR, RANDOM, POPUP, CLICK)
for(RKWARD_PKG in pkgs) {
  foos <- ls(paste("package", RKWARD_PKG, sep = ":"))
  for(RKWARD_FUN in foos) {
    if(RKWARD_FUN %in% SKIP) next
    print(RKWARD_FUN)
    cat(RKWARD_FUN, file=file.path("/tmp", "RKWARD_FUN.txt")) # consider changing; look here if rkward crashes
    try ({myexample(RKWARD_FUN, package=RKWARD_PKG, ask = FALSE, local = TRUE)})
  }
}

