#ifndef _SKIT_BLAS3_NO_TMPL_H
#define _SKIT_BLAS3_NO_TMPL_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// blas 3
// matrix / matrix
// expressions without template expression
//
// author: Pierre.Saramito@imag.fr
//
// date: 11 march 1997
//
// NOTE: use #define's for size code reduction
//
# include "rheolef/diag.h"
# include "rheolef/csr.h"
# include "rheolef/vec.h"
# include "rheolef/avec.h"
# include "rheolef/blas-algorithm.h"
namespace rheolef { 

// ==========================[ MAT AND DIAG ]====================================
template <class T>
csr<T>
operator * (const basic_diag<T>& d, const csr<T>& b);

template <class T>
csr<T>
operator * (const csr<T>& a, const basic_diag<T>& d);

template <class T>
csr<T>
operator *= (csr<T>& a, const basic_diag<T>& d);

// ===========================[ MAT +- MAT ]=====================================

template <class T>
csr<T>
operator + (const csr<T>& a, const csr<T>& b);

template <class T>
csr<T>
operator - (const csr<T>& a, const csr<T>& b);

template <class T>
csr<T>
operator * (const csr<T>& a, const csr<T>& b);

}// namespace rheolef
#endif // _SKIT_BLAS3_NO_TMPL_H
