#!/bin/sh
numbering_list=$*
old_file="numbering.cc"
new_file="numbering.cc.new"

cat > ${new_file} << EOF1
// file automatically generated by: $0
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/numbering.h"
EOF1

for numbering in ${numbering_list}; do
 echo "#include \"${numbering}_numbering.h\"" >>  ${new_file}
done

cat >> ${new_file} << EOF2
namespace rheolef {
using namespace std;

numbering_rep* 
numbering_rep::make_ptr (string name) 
{
  // TODO: use gperf instead of a long if-else test suite
  if (name == "") return 0;
EOF2

for numbering in ${numbering_list}; do
  echo "  if (name == \"${numbering}_numbering\") return new_macro(numbering_${numbering});" >>  ${new_file}
done

cat >> ${new_file} << EOF3
  error_macro ("undefined numbering \`" << name << "'");
}

} // namespace rheolef
EOF3

if test ! -f ${old_file}; then
  mv ${new_file} ${old_file}
  echo "! file ${old_file} created." 1>&2
elif diff ${old_file} ${new_file} >/dev/null; then
  echo "! file ${old_file} unchanged." 1>&2
  rm -f ${new_file}
else
  mv ${new_file} ${old_file}
  echo "! file ${old_file} modified." 1>&2
fi

exit 0
