#include "rheolef.h"
using namespace rheolef;
using namespace std;
size_t N; 
Float u_ex (const point& x) { return 0.5*(x[0]*(1-x[0]) + x[1]*(1-x[1]) + x[2]*(1-x[2]))/Float(N); }
Float g    (const point& x) { return u_ex(x) - 0.5/N; }
int main(int argc, char**argv) {
  environment distributed(argc, argv);
  geo omega (argv[1]);
  Float prec = (argc > 2) ? atof(argv[2]) : 1e-10;
  N = omega.dimension();
  space Xh (omega, "P1");
  space Wh (omega["boundary"], "P1");
  form a  (Xh, Xh, "grad_grad");
  form ab (Xh, Xh, "mass", omega["boundary"]);
  a = a + ab;
  form m  (Xh, Xh, "mass");
  form mb (Wh, Xh, "mass") ;
  field fh (Xh, 1);
  field gh = interpolate(Wh, g);
  field uh (Xh);
  solver sa (a.uu);
  uh.u = sa.solve (m.uu*fh.u + m.ub*fh.b + mb.uu*gh.u + mb.ub*gh.b - a.ub*uh.b);
  dcout << uh;
}
