#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv) {
  environment distributed (argc, argv);
  geo omega (argv[1]);
  space Xh (omega, "P1");
  Xh.block("boundary");
  form a (Xh, Xh, "grad_grad");
  form m (Xh, Xh, "mass");
  field fh (Xh, 1.0);
  field uh (Xh);
  uh ["boundary"] = 0;
  solver sa (a.uu);
  uh.u = sa.solve (m.uu*fh.u + m.ub*fh.b - a.ub*uh.b);
  dcout << uh;
}
