#!/bin/sh
NPROC_MIN=${NPROC_MIN-"1"}
silent_run () {
  run_status=0
  command="$*"
  echo "      $command"
  eval "$command"
  if test $? -ne 0; then run_status=1; fi
  return $run_status
}
run () {
  run_status=0
  command="$*"
  echo "      $command"
  eval "$command"
  if test $? -ne 0; then run_status=1; echo "        => *NO*"; fi
  return $run_status
}
loop_mpirun () {
  mpi_status=0
  mpi_command="$*"
  if test "${MPIRUN}" = "" -o "${NPROC_MAX}" = ""; then
    silent_run ${mpi_command}
    if test $? -ne 0; then mpi_status=1; echo "        => *NO*"; fi
  else
    nproc=${NPROC_MIN}
    while test ${nproc} -le ${NPROC_MAX}; do
      silent_run "${MPIRUN} -np ${nproc} ${mpi_command}"
      if test $? -ne 0; then mpi_status=1; echo "        => *NO*"; fi
      #sleep 1
      nproc=`expr ${nproc} + 1`
    done
  fi
  return $mpi_status
}
