# test-jit-lib.R
# Some of the arithmetic tests are redundant and could be removed.

gctorture(GCTORTURE.FLAG)
jit.flag <- 0
xglobal <- c(10,20,NaN,NA,0)
options(warn=1)         # print warnings as they occur

print(R.version.string)

cat("Starting test: JIT.FLAG", JIT.FLAG, "TRACE.FLAG", TRACE.FLAG,
    "GCTORTURE.FLAG", GCTORTURE.FLAG, "\n")

if (is.ra && length(grep(" Ra ", R.version.string)) != 1)
    warning("No Ra in R.version.string")

show.diffs <- function(test.jit, test.no.jit)
{
    if (length(test.jit) != length(test.no.jit)) {
        cat("length(test.jit)", length(test.jit),
            "length(test.no.jit)", length(test.no.jit), "\n")
        cat("non jitted answer", typeof(test.jit), "\n")
        print(test.jit)
        cat("jitted answer", typeof(test.no.jit), "\n")
        print(test.no.jit)
    } else if (is.matrix(test.jit)) {
        cat("Matrix differences:\n")
        for(i in 1:nrow(test.jit))
            for(j in 1:ncol(test.jit))
                if (!identical(test.jit[i,j], test.no.jit[i,j]))
                    cat("        ans[", i, ",", j, "] <- ", test.jit[i,j],
                        " # was ", test.no.jit[i,j], "\n", sep="")
    } else if (is.vector(test.jit)) {
        cat("Vector differences:\n")
        for(i in 1:length(test.jit))
           if (!identical(test.jit[i], test.no.jit[i]))
                cat("        ans[", i, "] <- ", test.jit[i],
                    " # was ", test.no.jit[i], "\n ", sep="")
    } else {
        cat("non jitted answer", typeof(test.jit), "\n")
        print(test.jit)
        cat("jitted answer", typeof(test.no.jit), "\n")
        print(test.no.jit)
   }
}

test <- function(test.func, ...)
{
    cat("Testing ", paste(substitute(test.func)),
        " for jit(", JIT.FLAG, ")\n", sep="")

    jit.flag <<- 0;        test.no.jit <- test.func(...)
    jit.flag <<- JIT.FLAG; test.jit    <- test.func(...)

    cat(paste(substitute(test.func)), "returns:\n")
    print(test.no.jit)

    if (!identical(test.jit, test.no.jit)) {
        show.diffs(test.no.jit, test.jit)
        stop("identical test failed for jit(", JIT.FLAG, ")")
    }
    cat("Tested ", paste(substitute(test.func)),
        " with jit(", JIT.FLAG, ") OK\n", sep="")
}

#------------------------------------------------------------------------------
# basic tests

test.test <- function(...)  # test test() and jit()
{
    jit(jit.flag, TRACE.FLAG)
    jit.state = jit()      # call jit() not from within a function
    if (is.ra && jit.flag) {
        stopifnot(jit.state[1] == jit.flag)
        stopifnot(jit.state[2] == TRACE.FLAG)
        stopifnot(jit.state[3] == jit.flag)
    } else {
        stopifnot(jit.state[1] == 0)
        stopifnot(jit.state[2] == 0)
        stopifnot(jit.state[3] == 0)
    }
    if (jit.state[1])
        cat("jit is on\n")
    else
        cat("jit is off\n")
    1
}
test(test.test)
f158 <- function(...)   # simple assignment
{
    jit(jit.flag, TRACE.FLAG)
    jit.state <- jit()
    cat("is.ra", is.ra, "jit.state", paste(jit.state, sep=" "), "\n")
    x <- 0
    for(i in as.double(1:3))
        x <- 3
    x
}
test(f158)
f160 <- function(...)   # assignment real1 <- real1
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for(i in as.double(1:3))
        x <- i
    x
}
test(f160)
f162_global=7
f162 <- function(...)   # assignment real1 <- globalreal1
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for(i in 1:3)
        x <- f162_global
    x
}
test(f162)
f164_global<-7
f164 <- function(...)   # assignment globalreal1 <- real1
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for(i in 1:3)
        f164_global <- x
    f164_global
}
test(f164)
f108_global=7
f108 <- function(...)   # assignment real1 <- globalreal1
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for(i in 1:3)
        x <- f108_global + x + 9
    print(x)
    x
}
test(f108)

# Removed test because correctly causes
# "Cannot change jitted symbol 'f110_global' to local scope"
# f110_global<-7
# f110 <- function(...)   # assignment globalreal1 <- real1
# {
#     jit(jit.flag, TRACE.FLAG)
#     x <- 0
#     for(i in 1:3)
#         f110_global <- 3 + x * f016_global
#     f110_global
# }
# test(f110)

f112_global<-7
f112 <- function(...)   # assignment globalreal1 <- real1
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for(i in 1:3)
        f112_global <- 3 + x
    f112_global
}
test(f112)
f114 <- function(...)   # assignment pi <- real1
{
    jit(jit.flag, TRACE.FLAG)
    saved.pi <- pi
    x <- 2
    for(i in 1:3)
        pi <- 1000 + x
    new.pi <- pi
    pi <- saved.pi
    new.pi
}
test(f114)
f116 <- function(...)   # assignment int1 <- int1
{
    jit(jit.flag, TRACE.FLAG)
    x <- as.integer(0)
    for(i in 1:3)
        x <- i
    x
}
test(f116)
f118 <- function(...)   # assignment real <- real
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    y <- c(-9,0,10,11,-12)
    for(i in 1:3)
        x <- y
    x
}
test(f118)
f119 <- function(...) # intermingle function calls
{
    foo <- function(x) x+99
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for(i in 1:5) {
        x <- x + sin(i) + 2 + 3
        x <- x + foo(i)
        x <- x + 4 + foo(x)
        # RA_TODO: jitter limitation in expression below, +6 is not compiled
        x <- x + 5 + foo(x) + 6
    }
    x
}
test(f119)
# test assignments of different types to vars of different scopes
f120_1 <- 4; f023_2 <- "a"; f023_3 <- NA; f023_4 <- 2:4
f120_5 <- 2; f023_6 <- 3;   f023_7 <- 8;  f023_8 <- -1
f120_9 <- -2
f120 <- function()
{
    nested_f <- function(x) x

    jit(jit.flag, TRACE.FLAG)

    x11 <- 4; x12 <- "a"; x13 <- NA; x14 <- 3:5
    x15 <- 2; x16 <- 3;   x17 <- 8;  x18 <- nested_f(as.integer(-1));
    x19 <- sin(-2)
    for(i in 1:3) {
        x1 <- 3;              x2 <- "b";               x3 <- TRUE;     x4 <- 4:6
        x5 <- atan2(2,3);     x6 <- besselI(2, nu=3);  x7 <- 7;        x8 <- nested_f(i)
        x9 <- sin(i)
        x11 <- 3;             x12 <- "b";              x13 <- TRUE;    x14 <- 5:7
        x15 <- atan2(2,3);    x16 <- besselI(2, nu=3); x17 <- 7;       x18 <- nested_f(i)
        x19 <- sin(i)
        f120_1 <- 3;          f023_2 <- "b";              f023_3 <- TRUE; f023_4 <- 6:8
        f120_5 <- atan2(2,3); f023_6 <- besselI(2, nu=3); f023_7 <- 7;    f023_8 <- nested_f(i)
        f120_9 <- sin(i)
    }
    c(x1,x2,x3,x4,
      x5,x6,x7,x8,
      x9,
      x11,x12,x13,x14,
      x15,x16,x17,x18,
      x19,
      f120_1,f023_2,f023_3,f023_4,
      f120_5, f023_6,f023_7,f023_8,
      f120_9)
}
test(f120)
# as f120 above but use nested funcs and args
f124_x <- -2;  f024_0a <- -1; f024_0b <- -9; f024_0c <- -8; f024_1 <- 4
f124_2 <- "a"; f024_3 <- NA;  f024_4 <- 2:4; f024_5 <- 2;   f024_6 <- 3
f124_7 <- 8;   f024_8 <- -1;  f024_9 <- -2
f124_aux <- function(y1, y2)
{
    f124_x <- -3; x20a <- y1; x20a <- y2; x20c <- y2; x21 <- 4
    x22 <- "a";   x23 <- NA;  x24 <- 3:5; x25 <- 2;   x26 <- 3
    x27 <- 8;     x28 <- -1;  x29 <- sin(-2)

    nested_f <- function(x) { x+1 }

    nested_g <- function(x) {

        jit(jit.flag, 2)

        x10a <- x;  xx10b <- y1;        x10c <- y2; x11 <- 4;
        x12 <- "b"; x13 <- NA;          x14 <- 3:5; x15 <- 2; x16 <- 3;
        x17 <- 8;  x18 <- nested_f(-1); x19 <- sin(-2)
        for(i in 1:3) {
            f124_x <- -4;      x0a <- x;
            x0b <- y1;         x0c <- y2; x1 <- 3
            x2 <- "c";         x3 <- TRUE;
            x4 <- 4:6;         x5 <- atan2(2,3);  x6 <- besselI(2, nu=3)
            x7 <- 7;           x8 <- nested_f(i + 1);
            x9 <- sin(i)
            x10a <- x + 1;     x10b <- y1 + 1;
            x10c <- y2 + 1;    x11 <- 3;  x12 <- "b"
            x13 <- TRUE;       x14 <- 5:7;
            x15 <- atan2(2,3); x16 <- besselI(2, nu=3)
            x17 <- 7;          x18 <- nested_f(as.double(i));
            x19 <- sin(i)
            x20a <- x + 2;     x20b <- y1 + 2;
            x20c <- y2 + 2;    x21 <- 4
            x22 <- "d";        x23 <- NA;
            x24 <- 7:9;        x25 <- atan2(1,2); x26 <- besselI(2, nu=3)
            x27 <- 8;          x28 <- nested_f(i-3);
            x29 <- sin(i+1)
            f124_0a <- x + 2;  f024_0b <- y1 + 2;
            f124_0c <- y2 + 2; f024_1 <- 3;    f024_2 <- "b";
            f124_3 <- TRUE;    f024_4 <- 6:8;
            f124_5 <- atan2(2,3); f024_6 <- besselI(2, nu=3)
            f124_7 <- 7;       f024_8 <- nested_f(as.double(i)); f024_9 <- sin(i)
        }
        c(x0a,x0b,x0c,x1,
          x2,x3,x4,x5,x6,
          x7,x8,x9,
          x10a,x10b,x10c,x11,
          x12,x13,x14,x15,x16,
          x17,x18,x19,
          x20a,x20b,x20c,x21,x22,x23,x24,x25,x26,
          x27,x28,x29,
          f124_x,f024_0a,f024_0b,f024_0c,f024_1,
          f124_2,f024_3,f024_4,f024_5,f024_6,
          f124_7,f024_8,f024_9)
   }
   nested_g(3.3)
}
f124 <- function(xparam)
{
    f124_aux(xparam, 3.2)
}
test(f124, 3.1)
f126 <- function(...)   # multiple assignments
{
    jit(jit.flag, TRACE.FLAG)
    x1 <- 0; x2 <- 1; x3 <- 2; x4 <- 3; x5 <- 4; x6 <- 5; x7 <- 6
    for(i in 1:3) {
        x1 <- x2 <- 90
        x3 <- x2
        x4 <- x1
        x1 <- x2 <- x5
        x5 <- 91
        x6 <- x7 <- x1 * x2
    }
    c(x1,x2,x3,x4,x5,x6,x7)
}
test(f126)

f128 <- function(...) # basic binop1 with scalars
{
    jit(jit.flag, TRACE.FLAG)
    x <- 1
    for(i in 11:13)
        x <- i+1
    x
}
test(f128)
f130 <- function(...) # basic binop with vector and scalar
{                     # also test '=' versus '<-'
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    for(i in 21:24)
        x = xglobal+1
    x
}
test(f130)
f128a <- function(...) # complicated expression
{
    jit(jit.flag, TRACE.FLAG)
    x <- 1
    for(i in 1:3)
        x <- 2 * ((x + 3) / (4 - x) + 5) + sin(12 * ((x * 13) - (1.1 ^ x) / 15))
    x
}
test(f128a)
f_jiton_off <- function()   # test jit on, jit off
{
          x1 <- 3; for(i in 1:3) x1 <- x1 * 2
jit(1,1); x2 <- 3; for(i in 1:3) x2 <- x2 * 2
jit(1,2); x3 <- 3; for(i in 1:3) x3 <- x3 * 2
jit(1,3); x4 <- 3; for(i in 1:3) x4 <- x4 * 2
jit(1,1); x5 <- 3; for(i in 1:3) x5 <- x5 * 2
jit(0);   x6 <- 3; for(i in 1:3) x6 <- x6 * 2
jit(1,1); x7 <- 3; for(i in 1:3) x7 <- x7 * 2
          x8 <- 3; for(i in 1:3) x8 <- x8 * 2  # jit should still be on

if (!all(x2 == x1))
    stop("test failed")
if (!all(x3 == x1))
    stop("test failed")
if (!all(x4 == x1))
    stop("test failed")
if (!all(x5 == x1))
    stop("test failed")
if (!all(x6 == x1))
    stop("test failed")
if (!all(x7 == x1))
    stop("test failed")
if (!all(x8 == x1))
    stop("test failed")
}
f_jiton_off()

# make sure jit is off even though we left it on in f_jiton_off
jit.state <- jit()
if (any(jit.state)) stop("test failed: jit.state after f_jiton_jitoff")

f134 <- function(...) # test multiple exps in for block
{
    jit(jit.flag, TRACE.FLAG)
    x <- 5
    for(i in 1:3) {
        x <- x + 1
        x <- x + 2
    }
    x
}
test(f134)
f136 <- function(...) # simple subassign and subscript of local
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    for(i in 1:3)
        x[i] <- x[i] + 99
    x
}
test(f136)
f138 <- function(...) # simple subassign of local and subscript of global
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    for(i in 1:3)
        x[i] <- xglobal[i] + 99
    x
}
f140 <- function()    # subassign and subscripts
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    y <- c(-9,0,10,11,-12)
    for(i in 1:3) {
        y[i] <- 3
        x <- y[i]
    }
    c(x,y)
}
test(f140)
f142 <- function(...) # test multiple exps in for block
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    for(i in 1:3) {
        x[i] <- xglobal[i] + 99
        x[i+1] <- x[i] * 2
    }
    x
}
test(f142)
f144 <- function(...) # nested for loops
{                     # this tests check_jit_binding_value val != R_NilValue
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for(i in 1:3)
        for(j in 1:3)
            x <- i+j
    x
}
test(f144)
f146 <- function(...)  # nested for with ifs
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for(i in 1:3)
       for(j in 1:3)
          x <- x + 1
    y <- 0
    for(i in 1:3) {
       for(j in 1:3) {
          y <- y + 1
          if (y == 7)
              break
       }
    }
    z <- 0
    for(i in 1:3) {
       if (z > 7)
          break
       for(j in 1:3) {
          z <- z + 1
       }
    }
    c(x,y,z)
}
test(f146)
f146a <- function(...)  # nested for with ifs
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for(i in 1:3)
       for(j in 1:3)
          x <- x + 1
    y <- 0
    for(i in 1:3) {
       for(j in 1:3) {
          y <- y + 1
          if (y == 2)
             break
       }
    }
    z <- 0
    for(i in 1:5) {
       if (z > 3)
          break
       for(j in 1:3) {
          z <- z + 1
       }
    }
    c(x,y,z)
}
test(f146a)
f148 <- function(...)   # longish loop
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for(i in 1:100)
        x <- x + .1
    x
}
test(f148)
f150 <- function(...) # large jitted expression, compare to f310
{
    jit(jit.flag, 2) # use trace=2 so we see "did not compile" msgs
    x <- 0
    for(i in 1:2) {
        x <- x +  1; x <- x +  2; x <- x +  3; x <- x +  4; x <- x +  5;
        x <- x +  6; x <- x +  7; x <- x +  8; x <- x +  9; x <- x + 10;
        x <- x + 11; x <- x + 12; x <- x + 13; x <- x + 14; x <- x + 15;
        x <- x + 16; x <- x + 17; x <- x + 18; x <- x + 19; x <- x + 20;
        x <- x + 21; x <- x + 22; x <- x + 23; x <- x + 24; x <- x + 25;
        x <- x + 26; x <- x + 27; x <- x + 28; x <- x + 29; x <- x + 30;
        x <- x + 31; x <- x + 32; x <- x + 33; x <- x + 34; x <- x + 35;
        x <- x + 36; x <- x + 37; x <- x + 38; x <- x + 39; x <- x + 40;
        x <- x + 41; x <- x + 42; x <- x + 43; x <- x + 44; x <- x + 45;
        x <- x + 46; x <- x + 47; x <- x + 48; x <- x + 49; x <- x + 50;
        x <- x + 51; x <- x + 52; x <- x + 53; x <- x + 54; x <- x + 55;
        x <- x + 56; x <- x + 57; x <- x + 58; x <- x + 59; x <- x + 60;
        x <- x + 61; x <- x + 62; x <- x + 63; x <- x + 64; x <- x + 65;
        x <- x + 66; x <- x + 67; x <- x + 68; x <- x + 69; x <- x + 70;
        x <- x + 71; x <- x + 72; x <- x + 73; x <- x + 74; x <- x + 75;
        x <- x + 76; x <- x + 77; x <- x + 78; x <- x + 79; x <- x + 80;
        x <- x + 81; x <- x + 82; x <- x + 83; x <- x + 84; x <- x + 85;
        x <- x + 86; x <- x + 87; x <- x + 88; x <- x + 89; x <- x + 90;
        x <- x + 91; x <- x + 92; x <- x + 93; x <- x + 94; x <- x + 95;
        x <- x + 96; x <- x + 97; x <- x + 98; x <- x + 99; x <- x + 100;
    }
    x
}
test(f150)
f152 <- function(...) # parentheses
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    y <- c(-9,0,10,11,-12)
    for(i in 1:3) {
        x <- (i + 1)
        x <- ((i + 1)) + x
        x <- x + (i + 1) * (i + 2)
        x <- x + ((i * 2) + (i * 3))
        y[i] <- x + 3
        x <- x + y[i] + (y[(i+0) + 1]) * ((y[(i+1)]) + 2)
    }
    c(x, y)
}
test(f152)
f152a <- function(...) # parentheses
{
    jit(jit.flag, TRACE.FLAG)
    u <- v <- w <- x <- y <- 0
    y <- c(-9,0,10,11,-12)
    for(i in 1:3) {
        u <- u + (i + 1)
        v <- v + ((i + 1)) + x
        w <- x + (i + 1) * (i + 2)
        x <- x + ((i * 2) + (i * 3))
        y[i] <- x + 3
        x <- x + y[i] + (y[(i+0) + 1]) * ((y[(i+1)]) + 2)
    }
    c(u,v,w,x,y)
    x
}
test(f152a)
f154 <- function(...) # multiple assignments
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    y <- 1
    for(i in 1:3) {
        x <- y <- i + 1
        x <- x + 1
        y <- x + 1
    }
    c(x,y)
}
test(f154)
# Removed because you cannot change jit() state from a jitted expression
# f156 <- function() { # test using jit(0) inside a loop in a jit block
#     jit(jit.flag, 2)
#     x <- 11
#     for (i in 1:5) {
#        x <- i + x
#        if (i > 1) {
#            jit(0, 2)
#            x <- c(x, 3) # check that we can now change length of x
#        }
#        x <- x + i
#     }
#     x
# }
# test(f156)

#------------------------------------------------------------------------------
# if statements

f158a <- function()
{
    jit(jit.flag, 3)
    x <- 0
    z0 <- z1 <- 0
    for (i in 1:3)
        if (1 < 0)              # always false
            x <- x + 10
    for (i in 1:3)
        z0 <- if (1 < 0)        # always false
            x <- x + 20
        else
            x <- x + 200
    for (i in 1:3)
        if (1 > 0)              # always true
            x <- x + 100
    for (i in 1:3)
        z1 <- if (1 > 0)        # always true
            x <- x + 30
        else
            x <- x + 300
    c(x,z0,z1)
}
test(f158a)
f160a <- function()
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    z1 <- z2 <- 0
    for (i in 1:3) {
        x <- x + 1
        if (1 < 0)              # always false
            x <- x + 10
        x <- x + 2
    }
    for (i in 1:3) {
        x <- x + 3
        z1 <- if (1 < 0)        # always false
            x <- x + 20
        else
            x <- x + 200
        x <- x + 4
    }
    for (i in 1:3) {
        x <- x + 5
        if (1 > 0)              # always true
            x <- x + 100
        x <- x + 6
    }
    for (i in 1:3) {
        x <- x + 7
        z2 <- if (1 > 0)        # always true
            x <- x + 30
        else
            x <- x + 300
        x <- x + 8
    }
    c(x,z1,z2)
}
test(f160a)
f162a <- function()
{
    jit(jit.flag, TRACE.FLAG)
    x <- z1 <- z2 <- 0
    for (i in 1:3) {
        x <- x + 1
        if (i %% 2)
            x <- x + 10
        x <- x + 2
    }
    for (i in 1:3) {
        x <- x + 3
        z1 <- if (i %% 2)
            x <- x + 20
        else
            x <- x + 200
        x <- x + 4
    }
    for (i in 1:3) {
        x <- x + 5
        if (i %% 2 != 0)
            x <- x + 100
        x <- x + 6
    }
    for (i in 1:3) {
        x <- x + 7
        z2 <- if (i %% 2 != 0)
            x <- x + 30
        else
            x <- x + 300
        x <- x + 8
    }
    c(x,z1,z2)
}
test(f162a)
f164a <- function() # nested ifs
{
    jit(jit.flag, 3) # want to see generated instructions

    x <- z1 <- z2 <- 0
    for (i in 1:5) {
        if (i %% 3) {
            z1 <- if (i > 2) {
                x <- x + 10
            } else
                x <- x + 11
        } else if (i < 4)
            x <- x + 12
    }
    for (i in 1:5) {
        if (i %% 3) {
            cat("")
            z2 <- if (i > 2) {
                x <- x + 10
                cat("")
            } else
                x <- x + 11
        } else if (i < 4) {
            cat("")
            x <- x + 12
            cat("")
        }
    }
    c(x,z1,z2)
}
test(f164a)
f165 <- function()
{
    jit(jit.flag, TRACE.FLAG)
    x <- z <- 0
    for (i in 1:5)
        z <- if (i %% 2) if (i > 3) x <- x+1
    c(x,z)
}
test(f165)

# RA_TODO following causes assertion fail in DAssertCompatibleType
# f165a <- function() {
#     jit(jit.flag, TRACE.FLAG)
#     x <- 3
#     for (i in 1:3) {
#        x <- if (0) 0
#        x <- 4
#     }
#     x
# }
# test(f165a)

#------------------------------------------------------------------------------
# for, while and repeat loops with break and next

f166 <- function(...) # while
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    while(x < 5)        # 5 makes sure we get to final loop in loops.c:JIT_WHILE
        x <- x + 1
    x
}
test(f166)
f166a <- function(...) # while
{
    jit(jit.flag, 1)    # use trace.flag=1 to check trace.flag=1
    x <- 0
    z <- 0i
    while(x < 5) {      # not jittable body (because z complex)
        z <- z + 1
        x <- x + 1
    }
    list(x,z)
}
test(f166a)
f166b <- function(...)
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    repeat {
        x <- x + 1
        if (x > 30)
            break
        x <- x + 10
    }
    x
}
test(f166b)
f170 <- function(...)
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    repeat {
        x <- x + 1
        if (x == 4)
            next
        x <- x + 2
        if (x >= 7)
            break
    }
    x
}
test(f170)
f170a <- function(...)
{
    jit(jit.flag, 1)    # use trace.flag=1 to check trace.flag=1
    x <- y <- 0
    repeat {
        x <- x + 1
        y <- y + 1
        if (x > 7)
            break
        if (x > 3)
            next
        y <- y + 10
    }
    c(x,y)
}
test(f170a)
f170b <- function(...)
{
    jit(jit.flag, TRACE.FLAG)
    x <- y <- 0
    for (i in 1:5) {
        x <- x + 1
        if (x > 3)
            next
        y <- y + 10
    }
    c(x,y,i)
}
test(f170b)
f170c <- function(...)
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for (i in 1:5) {
        if (i == 1)
            next
        x <- x + i
    }
    c(x,i)
}
test(f170c)
f170d <- function(...)
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for (i in 1:5) {
        if (i == 1)
            break
        x <- x + 1
    }
    c(x,i)
}
test(f170d)
f170e <- function(...)
{
    jit(jit.flag, TRACE.FLAG)
    x <- y <- i <- 0
    while ((i <- i+1) < 9) {
        x <- x + 1
        if (i == 3)
            next
        x <- x + 1
        y <- y + 10
    }
    c(x,y,i)
}
test(f170e)
f170f <- function(...)
{
    jit(jit.flag, TRACE.FLAG)
    x <- y <- z <- i <- 0
    while ((i <- i+1) < 9) {
        x <- x + 1
        if (i == 3)
            break
        x <- x + 1
        y <- y + 10
    }
    c(x,y,i)
}
test(f170f)
f170g <- function(...)
{
    jit(jit.flag, TRACE.FLAG)
    x <- i <- 0
    while ((i <- i+1) < 3) {
        next
        x <- x+1
    }
    c(x,i)
}
test(f170g)
f170i <- function(...)
{
    jit(jit.flag, TRACE.FLAG)
    x <- i <- 0
    while (i != 0) {
        x <- x+1
    }
    c(x,i)
}
test(f170i)
f170j <- function(...) # no execution of loop code
{
    jit(jit.flag, TRACE.FLAG)
    x <- z <- 0
    for (i in c()) z <- z + 1
    while (0) z <- z + 1
    c(x,z,i)
}
test(f170j)

f180 <- function(...) # different kinds of for loops
{
    jit(jit.flag, 2)
    ylogical = FALSE
    yint = 3L
    yreal = 3
    yimag = 3i
    ychar = "3"
    xlist = list(); ylist = list()
    for (ilogical in c(TRUE, FALSE, TRUE))    ylogical <- ylogical & ilogical
    for (iint     in c(1L,2L,3L))             yint <- yint + iint
    for (ireal    in c(1,2,3))                yreal <- yreal + ireal
    for (iimag    in c(1i,2i,3i))             yimag <- yimag + iimag
    for (ichar    in c("a","b","c"))          ychar <- paste(ychar, ichar)
    for (ilist    in list(a="a",b="b",c="c")) ylist <- c(ylist, ilist)

    list(ylogical, ilogical,
        yint, iint,
        yreal, ireal,
        yimag, iimag,
        ychar, ichar,
        ylist, ilist)
}
test(f180)

f182 <- function()      # for loop with real index
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for (i in 1:3)
        for (j in 1.1 : 3.3)
            x <- x + i + j
    x
}
test(f182)
f184 <- function()      # named handling in for loops
{
    jit(jit.flag, TRACE.FLAG)
    j <- 1
    y <- 3
    x <- double(5)
    iseq = as.double(5:9)
    for (i in iseq) {
        x[j] <- y  # after this, y is NAMED
        y <- i
        j <- j + 1
    }
    c(j,i,x,y)
}
test(f184)
f184a <- function()     # named handling in nested for loops
{
    jit(jit.flag, TRACE.FLAG)
    j <- 1
    y <- 3L
    x <- double(15)
    for (k in 1:3) {
        for (i in 5:9) {
            x[j] <- y  # after this, y is NAMED
            y <- i
            j <- j + 1
        }
    }
    c(x,y,j,i,k)
}
if (JIT.FLAG != 2)      # RA_TODO named handling for jit(2)
    test(f184a)

f186 <- function()      # named handling in while loops
{
    jit(jit.flag, TRACE.FLAG)
    i <- 1
    y <- 99
    while (i < 4) {
        y <- i         # 1 2 3  value of y is now named
        i <- i + 1     # 2 3 4  should duplicate here
    }
    c(y, i)
}
test(f186)
f188a <- function()     # basic for loop with real loop variable
{
    jit(jit.flag, TRACE.FLAG)
    y <- 0
    for (i in 1.1:3.1)
        y <- y + i
    c(y, i)
}
test(f188a)
f188b <- function()     # basic for loop with complex loop variable
{
    jit(jit.flag, TRACE.FLAG)
    y <- 1i
    for (i in c(1i,2i,3i))
        y <- y + i
    print(list(y, i))
    list(y, i)
}
test(f188b)
f188c <- function()     # basic for loop with string loop variable
{
    jit(jit.flag, TRACE.FLAG)
    y <- c("1", "2", "3")
    j <- 0
    for (i in c("a", "b", "c")) {
        j <- j + 1
        y[i] <- i
    }
    print(list(y, i, j))
    list(y, i, j)
}
test(f188c)
f188d <- function()     # basic for loop with list loop variable
{
    jit(jit.flag, TRACE.FLAG)
    y <- list(99, "2", "3")
    j <- 0
    for (i in list(1, "b", "c")) {
        j <- j + 1
        y[[i]] <- i
    }
    print(list(y, i, j))
    list(y, i, j)
}
test(f188d)
f188e <- function()     # basic for loop with logical loop variable
{
    jit(jit.flag, TRACE.FLAG)
    y <- TRUE
    for (i in c(TRUE, TRUE, FALSE))
        y <- y | i
    c(y, i)
}
test(f188e)

# RA_TODO not tested: for loops with RAW, EXPR, VEC SXPs

#------------------------------------------------------------------------------
# NAMED handling
# RA_TODO add more NAMED handling tests

f192 <- function(...) # if (needed for next test)
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    for(i in 1:5) {
        if (i %% 3 == 1)
            x[i] <- xglobal[i] + 10
        if (i %% 3 == 2)
            x[i] <- xglobal[i] + 20
        if (i %% 3 == 2)
            x[i] <- x[i] + xglobal[i] + 30
    }
    x
}
test(f192)
f194 <- function(...)
{
    jit(jit.flag, TRACE.FLAG)
    x <- 1
    y <- 2
    for(i in 1:3) {     # enable jitting
        x <- 3
        y <- x
        x <- 4
    }
    x <- 5
    c(x, y)
}
test(f194)
f196 <- function(...)
{
    jit(jit.flag, TRACE.FLAG)
    x <- y <- z <- 0
    for(i in 1:3) {
        x <- 1 + 2
        y <- 3 + 4
        z <- x
    }
    x <- 5
    c(x, y, z)
}
test(f196)
f198 <- function(...)
{
    jit(jit.flag, TRACE.FLAG)
    x <- 1
    y <- 2
    z <- 3
    for(i in 1:3) {
        x <- z
        y <- z
        z <- 4
    }
    z <- 5
    c(x, y, z)
}
test(f198)
f204 <- function(...)
{
    jit(jit.flag, TRACE.FLAG)
    x <- 1
    y <- 2
    z <- 3
    for(i in 1:3) {
        x <- z
        y <- x
        z <- 4
    }
    z <- 5
    c(x, y, z)
}
test(f204)

#------------------------------------------------------------------------------
# jit state nesting

stop.if.not.equal <- function(x, y, tag)
{
    cat("Testing ", tag, " ", sep="")
    if (!all(x == y))
        stop(tag, " failed because ",
             paste(substitute(x)), " != ", paste(substitute(y)))
    cat("OK\n")
}

fa <- function()
{
    jit(JIT.FLAG, 1)
    jit.state <- jit()
    x <- 1
    for(i in 1:3)
        x <- x + 1
    x
}
jit.state <- jit()
stop.if.not.equal(jit.state, 0, "fa_1")
fa()
jit.state <- jit()
stop.if.not.equal(jit.state, 0, "fa_2")
f_with_return <- function()
{
    jit(JIT.FLAG,1)
    x <- 1
    for(i in 1:3)
        x <- x + 2
    return(x)
    for(i in 1:3)
        x <- x + 3
    x
}
f_with_return()
jit.state <- jit()
stop.if.not.equal(jit.state, 0, "f_with_return")
f_call_fa <- function()
{
    x <- 1
    for(i in 1:3)
        x <- x + 4
    fa()
    jit.state <- jit()
    stop.if.not.equal(jit.state, 0, "f_call_fa_1")
    for(i in 1:3)
        x <- x + 5
    x
}
f_call_fa()
jit.state <- jit()
stop.if.not.equal(jit.state, 0, "f_call_fa_2")
fb_call_fa <- function()
{
    local.trace.flag = 1
    jit(JIT.FLAG, local.trace.flag)
    x <- 1
    for(i in 1:3)
        x <- x + 6
    if (TEST.CODE.THAT.ISSUES.WARNINGS) {
        cat("Expect a warning below: ignored jit(1) in fa because ...\n")
        fa()
    }
    jit.state <- jit()
    stop.if.not.equal(jit.state[1], if(is.ra) JIT.FLAG else 0, "fb_call_fa_1")
    stop.if.not.equal(jit.state[2], if(is.ra) local.trace.flag else 0, "fb_call_fa_2")
    stop.if.not.equal(jit.state[3], if(is.ra) JIT.FLAG else 0, "fb_call_fa_2")
    for(i in 1:3)
        x <- x + 7
    return(x)
    for(i in 1:3)
        x <- x + 8
    x
}
fb_call_fa()
jit.state <- jit()
stop.if.not.equal(jit.state, 0, "fb_call_fa_3")
fb_call_fa_with_return <- function()
{
    local.trace.flag = 1
    jit(JIT.FLAG, local.trace.flag)
    x <- 1
    for(i in 1:3)
        x <- x + 9
    if (TEST.CODE.THAT.ISSUES.WARNINGS) {
        cat("Expect a warning below: ignored jit(1) in f_with-return because ...\n")
        f_with_return()
    }
    jit.state <- jit()

    stop.if.not.equal(jit.state[1], if(is.ra) JIT.FLAG else 0, "fb_call_fa_with_return_1")
    stop.if.not.equal(jit.state[2], if(is.ra) local.trace.flag else 0, "fb_call_fa_with_return_2")
    stop.if.not.equal(jit.state[3], if(is.ra) JIT.FLAG else 0, "fb_call_fa_with_return_3")

    for(i in 1:3)
        x <- x + 10
    return(x)
    for(i in 1:3)
        x <- x + 11
    x
}
fb_call_fa_with_return()
jit.state <- jit()
stop.if.not.equal(jit.state, 0, "fb_call_fa_with_return_4")

test_jit_in_nested_func <- function()
{
    nested_func <- function()
    {
        jit.state <- jit()
        stop.if.not.equal(jit.state[1], 0,                         "nested_func_1")
        stop.if.not.equal(jit.state[2], 0,                         "nested_func_2")
        stop.if.not.equal(jit.state[3], if(is.ra) JIT.FLAG else 0, "nested_func_3")
    }
    jit(JIT.FLAG,2)
    for (i in 1:3)
        jit.state <- nested_func()

    stop.if.not.equal(jit.state[1], 0,                         "test_jit_in_nested_func_1")
    stop.if.not.equal(jit.state[2], 0,                         "test_jit_in_nested_func_2")
    stop.if.not.equal(jit.state[3], if(is.ra) JIT.FLAG else 0, "test_jit_in_nested_func_3")

    jit.state <- jit()
    stop.if.not.equal(jit.state[1], if(is.ra) JIT.FLAG else 0, "test_jit_in_nested_func_4")
    stop.if.not.equal(jit.state[2], if(is.ra) 2 else 0,        "test_jit_in_nested_func_5")
    stop.if.not.equal(jit.state[3], if(is.ra) JIT.FLAG else 0, "test_jit_in_nested_func_6")

    # note: in the following, jit is called from within stop.if.not.equal so returns 0
    stop.if.not.equal(jit()[1], 0,                         "test_jit_in_nested_func_7")
    stop.if.not.equal(jit()[2], 0,                         "test_jit_in_nested_func_8")
    stop.if.not.equal(jit()[3], if(is.ra) JIT.FLAG else 0, "test_jit_in_nested_func_9")
}
test_jit_in_nested_func()

#------------------------------------------------------------------------------
# arguments, promises

f205 <- function(arg)   # test arg passing
{
    jit(jit.flag, TRACE.FLAG)
    x <- 1
    for(i in 1:3)
        x <- x + arg
    x
}
test(f205, 1)
test(f205, 2)
f206 <- function(arg=9) # test default arg RA_TODO revisit, extend test
{
    jit(jit.flag, TRACE.FLAG)
    x <- 1
    for(i in 1:3)
        x <- x + arg
    x
}
test(f206)
f208 <- function(arg=9) # test default arg
{
    jit(jit.flag, TRACE.FLAG)
    for(i in 1:3)
        arg <- arg + i
    arg
}
test(f208, 4)
test(f208)
aglobal <- 13
bglobal <- 14
f210 <- function(x)    # lexical scoping 1
{
    jit(jit.flag, TRACE.FLAG)
    a <- 9
    b <- 9.1
    bglobal <- 9.2
    g <- function(y)
    {
        b <- 1; for(i in 1:3) 1 + a + b + aglobal + bglobal + x + y
    }
    for(i in 1:3) 1 + x + g(x)
    NULL
}
test(f210, -1)
f212 <- function(x)    # same as f210 above but force promise
{
    jit(jit.flag, TRACE.FLAG)
    a <- 9
    b <- 9.1
    bglobal <- 9.2
    x <- x # force promise
    g <- function(y)
    {
        b <- 1
        for(i in 1:3)
            2 + a + b + aglobal + bglobal + x + y
    }
    for(i in 1:3) 2 + x + g(x)
    NULL
}
test(f212, -2)
f214 <- function(x)    # lexical scoping 2
{
    a <- 9
    b <- 9.1
    bglobal <- 9.2
    g <- function(y)
    {
        jit(jit.flag, TRACE.FLAG)
        b <- 1
        for(i in 1:3)
            3 + a + b + aglobal + bglobal + x + y
    }
    for(i in 1:3) 3 + x + g(x)
    NULL
}
test(f214, -3)
f216 <- function(x)    # same as f210 above but force promise
{
    a <- 9
    b <- 9.1
    bglobal <- 9.2
    x <- x # force promise
    g <- function(y)
    {
        jit(jit.flag, TRACE.FLAG)
        b <- 1
        for(i in 1:3)
            4 + a + b + aglobal + bglobal + x + y
    }
    for(i in 1:3) 4 + x + g(x)
    NULL
}
test(f216, -4)
f218 <- function(x)
{
    g <- function(y) { jit(jit.flag, TRACE.FLAG); for(i in 1:3) x + y; c(x,y) }
    g(3) + 3
}
test(f218, -4)
f220 <- function(x)
{
    g <- function(y) { jit(jit.flag, TRACE.FLAG); for(i in 1:3) x + y + 1; c(x,y) }
    g(3) + 3
}
test(f220, -4)

f221 <- function(...) {         # test "..." argument
    foo1 <- function(N) {
        jit(jit.flag, TRACE.FLAG)
        for (i in 1:3)
            y <- N + 1
        c(y, N)
    }
    foo1(...)   # pass N as ...
}
test(f221, 12)

#------------------------------------------------------------------------------
# closures

return.incA <- function(inc)
{
    jit(0)
    function(x) { for(i in 1:3) x + inc }
}
incA.by.3 <- return.incA(3)
# following correctly won't get jitted because jit() is outside f
return.incA.jitted <- function(inc)
{
    jit(JIT.FLAG, 1)
    function(x) { for(i in 1:3) x + inc }
}
incA.by.3.jitted <- return.incA.jitted(3)
if (incA.by.3(2.2) != incA.by.3.jitted(2.2))
    stop("incA.by.3.jitted failed")

return.incB <- function(inc)
{
    function(x) { jit(0); for(i in 1:3) x + inc; x + inc }
}
incB.by.3 <- return.incB(3)
return.incB.jitted <- function(inc)
{
    function(x) { jit(JIT.FLAG, 1); for(i in 1:3) x + inc; x + inc }
}
incB.by.3.jitted <- return.incB.jitted(3)
if (incB.by.3(2.2) != incB.by.3.jitted(2.2))
    stop("incB.by.3.jitted failed")

#------------------------------------------------------------------------------
# subscripts

f224 <- function(...) # test subscripts, basic test
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    for(i in 1:3)
        x[i] <- i
    x
}
test(f224)
f226 <- function(...) # test subscripts, basic test
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    for(i in 1:3)
        x[i] <- xglobal[i] + 1 + 99
    x
}
test(f226)
f228 <- function(...) # test calculated subscript
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    for(i in 1:3)
        x[i+1] <- x[i] * 2
    x
}
test(f228)
f230 <- function(...) # test subscripts, vector expression
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    for(i in 1:3)
        x <- x * x[i]
    x
}
test(f230)
f232 <- function(...) # test subscripts, vector expressions
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    y <- c(1,2)
    for(i in 1:3) {
         x[2:3] <- x[1] + 1
         x[3:4] <- x[2] + y
         x[4:5] <- x[3] + c(1,2)
         x[1:2] <- x[4] + i
    }
    x
}
test(f232)

#------------------------------------------------------------------------------
# subassignment

f234 <- function(...) # assignment return values
{
    jit(jit.flag, TRACE.FLAG)
    ans <- list(1,2,3,4,5,6,7,8)
    y <- c(1.1, 2.2, 3.3, 4.4)
    yi <- 1:4
    for(i in 1:3) {
        ans[[1]] <- y[i]
        ans[[2]] <- yi[i]
        ans[[3]] <- y[2]
        ans[[4]] <- yi[2]
        ans[[5]] <- y[i]
        ans[[6]] <- yi[i]
        ans[[7]] <- y[2]
        ans[[8]] <- yi[2]
    }
    c(ans)
}
test(f234)
f236 <- function(...) # subassignment return values
{
    jit(jit.flag, TRACE.FLAG)
    ans <- list(1,2,3,4,5,6,7,8)
    y <- c(1.1, 2.2, 3.3, 4.4)
    yi <- 1:4
    for(i in 1:3) {
        ans[[1]] <- (y[i]  <- y[i])
        ans[[2]] <- (yi[i] <- yi[i])
        ans[[3]] <- (y[2]  <- y[2])
        ans[[4]] <- (yi[2] <- yi[2])
        ans[[5]] <- (y[i]  <- y[i])
        ans[[6]] <- (yi[i] <- yi[i])
        ans[[7]] <- (y[2]  <- y[2])
        ans[[8]] <- (yi[2] <- yi[2])
    }
    c(ans)
}
test(f236)
f238 <- function(...) # nested subassignment
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(1,2,3,4,5)
    y <- c(11,12,13,14,15)
    for(i in 1:3)
         y[ x[i]<-1 ] <- 100 + i
    y
}
test(f238)
f240 <- function(...) # test COMPILING_NOAS
{
    jit(jit.flag, TRACE.FLAG)
    x <- y <- c(11,12,13,14,15)
    k <- 0
    for(i in 1:3) {
       k <- k + 1
       x[k] <- i
       y[k] <- i+10
    }
    y
}
test(f240)
f240a <- function(...) # like f242 but with trace.flag=4
{
    jit(jit.flag, 4)
    x <- y <- c(11,12,13,14,15)
    k <- 0
    for(i in 1:3) {
       k <- k + 1
       x[k] <- i
       y[k] <- i+10
    }
    y
}
test(f240a)

#------------------------------------------------------------------------------
# unary ops i.e. unary plus and unary minus

f244 <- function(...)
{
    jit(jit.flag, 2)
    ans <- double(4)
    ansi <- integer(4)
    ans.vec <- double(4)
    ansi.vec <- integer(4)
    for(i in 1:3) {
        ans[1] <- -3
        ans[2] <- -i
        ans[3] <- -NaN
        ans[4] <- +4
        ansi[1] <- -as.integer(4)
        ansi[2] <- -i
        ansi[3] <- -NA
        ansi[4] <- +i
        ans.vec <- -ans
        ansi.vec <- -ansi
    }
    c(ans, as.double(ansi), ans.vec, as.double(ansi.vec))
}
test(f244)

#------------------------------------------------------------------------------
# binary ops

f246 <- function(...) # binops: scalar+scalar
{
    jit(jit.flag, TRACE.FLAG)
    ans <- double(112)
    for(i in 1:3) {
        ans[ 1] <- 2 + 3  # r1 r1
        ans[ 2] <- 2 - 3
        ans[ 3] <- 2 * 3
        ans[ 4] <- 2 / 3
        ans[ 5] <- 2 ^ 3
        ans[ 6] <- 2 %% 3
        ans[ 7] <- 2 %/% 3

        ans[ 8] <- i + 3  # i1 r1
        ans[ 9] <- i - 3
        ans[10] <- i * 3
        ans[11] <- i / 3
        ans[12] <- i ^ 3
        ans[13] <- i %% 3
        ans[14] <- i %/% 3

        ans[15] <- 2 + i # r1 i1
        ans[16] <- 2 - i
        ans[17] <- 2 * i
        ans[18] <- 2 / i
        ans[19] <- 2 ^ i
        ans[20] <- 2 %% i
        ans[21] <- 2 %/% i

        ans[22] <- i + i # i1 i1
        ans[23] <- i - i
        ans[24] <- i * i
        ans[25] <- i / i
        ans[26] <- i ^ i
        ans[27] <- i %% i
        ans[28] <- i %/% i

        # negative first argument (mostly for testing %% and %/%)

        ans[29] <- -2 + 3  # r1 r1
        ans[30] <- -2 - 3
        ans[31] <- -2 * 3
        ans[32] <- -2 / 3
        ans[33] <- -2 ^ 3
        ans[34] <- -2 %% 3
        ans[35] <- -2 %/% 3

        ans[36] <- -i + 3  # i1 r1
        ans[37] <- -i - 3
        ans[38] <- -i * 3
        ans[39] <- -i / 3
        ans[40] <- -i ^ 3
        ans[41] <- -i %% 3
        ans[42] <- -i %/% 3

        ans[43] <- -2 + i # r1 i1
        ans[44] <- -2 - i
        ans[45] <- -2 * i
        ans[46] <- -2 / i
        ans[47] <- -2 ^ i
        ans[48] <- -2 %% i
        ans[49] <- -2 %/% i

        ans[50] <- -i + i # i1 i1
        ans[51] <- -i - i
        ans[52] <- -i * i
        ans[53] <- -i / i
        ans[54] <- -i ^ i
        ans[55] <- -i %% i
        ans[56] <- -i %/% i

        # negative second argument  (mostly for testing %% and %/%)

        ans[57] <- 2 + -3  # r1 r1
        ans[58] <- 2 - -3
        ans[59] <- 2 * -3
        ans[60] <- 2 / -3
        ans[61] <- 2 ^ -3
        ans[62] <- 2 %% -3
        ans[63] <- 2 %/% -3

        ans[64] <- i + -3  # i1 r1
        ans[65] <- i - -3
        ans[66] <- i * -3
        ans[67] <- i / -3
        ans[68] <- i ^ -3
        ans[69] <- i %% -3
        ans[70] <- i %/% -3

        ans[71] <- 2 + -i # r1 i1
        ans[72] <- 2 - -i
        ans[73] <- 2 * -i
        ans[74] <- 2 / -i
        ans[75] <- 2 ^ -i
        ans[76] <- 2 %% -i
        ans[77] <- 2 %/% -i

        ans[78] <- i + -i # i1 i1
        ans[79] <- i - -i
        ans[80] <- i * -i
        ans[81] <- i / -i
        ans[82] <- i ^ -i
        ans[83] <- i %% -i
        ans[84] <- i %/% -i

        # negative both arguments  (mostly for testing %% and %/%)

        ans[85] <- -2 + -3  # r1 r1
        ans[86] <- -2 - -3
        ans[87] <- -2 * -3
        ans[88] <- -2 / -3
        ans[89] <- -2 ^ -3
        ans[90] <- -2 %% -3
        ans[91] <- -2 %/% -3

        ans[92] <- -i + -3  # i1 r1
        ans[93] <- -i - -3
        ans[94] <- -i * -3
        ans[95] <- -i / -3
        ans[96] <- -i ^ -3
        ans[97] <- -i %% -3
        ans[98] <- -i %/% -3

        ans[99] <- -2 + -i # r1 i1
        ans[100] <- -2 - -i
        ans[101] <- -2 * -i
        ans[102] <- -2 / -i
        ans[103] <- -2 ^ -i
        ans[104] <- -2 %% -i
        ans[105] <- -2 %/% -i

        ans[106] <- -i + -i # i1 i1
        ans[107] <- -i - -i
        ans[108] <- -i * -i
        ans[109] <- -i / -i
        ans[110] <- -i ^ -i
        ans[111] <- -i %% -i
        ans[112] <- -i %/% -i
    }
    ans
}
test(f246)
f248 <- function(...) # binops: scalar+vector
{
    jit(jit.flag, TRACE.FLAG)
    ans <- matrix(0,nrow=28,ncol=5)
    x <- c(-9,0,10,11,-12)
    xi <- 1:5

    for(i in 1:3) {
        ans[ 1,] <- 2 + x     # r1 r
        ans[ 2,] <- 2 - x
        ans[ 3,] <- 2 * x
        ans[ 4,] <- 2 / x
        ans[ 5,] <- 2 ^ x
        ans[ 6,] <- 2 %% x
        ans[ 7,] <- 2 %/% x

        ans[ 8,] <- i + x     # i1 r
        ans[ 9,] <- i - x
        ans[10,] <- i * x
        ans[11,] <- i / x
        ans[12,] <- i ^ x
        ans[13,] <- i %% x
        ans[14,] <- i %/% x

        ans[15,] <- 2 + xi   # r1 i
        ans[16,] <- 2 - xi
        ans[17,] <- 2 * xi
        ans[18,] <- 2 / xi
        ans[19,] <- 2 ^ xi
        ans[20,] <- 2 %% xi
        ans[21,] <- 2 %/% xi

        ans[22,] <- i + xi   # i1 i
        ans[23,] <- i - xi
        ans[24,] <- i * xi
        ans[25,] <- i / xi
        ans[26,] <- i ^ xi
        ans[27,] <- i %% xi
        ans[28,] <- i %/% xi
    }
    ans
}
test(f248)
f250 <- function(...) # binops: vector+scalar
{
    jit(jit.flag, TRACE.FLAG)
    ans <- matrix(0,nrow=28,ncol=5)
    x <- c(-9,0,10,11,-12)
    xi <- 1:5

    for(i in 1:3) {
        ans[ 1,] <- x + 2     # r r1
        ans[ 2,] <- x - 2
        ans[ 3,] <- x * 2
        ans[ 4,] <- x / 2
        ans[ 5,] <- x ^ 2
        ans[ 6,] <- x %% 2
        ans[ 7,] <- x %/% 2

        ans[ 8,] <- xi + 2    # i r1
        ans[ 9,] <- xi - 2
        ans[10,] <- xi * 2
        ans[11,] <- xi / 2
        ans[12,] <- xi ^ 2
        ans[13,] <- xi %% 2
        ans[14,] <- xi %/% 2

        ans[15,] <- x + i    # r i1
        ans[16,] <- x - i
        ans[17,] <- x * i
        ans[18,] <- x / i
        ans[19,] <- x ^ i
        ans[20,] <- x %% i
        ans[21,] <- x %/% i

        ans[22,] <- xi + i   # i i1
        ans[23,] <- xi - i
        ans[24,] <- xi * i
        ans[25,] <- xi / i
        ans[26,] <- xi ^ i
        ans[27,] <- xi %% i
        ans[28,] <- xi %/% i
    }
    ans
}
test(f250)
f252 <- function(...) # binops: vector+vector, real result
{
    jit(jit.flag, TRACE.FLAG)
    ans <- matrix(0,nrow=28,ncol=6)
    x <- c(-60,-70,-50, 40, 30, 20)
    y <- c( -3,  0,  2, -3,  0, 2)
    xi <- as.integer(x)
    yi <- as.integer(y)

    for(i in 1:3) {
        ans[ 1,] <- x + y     # r r
        ans[ 2,] <- x - y
        ans[ 3,] <- x * y
        ans[ 4,] <- x / y
        ans[ 5,] <- x ^ y
        ans[ 6,] <- x %% y
        ans[ 7,] <- x %/% y

        ans[ 8,] <- xi + y    # i r
        ans[ 9,] <- xi - y
        ans[10,] <- xi * y
        ans[11,] <- xi / y
        ans[12,] <- xi ^ y
        ans[13,] <- xi %% y
        ans[14,] <- xi %/% y

        ans[15,] <- x + yi   # r i
        ans[16,] <- x - yi
        ans[17,] <- x * yi
        ans[18,] <- x / yi
        ans[19,] <- x ^ yi
        ans[20,] <- x %% yi
        ans[21,] <- x %/% yi

        ans[22,] <- xi + yi  # i i
        ans[23,] <- xi - yi
        ans[24,] <- xi * yi
        ans[25,] <- xi / yi
        ans[26,] <- xi ^ yi
        ans[27,] <- xi %% yi
        ans[28,] <- xi %/% yi
    }
    ans
}
test(f252)
f254 <- function(...) # binops: vector+vector, int result
{
    jit(jit.flag, TRACE.FLAG)
    ans <- matrix(as.integer(0),nrow=5,ncol=9)
    # no div by zero test because that causes an error, correctly
    xi <- as.integer(c(-60,-70,-50,  0,  0, 0, 40, 30, 20))
    yi <- as.integer(c( -3, 70,  2, -3, 70, 2, -3, 30, 2))
    for(i in 1:4) {
        ans[1,] <- xi + yi
        ans[2,] <- xi - yi
        ans[3,] <- xi * yi
#       ans[*,] <- xi / yi    # skipped because gives a real result
#       ans[*,] <- xi ^ yi    # skipped because gives a real result
        ans[4,] <- xi %% yi
        ans[5,] <- xi %/% yi
    }
    ans
}
test(f254)

#------------------------------------------------------------------------------
# Binary ops with NA and div-by-zero
# We expect double NAs to be treated as NaNs whether you are jitting or not,
# but not integer NAs.

f256 <- function(...) # binops: scalar+scalar
{
    jit(jit.flag, TRACE.FLAG)
    ans <- double(184)
    ina <- as.integer(NA)
    rna <- as.double(NA)
    izero <- as.integer(0)
    rzero <- 0
    for(i in 1:2) {
        ans[ 1] <- 2 + rna  # r1 r1
        ans[ 2] <- 2 - rna
        ans[ 3] <- 2 * rna
        ans[ 4] <- 2 / rna
        ans[ 5] <- 2 ^ rna
        ans[ 6] <- 2 %% rna
        ans[ 7] <- 2 %/% rna

        ans[ 8] <- i + rna  # i1 r1
        ans[ 9] <- i - rna
        ans[10] <- i * rna
        ans[11] <- i / rna
        ans[12] <- i ^ rna
        ans[13] <- i %% rna
        ans[14] <- i %/% rna

        ans[15] <- rna + i # r1 i1
        ans[16] <- rna - i
        ans[17] <- rna * i
        ans[18] <- rna / i
        ans[19] <- rna ^ i
        ans[20] <- rna %% i
        ans[21] <- rna %/% i

        ans[22] <- i + ina # i1 i1
        ans[23] <- i - ina
        ans[24] <- i * ina
        ans[25] <- i / ina
        ans[26] <- i ^ ina
        ans[27] <- i %% ina
        ans[28] <- i %/% ina

        ans[29] <- 2 / rzero
        ans[30] <- i / rzero
        ans[31] <- rzero / i
        ans[32] <- i / izero
        # this and all divs by izero were removed, see jit.c:ERROR_IDIV_ZERO
        # ans[33] <- i %% izero
        # ans[34] <- i %/% izero

        ans[35] <- 2 ^ rzero
        ans[36] <- i ^ rzero
        ans[37] <- rzero ^ i
        ans[38] <- i ^ izero
        # ans[39] <- i %% izero
        # ans[40] <- i %/% izero

        ans[41] <- rzero ^ 2
        ans[42] <- rzero ^ i
        ans[43] <- i ^ rzero
        ans[44] <- izero ^ i
        ans[45] <- izero %% i
        ans[46] <- izero %/% i
    }
    for(i in 1:2) {
        # negative first operand (mostly for testing  %% and %/%)

        ans[47] <- -2 + rna  # r1 r1
        ans[48] <- -2 - rna
        ans[49] <- -2 * rna
        ans[50] <- -2 / rna
        ans[51] <- -2 ^ rna
        ans[52] <- -2 %% rna
        ans[53] <- -2 %/% rna

        ans[54] <- -i + rna  # i1 r1
        ans[55] <- -i - rna
        ans[56] <- -i * rna
        ans[57] <- -i / rna
        ans[58] <- -i ^ rna
        ans[59] <- -i %% rna
        ans[60] <- -i %/% rna

        ans[61] <- -rna + i # r1 i1
        ans[62] <- -rna - i
        ans[63] <- -rna * i
        ans[64] <- -rna / i
        ans[65] <- -rna ^ i
        ans[66] <- -rna %% i
        ans[67] <- -rna %/% i

        ans[68] <- -i + ina # i1 i1
        ans[69] <- -i - ina
        ans[70] <- -i * ina
        ans[71] <- -i / ina
        ans[72] <- -i ^ ina
        ans[73] <- -i %% ina
        ans[74] <- -i %/% ina

        ans[75] <- -2 / rzero
        ans[76] <- -i / rzero
        ans[77] <- -rzero / i
        ans[78] <- -i / izero
        # ans[79] <- -i %% izero
        # ans[80] <- -i %/% izero

        ans[81] <- -2 ^ rzero
        ans[82] <- -i ^ rzero
        ans[83] <- -rzero ^ i
        ans[84] <- -i ^ izero
        # ans[85] <- -i %% izero
        # ans[86] <- -i %/% izero

        ans[87] <- -rzero ^ 2
        ans[88] <- -rzero ^ i
        ans[89] <- -i ^ rzero
        ans[90] <- -izero ^ i
        ans[91] <- -izero %% i
        ans[92] <- -izero %/% i
    }
    for(i in 1:2) {
        # negative second operand (mostly for testing  %% and %/%)

        ans[93] <- 2 + -rna  # r1 r1
        ans[94] <- 2 - -rna
        ans[95] <- 2 * -rna
        ans[96] <- 2 / -rna
        ans[97] <- 2 ^ -rna
        ans[98] <- 2 %% -rna
        ans[99] <- 2 %/% -rna

        ans[100] <- i + -rna  # i1 r1
        ans[101] <- i - -rna
        ans[102] <- i * -rna
        ans[103] <- i / -rna
        ans[104] <- i ^ -rna
        ans[105] <- i %% -rna
        ans[106] <- i %/% -rna

        ans[107] <- rna + -i # r1 i1
        ans[108] <- rna - -i
        ans[109] <- rna * -i
        ans[110] <- rna / -i
        ans[111] <- rna ^ -i
        ans[112] <- rna %% -i
        ans[113] <- rna %/% -i

        ans[114] <- i + -ina # i1 i1
        ans[115] <- i - -ina
        ans[116] <- i * -ina
        ans[117] <- i / -ina
        ans[118] <- i ^ -ina
        ans[119] <- i %% -ina
        ans[120] <- i %/% -ina

        ans[121] <- 2 / -rzero
        ans[122] <- i / -rzero
        ans[123] <- rzero / -i
        ans[124] <- i / -izero
        # ans[125] <- i %% -izero
        # ans[126] <- i %/% -izero

        ans[127] <- 2 ^ -rzero
        ans[128] <- i ^ -rzero
        ans[129] <- rzero ^ -i
        ans[130] <- i ^ -izero
        # ans[131] <- i %% -izero
        # ans[132] <- i %/% -izero

        ans[133] <- rzero ^ -2
        ans[134] <- rzero ^ -i
        ans[135] <- i ^ -rzero
        ans[136] <- izero ^ -i
        ans[137] <- izero %% -i
        ans[138] <- izero %/% -i
    }
    for(i in 1:2) {
        # negative both operands (mostly for testing  %% and %/%)

        ans[139] <- -2 + -rna  # r1 r1
        ans[140] <- -2 - -rna
        ans[141] <- -2 * -rna
        ans[142] <- -2 / -rna
        ans[143] <- -2 ^ -rna
        ans[144] <- -2 %% -rna
        ans[145] <- -2 %/% -rna

        ans[146] <- -i + -rna  # i1 r1
        ans[147] <- -i - -rna
        ans[148] <- -i * -rna
        ans[149] <- -i / -rna
        ans[150] <- -i ^ -rna
        ans[151] <- -i %% -rna
        ans[152] <- -i %/% -rna

        ans[153] <- -rna + -i # r1 i1
        ans[154] <- -rna - -i
        ans[155] <- -rna * -i
        ans[156] <- -rna / -i
        ans[157] <- -rna ^ -i
        ans[158] <- -rna %% -i
        ans[159] <- -rna %/% -i

        ans[160] <- -i + -ina # i1 i1
        ans[161] <- -i - -ina
        ans[162] <- -i * -ina
        ans[163] <- -i / -ina
        ans[164] <- -i ^ -ina
        ans[165] <- -i %% -ina
        ans[166] <- -i %/% -ina

        ans[167] <- -2 / -rzero
        ans[168] <- -i / -rzero
        ans[169] <- -rzero / -i
        ans[170] <- -i / -izero
        # ans[171] <- -i %% -izero
        # ans[172] <- -i %/% -izero

        ans[173] <- -2 ^ -rzero
        ans[174] <- -i ^ -rzero
        ans[175] <- -rzero ^ -i
        ans[176] <- -i ^ -izero
        # ans[177] <- -i %% -izero
        # ans[178] <- -i %/% -izero

        ans[179] <- -rzero ^ -2
        ans[180] <- -rzero ^ -i
        ans[181] <- -i ^ -rzero
        ans[182] <- -izero ^ -i
        ans[183] <- -izero %% -i
        ans[184] <- -izero %/% -i
    }
    if (jit()[1]) {  # known issues
        ans[7]  <- NA # was -2147483648     2 %/% rna,
        ans[14] <- NA # was -2147483648     i %/% rna,
        ans[21] <- NA # was -2147483648     rna %/% i,
        ans[22] <- NA # was -2147483645     i + ina # i1 i1,
        ans[23] <- NA # was -2147483645     i - ina,
        ans[24] <- NA # was -2147483648     i * ina,
        ans[25] <- NA # was -1.396984e-09   i / ina,
        ans[26] <- NA # was 0               i ^ ina,
        ans[27] <- NA # was 3               i %% ina,
        ans[28] <- NA # was 0               i %/% ina,
        ans[53] <- NA # was -2147483648     -2 %/% rna,
        ans[60] <- NA # was -2147483648     -i %/% rna,
        ans[67] <- NA # was -2147483648     -rna %/% i,
        ans[68] <- NA # was 2147483645      -i + ina # i1 i1,
        ans[69] <- NA # was 2147483645      -i - ina,
        ans[70] <- NA # was -2147483648     -i * ina,
        ans[71] <- NA # was 1.396984e-09    -i / ina,
        ans[72] <- NA # was 0               -i ^ ina,
        ans[73] <- NA # was -3              -i %% ina,
        ans[74] <- NA # was 0               -i %/% ina,
        ans[99] <- NA # was -2147483648     2 %/% -rna,
        ans[106] <- NA # was -2147483648    i %/% -rna,
        ans[113] <- NA # was -2147483648    rna %/% -i,
        ans[114] <- NA # was -2147483645    i + -ina # i1 i1,
        ans[115] <- NA # was -2147483645    i - -ina,
        ans[116] <- NA # was -2147483648    i * -ina,
        ans[117] <- NA # was -1.396984e-09  i / -ina,
        ans[118] <- NA # was 0              i ^ -ina,
        ans[119] <- NA # was 3              i %% -ina,
        ans[120] <- NA # was 0              i %/% -ina,
        ans[145] <- NA # was -2147483648    -2 %/% -rna,
        ans[152] <- NA # was -2147483648    -i %/% -rna,
        ans[159] <- NA # was -2147483648    -rna %/% -i,
        ans[160] <- NA # was 2147483645     -i + -ina # i1 i1,
        ans[161] <- NA # was 2147483645     -i - -ina,
        ans[162] <- NA # was -2147483648    -i * -ina,
        ans[163] <- NA # was 1.396984e-09   -i / -ina,
        ans[164] <- NA # was 0              -i ^ -ina,
        ans[165] <- NA # was -3             -i %% -ina,
        ans[166] <- NA # was 0              -i %/% -ina,
     }
    ans
}
test(f256)
f258 <- function(...) # binops: scalar+vector
{
    jit(jit.flag, TRACE.FLAG)
    ans <- matrix(0,nrow=46,ncol=5)
    ina <- as.integer(NA)
    rna <- as.double(NA)
    izero <- as.integer(0)
    rzero <- 0
    x <- c(-9,-8,10,11,-12)
    xi <- 1:5
    x[1] <- rna
    x[2] <- rzero
    x[3] <- NaN
    xi[2] <- ina
    xi[3] <- izero
    xi[4] <- ina

    for(i in 1:3) {
        ans[ 1,] <- 2 + x     # r1 r
        ans[ 2,] <- 2 - x
        ans[ 3,] <- 2 * x
        ans[ 4,] <- 2 / x
        ans[ 5,] <- 2 ^ x
        ans[ 6,] <- 2 %% x
        ans[ 7,] <- 2 %/% x

        ans[ 8,] <- i + x     # i1 r
        ans[ 9,] <- i - x
        ans[10,] <- i * x
        ans[11,] <- i / x
        ans[12,] <- i ^ x
        ans[13,] <- i %% x
        ans[14,] <- i %/% x

        ans[15,] <- 2 + xi   # r1 i
        ans[16,] <- 2 - xi
        ans[17,] <- 2 * xi
        ans[18,] <- 2 / xi
        ans[19,] <- 2 ^ xi
        ans[20,] <- 2 %% xi
        ans[21,] <- 2 %/% xi

        ans[22,] <- i + xi   # i1 i
        ans[23,] <- i - xi
        ans[24,] <- i * xi
        ans[25,] <- i / xi
        ans[26,] <- i ^ xi
        ans[27,] <- i %% xi
        ans[28,] <- i %/% xi

        ans[29,] <- 2 / rzero
        ans[30,] <- i / rzero
        ans[31,] <- 2 / izero
        ans[32,] <- i / izero
        # ans[33,] <- i %% izero
        # ans[34,] <- i %/% izero

        ans[35,] <- 2 ^ rzero
        ans[36,] <- i ^ rzero
        ans[37,] <- 2 ^ izero
        ans[38,] <- i ^ izero
        # ans[39,] <- i %% izero
        # ans[40,] <- i %/% izero

        ans[41,] <- rzero ^ 2
        ans[42,] <- rzero ^ i
        ans[43,] <- izero ^ 2
        ans[44,] <- izero ^ i
        ans[45,] <- izero %% i
        ans[46,] <- izero %/% i
    }
    if (jit()[1]) {  # known issue
        ans[15,2] <- NA # was -2147483646
        ans[15,4] <- NA # was -2147483646
        ans[16,2] <- NA # was 2147483650
        ans[16,4] <- NA # was 2147483650
        ans[17,2] <- NA # was -4294967296
        ans[17,4] <- NA # was -4294967296
        ans[18,2] <- NA # was -9.313226e-10
        ans[18,4] <- NA # was -9.313226e-10
        ans[19,2] <- NA # was 0
        ans[19,4] <- NA # was 0
        ans[22,2] <- NA # was -2147483646
        ans[22,4] <- NA # was -2147483646
        ans[23,2] <- NA # was -2147483646
        ans[23,4] <- NA # was -2147483646
        ans[24,2] <- NA # was 0
        ans[24,4] <- NA # was 0
        ans[25,2] <- NA # was -9.313226e-10
        ans[25,4] <- NA # was -9.313226e-10
        ans[26,2] <- NA # was 0
        ans[26,4] <- NA # was 0
    }
    ans
}
test(f258)
f260 <- function(...) # binops: vector+scalar
{
    jit(jit.flag, TRACE.FLAG)
    ans <- matrix(0,nrow=46,ncol=5)
    ina <- as.integer(NA)
    rna <- as.double(NA)
    izero <- as.integer(0)
    rzero <- 0
    x <- c(-9,-8,10,11,-12)
    xi <- 1:5
    x[1] <- rna
    x[2] <- rzero
    x[3] <- NaN
    xi[2] <- ina
    xi[3] <- izero
    xi[4] <- ina

    for(i in 1:3) {
        ans[ 1,] <- x + 2     # r r1
        ans[ 2,] <- x - 2
        ans[ 3,] <- x * 2
        ans[ 4,] <- x / 2
        ans[ 5,] <- x ^ 2
        ans[ 6,] <- x %% 2
        ans[ 7,] <- x %/% 2

        ans[ 8,] <- xi + 2    # i r1
        ans[ 9,] <- xi - 2
        ans[10,] <- xi * 2
        ans[11,] <- xi / 2
        ans[12,] <- xi ^ 2
        ans[13,] <- xi %% 2
        ans[14,] <- xi %/% 2

        ans[15,] <- x + i    # r i1
        ans[16,] <- x - i
        ans[17,] <- x * i
        ans[18,] <- x / i
        ans[19,] <- x ^ i
        ans[20,] <- x %% i
        ans[21,] <- x %/% i

        ans[22,] <- xi + i   # i i1
        ans[23,] <- xi - i
        ans[24,] <- xi * i
        ans[25,] <- xi / i
        ans[26,] <- xi ^ i
        ans[27,] <- xi %% i
        ans[28,] <- xi %/% i

        ans[29,] <- x / rzero
        ans[30,] <- xi / rzero
        ans[31,] <- x / izero
        ans[32,] <- xi / izero
        # ans[33,] <- xi %% izero
        # ans[34,] <- xi %/% izero

        ans[35,] <- x ^ rzero
        ans[36,] <- xi ^ rzero
        ans[37,] <- x ^ izero
        ans[38,] <- xi ^ izero
        # ans[39,] <- xi %% izero
        # ans[40,] <- xi %/% izero

        ans[41,] <- rzero ^ x
        ans[42,] <- rzero ^ xi
        ans[43,] <- izero ^ x
        ans[44,] <- izero ^ xi
        ans[45,] <- izero %% xi
        ans[46,] <- izero %/% xi
    }
    # Known issue:
    #    standard R:    0 ^ rna <- Inf
    #    jitted:        0 ^ rna <- NA   tested with gcc 4.2.1-sjlj mingw32-2
    if (jit()[1]) {
        ans[41,1] <- Inf # was NA
        ans[41,3] <- Inf # was NaN
        ans[43,1] <- Inf # was NA
        ans[43,3] <- Inf # was NaN

        ans[8,2] <- NA # was -2147483646
        ans[8,4] <- NA # was -2147483646
        ans[9,2] <- NA # was -2147483650
        ans[9,4] <- NA # was -2147483650
        ans[10,2] <- NA # was -4294967296
        ans[10,4] <- NA # was -4294967296
        ans[11,2] <- NA # was -1073741824
        ans[11,4] <- NA # was -1073741824
        ans[12,2] <- NA # was 4.611686e+18
        ans[12,4] <- NA # was 4.611686e+18
        ans[22,2] <- NA # was -2147483646
        ans[22,4] <- NA # was -2147483646
        ans[23,2] <- NA # was 2147483646
        ans[23,4] <- NA # was 2147483646
        ans[24,2] <- NA # was 0
        ans[24,4] <- NA # was 0
        ans[25,2] <- NA # was -1073741824
        ans[25,4] <- NA # was -1073741824
        ans[26,2] <- NA # was 4.611686e+18
        ans[26,4] <- NA # was 4.611686e+18
        ans[30,2] <- NA # was -Inf
        ans[30,4] <- NA # was -Inf
        ans[32,2] <- NA # was -Inf
        ans[32,4] <- NA # was -Inf
        ans[38,2] <- NA # was 1
        ans[38,4] <- NA # was 1
        ans[44,2] <- NA # was Inf
        ans[44,4] <- NA # was Inf
    }
    ans
}
test(f260)
f261 <- function(...) # binops: vector+vector
{
    jit(jit.flag, TRACE.FLAG)
    rna <- as.double(NA)
    ans <- matrix(0,nrow=28,ncol=25)
    rzero <- 0
    x <- c(rna,   rna,   rna,   rna,   rna,
           rzero, rzero, rzero, rzero, rzero,
           NaN,   NaN,   NaN,   NaN,   NaN,
           11,    11,    11,    11,    11,
           -12,   -12,   -12,   -12,   -12)
    y <- c(rna, rzero, NaN, 11, -12,
           rna, rzero, NaN, 11, -12,
           rna, rzero, NaN, 11, -12,
           rna, rzero, NaN, 11, -12,
           rna, rzero, NaN, 11, -12)
    ina <- as.integer(NA)
    izero <- as.integer(0)
    inan <- as.integer(NaN)
    i11 <- as.integer(11)
    i12 <- as.integer(-12)
    i3 <- as.integer(3)
    i4 <- as.integer(4)
    xi <- c(ina,   ina,   ina,   ina,   ina,
            izero, izero, izero, izero, izero,
            inan,   inan,   inan,   inan,   inan,
            i11,    i11,    i11,    i11,    i11,
            -i12,   -i12,   -i12,   -i12,   -i12)
    # izero not included because would cause div by 0 error
    yi <- c(ina, i11, -i12, i3, i4,
            ina, i11, -i12, i3, i4,
            ina, i11, -i12, i3, i4,
            ina, i11, -i12, i3, i4,
            ina, i11, -i12, i3, i4)

    for(i in 1:3) {
        ans[ 1,] <- x + y     # r r
        ans[ 2,] <- x - y
        ans[ 3,] <- x * y
        ans[ 4,] <- x / y
        ans[ 5,] <- x ^ y
        ans[ 6,] <- x %% y
        ans[ 7,] <- x %/% y

        ans[ 8,] <- xi + y    # i r
        ans[ 9,] <- xi - y
        ans[10,] <- xi * y
        ans[11,] <- xi / y
        ans[12,] <- xi ^ y
        ans[13,] <- xi %% y
        ans[14,] <- xi %/% y

        ans[15,] <- x + yi   # r i
        ans[16,] <- x - yi
        ans[17,] <- x * yi
        ans[18,] <- x / yi
        ans[19,] <- x ^ yi
        ans[20,] <- x %% yi
        ans[21,] <- x %/% yi

        ans[22,] <- xi + yi  # i i
        ans[23,] <- xi - yi
        ans[24,] <- xi * yi
        ans[25,] <- xi / yi
        ans[26,] <- xi ^ yi
        ans[27,] <- xi %% yi
        ans[28,] <- xi %/% yi
    }
    # RA_TODO revisit all these differences and make sure they are all ok
    if (jit()[1]) {
        ans[5,6] <- Inf     # was NA            ans[ 5,] <- x ^ y
        ans[5,8] <- Inf     # was NaN
        ans[5,11] <- NA     # was NaN
        ans[6,2] <- NaN     # was NA            ans[ 6,] <- x %% y
        ans[7,1] <- NA      # was -2147483648   ans[ 7,] <- x %/% y
        ans[7,2] <- NA      # was -2147483648
        ans[7,3] <- NA      # was -2147483648
        ans[7,4] <- NA      # was -2147483648
        ans[7,5] <- NA      # was -2147483648
        ans[7,6] <- NA      # was -2147483648
        ans[7,7] <- NaN     # was -2147483648
        ans[7,8] <- NaN     # was -2147483648
        ans[7,11] <- NA     # was -2147483648
        ans[7,12] <- NaN    # was -2147483648
        ans[7,13] <- NaN    # was -2147483648
        ans[7,14] <- NaN    # was -2147483648
        ans[7,15] <- NaN    # was -2147483648
        ans[7,16] <- NA     # was -2147483648
        ans[7,17] <- Inf    # was -2147483648
        ans[7,18] <- NaN    # was -2147483648
        ans[7,21] <- NA     # was -2147483648
        ans[7,22] <- -Inf   # was -2147483648
        ans[7,23] <- NaN    # was -2147483648
        ans[8,2] <- NA      # was -2147483648   ans[ 8,] <- xi + y    # i r
        ans[8,3] <- NA      # was NaN
        ans[8,4] <- NA      # was -2147483637
        ans[8,5] <- NA      # was -2147483660
        ans[8,12] <- NA     # was -2147483648
        ans[8,13] <- NA     # was NaN
        ans[8,14] <- NA     # was -2147483637
        ans[8,15] <- NA     # was -2147483660
        ans[9,2] <- NA      # was -2147483648   ans[ 9,] <- xi - y
        ans[9,3] <- NA      # was NaN
        ans[9,4] <- NA      # was -2147483659
        ans[9,5] <- NA      # was -2147483636
        ans[9,12] <- NA     # was -2147483648
        ans[9,13] <- NA     # was NaN
        ans[9,14] <- NA     # was -2147483659
        ans[9,15] <- NA     # was -2147483636
        ans[10,2] <- NA     # was 0             ans[10,] <- xi * y
        ans[10,3] <- NA     # was NaN
        ans[10,4] <- NA     # was -23622320128
        ans[10,5] <- NA     # was 25769803776
        ans[10,12] <- NA    # was 0
        ans[10,13] <- NA    # was NaN
        ans[10,14] <- NA    # was -23622320128
        ans[10,15] <- NA    # was 25769803776
        ans[11,2] <- NA     # was -Inf          ans[11,] <- xi / y
        ans[11,3] <- NA     # was NaN
        ans[11,4] <- NA     # was -195225786
        ans[11,5] <- NA     # was 178956971
        ans[11,12] <- NA    # was -Inf
        ans[11,13] <- NA    # was NaN
        ans[11,14] <- NA    # was -195225786
        ans[11,15] <- NA    # was 178956971
        ans[12,3] <- NA     # was NaN           ans[12,] <- xi ^ y
        ans[12,4] <- NA     # was -4.479489e+102
        ans[12,5] <- NA     # was 1.039541e-112
        ans[12,6] <- Inf    # was NA
        ans[12,8] <- Inf    # was NaN
        ans[12,13] <- NA    # was NaN
        ans[12,14] <- NA    # was -4.479489e+102
        ans[12,15] <- NA    # was 1.039541e-112
        ans[13,3] <- NA     # was NaN           ans[13,] <- xi %% y
        ans[13,4] <- NA     # was 9
        ans[13,5] <- NA     # was -8
        ans[13,13] <- NA    # was NaN
        ans[13,14] <- NA    # was 9
        ans[13,15] <- NA    # was -8
        ans[14,1] <- NA     # was -2147483648   ans[14,] <- xi %/% y
        ans[14,2] <- NA     # was -2147483648
        ans[14,3] <- NA     # was -2147483648
        ans[14,4] <- NA     # was -195225787
        ans[14,5] <- NA     # was 178956970
        ans[14,6] <- NA     # was -2147483648
        ans[14,7] <- NaN    # was -2147483648
        ans[14,8] <- NaN    # was -2147483648
        ans[14,11] <- NA    # was -2147483648
        ans[14,12] <- NA    # was -2147483648
        ans[14,13] <- NA    # was -2147483648
        ans[14,14] <- NA    # was -195225787
        ans[14,15] <- NA    # was 178956970
        ans[14,16] <- NA    # was -2147483648
        ans[14,17] <- Inf   # was -2147483648
        ans[14,18] <- NaN   # was -2147483648
        ans[14,21] <- NA    # was -2147483648
        ans[14,22] <- Inf   # was -2147483648
        ans[14,23] <- NaN   # was -2147483648
        ans[15,6] <- NA     # was -2147483648
        ans[15,11] <- NA    # was NaN           ans[15,] <- x + yi   # r i
        ans[15,16] <- NA    # was -2147483637
        ans[15,21] <- NA    # was -2147483660
        ans[16,6] <- NA     # was 2147483648    ans[16,] <- x - yi
        ans[16,11] <- NA    # was NaN
        ans[16,16] <- NA    # was 2147483659
        ans[16,21] <- NA    # was 2147483636
        ans[17,6] <- NA     # was 0             ans[17,] <- x * yi
        ans[17,11] <- NA    # was NaN
        ans[17,16] <- NA    # was -23622320128
        ans[17,21] <- NA    # was 25769803776
        ans[18,6] <- NA     # was 0             ans[18,] <- x / yi
        ans[18,11] <- NA    # was NaN
        ans[18,16] <- NA    # was -5.122274e-09
        ans[18,21] <- NA    # was 5.587935e-09
        ans[19,11] <- NA    # was NaN           ans[19,] <- x ^ yi
        ans[19,16] <- NA    # was 0
        ans[19,21] <- NA    # was 0
        ans[20,6] <- NA     # was 0             ans[20,] <- x %% yi
        ans[20,11] <- NA    # was NaN
        ans[20,16] <- NA    # was -2147483637
        ans[20,21] <- NA    # was -12
        ans[21,1] <- NA     # was -2147483648   ans[21,] <- x %/% yi
        ans[21,2] <- NA     # was -2147483648
        ans[21,3] <- NA     # was -2147483648
        ans[21,4] <- NA     # was -2147483648
        ans[21,5] <- NA     # was -2147483648
        ans[21,6] <- NA     # was 0
        ans[21,11] <- NA    # was -2147483648
        ans[21,12] <- NaN   # was -2147483648
        ans[21,13] <- NaN   # was -2147483648
        ans[21,14] <- NaN   # was -2147483648
        ans[21,15] <- NaN   # was -2147483648
        ans[21,16] <- NA    # was -1
        ans[21,21] <- NA    # was 0
        ans[22,1] <- NA     # was 0             ans[22,] <- xi + yi  # i i
        ans[22,2] <- NA     # was -2147483637
        ans[22,3] <- NA     # was -2147483636
        ans[22,4] <- NA     # was -2147483645
        ans[22,5] <- NA     # was -2147483644
        ans[22,11] <- NA    # was 0
        ans[22,12] <- NA    # was -2147483637
        ans[22,13] <- NA    # was -2147483636
        ans[22,14] <- NA    # was -2147483645
        ans[22,15] <- NA    # was -2147483644
        ans[22,16] <- NA    # was -2147483637
        ans[22,21] <- NA    # was -2147483636
        ans[23,1] <- NA     # was 0             ans[23,] <- xi - yi
        ans[23,2] <- NA     # was 2147483637
        ans[23,3] <- NA     # was 2147483636
        ans[23,4] <- NA     # was 2147483645
        ans[23,5] <- NA     # was 2147483644
        ans[23,11] <- NA    # was 0
        ans[23,12] <- NA    # was 2147483637
        ans[23,13] <- NA    # was 2147483636
        ans[23,14] <- NA    # was 2147483645
        ans[23,15] <- NA    # was 2147483644
        ans[23,16] <- NA    # was -2147483637
        ans[23,21] <- NA    # was -2147483636
        ans[24,1] <- NA     # was 0             ans[24,] <- xi * yi
        ans[24,3] <- NA     # was 0
        ans[24,5] <- NA     # was 0
        ans[24,6] <- NA     # was 0
        ans[24,11] <- NA    # was 0
        ans[24,13] <- NA    # was 0
        ans[24,15] <- NA    # was 0
        ans[24,21] <- NA    # was 0
        ans[25,1] <- NA     # was 1             ans[25,] <- xi / yi
        ans[25,2] <- NA     # was -195225786
        ans[25,3] <- NA     # was -178956971
        ans[25,4] <- NA     # was -715827883
        ans[25,5] <- NA     # was -536870912
        ans[25,6] <- NA     # was 0
        ans[25,11] <- NA    # was 1
        ans[25,12] <- NA    # was -195225786
        ans[25,13] <- NA    # was -178956971
        ans[25,14] <- NA    # was -715827883
        ans[25,15] <- NA    # was -536870912
        ans[25,16] <- NA    # was -5.122274e-09
        ans[25,21] <- NA    # was -5.587935e-09
        ans[26,1] <- NA     # was 0             ans[26,] <- xi ^ yi
        ans[26,2] <- NA     # was -4.479489e+102
        ans[26,3] <- NA     # was 9.61963e+111
        ans[26,4] <- NA     # was -9.90352e+27
        ans[26,5] <- NA     # was 2.126765e+37
        ans[26,6] <- NA     # was Inf
        ans[26,11] <- NA    # was 0
        ans[26,12] <- NA    # was -4.479489e+102
        ans[26,13] <- NA    # was 9.61963e+111
        ans[26,14] <- NA    # was -9.90352e+27
        ans[26,15] <- NA    # was 2.126765e+37
        ans[26,16] <- NA    # was 0
        ans[26,21] <- NA    # was 0
        ans[27,1] <- NA     # was 0             ans[27,] <- xi %% yi
        ans[27,2] <- NA     # was 9
        ans[27,3] <- NA     # was 4
        ans[27,4] <- NA     # was 1
        ans[27,5] <- NA     # was 0
        ans[27,6] <- NA     # was 0
        ans[27,11] <- NA    # was 0
        ans[27,12] <- NA    # was 9
        ans[27,13] <- NA    # was 4
        ans[27,14] <- NA    # was 1
        ans[27,15] <- NA    # was 0
        ans[27,16] <- NA    # was -2147483637
        ans[27,21] <- NA    # was -2147483636
        ans[28,1] <- NA     # was 1
        ans[28,2] <- NA     # was -195225787
        ans[28,3] <- NA     # was -178956971
        ans[28,4] <- NA     # was -715827883
        ans[28,5] <- NA     # was -536870912
        ans[28,6] <- NA     # was 0
        ans[28,11] <- NA    # was 1             ans[28,] <- xi %/% yi
        ans[28,12] <- NA    # was -195225787
        ans[28,13] <- NA    # was -178956971
        ans[28,14] <- NA    # was -715827883
        ans[28,15] <- NA    # was -536870912
        ans[28,16] <- NA    # was -1
        ans[28,21] <- NA    # was -1
    }
    ans
}
test(f261)

#------------------------------------------------------------------------------
# Binary ops with LOGICALs
# Remember, NA is logical

f264 <- function(...) # binops: scalar+scalar
{
    jit(jit.flag, TRACE.FLAG)
    ans <- double(28)
    for(i in 1:2) {
        ans[ 1] <- 2 + 3  # r1 r1
        ans[ 2] <- 2 - 3
        ans[ 3] <- 2 * 3
        ans[ 4] <- 2 / 3
        ans[ 5] <- 2 ^ 3
        ans[ 6] <- 2 %% 3
        ans[ 7] <- 2 %/% 3

        ans[ 8] <- TRUE + 3  # i1 r1
        ans[ 9] <- FALSE - 3
        ans[10] <- NA * 3
        ans[11] <- i / 3
        ans[12] <- i ^ 3
        ans[13] <- i %% 3
        ans[14] <- i %/% 3

        ans[15] <- 2 + TRUE # r1 i1
        ans[16] <- 2 - FALSE
        ans[17] <- 2 * NA
        ans[18] <- 2 / i
        ans[19] <- 2 ^ i
        ans[20] <- 2 %% i
        ans[21] <- 2 %/% i

        ans[22] <- TRUE + i # i1 i1
        ans[23] <- FALSE - i
        ans[24] <- NA * i
        ans[25] <- i / i
        ans[26] <- i ^ i
        ans[27] <- i %% i
        ans[28] <- i %/% i
    }
    if (jit()[1]) {      # known limitation: jit treats NA as INT_MIN
        ans[10] <- NA
        ans[17] <- NA
        ans[24] <- NA
    }

    ans
}
test(f264)
f266 <- function(...) # binops: scalar+vector
{
    jit(jit.flag, TRACE.FLAG)
    ans <- matrix(0,nrow=28,ncol=5)
    x <- c(-9,0,10,11,-12)
    xi <- c(TRUE, FALSE, NA, TRUE, FALSE)

    for(i in 1:3) {
        ans[ 1,] <- 2 + x     # r1 r
        ans[ 2,] <- 2 - x
        ans[ 3,] <- 2 * x
        ans[ 4,] <- 2 / x
        ans[ 5,] <- 2 ^ x
        ans[ 6,] <- 2 %% x
        ans[ 7,] <- 2 %/% x

        ans[ 8,] <- i + x     # i1 r
        ans[ 9,] <- i - x
        ans[10,] <- i * x
        ans[11,] <- i / x
        ans[12,] <- i ^ x
        ans[13,] <- i %% x
        ans[14,] <- i %/% x

        ans[15,] <- 2 + xi   # r1 i
        ans[16,] <- 2 - xi
        ans[17,] <- 2 * xi
        ans[18,] <- 2 / xi
        ans[19,] <- 2 ^ xi
        ans[20,] <- 2 %% xi
        ans[21,] <- 2 %/% xi

        ans[22,] <- i + xi   # i1 i
        ans[23,] <- i - xi
        ans[24,] <- i * xi
        ans[25,] <- i / xi
        ans[26,] <- i ^ xi
        ans[27,] <- i %% xi
        ans[28,] <- i %/% xi
    }
    if (jit()[1]) {      # known limitation: logical NA treated as INT_MIN
        ans[15,3] <- NA
        ans[16,3] <- NA
        ans[17,3] <- NA
        ans[18,3] <- NA
        ans[19,3] <- NA
        ans[22,3] <- NA
        ans[23,3] <- NA
        ans[24,3] <- NA
        ans[25,3] <- NA
        ans[26,3] <- NA
    }
    ans
}
test(f266)
f268 <- function(...) # binops: vector+scalar
{
    jit(jit.flag, TRACE.FLAG)
    ans <- matrix(0,nrow=28,ncol=5)
    x <- c(-9,0,10,11,-12)
    xi <- c(TRUE, FALSE, NA, TRUE, FALSE)

    for(i in 1:3) {
        ans[ 1,] <- x + 2     # r r1
        ans[ 2,] <- x - 2
        ans[ 3,] <- x * 2
        ans[ 4,] <- x / 2
        ans[ 5,] <- x ^ 2
        ans[ 6,] <- x %% 2
        ans[ 7,] <- x %/% 2

        ans[ 8,] <- xi + 2    # i r1
        ans[ 9,] <- xi - 2
        ans[10,] <- xi * 2
        ans[11,] <- xi / 2
        ans[12,] <- xi ^ 2
        ans[13,] <- xi %% 2
        ans[14,] <- xi %/% 2

        ans[15,] <- x + i    # r i1
        ans[16,] <- x - i
        ans[17,] <- x * i
        ans[18,] <- x / i
        ans[19,] <- x ^ i
        ans[20,] <- x %% i
        ans[21,] <- x %/% i

        ans[22,] <- xi + i   # i i1
        ans[23,] <- xi - i
        ans[24,] <- xi * i
        ans[25,] <- xi / i
        ans[26,] <- xi ^ i
        ans[27,] <- xi %% i
        ans[28,] <- xi %/% i
    }
    if (jit()[1]) {      # known limitation: jit treats NA as INT_MIN
        ans[8,3] <- NA
        ans[9,3] <- NA
        ans[10,3] <- NA
        ans[11,3] <- NA
        ans[12,3] <- NA
        ans[22,3] <- NA
        ans[23,3] <- NA
        ans[24,3] <- NA
        ans[25,3] <- NA
        ans[26,3] <- NA
    }
    ans
}
test(f268)
f270 <- function(...) # binops: vector+vector
{
    jit(jit.flag, TRACE.FLAG)
    ans <- matrix(0,nrow=28,ncol=5)
    x <- c(-9,0,10,11,-12)
    xi <- c(TRUE, FALSE, NA, TRUE, FALSE)

    for(i in 1:3) {
        ans[ 1,] <- x + x     # r r
        ans[ 2,] <- x - x
        ans[ 3,] <- x * x
        ans[ 4,] <- x / x
        ans[ 5,] <- x ^ x
        ans[ 6,] <- x %% x
        ans[ 7,] <- x %/% x

        ans[ 8,] <- xi + x    # i r
        ans[ 9,] <- xi - x
        ans[10,] <- xi * x
        ans[11,] <- xi / x
        ans[12,] <- xi ^ x
        ans[13,] <- xi %% x
        ans[14,] <- xi %/% x

        ans[15,] <- x + xi   # r i
        ans[16,] <- x - xi
        ans[17,] <- x * xi
        ans[18,] <- x / xi
        ans[19,] <- x ^ xi
        ans[20,] <- x %% xi
        ans[21,] <- x %/% xi

        ans[22,] <- xi + xi  # i i
        ans[23,] <- xi - xi
        ans[24,] <- xi * xi
        ans[25,] <- xi / xi
        ans[26,] <- xi ^ xi
        ans[27,] <- xi %% xi
        ans[28,] <- xi %/% xi
    }
    if (jit()[1]) {      # known limitation: jit treats NA as INT_MIN
        ans[8,3] <- NA
        ans[9,3] <- NA
        ans[10,3] <- NA
        ans[11,3] <- NA
        ans[12,3] <- NA
        ans[15,3] <- NA
        ans[16,3] <- NA
        ans[17,3] <- NA
        ans[18,3] <- NA
        ans[19,3] <- NA
        ans[22,3] <- NA
        ans[23,3] <- NA
        ans[24,3] <- NA
        ans[25,3] <- NA
        ans[26,3] <- NA
    }
    ans
}
test(f270)

#------------------------------------------------------------------------------
# relops a.k.a comparison ops

f272 <- function(...) # relops: scalar+scalar
{
    jit(jit.flag, TRACE.FLAG)
    ans <- matrix(NA,nrow=3 * 3, ncol=28)
    x <- c(0, 11, -12)
    y <- c(0, 11, -12)
    xi <- c(0L, 11L, -12L)
    yi <- c(0L, 11L, -12L)

    for(j in 1:3) for(k in 1:3) {
        irow <- (j-1)*3 + k
        ans[irow, 1] <- x[j] == y[k]     # r1 r1
        ans[irow, 2] <- x[j] != y[k]
        ans[irow, 3] <- x[j] <  y[k]
        ans[irow, 4] <- x[j] <= y[k]
        ans[irow, 5] <- x[j] >  y[k]
        ans[irow, 6] <- x[j] >= y[k]
        ans[irow, 7] <- !x[j]

        ans[irow, 8] <- xi[j] == y[k]    # i1 r1
        ans[irow, 9] <- xi[j] != y[k]
        ans[irow, 10] <- xi[j] <  y[k]
        ans[irow, 11] <- xi[j] <= y[k]
        ans[irow, 12] <- xi[j] >  y[k]
        ans[irow, 13] <- xi[j] >= y[k]
        ans[irow, 14] <- !(xi[j] == y[k])

        ans[irow, 15] <- x[j] == yi[k]   # r1 i1
        ans[irow, 16] <- x[j] != yi[k]
        ans[irow, 17] <- x[j] <  yi[k]
        ans[irow, 18] <- x[j] <= yi[k]
        ans[irow, 19] <- x[j] >  yi[k]
        ans[irow, 20] <- x[j] >= yi[k]
        ans[irow, 21] <- !yi[k]

        ans[irow, 22] <- xi[j] == yi[k]  # i1 i1
        ans[irow, 23] <- xi[j] != yi[k]
        ans[irow, 24] <- xi[j] <  yi[k]
        ans[irow, 25] <- xi[j] <= yi[k]
        ans[irow, 26] <- xi[j] >  yi[k]
        ans[irow, 27] <- xi[j] >= yi[k]
        ans[irow, 28] <- !(xi[j] == yi[k])
    }
    ans
}
test(f272)
f274 <- function(...) # relops: vector+scalar
{
    jit(jit.flag, TRACE.FLAG)
    ans <- matrix(NA,nrow=16*56,ncol=3)
    x <- c(0, 11, -12)
    y <- c(0, 11, -12)
    xi <- c(0L, 11L, -12L)
    yi <- c(0L, 11L, -12L)

    for(j in 1:3) {
        irow <- (j-1)*56
        ans[irow + 1,] <- x == y[j]     # r r1
        ans[irow + 2,] <- x != y[j]
        ans[irow + 3,] <- x <  y[j]
        ans[irow + 4,] <- x <= y[j]
        ans[irow + 5,] <- x >  y[j]
        ans[irow + 6,] <- x >= y[j]
        ans[irow + 7,] <- !x

        ans[irow +  8,] <- xi == y[j]    # i r1
        ans[irow +  9,] <- xi != y[j]
        ans[irow + 10,] <- xi <  y[j]
        ans[irow + 11,] <- xi <= y[j]
        ans[irow + 12,] <- xi >  y[j]
        ans[irow + 13,] <- xi >= y[j]
        ans[irow + 14,] <- !xi

        ans[irow + 15,] <- x == yi[j]   # r i1
        ans[irow + 16,] <- x != yi[j]
        ans[irow + 17,] <- x <  yi[j]
        ans[irow + 18,] <- x <= yi[j]
        ans[irow + 19,] <- x >  yi[j]
        ans[irow + 20,] <- x >= yi[j]
        ans[irow + 21,] <- !(x == yi[j])

        ans[irow + 22,] <- xi == yi[j]  # i i1
        ans[irow + 23,] <- xi != yi[j]
        ans[irow + 24,] <- xi <  yi[j]
        ans[irow + 25,] <- xi <= yi[j]
        ans[irow + 26,] <- xi >  yi[j]
        ans[irow + 27,] <- xi >= yi[j]
        ans[irow + 28,] <- !(xi == yi[j])

        ans[irow + 29,] <- x[j] == y     # r1 r
        ans[irow + 30,] <- x[j] != y
        ans[irow + 31,] <- x[j] <  y
        ans[irow + 32,] <- x[j] <= y
        ans[irow + 33,] <- x[j] >  y
        ans[irow + 34,] <- x[j] >= y
        ans[irow + 35,] <- !x[j]

        ans[irow + 36,] <- xi[j] == y    # i1 r
        ans[irow + 37,] <- xi[j] != y
        ans[irow + 38,] <- xi[j] <  y
        ans[irow + 39,] <- xi[j] <= y
        ans[irow + 40,] <- xi[j] >  y
        ans[irow + 41,] <- xi[j] >= y
        ans[irow + 42,] <- !xi[j]

        ans[irow + 43,] <- x[j] == yi   # r1 i
        ans[irow + 44,] <- x[j] != yi
        ans[irow + 45,] <- x[j] <  yi
        ans[irow + 46,] <- x[j] <= yi
        ans[irow + 47,] <- x[j] >  yi
        ans[irow + 48,] <- x[j] >= yi
        ans[irow + 49,] <- !yi

        ans[irow + 50,] <- xi[j] == yi  # i1 i
        ans[irow + 51,] <- xi[j] != yi
        ans[irow + 52,] <- xi[j] <  yi
        ans[irow + 53,] <- xi[j] <= yi
        ans[irow + 54,] <- xi[j] >  yi
        ans[irow + 55,] <- xi[j] >= yi
        ans[irow + 56,] <- !xi
    }
    ans
}
test(f274)
f276 <- function(...) # relops: vector+vector
{
    jit(jit.flag, TRACE.FLAG)
    rna <- as.double(NA)
    ans <- matrix(NA,nrow=28,ncol=15)
    x <- c(0,     0,   0,   0,   0,
           11,   11,  11,  11,  11,
           -12, -12, -12, -12, -12)
    y <- c(0, 11, -12,
           0, 11, -12,
           0, 11, -12,
           0, 11, -12,
           0, 11, -12)
    xi <- c(  0L,   0L,   0L,   0L,   0L,
             11L,  11L,  11L,  11L,  11L,
            -12L, -12L, -12L, -12L, -12L)
    yi <- c(0L, 11L, -12L,
            0L, 11L, -12L,
            0L, 11L, -12L,
            0L, 11L, -12L,
            0L, 11L, -12L)

    for(i in 1:4) {
        ans[ 1,] <- x == y     # r r
        ans[ 2,] <- x != y
        ans[ 3,] <- x < y
        ans[ 4,] <- x <= y
        ans[ 5,] <- x > y
        ans[ 6,] <- x >= y
        ans[ 7,] <- !x

        ans[ 8,] <- xi == y    # i r
        ans[ 9,] <- xi != y
        ans[10,] <- xi < y
        ans[11,] <- xi <= y
        ans[12,] <- xi > y
        ans[13,] <- xi >= y
        ans[14,] <- !xi

        ans[15,] <- x == yi   # r i
        ans[16,] <- x != yi
        ans[17,] <- x < yi
        ans[18,] <- x <= yi
        ans[19,] <- x > yi
        ans[20,] <- x >= yi
        ans[21,] <- !x

        ans[22,] <- xi == yi  # i i
        ans[23,] <- xi != yi
        ans[24,] <- xi < yi
        ans[25,] <- xi <= yi
        ans[26,] <- xi > yi
        ans[27,] <- xi >= yi
        ans[28,] <- !xi
    }
    ans
}
test(f276)

#------------------------------------------------------------------------------
# math functions

f278 <- function(...) # test math1_r1
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    for(i in 1:3) {
        x[i] <- sin(xglobal[i])
        x[i] <- x[i] + xglobal[i] + 1 + cos(xglobal[i])
        x[i] <- x[i] + tan(xglobal[i]) + xglobal[i] + 1
    }
    x
}
test(f278)
f280 <- function(...) # test math1_i1
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    for(i in 1:3) {
        x[i] <- sin(i)
        x[i] <- x[i] + xglobal[i] + 1 + cos(i)
        x[i] <- x[i] + tan(i) + xglobal[i] + 1
    }
    x
}
test(f280)
f282 <- function(...) # test math1_r
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    for(i in 1:3) {
        x <- xglobal[i] + 1 + cos(xglobal)
        x <- x + tan(xglobal) + xglobal[i] + 1
    }
    x
}
test(f282)
f284 <- function(...) # test math1_i
{
    jit(jit.flag, TRACE.FLAG)
    x <- c(-9,0,10,11,-12)
    xi <- 1:3
    for(i in 1:5) {
        x <- xglobal[i] + 1 + cos(xi)
        x <- x + tan(xi) + xglobal[i] + 1
    }
    x
}
test(f284)

# Sanity check of math1 funcs, scalar args
# We only test a few values otherwise get loads of warnings
# because we are using the same args for all math funcs.

f285 <- function(x)
{
    jit(jit.flag, TRACE.FLAG)
    xi <- as.integer(x)
    y <- double(54)
    for(i in 1:2) {
        y[ 1] <- floor(x)
        y[ 2] <- floor(xi)
        y[ 3] <- ceiling(x)
        y[ 4] <- ceiling(xi)
        y[ 5] <- sqrt(x)
        y[ 6] <- sqrt(xi)
        y[ 7] <- sign(x)
        y[ 8] <- sign(xi)
        y[ 9] <- trunc(x)
        y[10] <- trunc(xi)
        y[11] <- exp(x)
        y[12] <- exp(xi)
        y[13] <- expm1(x)
        y[14] <- expm1(xi)
        y[15] <- log1p(x)
        y[16] <- log1p(xi)
        y[17] <- cos(x)
        y[18] <- cos(xi)
        y[19] <- sin(x)
        y[20] <- sin(xi)
        y[21] <- tan(x)
        y[22] <- tan(xi)
        y[23] <- acos(if (x <= 1) x else x / 2 ) # prevent warnings
        y[24] <- acos(if (xi <= 1) xi else 0 )
        y[25] <- asin(if (x <= 1) x else x / 2 )
        y[26] <- asin(if (xi <= 1) xi else 0 )
        y[27] <- cosh(x)
        y[28] <- cosh(xi)
        y[29] <- sinh(x)
        y[30] <- sinh(xi)
        y[31] <- tanh(x)
        y[32] <- tanh(xi)
        y[33] <- acosh(x)
        y[34] <- acosh(xi)
        y[35] <- asinh(x)
        y[36] <- asinh(xi)
        y[37] <- atanh(if (x <= 1) x else x / 2 )
        y[38] <- atanh(if (xi <= 1) xi else 0 )
        y[39] <- lgamma(x)
        y[40] <- lgamma(xi)
        y[41] <- gamma(x)
        y[42] <- gamma(xi)
        y[43] <- digamma(x)
        y[44] <- digamma(xi)
        y[45] <- trigamma(x)
        y[46] <- trigamma(xi)
# removed because gammaCody deprecated as from R 2.7.0
#        y[47] <- gammaCody(x)
#        y[48] <- gammaCody(xi)
        y[49] <- log(x)
        y[50] <- log(xi)
        y[51] <- log2(x)
        y[52] <- log2(xi)
        y[53] <- log10(x)
        y[54] <- log10(xi)
    }
    y
}
test(f285, 1)
test(f285, 2)

f285a <- function(x) # math1 funcs, vector args
{
    jit(jit.flag, TRACE.FLAG)
    xi <- as.integer(x)
    y <- matrix(NaN,nrow=54,ncol=3)
    for(i in 1:3) {
        y[ 1,] <- floor(x)
        y[ 2,] <- floor(xi)
        y[ 3,] <- ceiling(x)
        y[ 4,] <- ceiling(xi)
        y[ 5,] <- sqrt(x)
        y[ 6,] <- sqrt(xi)
        y[ 7,] <- sign(x)
        y[ 8,] <- sign(xi)
        y[ 9,] <- trunc(x)
        y[10,] <- trunc(xi)
        y[11,] <- exp(x)
        y[12,] <- exp(xi)
        y[13,] <- expm1(x)
        y[14,] <- expm1(xi)
        y[15,] <- log1p(x)
        y[16,] <- log1p(xi)
        y[17,] <- cos(x)
        y[18,] <- cos(xi)
        y[19,] <- sin(x)
        y[20,] <- sin(xi)
        y[21,] <- tan(x)
        y[22,] <- tan(xi)
        y[23,] <- acos(x)
        y[24,] <- acos(xi)
        y[25,] <- asin(x)
        y[26,] <- asin(xi)
        y[27,] <- cosh(x)
        y[28,] <- cosh(xi)
        y[29,] <- sinh(x)
        y[30,] <- sinh(xi)
        y[31,] <- tanh(x)
        y[32,] <- tanh(xi)
        y[33,] <- acosh(x)
        y[34,] <- acosh(xi)
        y[35,] <- asinh(x)
        y[36,] <- asinh(xi)
        y[37,] <- atanh(x)
        y[38,] <- atanh(xi)
        y[39,] <- lgamma(x)
        y[40,] <- lgamma(xi)
        y[41,] <- gamma(x)
        y[42,] <- gamma(xi)
        y[43,] <- digamma(x)
        y[44,] <- digamma(xi)
        y[45,] <- trigamma(x)
        y[46,] <- trigamma(xi)
# removed because gammaCody deprecated as from R 2.7.0
#        y[47,] <- gammaCody(x)
#        y[48,] <- gammaCody(xi)
        y[49,] <- log(x)
        y[50,] <- log(xi)
        y[51,] <- log2(x)
        y[52,] <- log2(xi)
        y[53,] <- log10(x)
        y[54,] <- log10(xi)
    }
    y
}
test(f285a, c(1, 1, 1)) # these are all 1 to avoid warnings

f285b <- function(x) # abs, must check that result has same type as arg
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for(i in 1:3)
        x <- abs(x)
    x
}
test(f285b, -1L)
test(f285b, 1L)
test(f285b, -1.2)
test(f285b, 1.2)
test(f285b, c(-1.2, 0, 2.3))
test(f285b, c(-1L, 0L, 2L))

#------------------------------------------------------------------------------
# error handling: these deliberately cause an error which we catch in a try block

test.try <- function(f) # for testing that jitting works in f when invoked by try
{
    z <- try(f(), silent=TRUE)
    if (class(z) == "try-error")
        stop("test ", paste(substitute(f)), " jit(", JIT.FLAG,") failed")
}

f286 <- function() # should cause no error, test with test.try
{
    jit(JIT.FLAG,1)
    x <- 0
    for(i in 1:3)
        x <- x+1

}
test.try(f286)  # this is a test of running jitted code under try()

test.err.handling <- function(test.func) # for testing that error caused by test.func is caught
{
    cat("Testing ", paste(substitute(test.func)),
        " with jit(", JIT.FLAG, ")\n", sep="")

    z <- try(test.func(), silent=TRUE)
    if (is.ra) {
        cat("Expect an err message right here-->", gsub("\n", " ", z[1]), "\n")
        if (class(z) != "try-error") {
            cat("\n")
            stop("test ", paste(substitute(test.func)),
                 " failed with JIT.FLAG==", JIT.FLAG,
                 " (it did not produce an error where expected)")
        }
    } else {
        cat("Expect an err message right here--> Correctly no error because is.ra==0\n")
        if (class(z) == "try-error") {
            cat("\n")
            stop("test ", paste(substitute(test.func)),
                 " gave unexpected error with isra==0")
        }
    }
    cat("Tested ", paste(substitute(test.func)),
        " with jit(", JIT.FLAG, ") OK\n", sep="")
}
f288 <- function(...) # cannot change the type of a jitted variable
{
    jit(JIT.FLAG, 1)
    x <- 0
    for(i in 1:5)
        if (i == 4)
            x <- i # double to int
        else
            x <- 2
    x
}
test.err.handling(f288)
f290 <- function(...)
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for(i in 1:3) {
        # The following statement LOOKS LIKE it is changing
        # the type but R changes the lhs to int.
        # Hence we use test() not test.err.handling() below.

        x <- i       # double to int
    }
    x
}
test(f290)
f294 <- function() # ok to change type of jitted variable after jit(0)
{
    foo <- function() {
        jit(JIT.FLAG, 1)
        y <- 0
        for(i in 1:3)
            y <- x + 1  # x gets jitted here
    }   # return does implicit jit(0) here
    x <- 1
    foo()
    x <- "c"
}
test(f294)
f296 <- function() # ok to change type of jitted variable after jit(0)
{
    jit(jit.flag, TRACE.FLAG)
    x <- 1
    for(i in 1:3)
        x <- x + 1    # x gets jitted here
    jit(0)
    x <- "c"
}
test(f296)
f296a <- function()
{
    foo <- function() 3
    jit(jit.flag, TRACE.FLAG)
    x <- 1
    for(i in 1:3)
       for(j in 1:3)
          x <- 2
    jit(0)
    print(system.time(foo()))
    x
}
test(f296a)
f300 <- function(...) # cannot change the type of a jitted variable, nested, arg
{
    foo <- function(x) {
        jit(JIT.FLAG, 4)
        y <- 0
        for(i in 1:3) {
            y <- x + 11 + 12 + 13
            if (i %%2)
                x <- 22
            else
                x <- 23L
        }
    }
    foo(44)
}
test.err.handling(f300)
f302 <- function() # cannot change the length of a jitted variable
{
    jit(JIT.FLAG,1)
    x <- 2
    for(i in 1:3)
        x <- x + 2
    length(x) <- 9
}
test.err.handling(f302)
f302a <- function() # cannot change the length of a jitted variable
{
    jit(JIT.FLAG,1)
    x <- 1
    for(i in 1:3)
        x <- x + 1
    x <- c(1,2,3)  # [1] to [3]
}
test.err.handling(f302a)
f306_global <- 3
f306 <- function() # cannot change jitted variable from non-local to local scope
{
    jit(JIT.FLAG,1)
    x <- 0
    for(i in 1:3) {
        x <- 1 + f306_global
        f306_global <- 4
    }
    x
}
test.err.handling(f306)
f307_global <- 3
f307 <- function() # cannot change jitted variable from non-local to local scope
{
    jit(JIT.FLAG,1)
    for(i in 1:3)
        f307_global <- f307_global + 1
    f307_global
}
test.err.handling(f307)

f308 <- function() # cannot remove a jitted variable
{
    jit(JIT.FLAG,1)
    x <- 0
    for(i in 1:3)
        x <- x + 1
    remove("x")
}
test.err.handling(f308)
f309 <- function()
{
    jit(JIT.FLAG)
    nojit(no.such.variable)
}
if (is.ra)
    test.err.handling(f309)
f309a <- function() # non symbol argument to "nojit"
{
    jit(JIT.FLAG)
    nojit("x")
}
test.err.handling(f309a)

# removed this test because no longer fails with new larger MAX_JIT_EXP_LEN
# f310 <- function() # too many expressions in jit block, compare to f150
# {
#     jit(jit.flag, 2)
#     x <- 0
#     for(i in 1:3) {
#         x <- x +  1; x <- x +  2; x <- x +  3; x <- x +  4; x <- x +  5;
#         x <- x +  6; x <- x +  7; x <- x +  8; x <- x +  9; x <- x + 10;
#         x <- x + 11; x <- x + 12; x <- x + 13; x <- x + 14; x <- x + 15;
#         x <- x + 16; x <- x + 17; x <- x + 18; x <- x + 19; x <- x + 20;
#         x <- x + 21; x <- x + 22; x <- x + 23; x <- x + 24; x <- x + 25;
#         x <- x + 26; x <- x + 27; x <- x + 28; x <- x + 29; x <- x + 30;
#         x <- x + 31; x <- x + 32; x <- x + 33; x <- x + 34; x <- x + 35;
#         x <- x + 36; x <- x + 37; x <- x + 38; x <- x + 39; x <- x + 40;
#         x <- x + 41; x <- x + 42; x <- x + 43; x <- x + 44; x <- x + 45;
#         x <- x + 46; x <- x + 47; x <- x + 48; x <- x + 49; x <- x + 50;
#         x <- x + 51; x <- x + 52; x <- x + 53; x <- x + 54; x <- x + 55;
#         x <- x + 56; x <- x + 57; x <- x + 58; x <- x + 59; x <- x + 60;
#         x <- x + 61; x <- x + 62; x <- x + 63; x <- x + 64; x <- x + 65;
#         x <- x + 66; x <- x + 67; x <- x + 68; x <- x + 69; x <- x + 70;
#         x <- x + 71; x <- x + 72; x <- x + 73; x <- x + 74; x <- x + 75;
#         x <- x + 76; x <- x + 77; x <- x + 78; x <- x + 79; x <- x + 80;
#         x <- x + 81; x <- x + 82; x <- x + 83; x <- x + 84; x <- x + 85;
#         x <- x + 86; x <- x + 87; x <- x + 88; x <- x + 89; x <- x + 90;
#         x <- x + 91; x <- x + 92; x <- x + 93; x <- x + 94; x <- x + 95;
#         x <- x + 96; x <- x + 97; x <- x + 98; x <- x + 99; x <- x + 100;
#         x <- x + 101    # the last straw
#     }
#     x
# }
# test(f310)
f312 <- function() # out of range index %d (allowed range is 1 to %d)
{
    jit(JIT.FLAG,1)
    x <- 1:3
    y <- 0
    for(i in 1:3)
        y <- y - x[i+1]
    y
}
test.err.handling(f312)
f312a <- function() # %/% div by zero
{
    jit(JIT.FLAG,1)
    x <- 1:3
    y <- 0L
    for(i in 1:3)
        y <- 7L %/% 0L
    y
}
test.err.handling(f312a)
f312b <- function() # %% div by zero
{
    jit(JIT.FLAG,1)
    x <- 1:3
    y <- 0L
    for(i in 1:3)
        y <- 9L %% 0L
    y
}
test.err.handling(f312b)
f313 <- function() # integer NA index in jitted expression
{
    jit(JIT.FLAG,1)
    x <- 1:3
    y <- 0
    for(i in 1:3) {
        j <- i
        if (i == 2)
            j <- as.integer(NA)
        y <- y - x[j]
    }
    y
}
test.err.handling(f313)
f314 <- function() # out of range index %g (allowed range is 1 to %d)
{
    jit(JIT.FLAG,1)
    x <- 1:3
    y <- 0
    for(i in 3:1)
        y <- y - x[i-1]
    y
}
test.err.handling(f314)
f315 <- function() # NaN index in jitted expression
{
    jit(JIT.FLAG,1)
    x <- 1:3
    y <- 0
    for(i in as.double(1:3)) {
        j <- i
        if (i == 2)
            j <- NaN
        y <- y - x[j]
    }
    y
}
test.err.handling(f315)
f316 <- function() # disallow if jitting: make an active binding
{
    jit(JIT.FLAG,1)
    f <- function(x) x+1
    jit(JIT.FLAG,1)
    makeActiveBinding("fred", f, .GlobalEnv)
}
test.err.handling(f316)
f318 <- function() # can't change type of while condition
{
    jit(JIT.FLAG,1)
    y <- 1
    x <- while (y) { y <- 0L }
    x
}
test.err.handling(f318)

f319 <- function() # messing with the loop index (try to remove it)
{
    jit(JIT.FLAG,1)
    x <- 1
    for(i in 1:3) {
        x <- x + 1
        remove("i")
    }
    x
}
if (is.ra)
    test.err.handling(f319)
f320 <- function() # messing with the loop index (try to change its type)
{
    jit(JIT.FLAG,1)
    x <- 1
    for(i in 1:3) {
        x <- x + 1
        i <- 1:3
    }
    x
}
test.err.handling(f320)
# RA_TODO: following fails with R 2.7.1 (error is not caught correctly by tryCatch)
# f322 <- function() # funcs called from a JIT block are nested too deeply
# {
#     foo1 <- function(x) foo1(x) # infinite recursion
#     jit(JIT.FLAG,1)
#     foo1(3)
# }
# test.err.handling(f322)

# Removed f399 because it is ok to change the index because the
# condition is precalculated and thus fixed beforehand
# f399 <- function() # can't change type of a for index variable
# {
#     jit(JIT.FLAG,1)
#     x <- for (i in 1:3) { i <- 99 }
#     x
# }
# test.err.handling(f399)

# RA_TODO not tested:
#     cannot unbind jitted variable '%s'
#     cannot use a '...' variable in a jit block
#     disallow if jitting: use active values
#     disallow if jitting: use user defined databases
#     disallow if jitting: attach
#     disallow if jitting: detach
#     disallow if jitting: use mkUnbound
#     disallow if jitting: libfixup
#     locked environments

#------------------------------------------------------------------------------
# test nojit
# RA_TODO add tests for nojit of more kinds of variable, not just local

nojit.global <- 1

test.nojit <- function()
{
    jit(0)
    jit(JIT.FLAG, 2)
    x <- y <- z <- 3
    nojit(x)         # allows use of "c" below which changes the length of x
    nojit(nojit.global)
    for (i in 1:3) {
        x <- c(x,i)  # would have been type change error if !nojit(x)
                     # instead will get "not jitted because unresolved"
        y <- y + i   # will be jitted
        nojit.global <- 99  # will not be jitted
    }
    cat("x", x, "y", y, "\n")
    for (i in 1:3) {
        x <- 1 + i   # will not be jitted because marked nojit
        y <- y + 1   # will be jitted
    }
    cat("x", x, "y", y, "\n")

#     # RA_TODO the following test fails
#     if (TEST.CODE.THAT.ISSUES.WARNINGS) {
#         if (is.ra)
#             cat("Expect a warning right here-->");
#         nojit(y)         # should get warning: ignored nojit because y is already jitted
#     }
    cat("Nojit variables 1:\n")
    if (is.ra)
        print(nojit())        # print no-jit variables, should be x, z, nojit.global
    else                      # else fake it to minimize diff noise
        cat("[1] \"x\"            \"nojit.global\"\n")

    jit(0)                    # clear x's not jittable bit

    jit(JIT.FLAG, 2)          # check that x can now be jitted
    for (i in 1:3)
        x <- x + 1
    cat("x", x, "\n")

    jit(0)                    # clear all no jitted bits
    cat("Nojit variables 2:\n")
    print(nojit())            # check that they are cleared

    if (TEST.CODE.THAT.ISSUES.WARNINGS) {
        cat("Expect a warning right here-->")
        if (!is.ra)
            cat("Correctly no warning because !is.ra\n")
        nojit(x)    # should get warning: ignored "nojit" because not in a JIT block
    }
    jit(1)      # check implicit clear of nojit bits on exit from func
    nojit(nojit.global)
    nojit(x)
    cat("Nojit variables 3:\n")
    if (is.ra)
        print(nojit())        # print no-jit variables, should be x, z, nojit.global
    else                      # else fake it to minimize diff noise
        cat("[1] \"nojit.global\" \"x\"           \n")
}
test.nojit()
cat("Nojit variables 4:\n")
print(nojit())                # print no-jit variables, there should be none

#------------------------------------------------------------------------------
f800 <- function(x)     # test invocation of some common R functions from a jit block
{
    jit(jit.flag, TRACE.FLAG)
    data(cars)
    count <- 0
    for(i in 1:x) {
        set.seed(i)
        x0 <- runif (30, 0, 1)
        x1 <- runif (30, 0, 1)
        count <- count + 1
        lmodel <- summary(lm(speed~dist, data=cars))
        if (i == 3) {
            cat("The answer is\n")
            print(lmodel, signif.stars=FALSE)
        }
        y <- sin(pi * x0) + x1
   }
   c(lmodel$coefficients, lmodel$residuals)
}
test(f800, 3)

#------------------------------------------------------------------------------
# misc tests that test fixes for bug reports

# test fix for wrong value assigned to TOS for
# TOS=eval() in case JIT_if_i in evaljit1.c

if_i_1.default <- function(x) x
if_i_1 <- function (x) UseMethod("if_i_1")
if_i <- function() 
{
    jit(jit.flag, TRACE.FLAG)
    x <- 0
    for(j in 1:3)
        if(1L)
            x <- if_i_1(45)
    x
}
test(if_i)

# test jitContextChangedAux fix for bug submitted by Ben Goodrich may 2008
foo_ben <- function(C = matrix(1, nrow=3, ncol=3), diag = TRUE) {
    vec  <- as.vector(C)
    vecs <- vec[c(lower.tri(C, diag))]
    Kp <- matrix(0, nrow = length(vec), ncol = length(vecs))
    intmat  <- matrix(1L, nrow = nrow(C), ncol = ncol(C))
    mark <- 1
    jit(jit.flag, TRACE.FLAG)
    for(j in 1:ncol(C)) for(i in 1:nrow(C)) {
        if(i >= j) Kp[mark,intmat[mark]]    <- i
        else       Kp[mark,t(intmat)[mark]] <- j
        mark <- mark + 1
    }
    Kp
}
test(foo_ben)

#------------------------------------------------------------------------------
# Test on "real code".  This was copied from maptools 0.6-19 and hacked on.
# Not too much gets compiled here because many of the variables are complex.

pointLabel <- function(x, y = NULL, labels = seq(along = x), cex = 1,
                       method = c("SANN", "GA"),
                       allowSmallOverlap = FALSE,
                       trace = FALSE,
                       doPlot = FALSE,
                       ...)
{
    toUnityCoords <- function(xy) {
            list(x = (xy$x - boundary[1]) / (boundary[2] - boundary[1]) * xyAspect,
            y = (xy$y - boundary[3]) / (boundary[4] - boundary[3]) / xyAspect)
    }
    toUserCoords <- function(xy) {
        list(x = boundary[1] + xy$x / xyAspect * (boundary[2] - boundary[1]),
        y = boundary[3] + xy$y * xyAspect * (boundary[4] - boundary[3]))
    }
    if (!missing(y) && (is.character(y) || is.expression(y))) {
        labels <- y
        y <- NULL
    }
    gen_offset <- function(code) {
        c(-1,  -1,  -1,  0,  0,   1,  1,   1)[code] * (width/2) +
        1i * c(-1,   0,   1, -1,  1,  -1,  0,   1)[code] * (height/2)
    }
    rect_intersect <- function(xy1, offset1, xy2, offset2) {
            w <- pmin(Re(xy1+offset1/2), Re(xy2+offset2/2)) - pmax(Re(xy1-offset1/2), Re(xy2-offset2/2))
            h <- pmin(Im(xy1+offset1/2), Im(xy2+offset2/2)) - pmax(Im(xy1-offset1/2), Im(xy2-offset2/2))
            w[w <= 0] <- 0
            h[h <= 0] <- 0
            w*h
    }
    nudge <- function(offset, rectidx1, rectidx2) {
        doesIntersect <- rect_intersect(xy[rectidx1] + offset[rectidx1], rectv[rectidx1],
                        xy[rectidx2] + offset[rectidx2], rectv[rectidx2]) > 0

        pyth <- abs(xy[rectidx1] + offset[rectidx1] - xy[rectidx2] - offset[rectidx2]) / nudgeFactor
        eps <- 1.0e-10

        for (i in which(doesIntersect & pyth > eps)) {
                idx1 <- rectidx1[i]
                idx2 <- rectidx2[i]
                vect <- (xy[idx1] + offset[idx1] - xy[idx2] - offset[idx2]) / pyth[idx1]
                offset[idx1] <- offset[idx1] + vect
                offset[idx2] <- offset[idx2] - vect
        }
        offset
    }
    SANN <- function(rectidx1, rectidx2) {
        i <- 1; j <- 1 # prevent jit "cannot change jitted symbol 'i' to local scope"
        gene <- rep(8, n_labels)

        # following code was offset <- objective(newgene, rectidx1, rectidx2)
        offset <- gen_offset(gene)
        if (allowSmallOverlap)
            offset <- nudge(offset, rectidx1, rectidx2)
        if (!is.null(rectidx1))
            area <- sum(rect_intersect(xy[rectidx1] + offset[rectidx1], rectv[rectidx1],
                        xy[rectidx2] + offset[rectidx2], rectv[rectidx2]))
        else
            area <- 0
        n_outside <- sum(Re(xy + offset - rectv/2) < 0 | Re(xy + offset + rectv/2) > xyAspect |
                         Im(xy + offset - rectv/2) < 0 | Im(xy + offset + rectv/2) > 1/xyAspect)

        score <- 1000 * area + n_outside
        # end was

        bestgene <- gene
        bestscore <- score
        T <- 2.5
        N1 = 50
        jit(jit.flag, trace.flag)
        for (i in 1:N1) {
            k <- 1
            for (j in 1:N1) {
                newgene <- gene
                # get sample return mismatches unless we use a set.seed below -- why?
                set.seed(1000 * i + j)
                newgene[sample(1:n_labels, 1)] <- sample(1:8,1)
                # following code was newscore <- objective(newgene, rectidx1, rectidx2)
                offset <- gen_offset(gene)
                if (allowSmallOverlap)
                     offset <- nudge(offset, rectidx1, rectidx2)
                if (!is.null(rectidx1))
                    area <- sum(rect_intersect(xy[rectidx1] + offset[rectidx1], rectv[rectidx1],
                                               xy[rectidx2] + offset[rectidx2], rectv[rectidx2]))
                else
                    area <- 0

                n_outside <- sum(Re(xy + offset - rectv/2) < 0 | Re(xy + offset + rectv/2) > xyAspect |
                                 Im(xy + offset - rectv/2) < 0 | Im(xy + offset + rectv/2) > 1/xyAspect)

                newscore <- 1000 * area + n_outside
                # end was

                if (newscore <= score || runif (1) < exp((score - newscore) / T)) {
                    k <- k + 1
                    score <- newscore
                    gene <- newgene
                }
                if (score <= bestscore) {
                    bestscore <- score
                    bestgene <- gene
                }
                if (bestscore == 0 || k == 10)
                # Added "if" so we iterate at least a few times before break.
                # This messes up the algorithm, it doesn't matter
                # for testing jit purposes.
                    if (i > 8 || N1 < 8)
                         break
            }
            if (bestscore == 0)
                break
            if (trace) cat("overlap area =", bestscore, "\n")
            T <- 0.9 * T
        }
        jit(0)
        if (trace) cat("overlap area =", bestscore, "\n")
        nx <- Re(xy + gen_offset(bestgene))
        ny <- Im(xy + gen_offset(bestgene))
        list(x = nx, y = ny)
    }
    labels <- as.graphicsAnnot(labels)
    # changed following two lines to prevent graphics window display
    boundary <- c(0,1,0,1) # was par()$usr
    xyAspect <- 1.1 # was par()$pin[1] / par()$pin[2] # width / height
    z <- xy.coords(x, y, recycle = TRUE)
    z <- toUnityCoords(z)
    x <- z$x
    y <- z$y
    if (length(labels) < length(x))
        labels <- rep(labels, length(x))
    method <- match.arg(method)
    if (allowSmallOverlap)
        nudgeFactor <- 0.02
    n_labels <- length(x)
    # changed following two lines to prevent graphics window popping up
    width <- rep(0.0373, n_labels)  # was (strwidth(labels, units = "figure", cex = cex) + 0.015) * xyAspect
    height <- rep(0.0242, n_labels) # was (strheight(labels, units = "figure", cex = cex) + 0.015) / xyAspect
    xy <- x + 1i * y
    rectv <- width + 1i * height
    rectidx1 <- rectidx2 <- array(0, (length(x)^2 - length(x)) / 2)
    k <- 0
    jit(jit.flag, trace.flag)
    for (i in 1:length(x))
        for (j in seq(len=(i-1))) {
            k <- k + 1
            rectidx1[k] <- i
            rectidx2[k] <- j
        }
    jit(0)
    canIntersect <- rect_intersect(xy[rectidx1], 2 * rectv[rectidx1],
                                   xy[rectidx2], 2 * rectv[rectidx2]) > 0
    rectidx_1 <- rectidx1[canIntersect] # prevent jit "cannot change len"
    rectidx_2 <- rectidx2[canIntersect]
    if (trace) cat("possible intersects =", length(rectidx1), "\n")
    if (trace) cat("portion covered =", sum(rect_intersect(xy, rectv,xy,rectv)),"\n")
    if (method == "SANN")
        xy <- SANN(rectidx_1, rectidx_2)
    else
        stop("only SANN is supported")
    xy <- toUserCoords(xy)
    if (doPlot)
        stop("doPlot not supported")
    invisible(xy)
}
if (JIT.FLAG < 2) { # point label has inner loops which change size
    N <- 5
    x <- runif (N)*10
    y <- runif (N)*10
    jit.flag <- 0; trace.flag <- 0
    set.seed(1)   # for reproducibility
    labels1 <- pointLabel(x, y, method=c("SANN"), as.character(round(x,1)), offset=0, cex=.6)
    jit.flag <- JIT.FLAG; trace.flag <- 2
    set.seed(1)
    labels2 <- pointLabel(x, y, method=c("SANN"), as.character(round(x,1)), offset=0, cex=.6)

    for (i in 1:length(labels1$x))
        if (!identical(labels1$x[i], labels2$x[i]) || !identical(labels1$y[i],labels2$y[i])) {
             cat("mismatch at [", i, "] labels1$x ", labels1$x[i],
                    " labels2$x ", labels2$x[i],
                    " labels1$y ", labels1$y[i],
                    " labels2$y ", labels2$y[i], "\n", sep="")
             stop("mismatch detected in pointLabel")
        }
    stopifnot(identical(labels1, labels2))
}

#------------------------------------------------------------------------------

cat("Done\n")
