/***************************************************************************
                          imageconverterdialog.cpp  -  description
                             -------------------
    begin                : Wed May 22 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "imageconverterdialog.h"

#include "quiteinsane/qxmlconfig.h"

#include <math.h>

#include <qapplication.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <qhbox.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qnamespace.h>
#include <qpixmap.h>
#include <qvbox.h>

ImageConverterDialog::ImageConverterDialog(int preview_size,QImage* image,QWidget* parent)
                     :ImageFilterDialog(preview_size,image,parent)
{
  mModeIndex = 0;
  mDepthIndex = 0;
  mDitherIndex = 0;
  initControls();
}
ImageConverterDialog::~ImageConverterDialog()
{
}
/** No descriptions */
void ImageConverterDialog::initControls()
{
  int mode =  xmlConfig->intValue("FILTER_IMAGECONVERTER_MODE",0);
  int depth =  xmlConfig->intValue("FILTER_IMAGECONVERTER_DEPTH",0);
  int dither =  xmlConfig->intValue("FILTER_IMAGECONVERTER_DITHER",0);
  showContinousUpdate(false);
  QVBox* vb = controlsVBox();
  if(!vb)
    return;
  setTitle(tr("Image Converter"));
  setCaption(tr("Image Converter"));
  //mode
  new QLabel(tr("Mode"),vb);
  mpModeCombo = new QComboBox(vb);
  mpModeCombo->insertItem(tr("RGB"),0);
  mpModeCombo->insertItem(tr("Grayscale"),1);
  mpModeCombo->insertItem(tr("Monochrome"),2);
  mpModeCombo->setCurrentItem(mode);
  new QLabel(tr("Depth"),vb);
  mpDepthCombo = new QComboBox(vb);
  mpDepthCombo->insertItem(tr("24/32 Bit"),0);
  mpDepthCombo->insertItem(tr("8 Bit/Index"),1);
  mpDepthCombo->setCurrentItem(depth);
  new QLabel(tr("Dither"),vb);
  mpDitherCombo = new QComboBox(vb);
  mpDitherCombo->insertItem(tr("Threshold (closest color)"),0);
  mpDitherCombo->insertItem(tr("Diffuse"),1);
  mpDitherCombo->insertItem(tr("Ordered"),1);
  mpDitherCombo->setCurrentItem(dither);
  mpDitherCombo->setEnabled(false);

  QWidget* dummy = new QWidget(vb);
  vb->setStretchFactor(dummy,1);


  slotDepthChanged(depth);
  slotDitherChanged(dither);
  slotModeChanged(mode);

  connect(mpModeCombo,SIGNAL(activated(int)),this,SLOT(slotModeChanged(int)));
  connect(mpDepthCombo,SIGNAL(activated(int)),this,SLOT(slotDepthChanged(int)));
  connect(mpDitherCombo,SIGNAL(activated(int)),this,SLOT(slotDitherChanged(int)));

  setFixedSize(minimumSizeHint());
}
/** No descriptions */
bool ImageConverterDialog::apply(QImage* image,bool emit_progress)
{
  if(!image)
    return false;
  int conversion_flags = 0;
  bool gray = image->allGray();
  int depth = image->depth();

  if(mDitherIndex == 0)
    conversion_flags = QPixmap::ThresholdDither;
  else if(mDitherIndex == 1)
    conversion_flags = QPixmap::DiffuseDither;
  else if(mDitherIndex == 2)
    conversion_flags = QPixmap::OrderedDither;
  conversion_flags |= QPixmap::AvoidDither;

  if((mModeIndex == 0) && !gray)//grayscale
  {
    if((depth == 32) && (mDepthIndex == 0))
    {
      //do nothing
      return true;
    }
    else if((depth == 8) && (mDepthIndex == 1))
    {
      //do nothing
      return true;
    }
    else
    {
      if(mDepthIndex == 0)
        *image = image->convertDepth(32);
      else if(mDepthIndex == 1)
        *image = image->convertDepth(8,conversion_flags);
    }
  }
  //if the image is a RGB image, but grayscale is requested, then convert to grayscale first
  else if((mModeIndex == 1) && !gray)//grayscale
  {
    if(depth == 32)
    {
      for(int y = 0;y < image->height();y++)
      {
        for(int x = 0;x < image->width();x++)
        {
          int gray_val = qGray(image->pixel(x,y));
          image->setPixel(x,y,qRgb(gray_val,gray_val,gray_val));
        }
      }
      *image = image->convertDepth(8);
    }
    else if(depth == 8)
    {
      for(int i = 0;i < image->numColors();i++)
      {
        int gray_val = qGray(image->color(i));
        image->setColor(i,qRgb(gray_val,gray_val,gray_val));
      }
    }
    else if(depth == 1)
    {
      *image = image->convertDepth(8,conversion_flags);
    }
  }
  else if(mModeIndex == 2)//lineart
  {
    *image = image->convertDepth(1,conversion_flags);
  }
  return true;
}
/** No descriptions */
void ImageConverterDialog::setImage(QImage* image)
{
  if(!image)
    return;
  ImageFilterDialog::setImage(image);
}
/** No descriptions */
void ImageConverterDialog::saveConfig()
{
  xmlConfig->setIntValue("FILTER_IMAGECONVERTER_MODE",mModeIndex);
  xmlConfig->setIntValue("FILTER_IMAGECONVERTER_DEPTH",mDepthIndex);
  xmlConfig->setIntValue("FILTER_IMAGECONVERTER_DITHER",mDitherIndex);
}
/** No descriptions */
void ImageConverterDialog::slotModeChanged(int index)
{
  mModeIndex = index;
  if(((mModeIndex == 0) && (mDepthIndex == 0)) || (mModeIndex == 1))
    mpDitherCombo->setEnabled(false);
  else
    mpDitherCombo->setEnabled(true);
  if(mModeIndex != 0)
    mpDepthCombo->setEnabled(false);
  else
    mpDepthCombo->setEnabled(true);
  updatePreview();
}
/** No descriptions */
void ImageConverterDialog::slotDepthChanged(int index)
{
  mDepthIndex = index;
  if((mDepthIndex == 0) && (mModeIndex == 0))
    mpDitherCombo->setEnabled(false);
  else
    mpDitherCombo->setEnabled(true);
  updatePreview();
}
/** No descriptions */
void ImageConverterDialog::slotDitherChanged(int index)
{
  mDitherIndex = index;
  updatePreview();
}