/*
 * Copyright (c) 2006 QUALCOMM Incorporated. All rights reserved.
 * See License.txt file for terms and conditions for modification and
 * redistribution.
 *
 * File:        pop_sasl.h
 *
 * Revisions: 
 *
 * 01/18/03  [rcg]
 *          - File added (items moved here from popper.h)
 *
 */

#ifndef ___POP_SASL_INCLUDED
#define ___POP_SASL_INCLUDED

#include "config.h"

#include "popper.h"


/*
 * Holds SASL related items.
 */

struct _pop_sasl {
    void            *   sasl_conn;              /* SASL connection state */
    char               *sasl_log_login;         /* Logging string for SASL */
    char               *sasl_mechname;          /* Mechanism used by SASL */
    char               *sasl_authname;          /* Authenticated name */
    int                 sasl_ssf;               /* # of encryption bits */
    int                 sasl_min_ssf;           /* Minimum required SSF */
    int                 sasl_max_ssf;           /* Maximum allowed SSF */
    BOOL                sasl_no_plaintext;      /* Disable plaintext methods */
    BOOL                sasl_no_active;         /* No active attack methods */
    BOOL                sasl_no_dictionary;     /* No dictionary methods */
    BOOL                sasl_forward_secrecy;   /* Only forward secret methods*/
    BOOL                sasl_no_anonymous;      /* No anonymous methods */
    char               *sasl_buffer;            /* Our read buffer */
    char               *sasl_ptr;               /* Our read buffer ptr */
    int                 sasl_cnt;               /* Amount of data left in buf */
    int                 sasl_buf_size;          /* Size of buffer */
    unsigned int        sasl_maxbuf;            /* Maximum output buffer size */
};





#endif /* ___POP_SASL_INCLUDED */
