//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_wdg_switches_pad_proxy_hpp__
#define __INC_wdg_switches_pad_proxy_hpp__

#include <QObject>
#include <QString>


namespace Wdg
{


/// @brief Switches_Pad_Proxy
///
class Switches_Pad_Proxy :
	public QObject
{
	Q_OBJECT

	// Public methods
	public:

	Switches_Pad_Proxy (
		QObject * parent_n = 0 );

	virtual
	~Switches_Pad_Proxy ( );


	// Proxy index

	unsigned char
	index ( ) const;

	void
	set_index (
		unsigned char idx_n );


	// Focus

	bool
	has_focus ( ) const;


	// Item name

	const QString &
	item_name ( ) const;

	void
	set_item_name (
		const QString & name_n );


	// Group name

	const QString &
	group_name ( ) const;

	void
	set_group_name (
		const QString & name_n );


	// Tool tip

	const QString &
	tool_tip ( ) const;

	void
	set_tool_tip (
		const QString & tip_n );


	// Style information

	unsigned int
	style_id ( ) const;

	void
	set_style_id (
		unsigned int id_n );



	// Protected methods
	protected:

	bool
	eventFilter (
		QObject * obj_n,
		QEvent * event_n );


	// Private attributes
	private:

	unsigned char _index;
	bool _has_focus;

	QString _item_name;
	QString _group_name;
	QString _tool_tip;
	unsigned int _style_id;
};


inline
unsigned char
Switches_Pad_Proxy::index ( ) const
{
	return _index;
}


inline
bool
Switches_Pad_Proxy::has_focus ( ) const
{
	return _has_focus;
}


inline
const QString &
Switches_Pad_Proxy::item_name ( ) const
{
	return _item_name;
}


inline
const QString &
Switches_Pad_Proxy::group_name ( ) const
{
	return _group_name;
}


inline
const QString &
Switches_Pad_Proxy::tool_tip ( ) const
{
	return _tool_tip;
}


inline
unsigned int
Switches_Pad_Proxy::style_id ( ) const
{
	return _style_id;
}


} // End of namespace


#endif
