//
// C++ Implementation:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "switches_pad_proxy.hpp"
#include <QFocusEvent>
#include <QCoreApplication>
#include "pass_events.hpp"


namespace Wdg
{


Switches_Pad_Proxy::Switches_Pad_Proxy (
	QObject * parent_n ) :
QObject ( parent_n ),
_index ( 0 ),
_has_focus ( false ),
_style_id ( 0 )
{
}


Switches_Pad_Proxy::~Switches_Pad_Proxy ( )
{
}


void
Switches_Pad_Proxy::set_index (
	unsigned char idx_n )
{
	_index = idx_n;
}


void
Switches_Pad_Proxy::set_item_name (
	const QString & name_n )
{
	_item_name = name_n;
}


void
Switches_Pad_Proxy::set_group_name (
	const QString & name_n )
{
	_group_name = name_n;
}


void
Switches_Pad_Proxy::set_tool_tip (
	const QString & tip_n )
{
	_tool_tip = tip_n;
}


void
Switches_Pad_Proxy::set_style_id (
	unsigned int id_n )
{
	_style_id = id_n;
}


bool
Switches_Pad_Proxy::eventFilter (
	QObject * obj_n,
	QEvent * event_n )
{
	bool res ( QObject::eventFilter ( obj_n, event_n ) );

	if ( !res && (
		( event_n->type() == QEvent::FocusIn ) ||
		( event_n->type() == QEvent::FocusOut ) ) )
	{
		QFocusEvent * ev_focus (
			static_cast < QFocusEvent * > ( event_n ) );

		_has_focus = ev_focus->gotFocus();
		if ( parent() != 0 ) {
			::Wdg::Pass_Event_Focus ev_pass ( *ev_focus );
			ev_pass.column_idx = index();
			QCoreApplication::sendEvent ( parent(), &ev_pass );
		}
	}

	return res;
}


} // End of namespace

