//
// C++ Implementation:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "mixer_ctl_int_proxies_group.hpp"

#include <qsnd/mixer_ctl_elem.hpp>
#include <wdg/sliders_pad_proxy_switch.hpp>
#include <mwdg/mixer_ctl_int_proxy_slider.hpp>
#include <mwdg/mixer_ctl_int_proxy_column.hpp>
#include <mwdg/event_types.hpp>

#include <QEvent>
#include <QCoreApplication>

#include <iostream>
#include <cassert>


namespace MWdg
{


Mixer_CTL_Int_Proxies_Group::Mixer_CTL_Int_Proxies_Group (
	::QSnd::Mixer_CTL_Elem * snd_elem_n,
	QObject * parent_n ) :
::Wdg::Sliders_Pad_Proxies_Group ( parent_n ),
_snd_elem ( snd_elem_n ),
_notify_value_change ( false )
{
	assert ( _snd_elem != 0 );

	connect ( _snd_elem, SIGNAL ( sig_values_changed() ),
		this, SLOT ( update_values() ) );
}


Mixer_CTL_Int_Proxies_Group::~Mixer_CTL_Int_Proxies_Group ( )
{
}


bool
Mixer_CTL_Int_Proxies_Group::is_joined ( ) const
{
	bool res ( false );
	if ( num_columns() > 0 ) {
		Mixer_CTL_Int_Proxy_Column * col ( mcolumn ( 0 ) );
		if ( col->has_slider() ) {
			res = col->mslider_proxy()->is_joined();
		}
	}
	return res;
}


inline
Mixer_CTL_Int_Proxy_Column *
Mixer_CTL_Int_Proxies_Group::mcolumn (
	unsigned int idx_n ) const
{
	return static_cast < ::MWdg::Mixer_CTL_Int_Proxy_Column * > ( column ( idx_n ) );
}


void
Mixer_CTL_Int_Proxies_Group::set_joined (
	bool flag_n )
{
	if (  num_columns() < 2 ) {
		return;
	}

	for ( unsigned int cii=0; cii < num_columns(); ++cii ) {
		::MWdg::Mixer_CTL_Int_Proxy_Column * col ( mcolumn ( cii ) );
		if ( col->has_slider() ) {
			::MWdg::Mixer_CTL_Int_Proxy_Slider * pslider ( col->mslider_proxy() );
			pslider->set_joined ( flag_n );
			pslider->set_enabled ( ( cii == 0 ) || !flag_n );
			if ( flag_n && ( cii == 0 ) ) {
				pslider->snd_elem()->level_integers();
			}
		}
	}

	{
		::MWdg::Mixer_CTL_Int_Proxy_Column * col ( mcolumn ( 0 ) );
		if ( col->has_switch() ) {
			col->switch_proxy()->set_switch_state ( flag_n );
		}
	}
}


bool
Mixer_CTL_Int_Proxies_Group::volumes_equal ( ) const
{
	return _snd_elem->integers_equal();;
}


void
Mixer_CTL_Int_Proxies_Group::level_volumes (
	unsigned int column_n )
{
	if (  num_columns() < 2 ) {
		return;
	}
	if ( column_n >= num_columns() ) {
		column_n = 0;
	}
	Mixer_CTL_Int_Proxy_Column * col ( mcolumn ( column_n ) );
	if ( col->has_slider() ) {
		Mixer_CTL_Int_Proxy_Slider * psl ( col->mslider_proxy() );
		psl->snd_elem()->set_integer_all ( psl->integer_value() );
	}
}


void
Mixer_CTL_Int_Proxies_Group::set_notify_value_change (
	bool flag_n )
{
	_notify_value_change = flag_n;
}


void
Mixer_CTL_Int_Proxies_Group::update_values ( )
{
	for ( unsigned int cii=0; cii < num_columns(); ++cii ) {
		Mixer_CTL_Int_Proxy_Column * col ( mcolumn ( cii ) );
		if ( col->has_slider() ) {
			col->mslider_proxy()->update_value();
		}
	}

	// Notify parent on demand
	if ( notify_value_change() && ( parent() != 0 ) ) {
		QEvent ev_req ( ::MWdg::evt_values_changed );
		QCoreApplication::sendEvent ( parent(), &ev_req );
	}
}


} // End of namespace
