//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_mwdg_controls_model_hpp__
#define __INC_mwdg_controls_model_hpp__

#include <QList>
#include <QAbstractItemModel>
#include <QStandardItemModel>


// Forward declaration
namespace QSnd {
	class Card_Info;
	class Control_Address;
}


namespace MWdg
{


/// @brief Controls_Model
///
class Controls_Model :
	public QStandardItemModel
{
	Q_OBJECT;

	// Public methods
	public:

	Controls_Model ( );

	~Controls_Model ( );


	void
	set_alsa_cfg_model (
		QAbstractItemModel * model_n );


	// Cards access

	int
	num_cards ( ) const;

	const ::QSnd::Card_Info *
	card_info (
		int index_n ) const;


	// Controls access

	const ::QSnd::Control_Address *
	ctl_info (
		const QModelIndex & idx_n ) const;

	QModelIndex
	ctl_info_index (
		const ::QSnd::Control_Address & ctl_addr_n ) const;


	// Public slots
	public slots:

	void
	revert ( );


	// Protected slots
	protected slots:

	void
	reset_begin ( );

	void
	reset_finish ( );


	// Protected methods
	protected:

	void
	clear_data ( );

	void
	load_ctl_plugins ( );

	void
	load_cards ( );


	// Private attributes
	private:

	QList < ::QSnd::Card_Info * > _card_infos;
	QList < QStandardItem * > _ctl_items;
	QList < ::QSnd::Control_Address * > _ctl_addrs;

	QAbstractItemModel * _alsa_cfg_model;

	// Strings
	QString _ttip_row_tmpl;
};


inline
int
Controls_Model::num_cards ( ) const
{
	return _card_infos.size();
}


} // End of namespace


#endif
