//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_mv_information_hpp__
#define __INC_mv_information_hpp__

#include <mview/mv_base.hpp>


// Forward declaration
namespace QSnd {
	class CTL_Info;
	class CTL_Info_Model;
}
namespace Wdg {
	class Tree_View_KV;
}
namespace MView {
	class MV_Info_Setup;
}


namespace MView
{


/// @brief MV_Info
///
class MV_Info :
	public ::MView::MV_Base
{
	Q_OBJECT

	// Public methods
	public:

	MV_Info (
		QWidget * parent_n = 0 );

	~MV_Info ( );


	// Mixer device and view setup

	void
	set_mdev_setup (
		const ::MWdg::Mixer_Device_Setup * setup_n );

	void
	set_view_setup (
		::MView::MV_Base_Setup * setup_n );


	// Private methods
	private:

	void
	clear_view ( );

	void
	setup_view ( );


	// Private attributes
	private:

	::MView::MV_Info_Setup * _view_setup;
	::QSnd::CTL_Info * _pcm_info;
	::QSnd::CTL_Info_Model * _pcm_info_model;
	::Wdg::Tree_View_KV * _tree_view;
};


} // End of namespace


#endif
