//
// C++ Implementation:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "mv_info.hpp"

#include <qsnd/event_types.hpp>
#include <qsnd/ctl_info_model.hpp>
#include <wdg/tree_view_kv.hpp>

#include <mwdg/mixer_style.hpp>
#include <mwdg/mixer_device_setup.hpp>
#include <mview/mv_info_setup.hpp>
#include <mview/message_widget.hpp>

#include <iostream>


namespace MView
{


MV_Info::MV_Info (
	QWidget * parent_n ) :
::MView::MV_Base ( parent_n ),
_view_setup ( 0 )
{
	_pcm_info = new ::QSnd::CTL_Info;
	_pcm_info_model = new ::QSnd::CTL_Info_Model;
	_tree_view = new ::Wdg::Tree_View_KV;

	connect ( _pcm_info, SIGNAL ( sig_reload_request() ),
		this, SIGNAL ( sig_mdev_reload_request() ) );

	_tree_view->setRootIsDecorated ( false );
	_tree_view->setHeaderHidden ( true );
	_tree_view->setModel ( _pcm_info_model );

	lay_stack()->addWidget ( _tree_view );
}


MV_Info::~MV_Info ( )
{
	set_mdev_setup ( 0 );
	set_view_setup ( 0 );

	delete _tree_view;
	delete _pcm_info_model;
	delete _pcm_info;
}


void
MV_Info::set_mdev_setup (
	const ::MWdg::Mixer_Device_Setup * setup_n )
{
	if ( mdev_setup() != 0 ) {
		clear_view();
		_pcm_info->close();
	}

	::MView::MV_Base::set_mdev_setup ( setup_n );

	if ( mdev_setup() != 0 ) {
		_pcm_info->open ( mdev_setup()->ctl_addr.ctl_str() );
		setup_view();
	}
}


void
MV_Info::set_view_setup (
	::MView::MV_Base_Setup * setup_n )
{
	if ( _view_setup != 0 ) {
		clear_view();
	}

	_view_setup = dynamic_cast < ::MView::MV_Info_Setup * > ( setup_n );
	if ( _view_setup != 0 ) {
		if ( _view_setup->wdg_style_db != 0 ) {
			// Get playback / capture colors
			{
				const unsigned int style_id ( ::MWdg::Mixer_Style::PLAYBACK );
				const QPalette & pal (
					_view_setup->wdg_style_db->palette ( style_id ) );
				_pcm_info_model->set_snd_dir_foreground ( 0,
					pal.color ( QPalette::WindowText ) );
			}
			{
				const unsigned int style_id ( ::MWdg::Mixer_Style::CAPTURE );
				const QPalette & pal (
					_view_setup->wdg_style_db->palette ( style_id ) );
				_pcm_info_model->set_snd_dir_foreground ( 1,
					pal.color ( QPalette::WindowText ) );
			}
		}
		setup_view();
	}
}


void
MV_Info::clear_view ( )
{
	if ( ( mdev_setup() == 0 ) || ( _view_setup == 0 ) ) {
		return;
	}
	_pcm_info_model->set_pcm_info ( 0 );
}


void
MV_Info::setup_view ( )
{
	if ( ( mdev_setup() == 0 ) || ( _view_setup == 0 ) ) {
		return;
	}

	unsigned int lay_stack_idx ( 0 );

	if ( _pcm_info->is_open() ) {
		_pcm_info_model->set_pcm_info ( _pcm_info );
		lay_stack_idx = 1;
	} else {
		if ( mdev_setup()->ctl_addr.is_clear() ) {
			message_wdg()->set_no_device();
		} else {
			message_wdg()->set_mixer_open_fail (
				mdev_setup()->ctl_addr.ctl_str(),
				_pcm_info->err_message(),
				_pcm_info->err_func() );
		}
	}

	lay_stack()->setCurrentIndex ( lay_stack_idx );
	if ( lay_stack_idx != 0 ) {
		_tree_view->expandToDepth ( 3 );
		_tree_view->adjust_first_column_width();
	}
}


} // End of namespace
