//
// C++ Implementation:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "alsa_config_view.hpp"

#include "config.hpp"
#include <QVBoxLayout>
#include <QHBoxLayout>


namespace MView
{


Alsa_Config_View::Alsa_Config_View (
	QWidget * parent_n ) :
QWidget ( parent_n ),
_view_setup ( 0 )
{
	{
		//: The window title
		const QString str_settings ( tr ( "ALSA configuration" ) );
		setWindowTitle (
			QString ( "%1 - %2" ).arg ( PROGRAM_TITLE ).arg ( str_settings ) );
	}

	QHBoxLayout * lay_bottom ( new QHBoxLayout );
	lay_bottom->setContentsMargins ( 0, 0, 0, 0 );

	{
		_btn_reload.setText ( tr ( "&Reload" ) );
		_btn_close.setText ( tr ( "&Close" ) );
		_btn_close.setDefault ( true );

		if ( QIcon::hasThemeIcon ( "window-close" ) ) {
			_btn_close.setIcon ( QIcon::fromTheme ( "window-close" ) );
		}

		if ( QIcon::hasThemeIcon ( "view-refresh" ) ) {
			_btn_reload.setIcon ( QIcon::fromTheme ( "view-refresh" ) );
		}

		connect ( &_btn_close, SIGNAL ( clicked() ),
			this, SIGNAL ( sig_close() ) );

		lay_bottom->addWidget ( &_btn_reload );
		lay_bottom->addStretch ( 1 );
		lay_bottom->addWidget ( &_btn_close );
	}

	{
		QVBoxLayout * lay_vbox ( new QVBoxLayout );
		lay_vbox->addWidget ( &_cfg_view );
		lay_vbox->addLayout ( lay_bottom );
		setLayout ( lay_vbox );
	}
}


void
Alsa_Config_View::set_view_setup (
	::MView::Alsa_Config_View_Setup * setup_n )
{
	if ( _view_setup != 0 ) {
		if ( _view_setup->alsa_cfg_model != 0 ) {
			_cfg_view.set_model ( 0 );
			disconnect ( &_btn_reload, 0, _view_setup->alsa_cfg_model, 0 );
		}
	}

	_view_setup = setup_n;

	if ( _view_setup != 0 ) {
		if ( _view_setup->alsa_cfg_model != 0 ) {
			_cfg_view.enable_sorting ( _view_setup->sorted );
			_cfg_view.set_model ( _view_setup->alsa_cfg_model );
			connect ( &_btn_reload, SIGNAL ( clicked() ),
				_view_setup->alsa_cfg_model, SLOT ( revert() ) );
		}
	}
}


} // End of namespace
